/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.action;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.util.BasicUtilities;

public class CoreAction
extends AbstractAction {
    public static final String ICON_NAME = "ICON_NAME";
    protected ActionManager manager;

    public CoreAction(String name, int id, ResourceBundle bundle, ActionManager mgr) {
        this.manager = mgr;
        this.putValue("Name", name);
        try {
            this.putValue(ICON_NAME, bundle.getString(name + "_Icon"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("Default", bundle.getString(name + "_Text"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("ShortDescription", bundle.getString(name + "_S_Desc"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("LongDescription", bundle.getString(name + "_L_Desc"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.putValue("MnemonicKey", new Integer(bundle.getString(name + "_Mnemonic")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            KeyStroke ks = BasicUtilities.getLocalKeyStroke(bundle, name + "_Accel");
            if (ks != null) {
                this.putValue("AcceleratorKey", ks);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.putValue("ActionCommandKey", Integer.toString(id));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.manager == null) {
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(this.getValue("ActionCommandKey").toString());
        }
        catch (Exception e) {
            return;
        }
        this.manager.forwardAction(new ActionEvent(evt.getSource(), id, evt.getActionCommand(), evt.getModifiers()));
    }
}

