/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;

public abstract class AbstractTableFilter
implements TableFilter {
    protected static final String[] CHOICE_BOOLEAN = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    protected DatabaseConnection connection = null;
    protected SystemConfig sysConfig = SystemConfig.getInstance();
    private ArrayList parameters;
    private Preferences preferences = null;
    private PrintWriter outWriter = new PrintWriter(System.out, true);
    private ResourceBundle bundle = null;
    private EventListenerList listenerList = new EventListenerList();
    private ProgressEvent evt = null;
    private boolean debugOn = false;

    @Override
    public final void addProgressListener(ProgressListener pl) {
        this.listenerList.add(ProgressListener.class, pl);
    }

    @Override
    public final void removeProgressListener(ProgressListener pl) {
        this.listenerList.remove(ProgressListener.class, pl);
    }

    @Override
    public final DriverPropertyInfo[] getParameters(int mode) {
        DriverPropertyInfo[] temp = new DriverPropertyInfo[]{};
        return this.parameters.toArray(temp);
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public final void setLogStream(PrintWriter logStream) {
        this.outWriter = null;
        this.outWriter = logStream == null ? new PrintWriter(System.out, true) : logStream;
    }

    @Override
    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Import16");
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void initialize(int mode, Preferences prefRoot) {
        this.preferences = prefRoot;
        this.parameters = null;
        this.parameters = new ArrayList();
        String key = null;
        String desc = null;
        this.loadProperties(mode);
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        String[] choices = charsets.keySet().toArray(new String[0]);
        if (this.supportsMutlipleCharsets(mode)) {
            String encoding = System.getProperty("file.encoding", "");
            if (!Charset.isSupported(encoding)) {
                encoding = "UTF8";
            }
            key = this.getString("ASCII_Encoding_Name");
            desc = this.getString("ASCII_Encoding_Desc");
            this.addProperty(key, choices, encoding, false, desc);
        }
        key = this.getString("Import_Debug_Property");
        desc = this.getString("Import_Debug_Desc");
        this.addProperty(key, CHOICE_BOOLEAN, "false", false, desc);
    }

    @Override
    public boolean canFilter(int mode, Object o) {
        switch (mode) {
            case 1: {
                if (o == null || !(o instanceof EnhancedTableModel)) break;
                EnhancedTableModel tm = (EnhancedTableModel)o;
                return tm.getRowCount() >= 1 && tm.getColumnCount() >= 1;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ArrayList arrayList = this.parameters;
        synchronized (arrayList) {
            this.parameters.clear();
        }
    }

    @Override
    public Preferences getConfiguration(int mode) {
        return this.preferences;
    }

    @Override
    public boolean accept(int mode, File f) {
        if (f != null) {
            switch (mode) {
                case 1: {
                    return f.canWrite();
                }
                case 0: {
                    return f.canRead() && f.exists();
                }
            }
        }
        return false;
    }

    @Override
    public void setDatabaseConnection(DatabaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isModeSupported(int mode) {
        return true;
    }

    @Override
    public FileFilter[] getSupportedFileTypes(int mode) {
        return new FileFilter[0];
    }

    protected final Charset getPreferredCharset(int mode) {
        String key = BasicUtilities.getString("ASCII_Encoding_Name");
        String val = this.getConfiguration(mode).get(key, System.getProperty("file.encoding", ""));
        if (Charset.isSupported(val)) {
            this.debug(BasicUtilities.getString("Using_Ecoding_Format", val));
            return Charset.forName(val);
        }
        String msg = BasicUtilities.getString("CharacterSet_Not_Supported", val);
        this.info(msg);
        return Charset.forName("UTF8");
    }

    protected final boolean isDebugEnabled() {
        if (this.preferences != null) {
            return this.preferences.getBoolean(this.getString("Import_Debug_Property"), false);
        }
        return false;
    }

    protected final void info(Object message) {
        this.info(message, null);
    }

    protected final void info(Object message, Throwable error) {
        BasicUtilities.HandleException(error, message.toString(), this.debugOn, this.outWriter);
    }

    protected final void debug(Object message) {
        this.debug(message, null);
    }

    protected final void debug(Object message, Throwable error) {
        if (this.isDebugEnabled()) {
            BasicUtilities.HandleException(error, message.toString(), this.debugOn, this.outWriter);
        }
    }

    protected final void setResourceBunde(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    protected final String getString(String key) {
        if (this.bundle == null) {
            return BasicUtilities.getString(key);
        }
        return BasicUtilities.getString(this.bundle, key);
    }

    protected final void setProgressMax(int max) {
        this.evt = null;
        this.evt = new ProgressEvent(this, 0, max);
    }

    protected final void addProperty(String name, String[] opts, String def, boolean req, String desc) {
        try {
            def = def == null ? "" : def;
            DriverPropertyInfo prop = new DriverPropertyInfo(name, def);
            prop.required = req;
            prop.choices = opts;
            prop.description = desc;
            prop.value = this.preferences.get(name, def);
            this.parameters.add(prop);
        }
        catch (Throwable t) {
            this.info("AbstractTableFilter::addProperty()", t);
        }
    }

    protected final void checkIfCancelled() throws InterruptedException {
        Thread.sleep(10L);
    }

    protected void fireProgressUpdated(int progress) {
        this.fireProgressUpdated(progress, "");
    }

    protected void fireProgressUpdated(int progress, String note) {
        if (this.evt == null) {
            return;
        }
        this.evt.setNote(note);
        this.evt.setProgress(progress);
        this.fireProgressUpdated(this.evt);
    }

    protected void fireProgressUpdated(ProgressEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProgressListener.class) continue;
            ((ProgressListener)listeners[i + 1]).progressUpdated(e);
        }
    }

    protected boolean supportsMutlipleCharsets(int mode) {
        switch (mode) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    protected abstract void loadProperties(int var1);
}

