/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public class ExcelTableFilter
extends AbstractTableFilter {
    private static final int BIFF2_TYPE = 9;
    private static final int BIFF3_TYPE = 521;
    private static final int BIFF4_TYPE = 1033;
    private static final int BIFF5_8_TYPE = 2057;
    private StringBuilder sbuf = new StringBuilder();
    private int totalread = 0;
    private Vector SSTArray;

    @Override
    public String getName() {
        return BasicUtilities.getString("Excel_Handler_Name");
    }

    @Override
    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFileRequired(int mode) {
        return true;
    }

    @Override
    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Xcel16");
    }

    @Override
    public int filterIn(EnhancedTableModel tm, File file, InputStream is) throws IOException, InterruptedException {
        Preferences prefs = this.getConfiguration(0);
        int totalbytes = is.available();
        this.setProgressMax(totalbytes);
        String key = BasicUtilities.getString("Excel_Imp_Row_As_Columns");
        int nameRow = prefs.getInt(key, -2);
        Vector<Object> cids = new Vector<Object>(0, 1);
        int op = 0;
        int ln = 0;
        int row = 0;
        int col = 0;
        int c = 0;
        boolean dset = false;
        boolean isBOF = false;
        try {
            block20: while (true) {
                this.checkIfCancelled();
                block21: while (!isBOF) {
                    switch (op) {
                        case 9: 
                        case 521: 
                        case 1033: 
                        case 2057: {
                            ln = this.readShort(is);
                            if (this.isBOF(op, ln)) {
                                isBOF = true;
                                continue block21;
                            }
                            op = ln;
                            break;
                        }
                        default: {
                            op = this.read(is);
                            if (op != 9) break;
                            op = ((op & 0xFF) << 0) + ((this.read(is) & 0xFF) << 8);
                        }
                    }
                    this.debug("Searching....  (" + Integer.toHexString(this.totalread) + ")");
                }
                this.debug("BOF @ (" + Integer.toHexString(this.totalread) + ")");
                isBOF = false;
                do {
                    if (op == 10 && op != -1) continue block20;
                    this.debug(Integer.toHexString(this.totalread) + ":(" + Integer.toHexString(op) + "," + ln + ")");
                    this.checkIfCancelled();
                    this.fireProgressUpdated(this.totalread);
                    switch (op) {
                        case 9: {
                            this.info("Excel 2.1 Spreadsheet");
                            this.skip(is, ln);
                            break;
                        }
                        case 521: {
                            this.info("Excel 3 Spreadsheet");
                            this.skip(is, ln);
                            break;
                        }
                        case 1033: {
                            this.info("Excel 4 Spreadshee");
                            this.skip(is, ln);
                            break;
                        }
                        case 2057: {
                            this.info("Excel 97/2000 Spreadsheet ");
                            this.skip(is, ln);
                            break;
                        }
                        case 0: 
                        case 512: {
                            if (ln == 8 && !dset) {
                                this.readShort(is);
                                tm.setRowCount(this.readShort(is));
                                this.readShort(is);
                                tm.setColumnCount(this.readShort(is));
                                dset = true;
                            } else if (ln == 14 && !dset) {
                                this.skip(is, 4L);
                                tm.setRowCount(this.readShort(is));
                                this.skip(is, 4L);
                                tm.setColumnCount(this.readShort(is));
                                this.skip(is, 2L);
                                dset = true;
                            } else if (ln == 10 && !dset) {
                                this.skip(is, 2L);
                                tm.setRowCount(this.readShort(is));
                                this.skip(is, 2L);
                                tm.setColumnCount(this.readShort(is));
                                this.skip(is, 2L);
                                dset = true;
                            } else {
                                this.skip(is, ln);
                            }
                            dset = true;
                            break;
                        }
                        case 3: 
                        case 515: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            if (op == 3) {
                                this.skip(is, 3L);
                            } else {
                                this.skip(is, 2L);
                            }
                            double d = this.readDouble(is);
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(Double.toString(d));
                                break;
                            }
                            tm.setValueAt(new Double(d), row, col);
                            break;
                        }
                        case 4: 
                        case 516: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            if (op == 4) {
                                this.skip(is, 3L);
                            } else {
                                this.skip(is, 2L);
                            }
                            c = op == 4 ? this.read(is) : this.readShort(is);
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(this.readUTFBody(is, c));
                                break;
                            }
                            tm.setValueAt(this.readUTFBody(is, c), row, col);
                            break;
                        }
                        case 2: 
                        case 638: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            if (op == 2) {
                                this.skip(is, 3L);
                            } else {
                                this.skip(is, 2L);
                            }
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(Integer.toString(this.readShort(is)));
                                break;
                            }
                            if (op == 2) {
                                tm.setValueAt(new Integer(this.readShort(is)), row, col);
                                break;
                            }
                            tm.setValueAt(this.readRKInteger(is), row, col);
                            break;
                        }
                        case 253: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            this.skip(is, 2L);
                            int sstidx = this.readInteger(is);
                            this.debug("SSTLabel(" + row + "," + col + "):" + sstidx);
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(this.SSTArray.get(sstidx));
                                break;
                            }
                            try {
                                tm.setValueAt(this.SSTArray.get(sstidx), row, col);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 189: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            for (int i = 0; i < (ln - 6) / 6; ++i) {
                                this.skip(is, 2L);
                                if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                    cids.add(this.readRKInteger(is));
                                    continue;
                                }
                                tm.setValueAt(this.readRKInteger(is), row, col + i);
                            }
                            this.readShort(is);
                            break;
                        }
                        case 252: {
                            int totalstrings = this.readInteger(is);
                            this.readInteger(is);
                            this.readSSTArray(is, totalstrings, ln - 8);
                            break;
                        }
                        default: {
                            this.skip(is, ln);
                        }
                    }
                    op = this.readShort(is);
                    if (op != -1) continue;
                    return 0;
                } while ((ln = this.readShort(is)) != -1);
                break;
            }
            return 0;
        }
        catch (EOFException eOFException) {
            if (!cids.isEmpty()) {
                if (nameRow == -1) {
                    tm.removeRow(tm.getRowCount() - 1);
                } else if (nameRow >= 0) {
                    tm.removeRow(nameRow);
                }
            }
            return 0;
        }
    }

    @Override
    public int filterOut(Object data, File file, OutputStream os) {
        return 0;
    }

    @Override
    protected void loadProperties(int mode) {
        switch (mode) {
            case 0: {
                String key = this.getString("Excel_Imp_Row_As_Columns");
                String desc = this.getString("Excel_Imp_Row_As_Columns_Tip");
                this.addProperty(key, null, "-2", false, desc);
                break;
            }
        }
    }

    protected boolean isColumnIdentifer(int row, int sentinalrow, int maxrows) {
        if (sentinalrow > -2) {
            return row == sentinalrow || sentinalrow == -1 && row == maxrows - 1;
        }
        return false;
    }

    protected void skip(InputStream is, long l) throws IOException {
        is.skip(l);
        this.totalread = (int)((long)this.totalread + l);
    }

    protected int read(InputStream is) throws IOException {
        int r = is.read();
        if (r == -1) {
            throw new EOFException();
        }
        ++this.totalread;
        return r;
    }

    protected void readSSTArray(InputStream is, int sz, int len) throws IOException {
        if (this.SSTArray == null) {
            this.SSTArray = new Vector(sz);
        }
        StringTokenizer st = new StringTokenizer(this.readUTFBody(is, len), "\u0000\u0001", false);
        int i = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.length() < 1) continue;
            this.SSTArray.add(tok);
            this.debug("SST[" + i + "] == " + this.SSTArray.get(i));
            ++i;
        }
    }

    protected Number readRKInteger(InputStream is) throws IOException {
        boolean isFloat;
        int x = this.readInteger(is);
        boolean x100 = (x & 1) == 1;
        boolean bl = isFloat = (x & 2) != 2;
        if (isFloat) {
            return new Float((double)((x & 0xFFFFFFFC) >> 2) * (x100 ? 0.01 : 1.0));
        }
        if (x100) {
            return new Float((double)((x & 0xFFFFFFFC) >> 2) * 0.01);
        }
        return new Integer((x & 0xFFFFFFFC) >> 2);
    }

    protected boolean isBOF(int op, int len) {
        switch (op) {
            case 9: {
                return len == 4;
            }
            case 521: 
            case 1033: {
                return len == 6;
            }
            case 2057: {
                return len == 16 || len == 8;
            }
        }
        return false;
    }

    protected int readShort(InputStream is) throws IOException {
        return ((this.read(is) & 0xFF) << 0) + ((this.read(is) & 0xFF) << 8);
    }

    protected int readInteger(InputStream is) throws IOException {
        return ((this.read(is) & 0xFF) << 0) + ((this.read(is) & 0xFF) << 8) + ((this.read(is) & 0xFF) << 16) + ((this.read(is) & 0xFF) << 24);
    }

    protected long readLong(InputStream is) throws IOException {
        return (((long)this.read(is) & 0xFFL) << 0) + (((long)this.read(is) & 0xFFL) << 8) + (((long)this.read(is) & 0xFFL) << 16) + (((long)this.read(is) & 0xFFL) << 24) + (((long)this.read(is) & 0xFFL) << 32) + (((long)this.read(is) & 0xFFL) << 40) + (((long)this.read(is) & 0xFFL) << 48) + (((long)this.read(is) & 0xFFL) << 56);
    }

    protected double readDouble(InputStream is) throws IOException {
        return Double.longBitsToDouble(this.readLong(is));
    }

    protected String readUTFBody(InputStream is, int utflen) throws IOException {
        this.sbuf.setLength(0);
        for (int i = 0; i < utflen; ++i) {
            this.sbuf.append((char)this.read(is));
        }
        return this.sbuf.toString();
    }
}

