/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.AbstractImportPlugin;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportProcessor;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class AutovaluePlugin
extends AbstractImportPlugin {
    private JComboBox jcbAType = new JComboBox();
    private HashMap nativeTypes = null;
    private JTextField txtAOptions = new JTextField();
    private static final String KEY_SQL_TYPE = "sqltype";
    private static final String KEY_OPTIONS = "options";
    private static final String KEY_SELECTION = "selection";

    @Override
    public ImportConfig.Entry createEntry() {
        ImportConfig.Entry entry = new ImportConfig.Entry(this);
        Object item = this.jcbAType.getSelectedItem();
        item = this.jcbAType.getSelectedItem();
        if (item != null) {
            entry.put(KEY_SELECTION, item);
            if (!this.nativeTypes.isEmpty()) {
                entry.put(KEY_SQL_TYPE, this.nativeTypes.get(item));
            } else {
                entry.put(KEY_SQL_TYPE, new Integer(JDBCUtilities.getTypeforName((String)item)));
            }
        } else {
            entry.put(KEY_SQL_TYPE, new Integer(12));
        }
        entry.put(KEY_OPTIONS, this.txtAOptions.getText());
        return entry;
    }

    @Override
    public void setEntry(ImportConfig.Entry entry) {
        this.jcbAType.setSelectedItem(entry.get(KEY_SELECTION));
        this.txtAOptions.setText(entry.getProperty(KEY_OPTIONS, ""));
    }

    @Override
    public void handleColumnSelectionChange(String newColumn, String oldColumn) {
    }

    @Override
    public void handleTableSelectionChange(String oldTable, String newTable) {
    }

    @Override
    public void installEditor(Container container) {
        this.nativeTypes = JDBCUtilities.getNativeTypeMap(this.connection.getDatabaseInformation());
        if (this.nativeTypes.isEmpty()) {
            this.jcbAType = new JComboBox<String>(AutovaluePlugin.getDefaultTypes());
        } else {
            Iterator itr = this.nativeTypes.keySet().iterator();
            while (itr.hasNext()) {
                String type = (String)itr.next();
                Integer sql = (Integer)this.nativeTypes.get(type);
                boolean isDate = JDBCUtilities.isDateType(sql);
                boolean isNumb = JDBCUtilities.isNumberType(sql);
                boolean isChar = JDBCUtilities.isStringType(sql);
                boolean isBool = JDBCUtilities.isBooleanType(sql);
                boolean isNull = sql == 0;
                if (isNull || isChar || isDate || isNumb || isBool) continue;
                itr.remove();
            }
            String[] types = this.nativeTypes.keySet().toArray(new String[this.nativeTypes.size()]);
            Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
            this.jcbAType = new JComboBox<String>(types);
        }
        container.setLayout(new GridBagLayout());
        AutovaluePlugin.constrain(0, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        AutovaluePlugin.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_SQL_Type")), UI_CONSTRAINT);
        AutovaluePlugin.constrain(2, 0, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbAType, UI_CONSTRAINT);
        AutovaluePlugin.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Auto_Options")), UI_CONSTRAINT);
        AutovaluePlugin.constrain(2, 1, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.txtAOptions, UI_CONSTRAINT);
        AutovaluePlugin.constrain(3, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        AutovaluePlugin.constrain(0, 2, 3, 1, 0.0, 1.0, 10, 0);
        container.add(Box.createVerticalGlue(), UI_CONSTRAINT);
    }

    @Override
    public ImportProcessor createProcessor() {
        return new AutoValueProcessor();
    }

    @Override
    public String getDescription() {
        return BasicUtilities.getString("Import_Map_Auto");
    }

    private static String[] getDefaultTypes() {
        return new String[]{"BIGINT", "BIT", "BOOLEAN", "CHAR", "DATE", "DECIMAL", "DOUBLE", "FLOAT", "INTEGER", "NUMERIC", "NULL", "REAL", "SMALLINT", "TIME", "TIMESTAMP", "TINYINT", "NULL", "VARCHAR"};
    }

    private static class AutoValueProcessor
    implements ImportProcessor {
        private int sqltype = 1111;
        private String options = "";

        private AutoValueProcessor() {
        }

        @Override
        public boolean canSkip() {
            return false;
        }

        @Override
        public int prepareImport(int row, int index, Map values, PreparedStatement ps, int type) throws SQLException {
            Object data = null;
            SystemConfig config = SystemConfig.getInstance();
            if (this.options.length() == 0) {
                return 3;
            }
            if (JDBCUtilities.isNumberType(this.sqltype)) {
                NumberFormat nf = NumberFormat.getInstance();
                Number num = null;
                try {
                    if (this.options.startsWith("!")) {
                        data = nf.parse(this.options.substring(1));
                    }
                    num = nf.parse(this.options);
                    data = new Double(num.doubleValue() + (double)row);
                }
                catch (ParseException pe) {
                    throw new SQLException(pe.getMessage());
                }
            } else if (JDBCUtilities.isDateType(this.sqltype)) {
                SimpleDateFormat sdf = new SimpleDateFormat("");
                sdf.applyPattern(config.getFormatForSQLType(this.sqltype));
                if (this.options.equalsIgnoreCase("now")) {
                    data = new Date();
                } else {
                    try {
                        data = sdf.parse(this.options);
                    }
                    catch (ParseException pe) {
                        throw new SQLException(pe.getMessage());
                    }
                }
            } else {
                data = JDBCUtilities.isBooleanType(this.sqltype) ? Boolean.valueOf(this.options) : this.options;
            }
            try {
                data = JDBCUtilities.convertValue(data, this.sqltype, null);
            }
            catch (ParseException pe) {
                throw new SQLException(pe.getMessage());
            }
            JDBCUtilities.configurePreparedStatement(ps, index, data, this.sqltype, false);
            return 0;
        }

        @Override
        public void setEntry(ImportConfig.Entry entry) {
            this.sqltype = (Integer)entry.get(AutovaluePlugin.KEY_SQL_TYPE);
            this.options = entry.getProperty(AutovaluePlugin.KEY_OPTIONS, "");
        }
    }
}

