/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.isqlviewer.core.ImportPlugin;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImportConfig {
    private String schema = null;
    private String catalog = null;
    private String table = null;
    private boolean useTransaction = false;
    private boolean useBatch = false;
    private HashMap entryMap = new HashMap();
    private static final String TAG_ROOT = "jetfire-script";
    private static final String TAG_ENTRY = "jetfire-entry";
    private static final String TAG_PROPERTY = "jetfire-property";
    private static final String TAG_VALUE = "jetfire-data";
    private static final String ATTR_ROOT_TABLE = "table";
    private static final String ATTR_ROOT_CATALOG = "catalog";
    private static final String ATTR_ROOT_SCHEMA = "schema";
    private static final String ATTR_ROOT_BATCH = "batch";
    private static final String ATTR_ROOT_TRANX = "transaction";
    private static final String ATTR_ENTRY_COLUMN = "column";
    private static final String ATTR_ENTRY_PLUGIN = "plugin";
    private static final String ATTR_PROP_NAME = "name";

    public boolean isUseBatch() {
        return this.useBatch;
    }

    public void setUseBatch(boolean useBatch) {
        this.useBatch = useBatch;
    }

    public boolean isUseTransaction() {
        return this.useTransaction;
    }

    public void setUseTransaction(boolean useTransaction) {
        this.useTransaction = useTransaction;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Iterator keys() {
        return this.entryMap.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(String key) {
        Object obj = null;
        HashMap hashMap = this.entryMap;
        synchronized (hashMap) {
            obj = this.entryMap.get(key.toUpperCase());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(String key, Entry entry) {
        try {
            HashMap hashMap = this.entryMap;
            synchronized (hashMap) {
                if (entry == null) {
                    this.entryMap.remove(key.toUpperCase());
                } else {
                    this.entryMap.put(key.toUpperCase(), entry);
                }
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry removeEntry(String key) {
        Object obj = null;
        try {
            HashMap hashMap = this.entryMap;
            synchronized (hashMap) {
                obj = this.entryMap.remove(key.toUpperCase());
            }
            return obj;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean containsKey(String key) {
        try {
            return this.entryMap.containsKey(key.toUpperCase());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isEmpty() {
        return this.entryMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap hashMap = this.entryMap;
        synchronized (hashMap) {
            this.clearEntries();
        }
    }

    public void store(OutputStream out) {
        Charset UTF8 = Charset.forName("UTF-8");
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(out, UTF8), true);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        writer.print("<");
        writer.print(TAG_ROOT);
        writer.print(" ");
        writer.print(ATTR_ROOT_CATALOG);
        writer.print("=\"");
        writer.print(StringUtilities.encodeXMLEntities(this.catalog));
        writer.print("\" ");
        writer.print(ATTR_ROOT_SCHEMA);
        writer.print("=\"");
        writer.print(StringUtilities.encodeXMLEntities(this.schema));
        writer.print("\" ");
        writer.print(ATTR_ROOT_TABLE);
        writer.print("=\"");
        writer.print(StringUtilities.encodeXMLEntities(this.table));
        writer.print("\" ");
        writer.print(ATTR_ROOT_BATCH);
        writer.print("=\"");
        writer.print(Boolean.toString(this.isUseBatch()));
        writer.print("\" ");
        writer.print(ATTR_ROOT_TRANX);
        writer.print("=\"");
        writer.print(Boolean.toString(this.isUseTransaction()));
        writer.println("\" >");
        for (String key : this.entryMap.keySet()) {
            Entry entry = (Entry)this.entryMap.get(key);
            if (entry == null) continue;
            this.storeEntry(writer, key, entry);
            writer.flush();
        }
        writer.print("</");
        writer.print(TAG_ROOT);
        writer.println(">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in) throws IOException {
        XMLReader reader = null;
        SystemConfig sysConfig = SystemConfig.getInstance();
        this.clearEntries();
        try {
            reader = sysConfig.getXMLReader();
            reader.setContentHandler(new ImportParser(this));
            reader.parse(new InputSource(in));
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
        }
        finally {
            reader = null;
        }
    }

    private void clearEntries() {
        Iterator itr = this.entryMap.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Entry entry = (Entry)this.entryMap.get(key);
            if (entry == null) continue;
            entry.clear();
            itr.remove();
        }
    }

    private void storeEntry(PrintWriter out, String column, Entry entry) {
        out.print("\t<");
        out.print(TAG_ENTRY);
        out.print(" ");
        out.print(ATTR_ENTRY_COLUMN);
        out.print("=\"");
        out.print(StringUtilities.encodeXMLEntities(column));
        out.print("\" ");
        out.print(ATTR_ENTRY_PLUGIN);
        out.print("=\"");
        out.print(StringUtilities.encodeXMLEntities(entry.plugin));
        out.print("\" ");
        out.println(">");
        for (String string : entry.keySet()) {
            Object val = entry.get(string);
            if (val == null) continue;
            this.storeProperty(string, val, out);
        }
        out.print("\t</");
        out.print(TAG_ENTRY);
        out.println(">");
    }

    private void storeProperty(String key, Object val, PrintWriter out) {
        out.print("\t\t<");
        out.print(TAG_PROPERTY);
        out.print(" ");
        out.print(ATTR_PROP_NAME);
        out.print("=\"");
        out.print(StringUtilities.encodeXMLEntities(key));
        out.println("\" >");
        out.print("\t\t\t<");
        out.print(TAG_VALUE);
        out.println(">");
        ByteArrayOutputStream os = new ByteArrayOutputStream(128);
        XMLEncoder encoder = new XMLEncoder(os);
        encoder.setOwner(this);
        encoder.writeObject(val);
        encoder.close();
        Base64Encoder b64 = new Base64Encoder(os.toString());
        out.print("\t\t\t ");
        out.println(StringUtilities.formatBreak(80, b64.processString(), "\t\t\t ", false));
        out.print("\t\t\t</");
        out.print(TAG_VALUE);
        out.println(">");
        out.print("\t\t</");
        out.print(TAG_PROPERTY);
        out.println(">");
        os.reset();
        os = null;
        encoder = null;
        b64 = null;
    }

    private static class ImportParser
    extends DefaultHandler {
        private ImportConfig owner = null;
        private String currentEntry = null;
        private String currentProperty = null;
        private StringBuffer valueBuffer = new StringBuffer("");
        private boolean done = false;
        private boolean invalue = false;

        @Override
        public void characters(char[] ch, int start, int length) {
            String chars;
            if (!this.done && this.invalue && (chars = new String(ch, start, length)).trim().length() >= 1) {
                this.valueBuffer.append(chars);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.done) {
                return;
            }
            if (localName.equalsIgnoreCase(ImportConfig.TAG_ROOT)) {
                this.done = true;
            } else if (localName.equalsIgnoreCase(ImportConfig.TAG_ENTRY)) {
                this.currentEntry = null;
            } else if (localName.equalsIgnoreCase(ImportConfig.TAG_PROPERTY) && this.currentEntry != null) {
                this.currentProperty = null;
            } else if (localName.equalsIgnoreCase(ImportConfig.TAG_VALUE) && this.currentProperty != null) {
                Entry entry = this.owner.getEntry(this.currentEntry);
                Base64Decoder b64 = new Base64Decoder(this.valueBuffer.toString());
                try {
                    ByteArrayInputStream xml = new ByteArrayInputStream(b64.processString().getBytes());
                    XMLDecoder decoder = new XMLDecoder(xml);
                    decoder.setOwner(this.owner);
                    Object value = decoder.readObject();
                    entry.put(this.currentProperty, value);
                    decoder = null;
                    xml.reset();
                    xml = null;
                }
                catch (Base64FormatException bfe) {
                    throw new SAXException(bfe);
                }
                b64 = null;
                this.invalue = false;
                this.valueBuffer.setLength(0);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.done) {
                return;
            }
            if (localName.equalsIgnoreCase(ImportConfig.TAG_ROOT)) {
                try {
                    this.owner.setCatalog(attributes.getValue(ImportConfig.ATTR_ROOT_CATALOG));
                }
                catch (Throwable t) {
                    this.owner.setCatalog(null);
                }
                try {
                    this.owner.setSchema(attributes.getValue(ImportConfig.ATTR_ROOT_SCHEMA));
                }
                catch (Throwable t) {
                    this.owner.setSchema(null);
                }
                try {
                    this.owner.setTable(attributes.getValue(ImportConfig.ATTR_ROOT_TABLE));
                }
                catch (Throwable t) {
                    this.owner.setTable(null);
                }
                try {
                    this.owner.setUseBatch(Boolean.valueOf(attributes.getValue(ImportConfig.ATTR_ROOT_BATCH)));
                }
                catch (Throwable t) {
                    this.owner.setUseBatch(false);
                }
                try {
                    this.owner.setUseTransaction(Boolean.valueOf(attributes.getValue(ImportConfig.ATTR_ROOT_TRANX)));
                }
                catch (Throwable t) {
                    this.owner.setUseTransaction(false);
                }
            } else if (localName.equalsIgnoreCase(ImportConfig.TAG_ENTRY)) {
                Entry entry = new Entry(attributes.getValue(ImportConfig.ATTR_ENTRY_PLUGIN));
                String column = attributes.getValue(ImportConfig.ATTR_ENTRY_COLUMN);
                this.owner.addEntry(column, entry);
                this.currentEntry = column;
            } else if (localName.equalsIgnoreCase(ImportConfig.TAG_PROPERTY) && this.currentEntry != null) {
                this.currentProperty = attributes.getValue(ImportConfig.ATTR_PROP_NAME);
            } else if (localName.equalsIgnoreCase(ImportConfig.TAG_VALUE) && this.currentProperty != null) {
                this.invalue = true;
            }
        }

        public ImportParser(ImportConfig reference) {
            this.owner = reference;
        }
    }

    public static class Entry
    extends Properties {
        private String plugin = "";

        public Entry(ImportPlugin plugin) {
            if (plugin == null) {
                throw new NullPointerException("ImportConfig.Entry(ImportPlugin)");
            }
            this.plugin = plugin.getName();
        }

        private Entry(String className) {
            this.plugin = className;
        }

        public String getPluginName() {
            return this.plugin;
        }
    }
}

