/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.isqlviewer.core.ImportPlugin;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class ImportRunner {
    private ImportConfig config = null;
    private DatabaseConnection connection = null;
    private EnhancedTableModel sourceData = null;
    private Collection plugins = SystemConfig.getInstance().getPluginFactory().createImportHandlers();
    private PrintWriter out = new PrintWriter(System.out, true);
    private PrintWriter err = new PrintWriter(System.err, true);
    private EventListenerList listeners = new EventListenerList();

    public ImportRunner(ImportConfig configuration, DatabaseConnection cnx) {
        if (configuration == null || cnx == null) {
            throw new NullPointerException();
        }
        this.config = configuration;
        this.connection = cnx;
    }

    public void setSourceData(EnhancedTableModel model) {
        this.sourceData = model;
    }

    public void setStdOut(OutputStream out) {
        this.out = out == null ? new PrintWriter(System.out, true) : new PrintWriter(out, true);
    }

    public void setStdErr(OutputStream err) {
        this.err = err == null ? new PrintWriter(System.err, true) : new PrintWriter(err, true);
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add(ProgressListener.class, listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove(ProgressListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void runImport() {
        importCount = this.sourceData.getTrueRowCount();
        useDebug = this.connection.getDebugOn();
        isVerbose = this.connection.getVerboseOn();
        currentCommit = this.connection.getAutoCommit();
        useTransaction = this.config.isUseTransaction() != false && this.connection.isTransactionsSupported() != false;
        useBatch = this.config.isUseBatch() != false && this.connection.isBatchSupported() != false;
        currentCatalog = this.connection.getCatalog();
        pSQL = null;
        qtable = this.config.getTable();
        ps = null;
        itr = this.config.keys();
        cols = new ArrayList<String>();
        destTypes = this.getColumnTypeMap(qtable);
        event = new ProgressEvent(this, 0, useBatch != false ? importCount * 2 : importCount);
        while (itr.hasNext()) {
            key = (String)itr.next();
            entry = this.config.getEntry(key);
            if (entry != null) {
                pluginName = entry.getPluginName();
                ip = this.pluginForName(pluginName);
                processor = ip.createProcessor();
                try {
                    processor.setEntry(entry);
                    if (!processor.canSkip()) {
                        cols.add(key);
                        continue;
                    }
                    this.out.println(BasicUtilities.getString("ImportColumnSkip", key));
                    continue;
                }
                catch (Throwable t) {
                    error = BasicUtilities.getString("ImmportProcessError", key);
                    throw new RuntimeException(error, t);
                }
            }
            this.out.println(BasicUtilities.getString("ImportColumnSkip", key));
        }
        if (cols.isEmpty()) {
            this.out.println(BasicUtilities.getString("ImportEmptyError"));
            return;
        }
        pSQL = JDBCUtilities.generatePreparedInsertRequest(qtable, cols.toArray(new String[0]));
        try {
            ps = this.connection.createPreparedStatement(pSQL);
            this.out.println(BasicUtilities.getString("Prepared_Statement_Info"));
            this.out.println(pSQL);
        }
        catch (Throwable t) {
            this.finalizeStatement(ps);
            BasicUtilities.HandleException(t, BasicUtilities.getString("Prepared_Statement_Error"), useDebug, this.err);
            return;
        }
        if (useTransaction) {
            this.out.println(BasicUtilities.getString("Import_Transaction_Start"));
            if (currentCommit) {
                this.connection.setAutoCommit(false);
            } else {
                msg = BasicUtilities.getString("Import_Tx_Overlap_Warning");
                opt = JOptionPane.showConfirmDialog(null, msg, null, 1);
                if (opt == 0) {
                    this.connection.performCommit();
                } else if (opt == 2) {
                    this.finalizeStatement(ps);
                    return;
                }
            }
        }
        try {
            try {
                newCat = null;
                if (currentCatalog != null && newCat != null && !currentCatalog.equals(newCat)) {
                    p = new String[]{newCat, currentCatalog};
                    this.out.println(BasicUtilities.getString("Import_Catalog_Change", p));
                    this.connection.changeCatalog(newCat);
                }
            }
            catch (Throwable t) {
                msg = BasicUtilities.getString("Catalog_Change_Exception", currentCatalog);
                BasicUtilities.HandleException(t, msg, useDebug, this.err);
                this.restoreAutoCommit(false, currentCommit, useTransaction);
                this.finalizeStatement(ps);
                event.setProgress(event.getMaximum());
                this.fireProgressEvent(event);
                return;
            }
            block33: for (i = 0; i < importCount; ++i) {
                itr = cols.iterator();
                parameterIndex = 0;
                event.setProgress(i);
                while (itr.hasNext()) {
                    key = (String)itr.next();
                    entry = this.config.getEntry(key);
                    pluginName = entry.getPluginName();
                    ip = this.pluginForName(pluginName);
                    processor = ip.createProcessor();
                    if (processor == null) {
                        throw new NullPointerException(pluginName + "::createProcessor()");
                    }
                    row = this.sourceData.getRowMap(i);
                    processor.setEntry(entry);
                    result = -1;
                    try {
                        type = (Integer)destTypes.get(key);
                        pType = type == null ? 1111 : type;
                        result = processor.prepareImport(i, ++parameterIndex, row, ps, pType);
                    }
                    catch (Throwable t) {
                        error = BasicUtilities.getString("ImmportProcessError", key);
                        throw new RuntimeException(error, t);
                    }
                    switch (result) {
                        case 2: {
                            this.restoreAutoCommit(false, currentCommit, useTransaction);
                            return;
                        }
                        case 3: {
                            JDBCUtilities.configurePreparedStatement(ps, parameterIndex - 1, null, 0, false);
                            break;
                        }
                        case 1: {
                            ps.clearParameters();
                            continue block33;
                        }
                        ** case 0:
lbl111:
                        // 2 sources

                        default: {
                            processor = null;
                            break;
                        }
                    }
                }
                this.fireProgressEvent(event);
                if (useBatch) {
                    try {
                        this.out.println(BasicUtilities.getString("Import_AddBatch_Info", Integer.toString(i)));
                        ps.addBatch();
                        continue;
                    }
                    catch (Throwable t) {
                        msg = BasicUtilities.getString("Import_AddBatch_Error", Integer.toString(i));
                        BasicUtilities.HandleException(t, msg, useDebug, this.err);
                        this.restoreAutoCommit(false, currentCommit, useTransaction);
                        this.finalizeStatement(ps);
                        event.setProgress(event.getMaximum());
                        this.fireProgressEvent(event);
                        return;
                    }
                }
                result = -1;
                try {
                    this.out.println(BasicUtilities.getString("Import_Exec_Info", Integer.toString(i)));
                    result = ps.executeUpdate();
                    try {
                        ps.clearParameters();
                    }
                    catch (Throwable msg) {
                        // empty catch block
                    }
                    this.out.println(BasicUtilities.getString("Import_Exec_Result", Integer.toString(result)));
                    continue;
                }
                catch (Throwable t) {
                    msg = BasicUtilities.getString("Import_Exec_Error");
                    BasicUtilities.HandleException(t, msg, useDebug, this.err);
                    this.restoreAutoCommit(false, currentCommit, useTransaction);
                    this.finalizeStatement(ps);
                    event.setProgress(event.getMaximum());
                    this.fireProgressEvent(event);
                    return;
                }
            }
            if (useBatch) {
                try {
                    this.out.println(BasicUtilities.getString("Import_BatchInfo_Info"));
                    results = ps.executeBatch();
                    if (useDebug && isVerbose) {
                        progress = event.getProgress();
                        event = new ProgressEvent(this, progress, progress + results.length);
                        for (c = 0; c < results.length; ++c) {
                            event.setProgress(progress++);
                            this.fireProgressEvent(event);
                            affected = Integer.toString(results[c]);
                            this.out.println(BasicUtilities.getString("Import_Exec_Result", affected));
                        }
                    }
                }
                catch (Throwable t) {
                    msg = BasicUtilities.getString("Import_Exec_Error");
                    BasicUtilities.HandleException(t, msg, useDebug, this.err);
                    this.restoreAutoCommit(false, currentCommit, useTransaction);
                    this.finalizeStatement(ps);
                    event.setProgress(event.getMaximum());
                    this.fireProgressEvent(event);
                    return;
                }
            }
            this.restoreAutoCommit(true, currentCommit, useTransaction);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ImportWizard::runImport()", true, this.err);
            this.restoreAutoCommit(false, currentCommit, useTransaction);
            return;
        }
        finally {
            this.finalizeStatement(ps);
            event.setProgress(event.getMaximum());
            this.fireProgressEvent(event);
        }
    }

    protected void restoreAutoCommit(boolean commit, boolean previousState, boolean useTx) {
        if (useTx && !this.connection.getAutoCommit()) {
            if (commit) {
                this.out.println(BasicUtilities.getString("Import_Transaction_Commit"));
                this.connection.performCommit();
            } else {
                this.out.println(BasicUtilities.getString("Import_Transaction_Rollback"));
                this.connection.performRollBack();
            }
            this.connection.setAutoCommit(previousState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getColumnTypeMap(String table) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        DatabaseMetaData dmd = this.connection.getDatabaseInformation();
        ResultSet set = null;
        String catalog = this.connection.getCatalog();
        String schema = this.connection.getSchema();
        try {
            set = dmd.getColumns(catalog, schema, table, "%");
            while (set.next()) {
                String column = set.getString("COLUMN_NAME");
                int type = set.getInt("DATA_TYPE");
                map.put(column, new Integer(type));
            }
        }
        catch (Throwable t) {
            map.clear();
            BasicUtilities.beep();
            BasicUtilities.HandleException(t);
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable column) {}
            set = null;
        }
        return map;
    }

    protected void fireProgressEvent(ProgressEvent event) {
        EventListener[] delegates = this.listeners.getListeners(ProgressListener.class);
        for (int i = 0; i < delegates.length; ++i) {
            ProgressListener delegate = (ProgressListener)delegates[i];
            try {
                delegate.progressUpdated(event);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void finalizeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.clearBatch();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                stmt.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                stmt.clearParameters();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                stmt = null;
            }
        }
    }

    private ImportPlugin pluginForName(String className) {
        for (ImportPlugin pi : this.plugins) {
            if (!pi.getClass().getName().equals(className)) continue;
            return pi;
        }
        return null;
    }
}

