/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.isqlviewer.core.jetfire.AbstractImportPlugin;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportProcessor;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class LookupPlugin
extends AbstractImportPlugin
implements ActionListener {
    private DefaultComboBoxModel mdlColumns = new DefaultComboBoxModel();
    private DefaultComboBoxModel mdlTables = new DefaultComboBoxModel();
    private JComboBox jcbColumns = new JComboBox(this.mdlColumns);
    private JComboBox jcbTables = new JComboBox(this.mdlTables);
    private JTextField txtWhereClause = new JTextField("");
    private JCheckBox chkAllowNulls = new JCheckBox(BasicUtilities.getString("Import_SQL_Allow_Nulls"));
    private static final String KEY_TABLE = "table";
    private static final String KEY_COLUMN = "column";
    private static final String KEY_ALLOW_NULLS = "allow-nulls";
    private static final String KEY_WHERE = "where";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.jcbTables) {
            DatabaseMetaData dmd = this.connection.getDatabaseInformation();
            ResultSet set = null;
            String catalog = this.connection.getCatalog();
            String schema = this.connection.getSchema();
            String table = (String)this.jcbTables.getSelectedItem();
            this.mdlColumns.removeAllElements();
            try {
                set = dmd.getColumns(catalog, schema, table, "%");
                while (set.next()) {
                    this.mdlColumns.addElement(set.getString("COLUMN_NAME"));
                }
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                BasicUtilities.HandleException(t);
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable throwable) {}
                set = null;
            }
        }
    }

    @Override
    public ImportConfig.Entry createEntry() {
        ImportConfig.Entry entry = new ImportConfig.Entry(this);
        entry.put(KEY_ALLOW_NULLS, new Boolean(this.chkAllowNulls.isSelected()));
        Object item = this.jcbColumns.getSelectedItem();
        if (item != null) {
            entry.put(KEY_COLUMN, item);
        } else {
            entry.put(KEY_COLUMN, "");
        }
        item = this.jcbTables.getSelectedItem();
        if (item != null) {
            entry.put(KEY_TABLE, item);
        } else {
            entry.put(KEY_TABLE, "");
        }
        entry.setProperty(KEY_WHERE, this.txtWhereClause.getText());
        return entry;
    }

    @Override
    public void setEntry(ImportConfig.Entry entry) {
        if (entry.containsKey(KEY_ALLOW_NULLS)) {
            try {
                Boolean bool = (Boolean)entry.get(KEY_ALLOW_NULLS);
                this.chkAllowNulls.setSelected(bool);
            }
            catch (Throwable t) {
                this.chkAllowNulls.setSelected(false);
            }
        }
        this.jcbColumns.setSelectedItem(entry.get(KEY_COLUMN));
        this.jcbTables.setSelectedItem(entry.get(KEY_TABLE));
        this.txtWhereClause.setText(entry.getProperty(KEY_WHERE, ""));
    }

    @Override
    public void installEditor(Container container) {
        container.setLayout(new GridBagLayout());
        LookupPlugin.constrain(0, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        LookupPlugin.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Table")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 0, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbTables, UI_CONSTRAINT);
        LookupPlugin.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Column")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 1, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbColumns, UI_CONSTRAINT);
        LookupPlugin.constrain(1, 2, 1, 1, 0.0, 0.0, 10, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Where")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 2, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.txtWhereClause, UI_CONSTRAINT);
        LookupPlugin.constrain(2, 3, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.chkAllowNulls, UI_CONSTRAINT);
        LookupPlugin.constrain(3, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        LookupPlugin.constrain(0, 4, 4, 1, 1.0, 1.0, 10, 3);
        container.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        this.jcbTables.addActionListener(this);
        Object[] tables = this.connection.getAvailableTables();
        for (int i = 0; i < tables.length; ++i) {
            this.mdlTables.addElement(tables[i]);
        }
        if (this.mdlTables.getSize() >= 1) {
            this.jcbTables.setSelectedIndex(0);
        }
        this.chkAllowNulls.setToolTipText(BasicUtilities.getString("Import_SQL_Allow_Nulls_Tip"));
        this.txtWhereClause.setToolTipText(BasicUtilities.getString("Import_Lookup_Where_Tip"));
        this.jcbColumns.setToolTipText(BasicUtilities.getString("Import_Lookup_Column_Tip"));
        this.jcbTables.setToolTipText(BasicUtilities.getString("Import_Lookup_Table_Tip"));
    }

    @Override
    public ImportProcessor createProcessor() {
        return new LookupProcessor(this);
    }

    @Override
    public String getDescription() {
        return BasicUtilities.getString("Import_SQL_Lookup");
    }

    private static class LookupProcessor
    implements ImportProcessor {
        private static final String SELECT = "SELECT {0} FROM {1} {2}";
        private ImportConfig.Entry current = null;
        private LookupPlugin reference = null;

        public LookupProcessor(LookupPlugin owner) {
            this.reference = owner;
        }

        @Override
        public boolean canSkip() {
            return false;
        }

        @Override
        public int prepareImport(int row, int index, Map values, PreparedStatement ps, int type) throws SQLException {
            block29: {
                if (!this.current.containsKey(LookupPlugin.KEY_COLUMN) || !this.current.containsKey(LookupPlugin.KEY_TABLE)) {
                    this.reference.info(BasicUtilities.getString("Lookup_Bad_Entry"));
                    return 2;
                }
                Statement lookup = ps.getConnection().createStatement();
                ResultSet set = null;
                try {
                    String table = this.current.getProperty(LookupPlugin.KEY_TABLE);
                    String column = this.current.getProperty(LookupPlugin.KEY_COLUMN);
                    String where = this.current.getProperty(LookupPlugin.KEY_WHERE, "");
                    if (where.trim().length() >= 1) {
                        where = "WHERE ".concat(where);
                    }
                    Object[] p = new String[]{column, table, where};
                    String query = MessageFormat.format(SELECT, p);
                    boolean allowNulls = false;
                    try {
                        Boolean bool = (Boolean)this.current.get(LookupPlugin.KEY_ALLOW_NULLS);
                        allowNulls = bool;
                    }
                    catch (Throwable bool) {
                        // empty catch block
                    }
                    this.reference.info(BasicUtilities.getString("Lookup_Query", query));
                    set = lookup.executeQuery(query);
                    if (set.next()) {
                        ResultSetMetaData md = set.getMetaData();
                        int idx = set.findColumn(column);
                        int stype = md.getColumnType(idx);
                        Object data = JDBCUtilities.getValueForType(set, stype, idx);
                        if (!allowNulls && data == null) {
                            int n = 1;
                            return n;
                        }
                        JDBCUtilities.configurePreparedStatement(ps, index, data, type, false);
                        break block29;
                    }
                    int n = allowNulls ? 3 : 1;
                    return n;
                }
                catch (SQLException sqle) {
                    throw sqle;
                }
                catch (Throwable t) {
                    throw new SQLException(t.getMessage());
                }
                finally {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable) {}
                    set = null;
                    try {
                        lookup.close();
                    }
                    catch (Throwable throwable) {}
                    lookup = null;
                }
            }
            return 0;
        }

        @Override
        public void setEntry(ImportConfig.Entry entry) {
            this.current = null;
            this.current = entry;
        }
    }
}

