/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public abstract class AbstractTreeModel
implements TreeModel {
    private transient Vector treeModelListeners;

    @Override
    public final void removeTreeModelListener(TreeModelListener l) {
        if (this.treeModelListeners != null && this.treeModelListeners.contains(l)) {
            Vector v = (Vector)this.treeModelListeners.clone();
            v.removeElement(l);
            this.treeModelListeners = v;
            if (this.treeModelListeners.isEmpty()) {
                this.treeModelListeners = null;
            }
        }
    }

    @Override
    public final void addTreeModelListener(TreeModelListener l) {
        Vector v;
        Vector vector = v = this.treeModelListeners == null ? new Vector(2) : (Vector)this.treeModelListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.treeModelListeners = v;
        }
    }

    public void reload() {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}, null, null));
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                try {
                    TreeModelListener tm = (TreeModelListener)itr.next();
                    tm.treeNodesChanged(e);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                try {
                    TreeModelListener tm = (TreeModelListener)itr.next();
                    tm.treeNodesInserted(e);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                try {
                    TreeModelListener tm = (TreeModelListener)itr.next();
                    tm.treeNodesRemoved(e);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                try {
                    TreeModelListener tm = (TreeModelListener)itr.next();
                    tm.treeStructureChanged(e);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

