/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class MetadataTreeModel
extends DefaultTreeModel {
    private static final DefaultMutableTreeNode UNCACHED_NODE = new DefaultMutableTreeNode("UNCACHED", false);
    private DatabaseMetaData metadata = null;
    private Vector lstTableTypes = null;
    private String currentCatlog = null;
    private String currentSchema = null;
    private MutableTreeNode nodeUDTS = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_User_Data_Types"), false);
    private MutableTreeNode nodeTypes = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Data_Types"), false);
    private MutableTreeNode nodeObjects = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Table_Types"), false);
    private MutableTreeNode nodeCatalog = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Catalogs"), false);
    private MutableTreeNode nodeSchema = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Schemas"), false);
    private MutableTreeNode nodeGeneral = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_General_Info"), false);
    private final DefaultMutableTreeNode nodeRoot = new DefaultMutableTreeNode("", true);
    private boolean procEnabled = true;
    private boolean metaEnabled = true;
    private boolean tabsEnabled = true;

    public String getCurrentCatlog() {
        return this.currentCatlog;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public MetadataTreeModel(DatabaseConnection cnx) {
        super(new DefaultMutableTreeNode("", true));
        this.setRoot(this.nodeRoot);
        if (cnx != null) {
            this.updateConnection(cnx);
        }
    }

    public void updateConnection(DatabaseConnection cnx) {
        if (cnx == null && this.metadata == null) {
            return;
        }
        if (this.nodeRoot != null) {
            this.nodeRoot.removeAllChildren();
        }
        if (cnx != null) {
            this.metadata = cnx.getDatabaseInformation();
            this.nodeRoot.setUserObject(cnx.getConnectionName());
            this.nodeRoot.setAllowsChildren(true);
            try {
                this.setSchema(this.metadata.getUserName(), false);
            }
            catch (Throwable t) {
                this.setSchema(null, false);
            }
            try {
                this.setCatalog(cnx.getCatalog(), false);
            }
            catch (Throwable t) {
                this.setCatalog(null, false);
            }
        } else {
            this.nodeRoot.setUserObject("");
            this.nodeRoot.setAllowsChildren(false);
            this.metadata = null;
            this.lstTableTypes = null;
            this.currentCatlog = null;
            this.currentSchema = null;
            this.reload(this.nodeRoot);
        }
    }

    public synchronized void setCatalog(String pCatalog) {
        this.setCatalog(pCatalog, true);
    }

    public synchronized void setSchema(String pSchema) {
        this.setSchema(pSchema, true);
    }

    public synchronized void setCatalog(String pCatalog, boolean reload) {
        this.currentCatlog = pCatalog != null ? pCatalog : null;
        if (reload) {
            this.reload();
        }
    }

    public synchronized void setSchema(String pSchema, boolean reload) {
        this.currentSchema = pSchema != null ? pSchema : null;
        if (reload) {
            this.reload();
        }
    }

    @Override
    public synchronized void reload() {
        this.nodeRoot.removeAllChildren();
        this.initNodes();
        this.reload(this.nodeRoot);
    }

    public int getTableTypeCount() {
        try {
            return this.lstTableTypes.size();
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    public boolean isUncachedNode(DefaultMutableTreeNode node) {
        try {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
            return child.getUserObject().toString().equalsIgnoreCase(UNCACHED_NODE.getUserObject().toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTableTypeNode(DefaultMutableTreeNode parent, String TableType) {
        parent.removeAllChildren();
        ResultSet set = null;
        if (this.tabsEnabled && this.isTableTypeNode(parent)) {
            try {
                set = this.metadata.getTables(this.currentCatlog, this.currentSchema, null, new String[]{TableType.trim()});
                Object[] lTableList = JDBCUtilities.getSingleColumn(set, "TABLE_NAME", null);
                for (int i = 0; i < lTableList.length; ++i) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(lTableList[i], true);
                    this.insertNodeInto(node, parent, 0);
                    if (!this.metaEnabled) continue;
                    this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), node, 0);
                }
            }
            catch (Throwable lTableList) {
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable lTableList) {}
            }
        } else if (this.procEnabled && this.isProcedureNode(parent)) {
            try {
                set = this.metadata.getProcedures(this.currentCatlog, this.currentSchema, null);
                Object[] itr = JDBCUtilities.getSingleColumn(set, "PROCEDURE_NAME", null);
                for (int i = 0; i < itr.length; ++i) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(itr[i], true);
                    this.insertNodeInto(node, parent, 0);
                    if (!this.metaEnabled) continue;
                    this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), node, 0);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.reload(parent);
    }

    public boolean isTableTypeNode(DefaultMutableTreeNode node) {
        try {
            if (this.isProcedureNode(node)) {
                return false;
            }
            if (node.getLevel() > 1) {
                return this.lstTableTypes.contains(node.getPath()[1].toString());
            }
            return this.lstTableTypes.contains(node.getUserObject().toString()) && !node.isRoot();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isProcedureNode(DefaultMutableTreeNode node) {
        try {
            String txt = node.getUserObject().toString();
            String prc = BasicUtilities.getString("JDBC_Procedures");
            return prc.equalsIgnoreCase(txt);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTableChildNodes(DefaultMutableTreeNode parent) {
        parent.removeAllChildren();
        DefaultMutableTreeNode type = (DefaultMutableTreeNode)parent.getPath()[1];
        if (this.isProcedureNode(type)) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Columns"), false);
            this.insertNodeInto(node, parent, 0);
            this.reload(parent);
            return;
        }
        String tableName = parent.getUserObject().toString();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Columns"), true);
        this.insertNodeInto(node, parent, 0);
        this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), node, 0);
        ResultSet set = null;
        try {
            set = this.metadata.getSuperTables(this.currentCatlog, this.currentSchema, tableName);
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Super_Tables"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            set = this.metadata.getIndexInfo(this.currentCatlog, this.currentSchema, tableName, false, false);
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Indicies"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            set = this.metadata.getPrimaryKeys(this.currentCatlog, this.currentSchema, tableName);
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Primary_Keys"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            set = this.metadata.getExportedKeys(this.currentCatlog, this.currentSchema, tableName);
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Exported_Keys"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            set = this.metadata.getImportedKeys(this.currentCatlog, this.currentSchema, tableName);
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Imported_Keys"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            set = this.metadata.getVersionColumns(this.currentCatlog, this.currentSchema, tableName);
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Version_Columns"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            set = this.metadata.getTablePrivileges(this.currentCatlog, this.currentSchema, tableName);
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Table_Privileges"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            set = this.metadata.getColumnPrivileges(this.currentCatlog, this.currentSchema, tableName, "%");
            if (set.next()) {
                parent.add(new DefaultMutableTreeNode(BasicUtilities.getString("JDBC_Column_Privileges"), false));
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            this.metadata.getConnection().clearWarnings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reload(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColumnChildNodes(DefaultMutableTreeNode parent) {
        parent.removeAllChildren();
        ResultSet set = null;
        try {
            String Table = parent.getPath()[2].toString();
            set = this.metadata.getColumns(this.currentCatlog, this.currentSchema, Table, null);
            Object[] itr = JDBCUtilities.getSingleColumn(set, "COLUMN_NAME", null);
            for (int i = 0; i < itr.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(itr[i], true);
                this.insertNodeInto(node, parent, 0);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            this.metadata.getConnection().clearWarnings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reload(parent);
    }

    public boolean isMetadataEnabled() {
        return this.metaEnabled;
    }

    public boolean isProceduresEnabled() {
        return this.procEnabled;
    }

    public boolean isTablesEnabled() {
        return this.tabsEnabled;
    }

    public void setMetadataEnabled(boolean b) {
        this.metaEnabled = b;
    }

    public void setProceduresEnabled(boolean b) {
        this.procEnabled = b;
    }

    public void setTablesEnabled(boolean b) {
        this.tabsEnabled = b;
    }

    protected void addVector(DefaultMutableTreeNode Parent, Vector pNodes, boolean hasChildren) {
        Iterator lIterator = pNodes.iterator();
        while (lIterator.hasNext()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(lIterator.next(), hasChildren);
            this.insertNodeInto(node, Parent, 0);
            if (!hasChildren) continue;
            this.insertNodeInto((DefaultMutableTreeNode)UNCACHED_NODE.clone(), node, 0);
        }
    }

    protected void initNodes() {
        if (this.metaEnabled) {
            this.insertNodeInto(this.nodeUDTS, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeTypes, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeObjects, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeCatalog, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeSchema, this.nodeRoot, 0);
            this.insertNodeInto(this.nodeGeneral, this.nodeRoot, 0);
        }
        if (this.tabsEnabled) {
            this.addTableTypeNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTableTypeNodes() {
        ResultSet set = null;
        try {
            set = this.metadata.getTableTypes();
            this.lstTableTypes = new Vector<Object>(Arrays.asList(JDBCUtilities.getSingleColumn(set, "TABLE_TYPE", null)));
            Iterator types = this.lstTableTypes.iterator();
            try {
                set.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (types.hasNext()) {
                String[] ttypes = new String[]{((String)types.next()).trim()};
                try {
                    set = this.metadata.getTables(this.currentCatlog, this.currentSchema, null, ttypes);
                    if (set.next()) continue;
                    types.remove();
                }
                catch (Exception e) {
                    types.remove();
                }
                finally {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (this.procEnabled) {
                try {
                    set = this.metadata.getProcedures(this.currentCatlog, this.currentSchema, null);
                    if (set.next()) {
                        this.lstTableTypes.insertElementAt(BasicUtilities.getString("JDBC_Procedures"), 0);
                    }
                }
                catch (Throwable throwable) {
                }
                finally {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.addVector(this.nodeRoot, this.lstTableTypes, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.metadata.getConnection().clearWarnings();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

