/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;

public class SQLTableModel
extends EnhancedTableModel {
    public static final int TYPE_MAP = 0;
    public static final int TYPE_RESULTSET = 1;
    public static final int TYPE_UNKNOWN = 2;
    private boolean isEditable = false;
    private boolean isOptimized = false;
    private int type = 2;

    public SQLTableModel(ResultSet set) {
        this.setData(set);
    }

    public SQLTableModel(Map table) {
        this.setData(table);
    }

    public SQLTableModel() {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.isEditable;
    }

    @Override
    public void clearAll() {
        super.clearAll();
        this.isOptimized = false;
        this.type = 2;
    }

    @Override
    public int getTrueRowCount() {
        if (this.type == 1 && this.isOptimized) {
            return 1;
        }
        return super.getTrueRowCount();
    }

    public int getModelType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(ResultSet set) {
        this.clearAllData();
        this.type = 1;
        SQLTableModel sQLTableModel = this;
        synchronized (sQLTableModel) {
            try {
                ResultSetMetaData rsmd = set.getMetaData();
                int cc = rsmd.getColumnCount();
                for (int c = 1; c <= cc; ++c) {
                    try {
                        this.columns.add(rsmd.getColumnLabel(c));
                        continue;
                    }
                    catch (Throwable t) {
                        this.columns.add(rsmd.getColumnName(c));
                    }
                }
                int rowNum = 1;
                while (set.next()) {
                    ArrayList<String> row = new ArrayList<String>(cc);
                    for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                        String str = set.getString(i);
                        row.add(set.wasNull() ? null : str.trim());
                    }
                    this.addRow(row);
                    ++rowNum;
                }
                rsmd = null;
                this.optimizeResultSetView();
            }
            catch (Throwable t) {
                this.clearAllData();
                BasicUtilities.HandleException(t, "iSQLTableModel::setData(ResultSet)", true);
            }
        }
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Map table) {
        this.clearAllData();
        this.type = 0;
        SQLTableModel sQLTableModel = this;
        synchronized (sQLTableModel) {
            this.columns.add(BasicUtilities.getString("Property_Name"));
            this.columns.add(BasicUtilities.getString("Property_Value"));
            for (Object next : table.keySet()) {
                if (next == null) continue;
                ArrayList<String> row = new ArrayList<String>(2);
                String k = new String(next.toString());
                row.add(k);
                Object o = table.get(k);
                row.add(o != null ? o.toString() : null);
                this.addRow(row);
            }
        }
        this.fireTableStructureChanged();
    }

    public Properties getTableAsProperties() {
        Properties props = new Properties();
        if (this.getColumnCount() >= 2) {
            for (int r = 0; r < this.getRowCount(); ++r) {
                try {
                    String key = (String)this.getValueAt(r, 0);
                    String value = (String)this.getValueAt(r, 1);
                    props.setProperty(key, value);
                    continue;
                }
                catch (NullPointerException npe) {
                    continue;
                }
                catch (ClassCastException cce) {
                    continue;
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "iSQLTableModel::getTableAsProperties()");
                }
            }
        }
        return props;
    }

    public void allowEditing(boolean f) {
        this.isEditable = f;
    }

    protected boolean optimizeResultSetView() {
        if (this.getRowCount() != 1 || this.getModelType() != 1) {
            return false;
        }
        ArrayList col1 = (ArrayList)((ArrayList)this.dataStore.get(0)).clone();
        ArrayList col0 = (ArrayList)this.columns.clone();
        this.clearAllData();
        this.isOptimized = true;
        this.type = 1;
        String[] newColumns = new String[]{BasicUtilities.getString("Table_Column_Name"), BasicUtilities.getString("Column_Value")};
        this.setColumns(newColumns);
        Iterator enum_ = col0.iterator();
        Iterator enum2 = col1.iterator();
        while (enum_.hasNext()) {
            ArrayList row = new ArrayList(2);
            row.add(enum_.next());
            if (enum2.hasNext()) {
                row.add(enum2.next());
            } else {
                row.add(null);
            }
            this.addRow(row);
        }
        enum_ = null;
        enum2 = null;
        col0 = null;
        col1 = null;
        System.runFinalization();
        return true;
    }
}

