/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.AbstractTreeModel;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.UserPreferences;

public class ScriptTreeModel
extends AbstractTreeModel {
    private final Object ROOT_NODE = new Object();
    private SystemConfig sysConfig = SystemConfig.getInstance();
    protected EventListenerList listenerList = new EventListenerList();
    protected Vector rootPaths = new Vector();
    protected FileFilter fileFilter = null;

    public ScriptTreeModel() {
        this(null);
    }

    public ScriptTreeModel(FileFilter filter) {
        this.setScriptFilter(filter);
        UserPreferences prefs = this.sysConfig.getPreferences();
        String paths = prefs.get("scripting.path");
        StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
        while (st.hasMoreTokens()) {
            File f = new File(st.nextToken());
            if (!f.isDirectory()) continue;
            this.rootPaths.add(f);
        }
    }

    public void setScriptFilter(FileFilter filter) {
        this.fileFilter = filter;
        this.reload();
    }

    @Override
    public Object getRoot() {
        return this.ROOT_NODE;
    }

    @Override
    public int getChildCount(Object o) {
        if (o == this.ROOT_NODE) {
            return this.rootPaths.size();
        }
        if (o instanceof File) {
            File[] files = null;
            File f = (File)o;
            files = this.fileFilter == null ? f.listFiles() : f.listFiles(this.fileFilter);
            return files.length;
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object o) {
        if (o == this.ROOT_NODE) {
            return false;
        }
        if (o instanceof File) {
            return !((File)o).isDirectory();
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath tp, Object o) {
    }

    @Override
    public int getIndexOfChild(Object o, Object c) {
        if (o == this.ROOT_NODE) {
            return this.rootPaths.indexOf(c);
        }
        if (o instanceof File) {
            File[] files = null;
            File f = (File)o;
            files = this.fileFilter == null ? f.listFiles() : f.listFiles(this.fileFilter);
            return Arrays.asList(files).indexOf(c);
        }
        return -1;
    }

    @Override
    public Object getChild(Object o, int idx) {
        if (o == this.ROOT_NODE) {
            return this.rootPaths.get(idx);
        }
        if (o instanceof File) {
            File[] files = null;
            File f = (File)o;
            files = this.fileFilter == null ? f.listFiles() : f.listFiles(this.fileFilter);
            return files[idx];
        }
        return null;
    }
}

