/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.event;

import java.util.EventObject;
import org.isqlviewer.sql.DatabaseConnection;

public class DatabaseEvent
extends EventObject {
    public static final int DISCONNECT = 0;
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    public static final int INITIALIZE = 3;
    public static final int AUTO_COMMIT_CHANGE = 4;
    public static final int CATALOG_CHANGE = 5;
    private int eventCode = -1;

    public DatabaseEvent(Object source, int code) {
        super(source);
        if (!(source instanceof DatabaseConnection)) {
            throw new IllegalArgumentException();
        }
        DatabaseEvent.checkCode(code);
        this.eventCode = code;
    }

    public int getID() {
        return this.eventCode;
    }

    public DatabaseConnection getConnection() {
        return (DatabaseConnection)this.getSource();
    }

    protected static void checkCode(int code) throws IllegalArgumentException {
        switch (code) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return;
            }
        }
        throw new IllegalArgumentException(Integer.toString(code));
    }
}

