/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.isqlviewer.event.DatabaseEvent;
import org.isqlviewer.event.DatabaseListener;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DriverPool;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;

public final class DatabaseConnection {
    private Driver gsJDBCDriver = null;
    private String gsJDBCurl = null;
    private Connection gsConnection = null;
    private IJSpace gsSpaceProxy = null;
    private boolean useSingleSpace = true;
    private static final String USER_PROP = "user";
    private static final String PASSWORD_PROP = "password";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");
    private static final Hashtable QUERY_THREADS = new Hashtable(0, 0.95f);
    static ResourceBundle resourceBundle = null;
    private ArrayList listenerList = null;
    private String[] tableTypes = null;
    private String preferredSchema = null;
    private GConnection databaseCnx = null;
    private DatabaseMetaData cnxMetaData = null;
    private SQLException lastError;
    private boolean supportsTransactions = false;
    private boolean supportsBatch = false;
    private boolean supportMultiResults = false;
    private boolean supportsSavePoints = false;
    private Properties props = new Properties();
    private Properties configuration = new Properties();
    private HashMap metaCache;
    private String cnxAlias;
    private String jdbcURL;
    private Driver jdbcDriver;
    private HashMap stmtMap = new HashMap();
    private int maxStatements = 1;

    public DatabaseConnection(String jdbcURL, Properties jdbcProperties) throws SQLException {
        this.jdbcURL = jdbcURL;
        this.props.putAll((Map<?, ?>)jdbcProperties);
        this.jdbcDriver = DriverPool.getDriver(jdbcURL);
        this.logDriverInformation();
    }

    public DatabaseConnection() {
    }

    public DatabaseConnection(Driver gsDriverClass, Properties jdbcProperties, IJSpace spaceProxy) {
        this.gsSpaceProxy = spaceProxy;
        if (jdbcProperties != null) {
            this.props.putAll((Map<?, ?>)jdbcProperties);
        }
        try {
            this.gsJDBCDriver = gsDriverClass;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logDriverInformation();
    }

    public DatabaseConnection(String gsDriverClass, String gsJDBCurl) {
        this.gsJDBCurl = gsJDBCurl;
        try {
            this.gsJDBCDriver = (Driver)Class.forName(gsDriverClass, false, null).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logDriverInformation();
    }

    public DatabaseConnection(Driver gsDriver, String gsJDBCurl) {
        this.gsJDBCurl = gsJDBCurl;
        this.gsJDBCDriver = gsDriver;
        this.logDriverInformation();
    }

    public DatabaseConnection(String jdbcURL, String jdbcUser, String jdbcPass) throws SQLException {
        this.jdbcURL = jdbcURL;
        this.updateAutheticationTokens(jdbcUser, jdbcPass);
        this.jdbcDriver = DriverPool.getDriver(jdbcURL);
        this.logDriverInformation();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public PreparedStatement createPreparedStatement(String sql, int type, int concurrency) throws SQLException {
        PreparedStatement ps = this.databaseCnx.prepareStatement(sql, type, concurrency);
        this.configureStatement(ps);
        return ps;
    }

    public PreparedStatement createPreparedStatement(String sql) throws SQLException {
        PreparedStatement ps = this.databaseCnx.prepareStatement(sql);
        this.configureStatement(ps);
        return ps;
    }

    public Statement createStatement() throws SQLException {
        Statement stmt = this.databaseCnx.createStatement();
        this.configureStatement(stmt);
        return stmt;
    }

    public Statement createStatement(int type, int concurrency) throws SQLException {
        Statement stmt = this.databaseCnx.createStatement(type, concurrency);
        this.configureStatement(stmt);
        return stmt;
    }

    public void configureOptions(Properties properties) {
        this.configuration.clear();
        if (properties == null) {
            return;
        }
        this.configuration.putAll((Map<?, ?>)properties);
    }

    public void disposeStatement(String statementID) {
        ResultSetRetreiver rsr = (ResultSetRetreiver)this.stmtMap.remove(statementID);
        if (rsr != null) {
            String msg = BasicUtilities.getString(resourceBundle, "Statement_Dispose", statementID);
            this.logEvent(msg);
            this.finalizeStatement(rsr.sqlStatement, false);
            QUERY_THREADS.remove(statementID.toUpperCase());
        }
        rsr = null;
    }

    public void cancelStatement(String statementID) {
        ResultSetRetreiver rsr = (ResultSetRetreiver)this.stmtMap.remove(statementID);
        if (rsr != null) {
            Thread t = DatabaseConnection.getThreadForName(statementID);
            if (t != null) {
                t.interrupt();
            }
            this.finalizeStatement(rsr.sqlStatement, true);
            QUERY_THREADS.remove(statementID.toUpperCase());
        }
        rsr = null;
    }

    public boolean gsConnect(Driver gsJDBCDriver, String gsJDBCurl) throws SQLException {
        this.gsJDBCDriver = gsJDBCDriver;
        this.gsJDBCurl = gsJDBCurl;
        return this.gsConnect();
    }

    public boolean gsConnect() throws SQLException {
        if (!this.isClosed()) {
            this.disconnect();
        }
        try {
            if (this.props.containsKey(USER_PROP)) {
                this.props.remove(USER_PROP);
            }
            if (this.props.containsKey(PASSWORD_PROP)) {
                this.props.remove(PASSWORD_PROP);
            }
            this.databaseCnx = GConnection.getInstance((IJSpace)this.gsSpaceProxy, (Properties)this.props);
            this.gsJDBCurl = this.databaseCnx.getUrl();
            this.databaseCnx.setUseSingleSpace(this.useSingleSpace);
        }
        catch (Exception sqle) {
            String[] params = new String[]{sqle.getMessage(), this.gsJDBCurl};
            String newMsg = BasicUtilities.getString(resourceBundle, "Connection_SQL_Exception", params);
            throw new SQLException(newMsg);
        }
        catch (Throwable t) {
            String msg = BasicUtilities.getString(resourceBundle, "Connection_Exception", this.gsJDBCurl);
            BasicUtilities.HandleException(t, msg, this.getDebugOn());
            return false;
        }
        try {
            if (this.getPreferredHoldability() != Integer.MAX_VALUE) {
                this.databaseCnx.setHoldability(this.getPreferredHoldability());
                this.databaseCnx.setUseSingleSpace(true);
                this.gsConnection = this.databaseCnx;
            }
        }
        catch (SQLException sqle) {
            this.trace("Connection::setHoldability", sqle);
        }
        catch (Throwable sqle) {
            // empty catch block
        }
        try {
            this.cnxMetaData = this.databaseCnx.getMetaData();
        }
        catch (SQLException sqle) {
            this.trace("Connection::getMetaData", sqle);
            this.cnxMetaData = null;
        }
        catch (Throwable t) {
            this.trace("Connection::getMetaData", t);
            this.cnxMetaData = null;
        }
        return true;
    }

    public Connection getGSConnection() {
        return this.databaseCnx;
    }

    public void updateAutheticationTokens(String user, String pass) {
        if (!this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Already_Connected"));
        }
        this.props.put(USER_PROP, user == null ? "" : user);
        this.props.put(PASSWORD_PROP, pass == null ? "" : pass);
    }

    public DriverPropertyInfo[] getDriverProperties(Properties defaults) throws SQLException {
        if (this.jdbcDriver != null) {
            return this.jdbcDriver.getPropertyInfo(this.jdbcURL, defaults);
        }
        return new DriverPropertyInfo[0];
    }

    public Driver getDriver() {
        return this.jdbcDriver;
    }

    public void changeCatalog(String newCatalog) throws SQLException {
        block4: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                this.databaseCnx.setCatalog(newCatalog);
                this.fireDatabaseEvent(new DatabaseEvent(this, 5));
            }
            catch (SQLException sqle) {
                this.HandleSQLException(sqle);
                throw sqle;
            }
            catch (Throwable t) {
                if (!this.getVerboseOn()) break block4;
                String msg = BasicUtilities.getString(resourceBundle, "Catalog_Change_Error", newCatalog);
                BasicUtilities.HandleException(t, msg, this.getDebugOn());
            }
        }
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            this.databaseCnx.setTransactionIsolation(isolation);
        }
        catch (SQLException sqle) {
            this.HandleSQLException(sqle);
            throw sqle;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCatalog() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getCatalog();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getSchema() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.preferredSchema;
    }

    public void setPreferredSchema(String schema) {
        this.preferredSchema = schema;
    }

    public boolean isBatchSupported() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.supportsBatch;
    }

    public boolean isTransactionsSupported() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.supportsTransactions;
    }

    public boolean isSavePointsSupported() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.supportsSavePoints;
    }

    public synchronized void setAutoCommit(boolean flag) {
        block4: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                String[] p = new String[]{this.getConnectionName(), Boolean.toString(flag)};
                this.logEvent(BasicUtilities.getString(resourceBundle, "AutoCommitMode_Change", p));
                this.databaseCnx.setAutoCommit(flag);
                this.fireDatabaseEvent(new DatabaseEvent(this, 4));
            }
            catch (SQLException sqle) {
                this.HandleSQLException(sqle);
            }
            catch (Throwable t) {
                if (!this.getVerboseOn()) break block4;
                BasicUtilities.HandleException(t, null, this.getDebugOn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRollBack() {
        block7: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                this.logEvent(BasicUtilities.getString(resourceBundle, "Rollback_Notice", this.getConnectionName()));
                GConnection gConnection = this.databaseCnx;
                synchronized (gConnection) {
                    this.databaseCnx.rollback();
                }
                this.fireDatabaseEvent(new DatabaseEvent(this, 2));
            }
            catch (SQLException sqle) {
                this.HandleSQLException(sqle);
            }
            catch (Throwable t) {
                if (!this.getVerboseOn()) break block7;
                BasicUtilities.HandleException(t, null, this.getDebugOn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            SQLWarning sQLWarning = this.databaseCnx.getWarnings();
            return sQLWarning;
        }
        catch (SQLException sqle) {
            this.HandleSQLException(sqle);
            SQLWarning sQLWarning = null;
            return sQLWarning;
        }
        catch (Throwable t) {
            if (this.getVerboseOn()) {
                BasicUtilities.HandleException(t, null, this.getDebugOn());
            }
            SQLWarning sQLWarning = null;
            try {
                this.databaseCnx.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return sQLWarning;
        }
        finally {
            try {
                this.databaseCnx.clearWarnings();
            }
            catch (Throwable throwable) {}
        }
    }

    public Map getTypeMap() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getTypeMap();
        }
        catch (SQLException sqle) {
            this.HandleSQLException(sqle);
            return null;
        }
        catch (Throwable t) {
            if (this.getVerboseOn()) {
                BasicUtilities.HandleException(t, null, this.getDebugOn());
            }
            return null;
        }
    }

    public int getTransactionIsolation() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getTransactionIsolation();
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public boolean getAutoCommit() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.databaseCnx.getAutoCommit();
        }
        catch (Throwable e) {
            return true;
        }
    }

    public void setConnectionName(String name) {
        this.cnxAlias = new String(name.getBytes());
    }

    public String getConnectionName() {
        return this.gsJDBCurl;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public int getActiveStatements() {
        return this.stmtMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommit() {
        block8: {
            if (this.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
            }
            try {
                this.logEvent(BasicUtilities.getString(resourceBundle, "Commit_Notice", this.getConnectionName()));
                GConnection gConnection = this.databaseCnx;
                synchronized (gConnection) {
                    if (!this.getAutoCommit()) {
                        this.databaseCnx.commit();
                    }
                }
                this.fireDatabaseEvent(new DatabaseEvent(this, 1));
            }
            catch (SQLException sqle) {
                this.HandleSQLException(sqle);
            }
            catch (Throwable t) {
                if (!this.getVerboseOn()) break block8;
                BasicUtilities.HandleException(t, null, this.getDebugOn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        this.flushConnectionInfo();
        if (this.databaseCnx == null) {
            return;
        }
        DatabaseConnection.interruptQueries();
        DatabaseConnection databaseConnection = this;
        synchronized (databaseConnection) {
            if (!this.getAutoCommit()) {
                this.log(BasicUtilities.getString(resourceBundle, "Commit_On_Close_Notice"));
                this.performCommit();
            }
            Iterator itr = this.stmtMap.keySet().iterator();
            int mapSize = this.stmtMap.size();
            ArrayList<String> removedStatementIDsList = new ArrayList<String>(mapSize);
            while (itr.hasNext()) {
                String id = (String)itr.next();
                this.disposeStatement(id);
                removedStatementIDsList.add(id);
            }
            for (int index = 0; index < mapSize; ++index) {
                this.stmtMap.remove(removedStatementIDsList.get(index));
            }
            try {
                this.databaseCnx.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.databaseCnx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.databaseCnx = null;
            this.cnxMetaData = null;
        }
        this.fireDatabaseEvent(new DatabaseEvent(this, 0));
        this.logEvent(BasicUtilities.getString(resourceBundle, "Disconnect_Notice", this.getConnectionName()));
    }

    public void logDriverInformation() {
        this.log(BasicUtilities.getString(resourceBundle, "Driver_Information", new String[]{this.gsJDBCDriver.getClass().getName(), Integer.toString(this.gsJDBCDriver.getMajorVersion()), Integer.toString(this.gsJDBCDriver.getMinorVersion())}));
        if (this.gsJDBCDriver.jdbcCompliant()) {
            this.log(BasicUtilities.getString(resourceBundle, "Driver_Is_Compliant"));
        } else {
            this.log(BasicUtilities.getString(resourceBundle, "Driver_Is_Not_Compliant"));
        }
    }

    public final synchronized boolean isClosed() {
        if (this.databaseCnx != null) {
            try {
                return this.databaseCnx.isClosed();
            }
            catch (SQLException sqle) {
                this.HandleSQLException(sqle);
                this.databaseCnx = null;
                return true;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                this.databaseCnx = null;
                return true;
            }
        }
        return true;
    }

    public SQLException getLastError() {
        return this.lastError;
    }

    public DatabaseMetaData getDatabaseInformation() {
        return this.cnxMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushConnectionInfo() {
        if (this.metaCache != null) {
            HashMap hashMap = this.metaCache;
            synchronized (hashMap) {
                this.metaCache.clear();
                this.metaCache = null;
            }
        }
    }

    public synchronized Map getConnectionInformation() {
        if (this.metaCache == null) {
            try {
                if (this.gsConnection == null) {
                    this.gsConnect();
                }
                DatabaseMetaData dmd = this.databaseCnx.getMetaData();
                Class<?> c = dmd.getClass();
                Method[] methods = c.getMethods();
                this.metaCache = new HashMap();
                Object[] p = new Object[]{};
                for (int i = 0; i < methods.length; ++i) {
                    String n = methods[i].getName();
                    try {
                        Object res;
                        Class<?> cClass = methods[i].getReturnType();
                        if (!cClass.isPrimitive() && !cClass.getName().endsWith("String")) continue;
                        if (n.startsWith("get")) {
                            n = n.substring(3);
                        }
                        this.metaCache.put(n, (res = methods[i].invoke((Object)dmd, p)) != null ? res.toString() : null);
                        continue;
                    }
                    catch (AbstractMethodError ame) {
                        this.metaCache.put(n, BasicUtilities.getString(resourceBundle, "Unsupported_Method"));
                        continue;
                    }
                    catch (Throwable t) {
                        if (t instanceof SQLException) {
                            this.HandleSQLException((SQLException)t);
                            continue;
                        }
                        if (!this.getDebugOn()) continue;
                        BasicUtilities.HandleException(t, "getConnectionInformation()", this.getVerboseOn());
                    }
                }
            }
            catch (Exception e) {
                BasicUtilities.HandleException(e);
            }
        }
        return this.metaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabaseListener(DatabaseListener l) {
        if (this.listenerList != null && this.listenerList.contains(l)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatabaseListener(DatabaseListener l) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList(1);
        }
        if (!this.listenerList.contains(l)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.add(l);
            }
        }
    }

    public int getMaxRowCount() {
        try {
            String property = this.configuration.getProperty("jdbc.max-rows");
            Integer value = Integer.decode(property);
            return value;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public int getPreferredHoldability() {
        try {
            String property = this.configuration.getProperty("jdbc.resultset-holdability");
            Integer value = Integer.decode(property);
            return value;
        }
        catch (Throwable t) {
            return Integer.MAX_VALUE;
        }
    }

    public int getMaxFieldSize() {
        try {
            String property = this.configuration.getProperty("jdbc.max-fieldsize");
            Integer value = Integer.decode(property);
            return value;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public int getQueryTimeout() {
        try {
            String property = this.configuration.getProperty("jdbc.timeout-query");
            Integer value = Integer.decode(property);
            return value;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public boolean getVerboseOn() {
        try {
            String property = this.configuration.getProperty("jdbc.verbose-enabled");
            Boolean value = Boolean.valueOf(property);
            return value;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean getDebugOn() {
        try {
            String property = this.configuration.getProperty("jdbc.debug-enabled");
            Boolean value = Boolean.valueOf(property);
            return value;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isGeneratedKeysEnabled() {
        try {
            String property = this.configuration.getProperty("jdbc.resultsetkeys-enabled");
            Boolean value = Boolean.valueOf(property);
            return value;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean getQueryEchoOn() {
        try {
            String property = this.configuration.getProperty("jdbc.echo-query");
            Boolean value = Boolean.valueOf(property);
            return value;
        }
        catch (Throwable t) {
            this.trace("getQueryEchoOn()", t);
            return false;
        }
    }

    public boolean getAutoReconnect() {
        try {
            String property = this.configuration.getProperty("jdbc.keepalive-enabled");
            Boolean value = Boolean.valueOf(property);
            return value;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean getEscapeProcessingOn() {
        try {
            String property = this.configuration.getProperty("jdbc.escapeProc-enabled");
            Boolean value = Boolean.valueOf(property);
            return value;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int getFetchMode() {
        try {
            String property = this.configuration.getProperty("jdbc.reverseFetch-enabled");
            Integer value = Integer.decode(property);
            return value;
        }
        catch (Throwable t) {
            return 1002;
        }
    }

    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public final void logEvent(String msg) {
        if (this.getVerboseOn()) {
            this.log(msg);
        }
    }

    public String executeStaticRequest(String sql, ResultSetViewer rndr) {
        return this.executeStaticRequest(sql, rndr, 1004, 1007);
    }

    public String executeStaticRequest(String sql, ResultSetViewer rndr, int rType, int conc) {
        try {
            if (this.gsConnection == null) {
                this.gsConnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String stmtID = Long.toHexString(System.currentTimeMillis()).toUpperCase();
        String fmt = "isql.{0}.{1}";
        stmtID = MessageFormat.format(fmt, this.getConnectionName(), stmtID);
        ResultSetRetreiver r = new ResultSetRetreiver(stmtID, rndr, null, sql);
        r.setResultsetType(rType);
        r.setResultsetConcurrency(conc);
        Thread t = new Thread((Runnable)r, stmtID);
        QUERY_THREADS.put(stmtID.toUpperCase(), t);
        t.start();
        return stmtID;
    }

    public String executeStatement(Statement statement, String sql, ResultSetViewer viewer) {
        String stmtID = Long.toHexString(System.currentTimeMillis()).toUpperCase();
        String fmt = "isql.{0}.{1}";
        stmtID = MessageFormat.format(fmt, this.getConnectionName(), stmtID);
        ResultSetRetreiver rsr = new ResultSetRetreiver(stmtID, viewer, statement, sql);
        Thread t = new Thread((Runnable)rsr, stmtID);
        QUERY_THREADS.put(stmtID.toUpperCase(), t);
        t.start();
        return stmtID;
    }

    public String executePreparedRequest(String psql, Object[] data, int[] types, ResultSetViewer rndr) throws SQLException {
        return this.executePreparedRequest(psql, data, types, rndr, 1004, 1007);
    }

    public String executePreparedRequest(String psql, Object[] data, int[] types, ResultSetViewer rndr, int rType, int conc) throws SQLException {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        PreparedStatement stmt = null;
        if (rndr == null) {
            rndr = new NullResultSetViewer(this);
        }
        try {
            stmt = this.cnxMetaData.supportsResultSetConcurrency(rType, conc) ? this.createPreparedStatement(psql, rType, conc) : this.createPreparedStatement(psql);
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
        if (stmt != null) {
            JDBCUtilities.configurePreparedStatement(stmt, data, types, false);
            SQLWarning warnings = stmt.getWarnings();
            if (warnings != null) {
                rndr.recieveStatementWarnings(stmt, warnings);
                stmt.clearWarnings();
            }
            String stmtID = Long.toHexString(System.currentTimeMillis()).toUpperCase();
            String fmt = "isql.{0}.{1}";
            stmtID = MessageFormat.format(fmt, this.getConnectionName(), stmtID);
            ResultSetRetreiver r = new ResultSetRetreiver(stmtID, rndr, stmt, psql);
            r.setResultsetType(rType);
            r.setResultsetConcurrency(conc);
            Thread t = new Thread((Runnable)r, stmtID);
            QUERY_THREADS.put(stmtID.toUpperCase(), t);
            t.start();
            return stmtID;
        }
        throw new SQLException();
    }

    public int[] executeBatch(Collection statements) throws SQLException {
        return this.executeBatch(statements, !this.supportsBatch, this.supportsTransactions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(Collection statements, boolean force, boolean isTransaction, ProgressListener callback) throws SQLException {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        if (statements.isEmpty()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Cannot_Execute_Empty_Batch"));
        }
        ProgressEvent event = new ProgressEvent(this, 0, statements.size());
        Statement stmt = null;
        int[] results = new int[statements.size()];
        int idx = 0;
        if (isTransaction) {
            this.setAutoCommit(false);
        }
        Iterator itr = statements.iterator();
        if (force) {
            while (itr.hasNext()) {
                try {
                    stmt = this.createStatement();
                    String sql = (String)itr.next();
                    long epoch = System.currentTimeMillis();
                    if (this.getQueryEchoOn()) {
                        String[] p = new String[2];
                        p[0] = BasicUtilities.getString(resourceBundle, "Basic_Query");
                        try {
                            p[1] = this.databaseCnx.nativeSQL(sql == null ? "" : sql);
                        }
                        catch (Throwable t) {
                            p[1] = sql == null ? "" : sql;
                        }
                        this.log(BasicUtilities.getString(resourceBundle, "Query_Echo", p));
                        p = null;
                    }
                    event.setProgress(idx);
                    stmt.execute(sql);
                    int rows = stmt.getUpdateCount();
                    results[idx++] = rows;
                    this.logEvent(BasicUtilities.getString(resourceBundle, "Row_Affected_Count", Integer.toString(rows)));
                    this.finalizeStatement(stmt, false);
                    if (callback != null) {
                        callback.progressUpdated(event);
                        try {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new InterruptedException();
                            }
                            DatabaseConnection t = this;
                            synchronized (t) {
                                this.wait(5L);
                            }
                        }
                        catch (InterruptedException ie) {
                            if (isTransaction) {
                                this.performRollBack();
                            }
                            return null;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    epoch = System.currentTimeMillis() - epoch;
                    this.logEvent(BasicUtilities.getString(resourceBundle, "Execution_Statistic", Long.toString(epoch)));
                }
                catch (SQLException sqle) {
                    this.HandleSQLException(sqle);
                    this.finalizeStatement(stmt, true);
                    if (!isTransaction) continue;
                    this.performRollBack();
                    throw sqle;
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, BasicUtilities.getString(resourceBundle, "Unexpected_Batch_Error"), this.getDebugOn());
                    this.finalizeStatement(stmt, true);
                    if (!isTransaction) continue;
                    this.performRollBack();
                    return null;
                }
            }
            if (isTransaction) {
                this.performCommit();
            }
        } else {
            DatabaseConnection databaseConnection;
            stmt = this.createStatement();
            int i = 0;
            while (itr.hasNext()) {
                String sql = (String)itr.next();
                this.logEvent(BasicUtilities.getString(resourceBundle, "Adding_Batch_Statement", Integer.toString(++i)));
                try {
                    stmt.addBatch(sql);
                    event.setProgress(i);
                    if (callback == null) continue;
                    callback.progressUpdated(event);
                    try {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        databaseConnection = this;
                        synchronized (databaseConnection) {
                            this.wait(5L);
                        }
                    }
                    catch (InterruptedException ie) {
                        this.finalizeStatement(stmt, true);
                        if (isTransaction) {
                            this.performRollBack();
                        }
                        return null;
                    }
                    catch (Throwable ie) {
                    }
                }
                catch (SQLException sqle) {
                    this.HandleSQLException(sqle);
                    if (!isTransaction) continue;
                    this.performRollBack();
                    throw sqle;
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, BasicUtilities.getString(resourceBundle, "Unexpected_Batch_Error"), this.getDebugOn());
                    if (!isTransaction) continue;
                    this.performRollBack();
                    this.finalizeStatement(stmt, true);
                    return null;
                }
            }
            try {
                long epoch = System.currentTimeMillis();
                results = stmt.executeBatch();
                epoch = System.currentTimeMillis() - epoch;
                this.logEvent(BasicUtilities.getString(resourceBundle, "Batch_Execution_Statistic", Long.toString(epoch)));
                if (isTransaction) {
                    this.performCommit();
                }
                this.finalizeStatement(stmt, false);
            }
            catch (SQLException sqle) {
                this.HandleSQLException(sqle);
                this.finalizeStatement(stmt, true);
                if (isTransaction) {
                    this.performRollBack();
                }
                throw sqle;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, BasicUtilities.getString(resourceBundle, "Unexpected_Batch_Error"), this.getDebugOn());
                if (isTransaction) {
                    this.performRollBack();
                }
                this.finalizeStatement(stmt, true);
                databaseConnection = null;
                return databaseConnection;
            }
            finally {
                this.setAutoCommit(true);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAvailableCatalogs() {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet rs = null;
        try {
            rs = this.cnxMetaData.getCatalogs();
            objectArray = JDBCUtilities.getSingleColumn(rs, 1, null).toArray();
        }
        catch (Throwable t) {
            try {
                BasicUtilities.HandleException(t);
                Object[] objectArray2 = new String[]{};
                return objectArray2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            rs.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAvailableSchemas() {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet rs = null;
        try {
            rs = this.cnxMetaData.getSchemas();
            objectArray = JDBCUtilities.getSingleColumn(rs, "TABLE_SCHEM", null);
        }
        catch (Throwable t) {
            try {
                BasicUtilities.HandleException(t);
                Object[] objectArray2 = null;
                return objectArray2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            rs.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    public Object[] getAvailableTables() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        try {
            return this.getAvailableTables(this.getCatalog());
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getAvailableTables(String catalog) {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet rs = null;
        try {
            rs = this.cnxMetaData.getTables(catalog, this.getSchema(), "%", this.tableTypes);
            objectArray = JDBCUtilities.getSingleColumn(rs, "TABLE_NAME", null);
        }
        catch (Throwable t) {
            try {
                BasicUtilities.HandleException(t, "DatabaseConnection::getAvailableTables(" + catalog + ")", this.getDebugOn());
                Object[] objectArray2 = new String[]{};
                return objectArray2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            rs.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    public String[] getTableTypes() {
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        return this.tableTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getProcedures() {
        Object[] objectArray;
        if (this.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
        }
        ResultSet rs = null;
        try {
            rs = this.getDatabaseInformation().getProcedures(this.getCatalog(), null, null);
            objectArray = JDBCUtilities.getSingleColumn(rs, "PROCEDURE_NAME", null);
        }
        catch (Throwable t) {
            try {
                BasicUtilities.HandleException(t, null, this.getDebugOn());
                Object[] objectArray2 = new Object[]{};
                return objectArray2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            rs.close();
            return objectArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return objectArray;
    }

    protected final void log(String msg) {
        System.out.println(msg);
    }

    public final void trace(String msg, Throwable error) {
        if (DriverManager.getLogWriter() != null) {
            BasicUtilities.HandleException(error, msg, true, DriverManager.getLogWriter());
            if (error instanceof SQLException) {
                this.lastError = (SQLException)error;
            }
        }
    }

    protected synchronized boolean re_init() throws SQLException {
        this.logEvent(BasicUtilities.getString(resourceBundle, "Keep_Alive_Message"));
        this.disconnect();
        return this.gsConnect();
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        try {
            DriverPool.deregisterDriver(this.jdbcDriver);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    protected void fireDatabaseEvent(DatabaseEvent e) {
        if (this.listenerList != null) {
            for (DatabaseListener dbl : this.listenerList) {
                try {
                    dbl.processDatabaseEvent(e);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void HandleSQLException(SQLException se) {
        if (!this.getVerboseOn() || se == null) {
            return;
        }
        String[] p = new String[]{se.getMessage() != null ? se.getMessage().trim() : "null", Integer.toString(se.getErrorCode()), se.getSQLState() == null ? "null" : se.getSQLState()};
        System.err.println(BasicUtilities.getString(resourceBundle, "SQL_Exception", p));
        p = null;
        if (this.getDebugOn()) {
            se.printStackTrace(System.err);
        }
        this.lastError = se;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureStatement(Statement sqlStatement) {
        if (sqlStatement != null) {
            Statement statement = sqlStatement;
            synchronized (statement) {
                try {
                    if (this.getQueryTimeout() >= 0) {
                        sqlStatement.setQueryTimeout(this.getQueryTimeout());
                    }
                }
                catch (SQLException sqle) {
                    this.trace("Statement::setQueryTimeout()", sqle);
                }
                catch (Throwable sqle) {
                    // empty catch block
                }
                try {
                    sqlStatement.setEscapeProcessing(this.getEscapeProcessingOn());
                }
                catch (SQLException sqle) {
                    this.trace("Statement::setEscapeProcessing()", sqle);
                }
                catch (Throwable sqle) {
                    // empty catch block
                }
                try {
                    if (this.getMaxFieldSize() >= 1) {
                        sqlStatement.setMaxFieldSize(this.getMaxFieldSize());
                    }
                }
                catch (SQLException sqle) {
                    this.trace("Statement::setMaxFieldSize()", sqle);
                }
                catch (Throwable sqle) {
                    // empty catch block
                }
                try {
                    if (this.getMaxRowCount() >= 1) {
                        sqlStatement.setMaxRows(this.getMaxRowCount());
                    }
                }
                catch (SQLException sqle) {
                    this.trace("Statement::setMaxRows()", sqle);
                }
                catch (Throwable sqle) {
                    // empty catch block
                }
                try {
                    if (this.getFetchMode() != 1002) {
                        sqlStatement.setFetchDirection(this.getFetchMode());
                    }
                }
                catch (SQLException sqle) {
                    this.trace("Statement::setFetchDirection()", sqle);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStatement(Statement stmt, boolean cancel) {
        if (stmt == null) {
            return;
        }
        Statement statement = stmt;
        synchronized (statement) {
            try {
                if (cancel) {
                    stmt.cancel();
                }
            }
            catch (SQLException sqle) {
                this.trace("Statement::cancel", sqle);
            }
            catch (Throwable t) {
                String s = BasicUtilities.getString(resourceBundle, "Unexcepted_Statement_Cancel_Error");
                BasicUtilities.HandleException(t, s, this.getDebugOn());
            }
            try {
                stmt.clearBatch();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                stmt.clearWarnings();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static Thread getThreadForName(String name) {
        return (Thread)QUERY_THREADS.get(name.toUpperCase());
    }

    private static String getStringHoldability(int holdability) {
        switch (holdability) {
            case 1: {
                return BasicUtilities.getString(resourceBundle, "Holding_Cursors_Across_Commits");
            }
            case 2: {
                return BasicUtilities.getString(resourceBundle, "Closing_Cursors_Across_Commits");
            }
        }
        return BasicUtilities.getString(resourceBundle, "Unknown_or_Holdability_Is_UnSupported");
    }

    private static void interruptQueries() {
        for (Object key : QUERY_THREADS.keySet()) {
            Thread thd = (Thread)QUERY_THREADS.get(key);
            thd.interrupt();
            try {
                thd.join(1000L);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean initialize() {
        return false;
    }

    public void setUseSingleSpace(boolean flag) {
        this.useSingleSpace = flag;
    }

    public IJSpace getGsSpaceProxy() {
        return this.gsSpaceProxy;
    }

    static /* synthetic */ void access$200(DatabaseConnection x0, Statement x1) {
        x0.configureStatement(x1);
    }

    static /* synthetic */ Logger access$400() {
        return _logger;
    }

    static /* synthetic */ DatabaseMetaData access$500(DatabaseConnection x0) {
        return x0.cnxMetaData;
    }

    static /* synthetic */ boolean access$600(DatabaseConnection x0) {
        return x0.supportMultiResults;
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle("org.isqlviewer.sql.ResourceStrings");
        }
        catch (Throwable t) {
            System.err.println("** Fatal Error ** iSQL-Viewer ResourceBundle(org.isqlviewer.sql.ResourceStrings) is unavailable exiting....");
            System.exit(-1);
        }
    }

    private static class NullResultSetViewer
    implements ResultSetViewer {
        private DatabaseConnection reference = null;

        public NullResultSetViewer(DatabaseConnection connection) {
            this.reference = connection;
        }

        @Override
        public void handleSQLException(ResultSet set, SQLException e) {
            this.reference.HandleSQLException(e);
        }

        @Override
        public void handleException(ResultSet set, Throwable e) {
            if (e instanceof SQLException) {
                this.handleSQLException(set, (SQLException)e);
            }
        }

        @Override
        public void handleStatementInterrupted(String stmtID) {
        }

        @Override
        public void processGeneratedKeys(String stmtID, ResultSet keys, String nativeSQL) {
        }

        @Override
        public void processResultSet(String stmtID, ResultSet set, String nativeSQL, int count, IJSpace spaceProxy, int executionTime) {
        }

        @Override
        public void processRowUpdates(String stmtID, int updateCount, String nativeSQL) {
        }

        @Override
        public void recieveResultsetWarnings(ResultSet set, SQLWarning warnings) {
            this.reference.HandleSQLException(warnings);
        }

        @Override
        public void recieveStatementWarnings(Statement stmt, SQLWarning warnings) {
            this.reference.HandleSQLException(warnings);
        }

        @Override
        public void statementInitialized(String stmtID) {
        }

        @Override
        public boolean supportsGeneratedKeys() {
            return false;
        }

        @Override
        public boolean supportsUpdateableResultSets() {
            return false;
        }
    }

    private class ResultSetRetreiver
    implements Runnable {
        private ResultSetViewer viewer = null;
        private Statement sqlStatement = null;
        private String SQL = null;
        private String localID = null;
        private boolean multiQuery = false;
        private boolean closeStatement = true;
        private int type = 1003;
        private int concur = 1007;

        public ResultSetRetreiver(String id, ResultSetViewer renderer, Statement stmt, String query) {
            this.viewer = renderer == null ? new NullResultSetViewer(DatabaseConnection.this) : renderer;
            this.localID = id;
            this.sqlStatement = stmt;
            this.SQL = query;
            this.multiQuery = !(this.sqlStatement instanceof CallableStatement) && !(this.sqlStatement instanceof PreparedStatement);
        }

        public void setResultsetType(int type) {
            this.type = type;
        }

        public void setResultsetConcurrency(int concur) {
            this.concur = concur;
        }

        public String getLocalID() {
            return this.localID;
        }

        private void dispatchInterruption() {
            if (this.viewer != null) {
                this.viewer.handleStatementInterrupted(this.localID);
            }
        }

        private String echoStatementInfo(String query) {
            if (DatabaseConnection.this.getQueryEchoOn()) {
                String[] p = new String[2];
                p[0] = this.sqlStatement instanceof CallableStatement ? BasicUtilities.getString(resourceBundle, "Callable_Statement") : (this.sqlStatement instanceof PreparedStatement ? BasicUtilities.getString(resourceBundle, "Prepared_Statement") : BasicUtilities.getString(resourceBundle, "Basic_Query"));
                try {
                    p[1] = DatabaseConnection.this.databaseCnx.nativeSQL(query == null ? "" : query);
                }
                catch (Throwable t) {
                    p[1] = query == null ? "" : query;
                }
                String nativeQL = p[1];
                p[1] = StringUtilities.formatBreak(80, nativeQL, "\t", false);
                DatabaseConnection.this.log(BasicUtilities.getString(resourceBundle, "Query_Echo", p));
                return nativeQL;
            }
            try {
                return DatabaseConnection.this.databaseCnx.nativeSQL(query == null ? "" : query);
            }
            catch (Throwable t) {
                DatabaseConnection.this.trace(MessageFormat.format("Connection:nativeSQL(''{0}'')", query), t);
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void doQuery(String query, String nativeSQL) throws Exception {
            results = false;
            if (DatabaseConnection.this.getActiveStatements() > DatabaseConnection.this.getMaxStatements()) {
                reason = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Max_Statement_Exceeded");
                state = Integer.toString(DatabaseConnection.this.getActiveStatements()).concat(">").concat(Integer.toString(DatabaseConnection.this.getMaxStatements()));
                throw new SQLException(reason, state, 74615);
            }
            if (this.multiQuery || this.sqlStatement == null) {
                try {
                    dmd = DatabaseConnection.access$100(DatabaseConnection.this).getMetaData();
                    this.sqlStatement = dmd.supportsResultSetConcurrency(this.type, this.concur) ? DatabaseConnection.this.createStatement(this.type, this.concur) : DatabaseConnection.this.createStatement();
                }
                catch (SQLException sqle) {
                    throw sqle;
                }
                catch (Throwable t) {
                    reason = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Default_Statement_Disabled");
                    throw new SQLException(reason);
                }
                DatabaseConnection.access$200(DatabaseConnection.this, this.sqlStatement);
            }
            if (Thread.interrupted()) {
                this.dispatchInterruption();
                return;
            }
            if (this.concur == 1008) {
                try {
                    this.sqlStatement.setCursorName(this.localID);
                }
                catch (SQLException sqle) {
                    DatabaseConnection.access$300(DatabaseConnection.this, sqle);
                }
                catch (Throwable sqle) {
                    // empty catch block
                }
            }
            delta = Runtime.getRuntime().freeMemory();
            epoch = System.currentTimeMillis();
            returnKeys = false;
            executionTime = 0;
            if (this.sqlStatement instanceof PreparedStatement) {
                ps = (PreparedStatement)this.sqlStatement;
                timeBefore = System.currentTimeMillis();
                results = ps.execute();
                timeAfter = System.currentTimeMillis();
                executionTime = (int)(timeAfter - timeBefore);
                if (DatabaseConnection.access$400().isLoggable(Level.FINE)) {
                    DatabaseConnection.access$400().log(Level.FINE, "Query execution time:" + executionTime + " miliseconds. Using prepared statement.");
                }
            } else if (DatabaseConnection.this.isGeneratedKeysEnabled()) {
                try {
                    if (DatabaseConnection.access$500(DatabaseConnection.this).supportsGetGeneratedKeys()) {
                        results = this.sqlStatement.execute(query, 1);
                        returnKeys = true;
                    } else {
                        msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Query_With_Keys_Not_Supported");
                        DatabaseConnection.this.log(msg);
                        timeBefore = System.currentTimeMillis();
                        results = this.sqlStatement.execute(query, 2);
                        timeAfter = System.currentTimeMillis();
                        executionTime = (int)(timeAfter - timeBefore);
                        if (DatabaseConnection.access$400().isLoggable(Level.FINE)) {
                            DatabaseConnection.access$400().log(Level.FINE, "Query <" + query + ">  took " + executionTime + " miliseconds.");
                        }
                    }
                }
                catch (Throwable t) {
                    msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Query_With_Keys_Failed");
                    DatabaseConnection.this.log(msg);
                    results = this.sqlStatement.execute(query);
                }
            } else {
                timeBefore = System.currentTimeMillis();
                results = this.sqlStatement.execute(query);
                timeAfter = System.currentTimeMillis();
                executionTime = (int)(timeAfter - timeBefore);
                if (DatabaseConnection.access$400().isLoggable(Level.FINE)) {
                    DatabaseConnection.access$400().log(Level.FINE, "Query <" + query + ">  took " + executionTime + " miliseconds.");
                }
            }
            epoch = System.currentTimeMillis() - epoch;
            bytes = StringUtilities.getHumanReadableSize(delta -= Runtime.getRuntime().freeMemory());
            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Execution_Statistic", Long.toString(epoch)));
            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Memory_Statistic", bytes));
            rowsAffected = -1;
            if (!results) {
                try {
                    rowsAffected = this.sqlStatement.getUpdateCount();
                }
                catch (SQLException sqle) {
                    DatabaseConnection.access$300(DatabaseConnection.this, sqle);
                    rowsAffected = -1;
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "Statement::getUpdateCount()");
                    rowsAffected = -1;
                }
            } else {
                rowsAffected = -1;
            }
            rsCount = 0;
            do {
                rs = null;
                if (results) {
                    block88: {
                        rs = this.sqlStatement.getResultSet();
                        try {
                            epoch = System.currentTimeMillis();
                            delta = Runtime.getRuntime().freeMemory();
                            this.viewer.processResultSet(this.localID, rs, nativeSQL, rsCount, DatabaseConnection.this.getGsSpaceProxy(), executionTime);
                            epoch = System.currentTimeMillis() - epoch;
                            bytes = StringUtilities.getHumanReadableSize(delta -= Runtime.getRuntime().freeMemory());
                            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Memory_Statistic", bytes));
                            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Rendering_Statistic", Long.toString(epoch)));
                        }
                        catch (NoClassDefFoundError e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            if (!DatabaseConnection.this.getVerboseOn()) break block88;
                            BasicUtilities.HandleException(t, "ResultSetViewer::processResultSet");
                        }
                    }
                    try {
                        warnings = rs.getWarnings();
                        if (warnings == null) ** GOTO lbl134
                        this.viewer.recieveResultsetWarnings(rs, warnings);
                    }
                    catch (SQLException sqle) {
                        DatabaseConnection.access$300(DatabaseConnection.this, sqle);
                    }
                    finally {
                        try {
                            rs.clearWarnings();
                        }
                        catch (Throwable sqle) {}
                    }
                } else if (rowsAffected >= 0) {
                    block89: {
                        try {
                            epoch = System.currentTimeMillis();
                            this.viewer.processRowUpdates(this.localID, rowsAffected, nativeSQL);
                            epoch = System.currentTimeMillis() - epoch;
                            DatabaseConnection.this.log(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Rendering_Statistic", Long.toString(epoch)));
                        }
                        catch (Throwable t) {
                            if (!DatabaseConnection.this.getVerboseOn()) break block89;
                            BasicUtilities.HandleException(t, "ResultSetViewer::processResultSet");
                        }
                    }
                    DatabaseConnection.this.logEvent(BasicUtilities.getString(DatabaseConnection.resourceBundle, "Row_Affected_Count", Integer.toString(rowsAffected)));
                }
lbl134:
                // 6 sources

                if (this.viewer.supportsGeneratedKeys() && returnKeys) {
                    try {
                        rs = this.sqlStatement.getGeneratedKeys();
                        this.viewer.processGeneratedKeys(this.localID, rs, nativeSQL);
                    }
                    catch (Throwable t) {
                        if (DatabaseConnection.this.getVerboseOn()) {
                            BasicUtilities.HandleException(t, "ResultSetViewer::processResultSet");
                        }
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                if (!DatabaseConnection.access$600(DatabaseConnection.this)) {
                    v0 = autoClose = this.viewer.supportsUpdateableResultSets() == false;
                    if (!JDBCUtilities.isUpdatable(rs) || autoClose) {
                        try {
                            if (rs == null) break;
                            DatabaseConnection.this.logEvent(BasicUtilities.getString(DatabaseConnection.resourceBundle, "ResultSet_Closing"));
                            rs.close();
                        }
                        catch (SQLException sqle) {
                            DatabaseConnection.access$300(DatabaseConnection.this, sqle);
                        }
                        break;
                    }
                    this.closeStatement = false;
                    DatabaseConnection.this.logEvent(BasicUtilities.getString(DatabaseConnection.resourceBundle, "ResultSet_Closing_Skip"));
                    break;
                }
                results = this.sqlStatement.getMoreResults();
                if (rs != null && results) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        DatabaseConnection.access$300(DatabaseConnection.this, sqle);
                    }
                }
                if (!results) {
                    try {
                        rowsAffected = this.sqlStatement.getUpdateCount();
                    }
                    catch (SQLException sqle) {
                        DatabaseConnection.access$300(DatabaseConnection.this, sqle);
                        rowsAffected = -1;
                    }
                    catch (Throwable t) {
                        rowsAffected = -1;
                    }
                    continue;
                }
                rowsAffected = -1;
            } while (results || rowsAffected != -1);
            if (this.viewer != null) {
                try {
                    warnings = this.sqlStatement.getWarnings();
                    if (warnings != null) {
                        this.viewer.recieveStatementWarnings(this.sqlStatement, warnings);
                    }
                }
                catch (SQLException sqle) {
                    DatabaseConnection.access$300(DatabaseConnection.this, sqle);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
                finally {
                    try {
                        this.sqlStatement.clearWarnings();
                    }
                    catch (Throwable sqle) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (DatabaseConnection.this.databaseCnx.isClosed() && DatabaseConnection.this.getAutoReconnect()) {
                    DatabaseConnection.this.re_init();
                }
            }
            catch (Throwable t) {
                DatabaseConnection.this.log(BasicUtilities.getString(resourceBundle, "Connection_Unavailable"));
                return;
            }
            try {
                DatabaseConnection.this.databaseCnx.clearWarnings();
            }
            catch (Throwable t) {
                // empty catch block
            }
            HashMap t = DatabaseConnection.this.stmtMap;
            synchronized (t) {
                DatabaseConnection.this.stmtMap.put(this.getLocalID(), this);
            }
            this.viewer.statementInitialized(this.localID);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                this.dispatchInterruption();
                return;
            }
            StringTokenizer st = new StringTokenizer(this.SQL, ";", false, true);
            st.setQuotesEnabled(true);
            try {
                while (st.hasMoreTokens()) {
                    String query = st.nextToken().trim();
                    if (query.length() == 0) continue;
                    String nativeSQL = this.echoStatementInfo(query);
                    this.doQuery(query, nativeSQL);
                }
            }
            catch (NoClassDefFoundError e) {
                JOptionPane.showMessageDialog(SpaceBrowser.getInstance().getParentFrame(), "The following class was not found. Please add it to the classpath:" + JSpaceUtilities.LINE_SEPARATOR + e.getMessage(), "Class Not Found", 2);
                DatabaseConnection.this.cancelStatement(this.getLocalID());
                return;
            }
            catch (InterruptedException ie) {
                DatabaseConnection.this.cancelStatement(this.getLocalID());
                return;
            }
            catch (SQLException sqle) {
                DatabaseConnection.this.HandleSQLException(sqle);
                this.viewer.handleSQLException(null, sqle);
                DatabaseConnection.this.disposeStatement(this.getLocalID());
                String excMessage = null;
                excMessage = JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)sqle, ClassNotFoundException.class);
                if (excMessage != null || (excMessage = JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)sqle, NoClassDefFoundError.class)) != null) {
                    JOptionPane.showMessageDialog(SpaceBrowser.getInstance().getParentFrame(), "The following class was not found. Please add it to the classpath:" + JSpaceUtilities.LINE_SEPARATOR + excMessage, "Class Not Found", 2);
                } else {
                    SpaceBrowser.showException("Query", sqle);
                }
            }
            catch (Exception e) {
                DatabaseConnection.this.disposeStatement(this.getLocalID());
                String excMessage = null;
                excMessage = JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)e, ClassNotFoundException.class);
                if (excMessage != null || (excMessage = JSpaceUtilities.getCauseExceptionMessageFromHierarchy((Exception)e, NoClassDefFoundError.class)) != null) {
                    Throwable causeException = JSpaceUtilities.getCauseExceptionFromHierarchy((Exception)e, ClassNotFoundException.class);
                    if (causeException == null) {
                        causeException = JSpaceUtilities.getCauseExceptionFromHierarchy((Exception)e, NoClassDefFoundError.class);
                    }
                    Throwable exc = causeException == null ? e : causeException;
                    this.viewer.handleException(null, exc);
                    JOptionPane.showMessageDialog(SpaceBrowser.getInstance().getParentFrame(), "The following class was not found. Please add it to the classpath:" + JSpaceUtilities.LINE_SEPARATOR + excMessage, "Class Not Found", 2);
                } else {
                    this.viewer.handleException(null, e);
                    SpaceBrowser.showException("Query", e);
                }
            }
            catch (Error e) {
                BasicUtilities.HandleException(e);
                DatabaseConnection.this.disposeStatement(this.getLocalID());
                SpaceBrowser.getInstance().getISQLPane().getWorkBench().getResultDelegate().cancelButtonPressed();
                SpaceBrowser.showException("Query", e);
            }
            finally {
                if (this.closeStatement) {
                    DatabaseConnection.this.disposeStatement(this.getLocalID());
                }
                System.runFinalization();
                if (st.hasMoreTokens()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        this.dispatchInterruption();
                        return;
                    }
                }
            }
        }
    }
}

