/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.isqlviewer.util.BasicUtilities;

public class FileBlob
implements Blob {
    protected File file;
    protected StringBuffer blob = new StringBuffer("");

    public FileBlob(File f) throws IOException {
        this.file = f;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream((int)f.length());
        FileInputStream fis = new FileInputStream(this.file);
        BasicUtilities.copyStream(fis, bytes);
        this.blob.append(new String(bytes.toByteArray()));
        fis.close();
        fis = null;
        bytes.close();
        bytes = null;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public byte[] getBytes(long pos, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.blob.toString().getBytes(), (int)pos, bytes, 0, length);
        return bytes;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            return new BufferedInputStream(new ByteArrayInputStream(this.blob.toString().getBytes()));
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        try {
            String s = new String(pattern);
            String b = this.blob.toString();
            return b.indexOf(s);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    @Override
    public void truncate(long len) throws SQLException {
        try {
            this.blob.setLength((int)len);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            BlobAdapterStream bas = new BlobAdapterStream();
            bas.setOffset(pos);
            return bas;
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            String str = new String(bytes, offset, len);
            this.blob.replace((int)pos, (int)(pos + (long)len), str);
            return len;
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private class BlobAdapterStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private long offset = -1L;

        private BlobAdapterStream() {
        }

        public void setOffset(long pos) {
            this.offset = pos;
            if (this.offset > (long)FileBlob.this.blob.length()) {
                this.offset = -1L;
            }
        }

        @Override
        public synchronized void write(int b) {
            char c = (char)(b &= 0xFF);
            this.buf.append(String.valueOf(c));
        }

        @Override
        public synchronized void write(byte[] b, int off, int length) {
            this.buf.append(new String(b, off, length));
        }

        @Override
        public synchronized void write(byte[] b) {
            this.buf.append(new String(b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                if (this.buf.length() > 0) {
                    if (this.offset < (long)FileBlob.this.blob.length() && this.offset >= 0L) {
                        try {
                            FileBlob.this.setBytes(this.offset, this.buf.toString().getBytes());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.offset += (long)this.buf.length();
                    } else {
                        FileBlob.this.blob.append(this.buf.toString());
                        this.offset = FileBlob.this.blob.length();
                    }
                }
                this.buf.setLength(0);
            }
        }

        @Override
        public void close() {
            this.flush();
            this.buf.setLength(0);
        }
    }
}

