/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;

public class J2EEAdapterDriver
implements Driver {
    private static final int SQL_STATE_LOOKUP = 1;
    private static final int SQL_STATE_INIT = 0;
    private static final int VENDOR_CODE = 74615;
    private static final String URL_PREFIX = "jdbc:j2ee:";
    private Context j2eeContext = null;
    private DataSource dataSource = null;
    private String url = null;

    @Override
    public Connection connect(String jdbcURL, Properties info) throws SQLException {
        try {
            this.j2eeContext = new InitialContext(info);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage(), Integer.toHexString(0), 74615);
        }
        try {
            String dsn = jdbcURL.substring(URL_PREFIX.length());
            this.dataSource = (DataSource)this.j2eeContext.lookup(dsn);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage(), Integer.toHexString(1), 74615);
        }
        this.url = jdbcURL;
        if (DriverManager.getLogWriter() != null) {
            try {
                this.dataSource.setLogWriter(DriverManager.getLogWriter());
            }
            catch (SQLException sqle) {
                BasicUtilities.HandleException(sqle);
            }
            catch (Throwable sqle) {
                // empty catch block
            }
        }
        String user = info.getProperty("user", "").trim();
        String pass = info.getProperty("password", "").trim();
        if (user.length() == 0 && pass.length() == 0) {
            return this.dataSource.getConnection();
        }
        return this.dataSource.getConnection(user, pass);
    }

    @Override
    public boolean acceptsURL(String jdbcURL) {
        if (jdbcURL == null || !jdbcURL.startsWith(URL_PREFIX)) {
            return false;
        }
        String dsn = jdbcURL.substring(URL_PREFIX.length());
        return dsn.trim().length() >= 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String jdbcURL, Properties info) {
        ArrayList<DriverPropertyInfo> lst = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo dpi = null;
        String def = null;
        def = info.getProperty("user", "");
        dpi = new DriverPropertyInfo("user", def);
        dpi.description = "";
        dpi.required = true;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("password", "");
        dpi = new DriverPropertyInfo("password", def);
        dpi.description = "";
        dpi.required = true;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.provider.url", System.getProperty("java.naming.provider.url", ""));
        dpi = new DriverPropertyInfo("java.naming.provider.url", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Provider_URL_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.factory.initial", System.getProperty("java.naming.factory.initial", ""));
        dpi = new DriverPropertyInfo("java.naming.factory.initial", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Init_Cntxt_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.authoritative", System.getProperty("java.naming.authoritative", ""));
        dpi = new DriverPropertyInfo("java.naming.authoritative", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_Auth_Desc");
        dpi.required = false;
        dpi.choices = new String[]{"", Boolean.toString(true), Boolean.toString(false)};
        lst.add(dpi);
        def = info.getProperty("java.naming.batchsize", System.getProperty("java.naming.batchsize", ""));
        dpi = new DriverPropertyInfo("java.naming.batchsize", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_BatchSize_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.dns.url", System.getProperty("java.naming.dns.url", ""));
        dpi = new DriverPropertyInfo("java.naming.dns.url", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_DNSURL_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.factory.object", System.getProperty("java.naming.factory.object", ""));
        dpi = new DriverPropertyInfo("java.naming.factory.object", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_ObjFactory_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.referral", System.getProperty("java.naming.referral", ""));
        dpi = new DriverPropertyInfo("java.naming.referral", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_Referral_Desc");
        dpi.required = false;
        dpi.choices = new String[]{"follow", "ignore", "throw", ""};
        lst.add(dpi);
        def = info.getProperty("java.naming.security.authentication", System.getProperty("java.naming.security.authentication", ""));
        dpi = new DriverPropertyInfo("java.naming.security.authentication", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecAuth_Desc");
        dpi.required = false;
        dpi.choices = new String[]{"none", "simple", "strong", ""};
        lst.add(dpi);
        def = info.getProperty("java.naming.security.credentials", System.getProperty("java.naming.security.credentials", ""));
        dpi = new DriverPropertyInfo("java.naming.security.credentials", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecCred_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.security.principal", System.getProperty("java.naming.security.principal", ""));
        dpi = new DriverPropertyInfo("java.naming.security.principal", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecPrin_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.security.protocol", System.getProperty("java.naming.security.protocol", ""));
        dpi = new DriverPropertyInfo("java.naming.security.protocol", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_SecProto_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.factory.state", System.getProperty("java.naming.factory.state", ""));
        dpi = new DriverPropertyInfo("java.naming.factory.state", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_StateFactory_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        def = info.getProperty("java.naming.factory.url.pkgs", System.getProperty("java.naming.factory.url.pkgs", ""));
        dpi = new DriverPropertyInfo("java.naming.factory.url.pkgs", def);
        dpi.description = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Context_URLPrefix_Desc");
        dpi.required = false;
        dpi.choices = null;
        lst.add(dpi);
        return lst.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            PrintWriter out = DriverManager.getLogWriter();
            if (out != null) {
                out.println(BasicUtilities.getString(DatabaseConnection.resourceBundle, "J2EEContext_Close", this.url));
            }
            this.j2eeContext.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

