/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.util.BasicUtilities;

public abstract class JDBCUtilities {
    private static final String RESULT_RESERVED_CHARS = "srctfzwCST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getSingleColumn(ResultSet rs, int column, ResultSetViewer handler) {
        if (rs == null) {
            return null;
        }
        boolean isScrollable = false;
        try {
            int type = rs.getType();
            isScrollable = type == 1004 || type == 1005;
        }
        catch (Throwable type) {
            // empty catch block
        }
        if (isScrollable) {
            try {
                rs.beforeFirst();
            }
            catch (SQLException sqle) {
                if (handler != null) {
                    handler.handleSQLException(rs, sqle);
                } else {
                    JDBCUtilities.addWarning(rs, sqle);
                }
                return new ArrayList();
            }
            catch (AbstractMethodError ame) {
                JDBCUtilities.addWarning(rs, ame.getClass().getName(), "ResultSet:beforeFirst()");
            }
            catch (UnsupportedOperationException ose) {
                JDBCUtilities.addWarning(rs, ose.getClass().getName(), "ResultSet:beforeFirst()");
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "ResultSet:beforeFirst()");
                return new ArrayList();
            }
        }
        ArrayList<String> collection = new ArrayList<String>();
        try {
            while (rs.next()) {
                try {
                    String o = rs.getString(column);
                    if (!collection.contains(o) || !rs.wasNull()) {
                        collection.add(o);
                    }
                }
                catch (SQLException sqle) {
                    if (handler != null) {
                        handler.handleSQLException(rs, sqle);
                    }
                    JDBCUtilities.addWarning(rs, sqle);
                }
                if (handler == null) continue;
                try {
                    handler.recieveResultsetWarnings(rs, rs.getWarnings());
                }
                catch (Throwable sqle) {}
            }
        }
        catch (SQLException sqle) {
            if (handler != null) {
                handler.handleSQLException(rs, sqle);
            } else {
                JDBCUtilities.addWarning(rs, sqle);
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ResultSetUtilites::getSingleColumn(ResultSet,int)");
        }
        finally {
            if (isScrollable) {
                try {
                    rs.beforeFirst();
                }
                catch (SQLException sqle) {
                    if (handler != null) {
                        handler.handleSQLException(rs, sqle);
                    } else {
                        JDBCUtilities.addWarning(rs, sqle);
                    }
                }
                catch (AbstractMethodError ame) {
                    JDBCUtilities.addWarning(rs, AbstractMethodError.class.getName(), "ResultSet:beforeFirst()");
                }
                catch (UnsupportedOperationException ose) {
                    JDBCUtilities.addWarning(rs, UnsupportedOperationException.class.getName(), "ResultSet:beforeFirst()");
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "ResultSet:beforeFirst()");
                }
            }
        }
        return collection;
    }

    public static Object[] getSingleColumn(ResultSet rs, String column, ResultSetViewer handler) {
        if (rs == null) {
            return null;
        }
        try {
            int columnID = rs.findColumn(column);
            return JDBCUtilities.getSingleColumn(rs, columnID, handler).toArray();
        }
        catch (SQLException sqle) {
            if (handler != null) {
                handler.handleSQLException(rs, sqle);
            } else {
                JDBCUtilities.addWarning(rs, sqle);
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "JDBCUtilities::getSingleColumn(ResultSet, String, ResultSetViewer");
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getSingleRow(ResultSet rs, int row, ResultSetViewer handler) {
        if (rs == null) {
            return null;
        }
        boolean isScrollable = false;
        try {
            int type = rs.getType();
            isScrollable = type != 1003;
        }
        catch (Throwable type) {
            // empty catch block
        }
        if (isScrollable) {
            try {
                rs.beforeFirst();
            }
            catch (SQLException sqle) {
                if (handler != null) {
                    handler.handleSQLException(rs, sqle);
                } else {
                    JDBCUtilities.addWarning(rs, sqle);
                }
                return new ArrayList();
            }
            catch (UnsupportedOperationException ose) {
                JDBCUtilities.addWarning(rs, ose.getClass().getName(), "ResultSet:first()");
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "ResultSet:first()");
                return new ArrayList();
            }
        } else {
            try {
                if (!rs.isBeforeFirst()) {
                    JDBCUtilities.addWarning(rs, "JDBCUtilities:getSingleRow(" + row + ")", "ResultSet:!isBeforefirst()");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        ArrayList<Object> collection = new ArrayList<Object>();
        try {
            int current = 1;
            int columnCount = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                if (current++ != row) continue;
                for (int i = 1; i <= columnCount; ++i) {
                    collection.add(rs.getObject(i));
                }
            }
        }
        catch (SQLException sqle) {
            if (handler != null) {
                handler.handleSQLException(rs, sqle);
            } else {
                JDBCUtilities.addWarning(rs, sqle);
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ResultSetUtilites::getSingleRow(ResultSet,int,ResultSetViewer)");
        }
        finally {
            if (isScrollable) {
                try {
                    rs.beforeFirst();
                }
                catch (SQLException sqle) {
                    if (handler != null) {
                        handler.handleSQLException(rs, sqle);
                    } else {
                        JDBCUtilities.addWarning(rs, sqle);
                    }
                }
                catch (UnsupportedOperationException ose) {
                    JDBCUtilities.addWarning(rs, ose.getClass().getName(), "ResultSet:first()");
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "ResultSet:first()");
                }
            }
        }
        return collection;
    }

    public static void addWarning(ResultSet rs, String reason, String state) {
        try {
            reason = reason == null ? "" : reason;
            state = state == null ? "" : state;
            SQLWarning warnings = rs.getWarnings();
            if (warnings == null) {
                throw new SQLException(reason, state);
            }
            SQLWarning newWarning = new SQLWarning(reason, "ISQLV-" + state, 74615);
            warnings.setNextWarning(newWarning);
        }
        catch (SQLException sqle) {
            BasicUtilities.HandleException(sqle);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "JDBCUtilities::addWarning(" + reason + ", " + state + ")");
        }
    }

    public static void addWarning(ResultSet rs, SQLException sqle) {
        JDBCUtilities.addWarning(rs, sqle.getMessage(), sqle.getSQLState());
    }

    public static boolean isUpdatable(ResultSet rs) {
        try {
            int concur = rs.getConcurrency();
            int type = rs.getType();
            boolean updatable = concur == 1008;
            boolean scrollable = type == 1004 || type == 1005;
            return updatable && scrollable;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isDateType(int type) {
        switch (type) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringType(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBooleanType(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumberType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static String getResultString(String pattern, ResultSet rs, DatabaseConnection dbc, EnhancedTableModel model) {
        StringBuffer buff = new StringBuffer(pattern);
        String s = buff.toString();
        int end = 0;
        int idx0 = 0;
        int idx1 = 0;
        end = s.lastIndexOf(37);
        if (end >= 0 && (rs != null || dbc != null)) {
            while (idx0 < end) {
                idx0 = s.indexOf(37, idx1);
                if ((idx1 = idx0 + 1) >= s.length()) {
                    idx1 = s.length() - 1;
                }
                if (RESULT_RESERVED_CHARS.indexOf(s.charAt(idx1)) < 0) continue;
                try {
                    char x = '\u0000';
                    x = s.charAt(idx0 + 1);
                    String y = "";
                    switch (x) {
                        case 'C': {
                            try {
                                y = rs.getMetaData().getCatalogName(1);
                            }
                            catch (Throwable t) {
                                y = "null";
                            }
                            break;
                        }
                        case 'T': {
                            try {
                                y = rs.getMetaData().getTableName(1);
                            }
                            catch (Throwable t) {
                                y = "null";
                            }
                            break;
                        }
                        case 'S': {
                            try {
                                y = rs.getMetaData().getSchemaName(1);
                            }
                            catch (Throwable t) {
                                y = "null";
                            }
                            break;
                        }
                        case 's': {
                            y = dbc.getConnectionName();
                            break;
                        }
                        case 'r': {
                            if (model != null) {
                                y = Integer.toString(model.getTrueRowCount());
                                break;
                            }
                            y = "-1";
                            break;
                        }
                        case 'c': {
                            if (model != null) {
                                y = Integer.toString(model.getColumnCount());
                                break;
                            }
                            y = "-1";
                            break;
                        }
                        case 't': {
                            try {
                                y = Integer.toString(rs.getType());
                            }
                            catch (Throwable t) {
                                y = Integer.toString(-1);
                            }
                            break;
                        }
                        case 'f': {
                            try {
                                y = Integer.toString(rs.getFetchDirection());
                            }
                            catch (Throwable t) {
                                y = Integer.toString(1002);
                            }
                            break;
                        }
                        case 'x': {
                            try {
                                y = rs.getCursorName();
                            }
                            catch (Throwable t) {
                                y = "null";
                            }
                            break;
                        }
                        case 'z': {
                            try {
                                y = Integer.toString(rs.getFetchSize());
                            }
                            catch (Throwable t) {
                                y = Integer.toString(-1);
                            }
                            break;
                        }
                    }
                    if (idx1 + 1 >= buff.length()) {
                        idx1 = buff.length() - 1;
                    }
                    if (y == null) {
                        buff.replace(idx0, idx1 + 1, "");
                    } else {
                        buff.replace(idx0, idx1 + 1, y);
                    }
                    s = buff.toString();
                    end = s.lastIndexOf(37);
                }
                catch (NumberFormatException e) {
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    try {
                        buff.replace(idx0, idx1, "");
                        s = buff.toString();
                        end = s.lastIndexOf(37);
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return buff.toString().trim();
    }

    public static Object convertValue(Object data, int type, Format fmt) throws ParseException {
        if (data == null && type != 0) {
            throw new IllegalArgumentException("null (" + JDBCUtilities.getTypeforValue(type) + ")");
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 1: 
            case 12: {
                return data.toString();
            }
            case -6: {
                if (data instanceof Number) {
                    if (data instanceof Byte) {
                        return data;
                    }
                    Number numb = (Number)data;
                    return new Byte(numb.byteValue());
                }
                String txt = data.toString().trim();
                if (txt.length() == 0) {
                    txt = "0";
                }
                try {
                    byte bite = Byte.parseByte(txt);
                    return new Byte(bite);
                }
                catch (Throwable t) {
                    if (fmt == null) {
                        throw new IllegalArgumentException(data.toString());
                    }
                    Number numb = (Number)fmt.parseObject(data.toString());
                    return new Byte(numb.byteValue());
                }
            }
            case 5: {
                if (data instanceof Number) {
                    if (data instanceof Short) {
                        return data;
                    }
                    Number numb = (Number)data;
                    return new Short(numb.shortValue());
                }
                String txt = data.toString().trim();
                if (txt.length() == 0) {
                    txt = "0";
                }
                try {
                    short shrt = Short.parseShort(txt);
                    return new Short(shrt);
                }
                catch (Throwable t) {
                    if (fmt == null) {
                        throw new IllegalArgumentException(data.toString());
                    }
                    Number numb = (Number)fmt.parseObject(data.toString());
                    return new Short(numb.shortValue());
                }
            }
            case 4: {
                if (data instanceof Number) {
                    if (data instanceof Integer) {
                        return data;
                    }
                    Number numb = (Number)data;
                    return new Integer(numb.intValue());
                }
                String txt = data.toString().trim();
                if (txt.length() == 0) {
                    txt = "0";
                }
                try {
                    int val = Integer.parseInt(txt);
                    return new Integer(val);
                }
                catch (Throwable t) {
                    if (fmt == null) {
                        throw new IllegalArgumentException(data.toString().trim());
                    }
                    Number numb = (Number)fmt.parseObject(data.toString());
                    return new Integer(numb.intValue());
                }
            }
            case -5: {
                if (data instanceof Number) {
                    if (data instanceof Long) {
                        return data;
                    }
                    Number numb = (Number)data;
                    return new Long(numb.longValue());
                }
                String txt = data.toString().trim();
                if (txt.length() == 0) {
                    txt = "0";
                }
                try {
                    long val = Long.parseLong(txt);
                    return new Long(val);
                }
                catch (Throwable t) {
                    if (fmt == null) {
                        throw new IllegalArgumentException(data.toString());
                    }
                    Number numb = (Number)fmt.parseObject(data.toString());
                    return new Long(numb.longValue());
                }
            }
            case 6: 
            case 8: {
                if (data instanceof Number) {
                    if (data instanceof Double) {
                        return data;
                    }
                    Number numb = (Number)data;
                    return new Double(numb.doubleValue());
                }
                String txt = data.toString().trim();
                if (txt.length() == 0) {
                    txt = "0";
                }
                try {
                    double val = Double.parseDouble(txt);
                    return new Double(val);
                }
                catch (Throwable t) {
                    if (fmt == null) {
                        throw new IllegalArgumentException(data.toString());
                    }
                    Number numb = (Number)fmt.parseObject(data.toString());
                    return new Double(numb.doubleValue());
                }
            }
            case 2: 
            case 3: {
                if (data instanceof Number) {
                    if (data instanceof BigDecimal) {
                        return data;
                    }
                    Number numb = (Number)data;
                    return new BigDecimal(numb.doubleValue());
                }
                String txt = data.toString().trim();
                if (txt.length() == 0) {
                    txt = "0";
                }
                try {
                    return new BigDecimal(txt);
                }
                catch (Throwable t) {
                    if (fmt == null) {
                        throw new IllegalArgumentException(data.toString());
                    }
                    Number numb = (Number)fmt.parseObject(data.toString());
                    return new BigDecimal(numb.doubleValue());
                }
            }
            case -7: 
            case 16: {
                if (data instanceof Boolean) {
                    return data;
                }
                try {
                    return Boolean.valueOf(data.toString());
                }
                catch (Throwable t) {
                    if (fmt == null) {
                        throw new IllegalArgumentException(data.toString());
                    }
                    return (Boolean)fmt.parseObject(data.toString());
                }
            }
            case -4: 
            case -3: 
            case 2004: {
                if (data instanceof byte[]) {
                    return new ByteArrayBlob((byte[])data);
                }
                if (data instanceof Blob) {
                    byte[] blob = null;
                    try {
                        Blob b = (Blob)data;
                        blob = b.getBytes(0L, (int)b.length());
                    }
                    catch (SQLException sqle) {
                        blob = data.toString().getBytes();
                    }
                    return new ByteArrayBlob(blob);
                }
                if (data instanceof Clob) {
                    byte[] blob = null;
                    try {
                        Clob c = (Clob)data;
                        blob = c.getSubString(0L, (int)c.length()).getBytes();
                    }
                    catch (SQLException sqle) {
                        blob = data.toString().getBytes();
                    }
                    return new ByteArrayBlob(blob);
                }
                if (fmt == null) {
                    return data.toString().getBytes();
                }
                return (byte[])fmt.parseObject(data.toString());
            }
            case -1: 
            case 2005: {
                try {
                    if (data instanceof Clob) {
                        Clob clob = (Clob)data;
                        try {
                            return new ByteArrayClob(clob.getSubString(0L, (int)clob.length()));
                        }
                        catch (SQLException e) {
                            throw new ParseException(e.getMessage(), 0);
                        }
                    }
                    if (data instanceof char[]) {
                        return new ByteArrayClob((char[])data);
                    }
                    if (data instanceof String) {
                        return new ByteArrayClob(data.toString());
                    }
                    if (data instanceof Blob) {
                        String c = null;
                        try {
                            Blob b = (Blob)data;
                            c = new String(b.getBytes(0L, (int)b.length()));
                        }
                        catch (SQLException sqle) {
                            c = data.toString();
                        }
                        return new ByteArrayClob(c);
                    }
                    if (fmt == null) {
                        return new ByteArrayClob(data.toString());
                    }
                    return (Clob)fmt.parseObject(data.toString());
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            case 91: {
                if (data instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)data;
                    return new Date(date.getTime());
                }
                if (data instanceof Number) {
                    Number numb = (Number)data;
                    return new Date(numb.longValue());
                }
                if (fmt == null) {
                    throw new IllegalArgumentException(data.toString());
                }
                java.util.Date date = (java.util.Date)fmt.parseObject(data.toString());
                return new Date(date.getTime());
            }
            case 92: {
                if (data instanceof Time) {
                    return data;
                }
                if (data instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)data;
                    return new Time(date.getTime());
                }
                if (data instanceof Number) {
                    Number numb = (Number)data;
                    return new Time(numb.longValue());
                }
                if (fmt == null) {
                    throw new IllegalArgumentException(data.toString());
                }
                java.util.Date date = (java.util.Date)fmt.parseObject(data.toString());
                return new Time(date.getTime());
            }
            case 93: {
                if (data instanceof Time) {
                    return data;
                }
                if (data instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)data;
                    return new Timestamp(date.getTime());
                }
                if (data instanceof Number) {
                    Number numb = (Number)data;
                    return new Timestamp(numb.longValue());
                }
                if (fmt == null) {
                    throw new IllegalArgumentException(data.toString());
                }
                java.util.Date date = (java.util.Date)fmt.parseObject(data.toString());
                return new Timestamp(date.getTime());
            }
        }
        return data;
    }

    public static int getTypeforName(String name) {
        try {
            Class<Types> c = Types.class;
            return c.getField(name.toUpperCase()).getInt(null);
        }
        catch (Exception e) {
            return 12;
        }
    }

    public static String getTypeforValue(int type) {
        try {
            Class<Types> c = Types.class;
            Field[] flds = c.getDeclaredFields();
            for (int i = 0; i < flds.length; ++i) {
                Field f = flds[i];
                if (f.getInt(null) != type) continue;
                return f.getName();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getSQLTypes(boolean sorted) {
        Vector<String> list = new Vector<String>();
        try {
            Class<Types> c = Types.class;
            Field[] types = c.getFields();
            for (int i = 0; i < types.length; ++i) {
                try {
                    list.add(types[i].getName());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception c) {
            // empty catch block
        }
        Object[] data = list.toArray(new String[0]);
        if (sorted) {
            Arrays.sort(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getNativeTypeMap(DatabaseMetaData metaData) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ResultSet set = null;
        try {
            set = metaData.getTypeInfo();
            while (set.next()) {
                String name = set.getString("TYPE_NAME");
                Integer sqlType = new Integer(set.getInt("DATA_TYPE"));
                map.put(name, sqlType);
            }
        }
        catch (Throwable t) {
            map.clear();
            BasicUtilities.HandleException(t);
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable name) {}
        }
        return map;
    }

    public static String generatePreparedInsertRequest(String Table, String[] Columns) {
        if (Columns.length >= 1 && Table != null) {
            int i;
            StringBuffer sql = new StringBuffer("INSERT INTO ");
            sql.append(Table);
            sql.append(" (");
            for (i = 0; i < Columns.length - 1; ++i) {
                sql.append(Columns[i]);
                sql.append(", ");
            }
            sql.append(Columns[Columns.length - 1]);
            sql.append(") VALUES (");
            for (i = 0; i < Columns.length - 1; ++i) {
                sql.append("?, ");
            }
            sql.append("?)");
            return sql.toString();
        }
        return null;
    }

    public static String generatePreparedUpdateRequest(String Table, String[] Columns, String whereClause) {
        try {
            StringBuffer sql = new StringBuffer("UPDATE ");
            sql.append(Table);
            sql.append(" SET (");
            for (int i = 0; i < Columns.length - 1; ++i) {
                sql.append(Columns[i]);
                sql.append("=?, ");
            }
            sql.append(Columns[Columns.length - 1]);
            sql.append("=?)");
            if (whereClause != null && whereClause.trim().length() >= 1) {
                sql.append(" WHERE ");
                sql.append(whereClause);
            }
            return sql.toString();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
            return null;
        }
    }

    public static void configurePreparedStatement(PreparedStatement ps, Object[] data, int[] type, boolean convert) throws SQLException {
        if (data == null || type == null) {
            throw new NullPointerException();
        }
        if (data.length != type.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < data.length; ++i) {
            JDBCUtilities.configurePreparedStatement(ps, i + 1, data[i], type[i], convert);
        }
    }

    public static void configurePreparedStatement(PreparedStatement ps, int index, Object value, int type, boolean convert) throws SQLException {
        if (value == null) {
            ps.setNull(index, type);
            return;
        }
        if (convert) {
            try {
                JDBCUtilities.convertValue(value, type, null);
            }
            catch (ParseException pe) {
                throw new SQLException(pe.getMessage());
            }
        }
        switch (type) {
            case 1: 
            case 12: {
                ps.setString(index, (String)value);
                break;
            }
            case -6: {
                ps.setByte(index, ((Number)value).byteValue());
                break;
            }
            case 5: {
                ps.setShort(index, ((Number)value).shortValue());
                break;
            }
            case 4: {
                ps.setInt(index, ((Number)value).intValue());
                break;
            }
            case 7: {
                ps.setFloat(index, ((Number)value).floatValue());
                break;
            }
            case -5: {
                ps.setLong(index, ((Number)value).longValue());
                break;
            }
            case 6: 
            case 8: {
                ps.setDouble(index, ((Number)value).doubleValue());
                break;
            }
            case 2: 
            case 3: {
                ps.setBigDecimal(index, (BigDecimal)value);
                break;
            }
            case -7: 
            case 16: {
                ps.setBoolean(index, (Boolean)value);
                break;
            }
            case 2004: {
                ps.setBlob(index, (Blob)value);
                break;
            }
            case 2005: {
                ps.setClob(index, (Clob)value);
                break;
            }
            case 91: {
                ps.setDate(index, (Date)value);
                break;
            }
            case 92: {
                ps.setTime(index, (Time)value);
                break;
            }
            case 93: {
                ps.setTimestamp(index, (Timestamp)value);
                break;
            }
            case -4: 
            case -3: {
                ByteArrayBlob blob = (ByteArrayBlob)value;
                ps.setBinaryStream(index, blob.getBinaryStream(), (int)blob.length());
                break;
            }
            case -1: {
                ByteArrayClob clob = (ByteArrayClob)value;
                ps.setCharacterStream(index, clob.getCharacterStream(), (int)clob.length());
                break;
            }
            default: {
                ps.setObject(index, value);
            }
        }
    }

    public static Object getValueForType(ResultSet set, int type, int idx) throws SQLException {
        Object data = null;
        try {
            switch (type) {
                case 91: {
                    data = set.getDate(idx);
                    break;
                }
                case -6: {
                    data = set.getByte(idx);
                    break;
                }
                case 5: {
                    data = set.getShort(idx);
                    break;
                }
                case 93: {
                    data = set.getTimestamp(idx);
                    break;
                }
                case 92: {
                    data = set.getTime(idx);
                    break;
                }
                case 4: {
                    data = new Integer(set.getInt(idx));
                    break;
                }
                case 2: 
                case 3: {
                    data = set.getBigDecimal(idx);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    data = set.getDouble(idx);
                    break;
                }
                case -5: {
                    data = set.getLong(idx);
                    break;
                }
                case -7: 
                case 16: {
                    data = set.getBoolean(idx);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    data = new ByteArrayBlob(set.getBytes(idx));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    data = set.getString(idx);
                    break;
                }
                case 2004: {
                    data = set.getBlob(idx);
                    break;
                }
                case 2005: {
                    data = set.getClob(idx);
                    break;
                }
                case 2006: {
                    data = set.getRef(idx);
                    break;
                }
                case 2003: {
                    data = set.getArray(idx);
                    break;
                }
                case 2001: {
                    data = set.getObject(idx);
                    break;
                }
                default: {
                    data = set.getObject(idx);
                    break;
                }
            }
        }
        catch (SQLException sqle) {
            String[] p = new String[]{Integer.toString(idx), JDBCUtilities.getTypeforValue(type), sqle.getMessage()};
            String msg = BasicUtilities.getString("Resultset_Pull_Error", p);
            System.err.println(msg);
            throw sqle;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        try {
            if (set.wasNull()) {
                data = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return data;
    }
}

