/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.swing.JListUISupport;
import org.isqlviewer.ui.HelpWindow;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class BookmarkEditor
extends JDialog
implements DocumentListener,
ActionListener,
ListSelectionListener {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private DefaultListModel mdlParams = new DefaultListModel();
    private DefaultComboBoxModel mdlTypes = new DefaultComboBoxModel<String>(JDBCUtilities.getSQLTypes(true));
    private JLabel lblName = new JLabel(BasicUtilities.getString("Bookmark_Name"));
    private JLabel lblSQL = new JLabel(BasicUtilities.getString("Bookmark_SQL"));
    private JLabel lblUsage = new JLabel("");
    private JLabel lblCre8d = new JLabel("");
    private JLabel lblLastU = new JLabel("");
    private JLabel lblBPath = new JLabel("");
    private DateFormat df = DateFormat.getDateTimeInstance();
    private JTextField txtName = new JTextField("", 16);
    private JTextField txtParamValue = new JTextField("", 16);
    private JTextField txtParamOptions = new JTextField("", 16);
    private JButton btnParamAdd = new JButton("+");
    private JButton btnParamHlp = new JButton(BasicUtilities.loadIconResource("Help24"));
    private JButton btnParamDel = new JButton("-");
    private JComboBox jcbTypes = new JComboBox(this.mdlTypes);
    private JList lstParams = new JList(this.mdlParams);
    private HelpWindow helpView = null;
    private SQLEditor sqlEditor = new SQLEditor();
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnCancel = new JButton(BasicUtilities.getString("Cancel"));
    private boolean isNew = false;
    private boolean changeSelection = false;
    private SQLBookmark bookmark = null;
    private BookmarkTreeModel model = null;

    public BookmarkEditor(JDialog parent, BookmarkTreeModel model) {
        super((Dialog)parent, true);
        this.model = model;
        this.initUI();
    }

    public BookmarkEditor(JFrame parent, BookmarkTreeModel model) {
        super((Frame)parent, true);
        this.model = model;
        this.initUI();
    }

    public void setBookmark(SQLBookmark bm) {
        this.bookmark = bm;
        this.setTitle(BasicUtilities.getString("Bookmark_Editor_Title", bm.getName()));
        this.sqlEditor.setText(bm.getSQL());
        this.txtName.setText(bm.getName());
        String date = this.df.format(bm.getCreationDate());
        this.lblCre8d.setText(BasicUtilities.getString("Bookmark_Make_Date", date));
        date = this.df.format(bm.getLastAccessTime());
        this.lblLastU.setText(BasicUtilities.getString("Bookmark_Last_Date", date));
        this.lblUsage.setText(BasicUtilities.getString("Bookmark_Use_Count", Long.toString(bm.getUseCount())));
        this.lblBPath.setText(BasicUtilities.getString("Bookmark_Path", bm.getPath()));
        this.mdlParams.clear();
        Iterator itr = bm.parameterIterator();
        while (itr.hasNext()) {
            this.mdlParams.addElement(itr.next());
        }
        if (this.mdlParams.isEmpty()) {
            this.jcbTypes.setEnabled(false);
            this.txtParamOptions.setEnabled(false);
            this.txtParamValue.setEnabled(false);
        } else {
            this.lstParams.setSelectedIndex(0);
        }
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void installEditorSupport(DatabaseConnection dbc) {
        this.sqlEditor.createContextHelp(this);
        this.sqlEditor.configureWithConnection(dbc);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting() || this.lstParams.getSelectedIndex() < 0) {
            this.jcbTypes.setEnabled(false);
            this.txtParamOptions.setEnabled(false);
            this.txtParamValue.setEnabled(false);
            return;
        }
        this.changeSelection = true;
        SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)this.lstParams.getSelectedValue();
        if (parameter == null) {
            this.jcbTypes.setSelectedItem(null);
            this.txtParamOptions.setText("");
            this.txtParamValue.setText("");
            return;
        }
        this.jcbTypes.setSelectedItem(JDBCUtilities.getTypeforValue(parameter.getSQLType()));
        this.txtParamOptions.setText(parameter.getOptions());
        this.txtParamValue.setText(parameter.getValue());
        this.jcbTypes.setEnabled(true);
        this.txtParamOptions.setEnabled(true);
        this.txtParamValue.setEnabled(true);
        this.changeSelection = false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.btnOK) {
            this.bookmark.setName(this.txtName.getText());
            this.bookmark.setSQL(this.sqlEditor.getText());
            this.applyParameters();
            try {
                if (this.isNew) {
                    this.model.addBookmark(this.bookmark);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.model.setModified();
            this.model.refresh(this.bookmark);
            this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (src == this.btnCancel) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (src == this.btnParamHlp) {
            if (this.helpView == null) {
                URL url = BasicUtilities.getResourceURL(BasicUtilities.getString("Import_Auto_Inline_Help"));
                this.helpView = HelpWindow.showHelp(this, url, "Bork");
                this.helpView.setDefaultCloseOperation(1);
            } else {
                this.helpView.show();
            }
        } else if (src == this.btnParamAdd) {
            this.mdlParams.addElement(new SQLBookmark.Parameter());
            this.lstParams.setSelectedIndex(this.mdlParams.getSize() - 1);
            this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        } else if (src == this.btnParamDel) {
            int index = this.lstParams.getSelectedIndex();
            if (index >= 0) {
                this.mdlParams.remove(index);
                this.lstParams.setSelectedIndex(Math.min(this.mdlParams.getSize() - 1, index));
                this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
            }
        } else if (src == this.jcbTypes) {
            this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
            int[] selected = this.lstParams.getSelectedIndices();
            int newType = JDBCUtilities.getTypeforName((String)this.mdlTypes.getSelectedItem());
            for (int i = 0; i < selected.length; ++i) {
                SQLBookmark.Parameter param = (SQLBookmark.Parameter)this.mdlParams.get(selected[i]);
                param.setSQLType(newType);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)this.lstParams.getSelectedValue();
        if (parameter != null && !this.changeSelection) {
            parameter.setOptions(this.txtParamOptions.getText());
            parameter.setValue(this.txtParamValue.getText());
            this.lstParams.invalidate();
            this.lstParams.repaint();
            return;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        SQLBookmark.Parameter parameter = (SQLBookmark.Parameter)this.lstParams.getSelectedValue();
        if (parameter != null && !this.changeSelection) {
            parameter.setOptions(this.txtParamOptions.getText());
            parameter.setValue(this.txtParamValue.getText());
            this.lstParams.invalidate();
            this.lstParams.repaint();
            return;
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 200: {
                this.sqlEditor.requestFocus();
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
                break;
            }
            case 201: {
                String title;
                Boolean modified = (Boolean)this.getRootPane().getClientProperty("windowModified");
                if (modified == null || !modified.booleanValue()) break;
                String msg = BasicUtilities.getString("Bookmark_Edit_Warning");
                int res = JOptionPane.showConfirmDialog(this, msg = StringUtilities.formatBreak(80, "<html>".concat(msg), "", true), title = BasicUtilities.getString("Warning"), 0);
                if (res == 0) break;
                return;
            }
        }
        super.processWindowEvent(e);
    }

    private void initUI() {
        JPanel root = (JPanel)this.getContentPane();
        this.setDefaultCloseOperation(2);
        root.setLayout(new GridBagLayout());
        this.sqlEditor.setPreferredSize(new Dimension(360, 200));
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.txtName.getDocument().addDocumentListener(this);
        this.sqlEditor.getDocument().addDocumentListener(this);
        this.btnOK.setDefaultCapable(true);
        JPanel editor = new JPanel(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.btnOK);
        BookmarkEditor.constrain(0, 1, 1, 1, 0.0, 0.0, 17, 0);
        editor.add((Component)this.lblName, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 2, 2, 1, 0.0, 0.0, 17, 2);
        editor.add((Component)this.txtName, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 3, 1, 1, 0.0, 0.0, 17, 0);
        editor.add((Component)this.lblSQL, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 4, 2, 1, 1.0, 1.0, 17, 1);
        editor.add((Component)this.sqlEditor, UI_CONSTRAINT);
        String title = BasicUtilities.getString("Bookmarks_General");
        Icon icon = BasicUtilities.loadIconResource("Bookmarks16");
        String tip = BasicUtilities.getString("Bookmarks_General_Tip");
        JComponent comp = editor;
        JTabbedPane jtpRoot = new JTabbedPane(1);
        jtpRoot.addTab(title, icon, comp, tip);
        JPanel minfo = new JPanel(new GridBagLayout());
        BookmarkEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 17, 0);
        minfo.add((Component)this.lblBPath, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 1, 1, 1, 0.0, 0.0, 17, 0);
        minfo.add((Component)this.lblCre8d, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 2, 1, 1, 0.0, 0.0, 17, 0);
        minfo.add((Component)this.lblLastU, UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 3, 1, 1, 0.0, 0.0, 17, 0);
        minfo.add((Component)this.lblUsage, UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 0, 1, 5, 1.0, 0.0, 10, 2);
        minfo.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        BookmarkEditor.constrain(0, 4, 1, 1, 0.0, 1.0, 10, 3);
        minfo.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        title = BasicUtilities.getString("Boomark_Parameters");
        icon = BasicUtilities.loadIconResource("TableInfo16");
        tip = BasicUtilities.getString("Boomark_Param_Tip");
        comp = this.createParameterEditor();
        jtpRoot.addTab(title, icon, comp, tip);
        title = BasicUtilities.getString("Boomark_Info");
        icon = BasicUtilities.loadIconResource("Information16");
        tip = BasicUtilities.getString("Boomark_Info_Tip");
        comp = minfo;
        jtpRoot.addTab(title, icon, comp, tip);
        BookmarkEditor.constrain(0, 0, 1, 4, 0.0, 0.0, 10, 0);
        root.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
        root.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 1, 3, 1, 1.0, 1.0, 10, 1);
        root.add((Component)jtpRoot, UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 2, 1, 1, 1.0, 0.0, 10, 2);
        root.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        BookmarkEditor.constrain(2, 2, 1, 1, 0.0, 0.0, 13, 0);
        root.add((Component)this.btnCancel, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 2, 1, 1, 0.0, 0.0, 13, 0);
        root.add((Component)this.btnOK, UI_CONSTRAINT);
        BookmarkEditor.constrain(4, 0, 1, 4, 0.0, 0.0, 10, 0);
        root.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 4, 3, 1, 0.0, 0.0, 10, 0);
        root.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        this.pack();
        this.setSize(new Dimension(540, 320));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getOwner());
    }

    private JComponent createParameterEditor() {
        JPanel panel = new JPanel(new GridBagLayout());
        JListUISupport.install(this.lstParams, true);
        this.lstParams.setCellRenderer(new ParameterRenderer());
        this.lstParams.getSelectionModel().setSelectionMode(0);
        this.btnParamAdd.setFont(this.btnParamAdd.getFont().deriveFont(1, 16.0f));
        this.btnParamDel.setFont(this.btnParamDel.getFont().deriveFont(1, 16.0f));
        this.btnParamAdd.addActionListener(this);
        this.btnParamDel.addActionListener(this);
        this.btnParamHlp.addActionListener(this);
        this.lstParams.addListSelectionListener(this);
        this.jcbTypes.addActionListener(this);
        this.txtParamOptions.getDocument().addDocumentListener(this);
        this.txtParamValue.getDocument().addDocumentListener(this);
        this.btnParamAdd.setToolTipText(BasicUtilities.getString("Bookmark_AddParam_Tip"));
        this.btnParamDel.setToolTipText(BasicUtilities.getString("Bookmark_DelParam_Tip"));
        this.btnParamHlp.setToolTipText(BasicUtilities.getString("Bookmark_HlpParam_Tip"));
        BookmarkEditor.constrain(0, 0, 1, 10, 0.0, 0.0, 10, 0);
        panel.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
        panel.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 1, 2, 7, 0.75, 1.0, 10, 1);
        panel.add((Component)new JScrollPane(this.lstParams), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 2);
        panel.add((Component)new JLabel(BasicUtilities.getString("Bookmark_Select_Parameter_Type")), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 2);
        panel.add((Component)this.jcbTypes, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 3, 1, 1, 0.0, 0.0, 17, 2);
        panel.add((Component)new JLabel(BasicUtilities.getString("Bookmark_Parameter_Value")), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 4, 2, 1, 0.0, 0.0, 17, 2);
        panel.add((Component)this.txtParamValue, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 5, 1, 1, 1.0, 0.0, 17, 2);
        panel.add((Component)new JLabel(BasicUtilities.getString("Bookmark_Parameter_Options")), UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 6, 2, 1, 1.0, 0.0, 17, 2);
        panel.add((Component)this.txtParamOptions, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 7, 2, 2, 0.0, 1.0, 10, 3);
        panel.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 8, 1, 1, 0.0, 0.0, 18, 0);
        panel.add((Component)this.btnParamAdd, UI_CONSTRAINT);
        BookmarkEditor.constrain(2, 8, 1, 1, 0.0, 0.0, 18, 0);
        panel.add((Component)this.btnParamDel, UI_CONSTRAINT);
        BookmarkEditor.constrain(3, 8, 1, 1, 0.0, 0.0, 12, 0);
        panel.add((Component)this.btnParamHlp, UI_CONSTRAINT);
        BookmarkEditor.constrain(4, 0, 1, 10, 0.0, 0.0, 10, 0);
        panel.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
        BookmarkEditor.constrain(1, 9, 3, 1, 0.0, 0.0, 10, 0);
        panel.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
        return panel;
    }

    private void applyParameters() {
        this.bookmark.clearParameters();
        this.bookmark.addAll(Arrays.asList(this.mdlParams.toArray()));
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        BookmarkEditor.UI_CONSTRAINT.gridx = x;
        BookmarkEditor.UI_CONSTRAINT.gridy = y;
        BookmarkEditor.UI_CONSTRAINT.gridwidth = w;
        BookmarkEditor.UI_CONSTRAINT.gridheight = h;
        BookmarkEditor.UI_CONSTRAINT.weightx = wx;
        BookmarkEditor.UI_CONSTRAINT.weighty = wy;
        BookmarkEditor.UI_CONSTRAINT.anchor = a;
        BookmarkEditor.UI_CONSTRAINT.fill = f;
    }

    private static class ParameterRenderer
    extends DefaultListCellRenderer {
        private ParameterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object o, int idx, boolean sel, boolean foc) {
            super.getListCellRendererComponent((JList<?>)list, o, idx, sel, foc);
            this.setIcon(BasicUtilities.loadIconResource("TableInfo16"));
            SQLBookmark.Parameter param = (SQLBookmark.Parameter)o;
            this.setText(idx + 1 + "-" + param.getValue());
            return this;
        }
    }

    public static class TreeCell
    extends DefaultTreeCellEditor {
        public TreeCell(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree t, Object val, boolean sel, boolean ex, boolean lf, int row) {
            if (val instanceof String) {
                String s = (String)val;
                int idx = s.lastIndexOf(47);
                idx = s.lastIndexOf(47, idx - 1);
                try {
                    val = s.substring(idx + 1, s.length() - 1);
                }
                catch (Exception exception) {}
            } else if (val instanceof SQLBookmark) {
                SQLBookmark bm = (SQLBookmark)val;
                val = bm.getName();
            }
            return super.getTreeCellEditorComponent(t, val, sel, ex, lf, row);
        }
    }
}

