/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    private static int lastX = 0;
    private static int lastY = 0;
    protected Icon right;
    protected int iconGap = 2;
    protected Icon left;

    public CompoundIcon(Icon leftIcon, Icon rightIcon) {
        this.left = leftIcon;
        this.right = rightIcon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        lastX = x;
        lastY = y;
        if (this.left != null) {
            this.left.paintIcon(c, g, x, y);
        }
        if (this.right != null) {
            int l = this.left == null ? 0 : this.left.getIconWidth() + this.iconGap;
            this.right.paintIcon(c, g, x + l, y);
        }
    }

    @Override
    public int getIconWidth() {
        int l = this.left == null ? 0 : this.left.getIconWidth();
        int r = this.right == null ? 0 : this.right.getIconWidth();
        return l + r + this.iconGap;
    }

    @Override
    public int getIconHeight() {
        int l = this.left == null ? 0 : this.left.getIconHeight();
        int r = this.right == null ? 0 : this.right.getIconHeight();
        return Math.max(r, l);
    }

    public Icon getRightIcon() {
        return this.right;
    }

    public Icon getLeftIcon() {
        return this.left;
    }

    public void setRightIcon(Icon icon) {
        this.right = icon;
    }

    public void setLeftIcon(Icon icon) {
        this.left = icon;
    }

    public boolean isOverIcon(int x, int y) {
        int h;
        int w = this.left == null ? 0 : this.left.getIconWidth();
        int n = h = this.left == null ? 0 : this.left.getIconHeight();
        if (x < lastX || x > lastX + w) {
            return false;
        }
        return y >= lastY && y <= lastX + h;
    }
}

