/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class ITableCellEditor
extends DefaultCellEditor {
    private int sqlType = 1111;
    private SimpleDateFormat sdf = new SimpleDateFormat("");

    public ITableCellEditor(int type) {
        super(new JTextField());
        this.sqlType = type;
    }

    @Override
    public Object getCellEditorValue() {
        UserPreferences prefs;
        SystemConfig config = SystemConfig.getInstance();
        String txt = (String)super.getCellEditorValue();
        if (JDBCUtilities.isDateType(this.sqlType)) {
            this.sdf.applyPattern(config.getFormatForSQLType(this.sqlType));
            try {
                return this.sdf.parse(txt);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                return txt;
            }
        }
        if (txt != null && (prefs = config.getPreferences()).getBoolean("general.ascii2native-enabled")) {
            return StringUtilities.encode(txt, false, false);
        }
        return super.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        UserPreferences prefs;
        SystemConfig config = SystemConfig.getInstance();
        if (JDBCUtilities.isDateType(this.sqlType)) {
            this.sdf.applyPattern(config.getFormatForSQLType(this.sqlType));
            try {
                if (value == null) {
                    value = new Date();
                }
                value = this.sdf.format((Date)value);
            }
            catch (Throwable throwable) {}
        } else if (value != null && (prefs = config.getPreferences()).getBoolean("general.ascii2native-enabled")) {
            value = StringUtilities.decode(value.toString());
        }
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        c.setBackground(UIManager.getColor("ToolTip.background"));
        c.setForeground(UIManager.getColor("ToolTip.foreground"));
        int h = c.getPreferredSize().height;
        int h2 = table.getRowHeight();
        table.setRowHeight(Math.max(h2, h));
        return c;
    }
}

