/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class ITableCellRenderer
extends DefaultTableCellRenderer {
    private static UserPreferences prefs = SystemConfig.getInstance().getPreferences();
    private SimpleDateFormat sdf = null;
    private Border origBorder = this.getBorder();
    private String style = null;
    private int type = -1;

    public ITableCellRenderer() {
        this(1111);
    }

    public ITableCellRenderer(int newType) {
        this.type = newType;
    }

    public void applyStyle(String newStyle) {
        this.style = newStyle;
    }

    @Override
    public Component getTableCellRendererComponent(JTable tab, Object o, boolean sel, boolean foc, int row, int col) {
        super.getTableCellRendererComponent(tab, o, sel, foc, row, col);
        if (o == null) {
            Border bdr = BorderFactory.createLineBorder(prefs.getColor("general.null-color"));
            if (foc) {
                this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), bdr));
            } else {
                this.setBorder(bdr);
            }
        } else {
            this.setBorder(this.origBorder);
            try {
                this.format(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (row == tab.getEditingRow()) {
            this.setBackground(tab.getBackground());
        }
        return this;
    }

    protected void format(Object o) {
        if (o == null) {
            this.setText(null);
            return;
        }
        this.setHorizontalAlignment(2);
        this.setIcon(null);
        switch (this.type) {
            case 93: {
                if (this.sdf == null) {
                    if (this.style == null) {
                        this.sdf = new SimpleDateFormat(prefs.get("general.timestamp-format"));
                    } else {
                        this.sdf.applyPattern(prefs.get("general.timestamp-format"));
                    }
                }
                try {
                    this.setText(this.sdf.format((Date)o));
                }
                catch (Throwable throwable) {}
                break;
            }
            case 92: {
                if (this.sdf == null) {
                    if (this.style == null) {
                        this.sdf = new SimpleDateFormat(prefs.get("general.time-format"));
                    } else {
                        this.sdf.applyPattern(prefs.get("general.time-format"));
                    }
                }
                try {
                    this.setText(this.sdf.format((Date)o));
                }
                catch (Throwable throwable) {}
                break;
            }
            case 91: {
                if (this.sdf == null) {
                    if (this.style == null) {
                        this.sdf = new SimpleDateFormat(prefs.get("general.date-format"));
                    } else {
                        this.sdf.applyPattern(prefs.get("general.date-format"));
                    }
                }
                try {
                    this.setText(this.sdf.format((Date)o));
                }
                catch (Throwable throwable) {}
                break;
            }
            case 2006: {
                try {
                    Ref ref = (Ref)o;
                    Object[] p = new String[]{ref.getBaseTypeName()};
                    String fmt = MessageFormat.format("REF ''{0}''", p);
                    this.setText(fmt);
                }
                catch (Throwable ref) {}
                break;
            }
            case 2004: {
                try {
                    long size = ((Blob)o).length();
                    Object[] p = new String[]{StringUtilities.getHumanReadableSize(size)};
                    String fmt = MessageFormat.format("BLOB {0}", p);
                    this.setText(fmt);
                }
                catch (Throwable size) {}
                break;
            }
            case 2005: {
                try {
                    long size = ((Clob)o).length();
                    Object[] p = new String[]{StringUtilities.getHumanReadableSize(size)};
                    String fmt = MessageFormat.format("CLOB {0}", p);
                    this.setText(fmt);
                }
                catch (Throwable throwable) {}
                break;
            }
            default: {
                this.setText(o.toString().trim());
            }
        }
    }
}

