/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.ImportPlugin;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.TableSelector;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;

public class ImportEditor
extends JPanel
implements MouseListener,
ListSelectionListener,
ActionListener,
ChangeListener {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private DefaultListModel mdlMappings = new DefaultListModel();
    private DefaultComboBoxModel editorOptions = new DefaultComboBoxModel();
    private JSplitPane jspRoot = new JSplitPane(1);
    private JSplitPane jspData = new JSplitPane(0);
    private JList jlsMappings = new JList(this.mdlMappings);
    private JButton btnDelete = new JButton(BasicUtilities.loadIconResource("RowDelete16"));
    private JButton btnOpen = new JButton(BasicUtilities.loadIconResource("Open16"));
    private JButton btnSave = new JButton(BasicUtilities.loadIconResource("SaveAs16"));
    private JCheckBox chkUseBatch = new JCheckBox(BasicUtilities.getString("Import_Batch_Opt"));
    private JCheckBox chkUseTx = new JCheckBox(BasicUtilities.getString("Import_Trans_Opt"));
    private JLabel lblStatus = new JLabel("");
    private JLabel lblSelect = new JLabel("");
    private ITable tblImportData = new ITable();
    private TableSelector jtsSelector;
    private WizardPanel pnlEditor = new WizardPanel();
    private ImportConfig importMapping = new ImportConfig();
    private JComboBox jcbEditor = new JComboBox(this.editorOptions);
    private ColumnMapRenderer listRenderer = new ColumnMapRenderer();
    private DatabaseConnection connection = null;
    private ArrayList plugins = null;
    private String lastTable = null;
    private int lastSelection = -1;
    private boolean isLoading = false;

    public ImportEditor(DatabaseConnection connection) {
        super(new BorderLayout(1, 1));
        this.connection = connection;
        try {
            this.initUI();
            this.loadEditors();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ImportEditor()::initUI()");
        }
        finally {
            this.stateChanged(null);
        }
    }

    public void setData(EnhancedTableModel model) {
        TableModel old = this.tblImportData.getModel();
        this.tblImportData.setModel(model);
        for (ImportPlugin ip : this.plugins) {
            if (old != null) {
                old.removeTableModelListener(ip);
            }
            model.addTableModelListener(ip);
            try {
                ip.handleDataModelChange(model);
            }
            catch (Throwable t) {
                BasicUtilities.showExceptionPopup(this, t, null);
            }
        }
        BasicUtilities.optimizeTableView(this.tblImportData);
    }

    public ImportConfig getImportConfig() {
        this.importMapping.setUseTransaction(this.chkUseTx.isSelected());
        this.importMapping.setUseBatch(this.chkUseBatch.isSelected());
        return this.importMapping;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        ImportPlugin plugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
        if (evt == null || evt.getValueIsAdjusting() || this.isLoading) {
            return;
        }
        int selection = this.jlsMappings.getSelectedIndex();
        if (selection < 0 || selection >= this.mdlMappings.size()) {
            return;
        }
        String oldColumn = null;
        String newColumn = null;
        oldColumn = this.lastSelection < 0 ? "" : (String)this.mdlMappings.get(this.lastSelection);
        newColumn = (String)this.mdlMappings.get(selection);
        if (this.lastSelection >= 0) {
            try {
                if (!plugin.canChangeSelection()) {
                    ListSelectionModel smodel = this.jlsMappings.getSelectionModel();
                    smodel.setValueIsAdjusting(true);
                    this.jlsMappings.setSelectedIndex(this.lastSelection);
                    BasicUtilities.beep();
                    return;
                }
                this.importMapping.addEntry(oldColumn, plugin.createEntry());
            }
            catch (Throwable t) {
                BasicUtilities.showExceptionPopup(this, t, null);
            }
        }
        try {
            ImportConfig.Entry entry = this.importMapping.getEntry(newColumn);
            if (entry == null) {
                entry = new ImportConfig.Entry(plugin);
            } else {
                String id = this.pluginDescriptionForName(entry.getPluginName());
                this.jcbEditor.setSelectedItem(id);
            }
        }
        catch (Throwable t) {
            BasicUtilities.showExceptionPopup(this, t, null);
        }
        this.lblSelect.setText(BasicUtilities.getString("Imported_Data_Using", newColumn));
        try {
            plugin.handleColumnSelectionChange(newColumn, oldColumn);
        }
        catch (Throwable t) {
            BasicUtilities.showExceptionPopup(this, t, null);
        }
        this.lastSelection = selection;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        this.lblStatus.setText(button.getActionCommand());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lblStatus.setText("");
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        ImportPlugin plugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
        String catalog = this.jtsSelector.getSelectedCatalog();
        String schema = this.jtsSelector.getSelectedSchema();
        String table = this.jtsSelector.getSelectedTable();
        String oldTable = null;
        oldTable = this.lastTable == null ? "" : this.lastTable;
        this.loadColumns(catalog, schema, table);
        this.importMapping.setCatalog(catalog);
        this.importMapping.setSchema(schema);
        this.importMapping.setTable(table);
        try {
            plugin.handleTableSelectionChange(oldTable, table);
        }
        catch (Throwable t) {
            BasicUtilities.showExceptionPopup(this, t, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isLoading) {
            return;
        }
        Object src = evt.getSource();
        if (src == this.btnDelete) {
            BasicUtilities.removeSelectedRows(this.tblImportData);
        } else if (src == this.jcbEditor) {
            String option = (String)this.jcbEditor.getSelectedItem();
            String column = (String)this.jlsMappings.getSelectedValue();
            this.pnlEditor.showCard(option);
            ImportPlugin plugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
            try {
                ImportConfig.Entry oldEntry = this.importMapping.removeEntry(column);
                ImportConfig.Entry entry = null;
                if (oldEntry != null && oldEntry.getPluginName().equalsIgnoreCase(plugin.getName())) {
                    entry = oldEntry;
                } else {
                    oldEntry = null;
                    entry = new ImportConfig.Entry(plugin);
                }
                this.importMapping.addEntry(column, entry);
                plugin.setEntry(entry);
            }
            catch (Throwable t) {
                BasicUtilities.showExceptionPopup(this, t, null);
            }
        } else if (src == this.btnSave) {
            this.importMapping.setUseTransaction(this.chkUseTx.isSelected());
            this.importMapping.setUseBatch(this.chkUseBatch.isSelected());
            String column = (String)this.jlsMappings.getSelectedValue();
            ImportPlugin plugin = (ImportPlugin)this.plugins.get(this.jcbEditor.getSelectedIndex());
            this.importMapping.addEntry(column, plugin.createEntry());
            String desc = BasicUtilities.getString("ImportFile_Desc");
            FileFilter[] options = new FileFilter[]{new ExtensionFileFilter("icf", desc)};
            File file = BasicUtilities.saveSystemFile(this, options);
            if (file != null) {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    this.importMapping.store(fos);
                    fos.flush();
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {}
                    fos = null;
                }
            }
        } else if (src == this.btnOpen) {
            this.loadConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumns(String cat, String schema, String tab) {
        ResultSet set = null;
        DatabaseMetaData metadata = this.connection.getDatabaseInformation();
        this.lastSelection = -1;
        this.mdlMappings.removeAllElements();
        this.jlsMappings.clearSelection();
        if (!this.isLoading) {
            this.importMapping.clear();
        }
        try {
            set = metadata.getColumns(cat, schema, tab, null);
            while (set.next()) {
                String columnName = set.getString("COLUMN_NAME");
                String type = JDBCUtilities.getTypeforValue(set.getInt("DATA_TYPE"));
                this.mdlMappings.addElement(columnName);
                this.listRenderer.columnInfo.put(columnName, type);
            }
        }
        catch (SQLException sqle) {
            String msg = BasicUtilities.getString("Column_Load_Error");
            BasicUtilities.showExceptionPopup(this, sqle, msg);
        }
        catch (Throwable t) {
            BasicUtilities.beep();
            BasicUtilities.HandleException(t);
        }
        finally {
            if (this.mdlMappings.size() >= 1) {
                this.jlsMappings.setSelectedIndex(0);
            }
            try {
                set.close();
            }
            catch (Throwable sqle) {}
            set = null;
        }
    }

    private void loadEditors() {
        PluginFactory factory = SystemConfig.getInstance().getPluginFactory();
        this.plugins = new ArrayList(factory.createImportHandlers());
        for (ImportPlugin ip : this.plugins) {
            ip.setDatabaseConnection(this.connection);
            try {
                JPanel container = new JPanel();
                ip.installEditor(container);
                container.setBorder(BorderFactory.createEmptyBorder());
                this.editorOptions.addElement(ip.getDescription());
                JScrollPane jsp = new JScrollPane(container);
                jsp.setBorder(BorderFactory.createEmptyBorder());
                this.pnlEditor.add((Component)jsp, ip.getDescription());
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration() {
        String title;
        String msg;
        int result;
        if (!this.importMapping.isEmpty() && (result = JOptionPane.showConfirmDialog(this, msg = BasicUtilities.getString("ImportConfig_DataLoss_Warning"), title = BasicUtilities.getString("Warning"), 0)) != 0) {
            return;
        }
        String desc = BasicUtilities.getString("ImportFile_Desc");
        FileFilter[] options = new FileFilter[]{new ExtensionFileFilter("icf", desc)};
        File file = BasicUtilities.getSystemFile(this, 0, options);
        if (file != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                this.importMapping.load(fis);
                this.isLoading = true;
                this.jtsSelector.setSelectedCatalog(this.importMapping.getCatalog());
                this.jtsSelector.setSelectedSchema(this.importMapping.getSchema());
                this.jtsSelector.setSelectedTable(this.importMapping.getTable());
                if (this.chkUseTx.isEnabled()) {
                    this.chkUseTx.setSelected(this.importMapping.isUseTransaction());
                }
                if (this.chkUseBatch.isEnabled()) {
                    this.chkUseBatch.setSelected(this.importMapping.isUseBatch());
                }
                this.lastSelection = -1;
                this.lastTable = null;
                this.isLoading = false;
                this.jlsMappings.setSelectedIndex(0);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
                fis = null;
                this.invalidate();
                Object object = this.getTreeLock();
                synchronized (object) {
                    this.validateTree();
                }
            }
        }
    }

    private void initUI() {
        this.listRenderer.config = this.importMapping;
        this.chkUseBatch.setEnabled(this.connection.isBatchSupported());
        this.chkUseTx.setEnabled(this.connection.isTransactionsSupported());
        this.chkUseBatch.setToolTipText(BasicUtilities.getString("Import_Batch_Tip"));
        this.chkUseTx.setToolTipText(BasicUtilities.getString("Import_Trans_Tip"));
        this.jtsSelector = new TableSelector(this.connection.getDatabaseInformation(), true);
        this.jtsSelector.setTablesEditable(false);
        this.jtsSelector.addChangeListener(this);
        this.jtsSelector.setSelectedSchema(this.connection.getSchema());
        this.tblImportData.allowColumnReordering(false);
        this.tblImportData.setSelectionToggleEnabled(false);
        this.tblImportData.setRowSelectionAllowed(true);
        this.tblImportData.setColumnSelectionAllowed(false);
        this.btnDelete.setToolTipText(BasicUtilities.getString("Import_Delete_Selected_Rows"));
        this.configureButton(this.btnDelete);
        this.configureButton(this.btnOpen);
        this.btnOpen.setActionCommand(BasicUtilities.getString("Import_Load_Configuration"));
        this.configureButton(this.btnSave);
        this.btnSave.setActionCommand(BasicUtilities.getString("Import_Save_Configuration"));
        this.jcbEditor.setMaximumRowCount(5);
        this.jcbEditor.addActionListener(this);
        this.jlsMappings.addListSelectionListener(this);
        this.jlsMappings.setDragEnabled(false);
        this.jlsMappings.setCellRenderer(this.listRenderer);
        this.jlsMappings.setSelectionMode(0);
        JPanel editor = new JPanel(new GridBagLayout());
        this.lblSelect.setText(BasicUtilities.getString("Imported_Data_Using", ""));
        ImportEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 18, 0);
        editor.add((Component)this.lblSelect, UI_CONSTRAINT);
        ImportEditor.constrain(1, 0, 1, 1, 0.75, 0.0, 18, 2);
        editor.add((Component)this.jcbEditor, UI_CONSTRAINT);
        ImportEditor.constrain(0, 1, 3, 1, 1.0, 1.0, 10, 1);
        editor.add((Component)new JScrollPane(this.pnlEditor), UI_CONSTRAINT);
        JPanel preview = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel(BasicUtilities.getString("Imported_Data_Preview"));
        ImportEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 18, 0);
        preview.add((Component)lbl, UI_CONSTRAINT);
        ImportEditor.constrain(2, 0, 1, 1, 0.0, 0.0, 12, 0);
        preview.add((Component)this.btnDelete, UI_CONSTRAINT);
        ImportEditor.constrain(0, 1, 3, 1, 1.0, 1.0, 10, 1);
        preview.add((Component)new JScrollPane(this.tblImportData), UI_CONSTRAINT);
        JPanel tools = new JPanel(new GridBagLayout());
        ImportEditor.constrain(0, 0, 1, 1, 0.0, 0.0, 18, 0);
        tools.add((Component)this.btnOpen, UI_CONSTRAINT);
        ImportEditor.constrain(1, 0, 1, 1, 0.0, 0.0, 18, 0);
        tools.add((Component)this.btnSave, UI_CONSTRAINT);
        ImportEditor.constrain(2, 0, 1, 1, 0.0, 0.0, 17, 0);
        tools.add((Component)this.lblStatus, UI_CONSTRAINT);
        ImportEditor.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
        tools.add((Component)this.chkUseTx, UI_CONSTRAINT);
        ImportEditor.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
        tools.add((Component)this.chkUseBatch, UI_CONSTRAINT);
        ImportEditor.constrain(0, 1, 3, 2, 1.0, 0.0, 17, 2);
        tools.add((Component)this.jtsSelector, UI_CONSTRAINT);
        this.jspRoot.setOrientation(0);
        this.jspRoot.setBorder(BorderFactory.createEmptyBorder());
        this.jspRoot.setBottomComponent(preview);
        this.jspRoot.setTopComponent(this.jspData);
        this.jspData.setLeftComponent(new JScrollPane(this.jlsMappings));
        this.jspData.setRightComponent(editor);
        this.jspData.setOrientation(1);
        this.jspData.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)tools, "North");
        this.add((Component)this.jspRoot, "Center");
    }

    private void configureButton(JButton button) {
        button.setAlignmentY(0.5f);
        button.setBorderPainted(!BasicUtilities.isMac());
        button.setFocusPainted(false);
        button.addActionListener(this);
        button.addMouseListener(this);
    }

    private String pluginDescriptionForName(String name) {
        for (ImportPlugin next : this.plugins) {
            if (!next.getName().equalsIgnoreCase(name)) continue;
            return next.getDescription();
        }
        return null;
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        ImportEditor.UI_CONSTRAINT.gridx = x;
        ImportEditor.UI_CONSTRAINT.gridy = y;
        ImportEditor.UI_CONSTRAINT.gridwidth = w;
        ImportEditor.UI_CONSTRAINT.gridheight = h;
        ImportEditor.UI_CONSTRAINT.weightx = wx;
        ImportEditor.UI_CONSTRAINT.weighty = wy;
        ImportEditor.UI_CONSTRAINT.anchor = a;
        ImportEditor.UI_CONSTRAINT.fill = f;
    }

    private static class ColumnMapRenderer
    extends DefaultListCellRenderer {
        private HashMap columnInfo = new HashMap();
        private ImportConfig config = null;

        private ColumnMapRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList lst, Object val, int idx, boolean sel, boolean foc) {
            String[] p = new String[]{(String)val, (String)this.columnInfo.get(val)};
            String txtvalue = BasicUtilities.getString("Import_ColumnList_Label", p);
            super.getListCellRendererComponent((JList<?>)lst, txtvalue, idx, sel, foc);
            this.setIcon(BasicUtilities.loadIconResource("Table16"));
            if (this.config.containsKey(p[0])) {
                this.setFont(lst.getFont().deriveFont(10.0f));
            } else {
                this.setFont(lst.getFont().deriveFont(1, 10.0f));
            }
            return this;
        }
    }
}

