/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class JConsole
extends JComponent
implements AdjustmentListener,
PreferenceChangeListener {
    public static final String CATEGORY_SYSTEM_OUT = "system";
    public static final String CATEGORY_SYSTEM_ERR = "err";
    public static final String CATEGORY_DRIVER_MANAGER = BasicUtilities.getString("Driver_Manager_Category");
    public static final String CATEGORY_SCRIPT_DEBUG = BasicUtilities.getString("Script_Debug_Category");
    private static final PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
    private static final PrintStream err = new PrintStream(new FileOutputStream(FileDescriptor.err));
    private OutputStream os = new ConsoleOutputStream(this, "system");
    private JTextPane console = new JTextPane();
    private JScrollPane container = new JScrollPane(this.console);
    private String TSPattern = null;
    private SimpleDateFormat sdf = null;
    private Color clrDriverCat = null;
    private Color clrSystemCat = null;
    private Color clrErrorCat = null;
    private String defaultText = null;
    private UserPreferences prefs = null;
    private boolean autoScroll = true;

    public JConsole() {
        this("");
    }

    public JConsole(String defaultText) {
        this.defaultText = defaultText;
        this.setLayout(new BorderLayout());
        this.add((Component)this.container, "Center");
        this.console.setEditable(false);
        this.console.getCaret().setBlinkRate(0);
        BasicUtilities.localizeTextComponent(this.console, null);
        this.container.setHorizontalScrollBarPolicy(31);
        this.container.setVerticalScrollBarPolicy(22);
        this.container.getVerticalScrollBar().addAdjustmentListener(this);
    }

    public synchronized void configure(UserPreferences config) {
        this.registerPropertyListening(config);
        this.prefs = config;
        this.TSPattern = config.get("console.timestamp-format");
        if (this.TSPattern.trim().length() >= 1) {
            this.sdf = new SimpleDateFormat(this.TSPattern);
        } else {
            this.sdf = null;
            this.TSPattern = null;
        }
        this.clrDriverCat = config.getColor("console.sql-color");
        this.clrSystemCat = config.getColor("console.sys-color");
        this.clrErrorCat = config.getColor("console.err-color");
        this.setForeground(config.getColor("console.foreground-color"));
        this.setBackground(config.getColor("console.background-color"));
        this.setFont(config.getFont("console.font"));
        this.setText(this.defaultText);
    }

    public Document getDocument() {
        return this.console.getDocument();
    }

    public String getText() {
        return this.console.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String category, String s) {
        Document doc;
        SimpleAttributeSet sas = new SimpleAttributeSet();
        if (s == null) {
            return;
        }
        if (s.trim().length() == 0) {
            return;
        }
        Document document = doc = this.getDocument();
        synchronized (document) {
            if (category == null) {
                category = CATEGORY_SYSTEM_OUT;
            }
            StyleConstants.setFontFamily(sas, this.getFont().getFamily());
            StyleConstants.setFontSize(sas, this.getFont().getSize());
            StyleConstants.setBold(sas, this.getFont().isBold());
            StyleConstants.setItalic(sas, this.getFont().isItalic());
            StyleConstants.setBackground(sas, this.getBackground());
            if (this.TSPattern != null && this.sdf != null && !s.equalsIgnoreCase(this.defaultText)) {
                String ts = this.sdf.format(new Date());
                StyleConstants.setForeground(sas, this.getForeground());
                ts = ts.concat(" ");
                try {
                    doc.insertString(doc.getLength(), ts, sas);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (CATEGORY_DRIVER_MANAGER.equalsIgnoreCase(category) || CATEGORY_SCRIPT_DEBUG.equalsIgnoreCase(category)) {
                StyleConstants.setForeground(sas, this.clrDriverCat == null ? this.getForeground() : this.clrDriverCat);
            } else if (CATEGORY_SYSTEM_OUT.equalsIgnoreCase(category)) {
                StyleConstants.setForeground(sas, this.clrSystemCat == null ? this.getForeground() : this.clrSystemCat);
            } else if (CATEGORY_SYSTEM_ERR.equalsIgnoreCase(category)) {
                StyleConstants.setForeground(sas, this.clrErrorCat == null ? this.getForeground() : this.clrErrorCat);
            }
            try {
                doc.insertString(doc.getLength(), s, sas);
            }
            catch (Exception e) {
                BasicUtilities.HandleException((Throwable)e, "JConsole:append(String,String):insertString", false, err);
            }
        }
        if (this.autoScroll) {
            try {
                int length = doc.getLength();
                this.console.setCaretPosition(length);
                this.scrollRectToVisible(this.console.modelToView(length - 1));
            }
            catch (Exception e) {
                BasicUtilities.HandleException((Throwable)e, "JConsole:append(String,String):setCaretPosition", false, err);
            }
            JScrollBar vs = this.container.getVerticalScrollBar();
            vs.setValue(vs.getMaximum());
        }
        this.console.invalidate();
        this.repaint();
    }

    public void append(String s) {
        this.append(CATEGORY_SYSTEM_OUT, s);
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
            if (text.trim().length() == 0) {
                this.append(this.defaultText == null ? "" : this.defaultText);
            } else {
                this.append(text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OutputStream createFilteredStream(String category) {
        if (category != null) {
            return new ConsoleOutputStream(this, category);
        }
        return this.toOutputStream();
    }

    public OutputStream toOutputStream() {
        return this.os;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        if (event == null || this.prefs == null) {
            return;
        }
        String key = event.getKey();
        String val = event.getNewValue();
        if (key.equals("console.background-color")) {
            this.setBackground(Color.decode(val));
            this.syncDisplay();
        } else if (key.equals("console.foreground-color")) {
            this.setForeground(Color.decode(val));
            this.syncDisplay();
        } else if (key.equals("console.err-color")) {
            this.clrErrorCat = Color.decode(val);
        } else if (key.equals("console.font")) {
            this.setFont(StringUtilities.parseFontString(val));
            this.syncDisplay();
        } else if (key.equals("console.sql-color")) {
            this.clrDriverCat = Color.decode(val);
        } else if (key.equals("console.sys-color")) {
            this.clrSystemCat = Color.decode(val);
        } else if (key.equals("console.timestamp-format")) {
            this.TSPattern = val;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.autoScroll = !e.getValueIsAdjusting();
    }

    private void registerPropertyListening(UserPreferences p) {
        if (p == null) {
            return;
        }
        if (this.prefs != null && p != this.prefs) {
            this.prefs.removePreferenceChangeListener(this);
        } else if (p == this.prefs && this.prefs != null) {
            return;
        }
        p.addPreferenceChangeListener(this);
    }

    private void syncDisplay() {
        StyledDocument doc = (StyledDocument)this.getDocument();
        SimpleAttributeSet sas = new SimpleAttributeSet();
        StyleConstants.setFontFamily(sas, this.getFont().getFamily());
        StyleConstants.setFontSize(sas, this.getFont().getSize());
        StyleConstants.setBold(sas, this.getFont().isBold());
        StyleConstants.setItalic(sas, this.getFont().isItalic());
        StyleConstants.setBackground(sas, this.getBackground());
        doc.setCharacterAttributes(0, doc.getLength(), sas, true);
    }

    private static class Appender
    implements Runnable {
        JConsole textView = null;
        String category = null;
        String line = null;

        public Appender(JConsole console, String category, String line) {
            this.textView = console;
            this.category = category;
            this.line = line;
        }

        @Override
        public void run() {
            try {
                this.textView.append(this.category, this.line);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ConsoleOutputStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private String category = null;
        private JConsole reference;

        public ConsoleOutputStream(JConsole owner, String category) {
            this.reference = owner;
            this.category = category != null ? category : JConsole.CATEGORY_SYSTEM_OUT;
        }

        public boolean isSystemStream() {
            return JConsole.CATEGORY_SYSTEM_ERR.equalsIgnoreCase(this.category) || JConsole.CATEGORY_SYSTEM_OUT.equalsIgnoreCase(this.category);
        }

        @Override
        public synchronized void write(int b) {
            this.buf.append(Character.toString((char)b));
        }

        @Override
        public synchronized void write(byte[] b, int offset, int length) {
            this.buf.append(new String(b, offset, length));
        }

        @Override
        public synchronized void write(byte[] b) {
            this.buf.append(new String(b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                char last;
                if (this.buf.length() > 0 && ((last = this.buf.charAt(this.buf.length() - 1)) == '\n' || last == '\r')) {
                    if (Boolean.getBoolean("isql.debug.threads")) {
                        this.buf.insert(0, "] ");
                        this.buf.insert(0, Thread.currentThread().getName());
                        this.buf.insert(0, "[");
                    }
                    if (!this.isSystemStream()) {
                        if (this.category.trim().length() >= 1) {
                            this.buf.insert(0, "> ");
                            this.buf.insert(0, this.category);
                            this.buf.insert(0, "<");
                        }
                    } else if (Boolean.getBoolean("isql.debug")) {
                        if (JConsole.CATEGORY_SYSTEM_ERR.equalsIgnoreCase(this.category)) {
                            err.println(this.buf.toString().trim());
                        } else {
                            out.println(this.buf.toString().trim());
                        }
                    }
                    String text = this.buf.toString();
                    SwingUtilities.invokeLater(new Appender(this.reference, this.category, text));
                    this.buf.setLength(0);
                }
            }
        }
    }
}

