/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.isqlviewer.core.model.MetadataTreeModel;
import org.isqlviewer.util.BasicUtilities;

public class JDBCTreeCellRenderer
extends DefaultTreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean foc) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, foc);
        this.setText(value.toString());
        MetadataTreeModel mdl = (MetadataTreeModel)tree.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        int depth = node.getLevel();
        switch (depth) {
            case 0: {
                this.setIcon(BasicUtilities.loadIconResource("Database16"));
                break;
            }
            case 1: {
                if (leaf) {
                    this.setIcon(BasicUtilities.loadIconResource("Information16"));
                    break;
                }
                this.setIcon(BasicUtilities.loadIconResource("Query16"));
                break;
            }
            case 2: {
                DefaultMutableTreeNode type = (DefaultMutableTreeNode)node.getPath()[1];
                if (!leaf || mdl.isTableTypeNode(type)) {
                    if (mdl.isProcedureNode(type)) {
                        this.setIcon(BasicUtilities.loadIconResource("Script16"));
                        break;
                    }
                    this.setIcon(BasicUtilities.loadIconResource("Table16"));
                    break;
                }
                this.setIcon(BasicUtilities.loadIconResource("TableInfo16"));
                break;
            }
            case 3: {
                if (leaf) {
                    DefaultMutableTreeNode prev = (DefaultMutableTreeNode)node.getPath()[1];
                    if (mdl.isProcedureNode(prev)) {
                        this.setIcon(BasicUtilities.loadIconResource("TableColumns16"));
                        break;
                    }
                    this.setIcon(BasicUtilities.loadIconResource("TableInfo16"));
                    break;
                }
                this.setIcon(BasicUtilities.loadIconResource("TableColumns16"));
                break;
            }
            case 4: {
                this.setIcon(BasicUtilities.loadIconResource("TableInfo16"));
                break;
            }
        }
        return this;
    }
}

