/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public class JFileList
extends JPanel
implements ActionListener,
DropTargetListener {
    private DefaultListModel mdlPaths = new DefaultListModel();
    private JList lstPaths = new JList();
    private JScrollPane jspPaths = new JScrollPane(this.lstPaths);
    private JButton btnAddPath = new JButton(BasicUtilities.loadIconResource("Add16"));
    private JButton btnRemovePath = new JButton(BasicUtilities.loadIconResource("Delete16"));
    private Vector filters = new Vector();
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private JToolBar jtbPathTools = new JToolBar(1);
    boolean isPathModified = false;

    public JFileList() {
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ServiceResourceEditor::initUI()");
        }
    }

    public void setResources(URL[] urls) {
        this.mdlPaths.clear();
        this.isPathModified = false;
        if (urls == null) {
            return;
        }
        for (int i = 0; i < urls.length; ++i) {
            this.addURL(urls[i], false);
        }
        if (this.isPathModified) {
            this.fireStateChanged(this.changeEvent);
        }
    }

    public URL[] getResources() {
        if (!this.mdlPaths.isEmpty()) {
            URL[] urls = new URL[this.mdlPaths.size()];
            for (int i = 0; i < urls.length; ++i) {
                try {
                    urls[i] = ((File)this.mdlPaths.get(i)).toURL();
                    continue;
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
            }
            return urls;
        }
        return new URL[0];
    }

    public File[] getFiles() {
        if (!this.mdlPaths.isEmpty()) {
            File[] f = new File[this.mdlPaths.size()];
            for (int i = 0; i < f.length; ++i) {
                f[i] = (File)this.mdlPaths.get(i);
            }
            return f;
        }
        return new File[0];
    }

    public void setPathString(String path) {
        this.mdlPaths.clear();
        this.isPathModified = false;
        if (path == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator, false, true);
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            File file = new File(element);
            this.addFile(file, false);
        }
        if (this.isPathModified) {
            this.fireStateChanged(this.changeEvent);
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    public String toPathString() {
        File[] f = this.getFiles();
        StringBuffer buff = new StringBuffer("");
        if (f != null) {
            for (int i = 0; i < f.length; ++i) {
                buff.append(f[i].getAbsolutePath());
                buff.append(File.pathSeparator);
            }
        }
        return buff.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        boolean notify = false;
        if (src.equals(this.btnAddPath)) {
            File[] f = BasicUtilities.getSystemFiles(this, 2);
            if (f != null) {
                for (int i = 0; i < f.length; ++i) {
                    File file = f[i];
                    if (!this.checkFile(file)) continue;
                    try {
                        this.addFile(file, false);
                        notify = true;
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        } else if (src.equals(this.btnRemovePath)) {
            int[] idxs = this.lstPaths.getSelectedIndices();
            try {
                for (int i = idxs.length - 1; i >= 0; --i) {
                    int index = idxs[i];
                    this.mdlPaths.removeElementAt(index);
                    notify = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (notify) {
            this.fireStateChanged(this.changeEvent);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tx = dtde.getTransferable();
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                dtde.acceptDrop(dtde.getDropAction());
                Object txData = tx.getTransferData(DataFlavor.javaFileListFlavor);
                if (!(txData instanceof List)) {
                    BasicUtilities.beep();
                    dtde.rejectDrop();
                    return;
                }
                List lst = (List)txData;
                Iterator itr = lst.iterator();
                boolean notify = false;
                while (itr.hasNext()) {
                    Object next = itr.next();
                    if (next instanceof File) {
                        File f = (File)next;
                        try {
                            if (!this.checkFile(f)) continue;
                            this.addFile(f, false);
                            notify = true;
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    BasicUtilities.beep();
                    dtde.rejectDrop();
                    return;
                }
                dtde.dropComplete(true);
                if (notify) {
                    this.fireStateChanged(this.changeEvent);
                }
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                dtde.rejectDrop();
                BasicUtilities.HandleException(t);
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public boolean addFileFilter(FilenameFilter fnf) {
        if (this.filters.add(fnf)) {
            this.fireStateChanged(this.changeEvent);
            return true;
        }
        return false;
    }

    public void addFile(File f) {
        this.addFile(f, true);
    }

    public void addURL(URL url) {
        this.addURL(url, true);
    }

    public void setPath(String path) {
        this.mdlPaths.clear();
        if (path == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator, false);
        while (st.hasMoreTokens()) {
            this.addFile(new File(st.nextToken()));
        }
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void removeFilter(int index) {
        try {
            this.filters.remove(index);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean removeFilter(FilenameFilter fnf) {
        return this.filters.remove(fnf);
    }

    protected void fireStateChanged(ChangeEvent e) {
        EventListener[] listeners = this.listenerList.getListeners(ChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ((ChangeListener)listeners[i]).stateChanged(e);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected boolean checkFile(File f) {
        if (f == null || !f.exists()) {
            return false;
        }
        for (FilenameFilter fnf : this.filters) {
            if (fnf.accept(f.getParentFile(), f.getName())) continue;
            return false;
        }
        return true;
    }

    protected void addURL(URL url, boolean fire) {
        try {
            this.addFile(new File(url.getFile()), fire);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void addFile(File f, boolean fire) {
        if (this.checkFile(f)) {
            try {
                this.mdlPaths.addElement(f);
                this.isPathModified = true;
                if (fire) {
                    this.fireStateChanged(this.changeEvent);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout(2, 2));
        this.mdlPaths = new DefaultListModel();
        this.lstPaths.setModel(this.mdlPaths);
        this.btnAddPath.addActionListener(this);
        this.btnRemovePath.addActionListener(this);
        this.jtbPathTools.setFloatable(false);
        this.jtbPathTools.add(this.btnAddPath);
        this.jtbPathTools.add(this.btnRemovePath);
        this.jspPaths.setRowHeaderView(this.jtbPathTools);
        this.btnAddPath.setToolTipText(BasicUtilities.getString("Path_Add_Tip"));
        this.btnRemovePath.setToolTipText(BasicUtilities.getString("Path_Del_Tip"));
        this.lstPaths.setToolTipText(BasicUtilities.getString("Path_List_Tip"));
        this.lstPaths.setSelectionMode(2);
        this.lstPaths.setDropTarget(new DropTarget(this.lstPaths, this));
        this.add((Component)this.jspPaths, "Center");
    }

    @Override
    public void setToolTipText(String text) {
        this.lstPaths.setToolTipText(text);
    }

    public static class DirectoryFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            if (dir == null || name == null) {
                return false;
            }
            name = name.toLowerCase();
            boolean isDir = new File(dir, name).isDirectory();
            return dir.canRead() && isDir;
        }
    }

    public static class ClasspathFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            if (dir == null || name == null) {
                return false;
            }
            name = name.toLowerCase();
            boolean isDir = new File(dir, name).isDirectory();
            return dir.canRead() && (isDir || name.endsWith(".jar") || name.endsWith(".zip"));
        }
    }
}

