/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.isqlviewer.util.BasicUtilities;

public class JFontChoser
extends JComponent {
    private Font[] fnts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    private Integer[] Sizes = new Integer[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(14), new Integer(16), new Integer(18), new Integer(20), new Integer(22), new Integer(24), new Integer(26), new Integer(28), new Integer(36)};
    private JTextField txtExampleArea = new JTextField("abcdefghijk ABCDEFGHIJK");
    private DefaultListModel fontNames = new DefaultListModel();
    private DefaultListModel fontStyles = new DefaultListModel();
    private DefaultListModel fontSizes = new DefaultListModel();
    private int styleFontOffset = -1;
    private JDialog dialog = null;
    private ListSelectionHandler listSelectionHandler = new ListSelectionHandler();
    private JList lstFontNames = new JList(this.fontNames);
    private JList lstFontSizes = new JList(this.fontSizes);
    private JList lstFontStyle = new JList(this.fontStyles);
    private JButton btnOK = new JButton("OK");
    private JButton btnCancel = new JButton("Cancel");
    private JLabel lblPreview = new JLabel("Preview :");
    private boolean wasCancelled = true;
    private Font originalSelection = null;

    public JFontChoser() {
        this.initUI();
        this.setSelectedFont(null);
    }

    public Font getSelectedFont() {
        String family = (String)this.lstFontNames.getSelectedValue();
        Integer size = (Integer)this.lstFontSizes.getSelectedValue();
        if (this.styleFontOffset != -1) {
            return this.fnts[this.styleFontOffset + this.lstFontStyle.getSelectedIndex()].deriveFont(size.floatValue());
        }
        return new Font(family, 0, size);
    }

    public void setSelectedFont(Font fnt) {
        if (fnt == null) {
            fnt = new Font("Default", 0, 12);
        }
        this.originalSelection = fnt;
        int idx = this.fontNames.indexOf(fnt.getFamily());
        if (idx < 0) {
            idx = 0;
        }
        String styleName = null;
        try {
            styleName = fnt.getName().substring(fnt.getFamily().length());
            if (styleName.length() == 0) {
                styleName = "Plain";
            }
        }
        catch (Exception e) {
            styleName = "Plain";
        }
        try {
            this.lstFontNames.setSelectedIndex(idx);
            this.lstFontNames.ensureIndexIsVisible(idx);
            styleName = styleName.trim();
            idx = this.fontStyles.indexOf(styleName);
            if (idx < 0) {
                idx = 0;
            }
            this.lstFontStyle.setSelectedIndex(idx);
            this.lstFontNames.ensureIndexIsVisible(idx);
            Integer size = new Integer(fnt.getSize());
            idx = this.fontSizes.indexOf(size);
            if (idx < 0) {
                idx = 0;
            }
            this.lstFontSizes.setSelectedIndex(idx);
            this.lstFontNames.ensureIndexIsVisible(idx);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Font showDialog(Component component, String title, Font initialFont) {
        this.setSelectedFont(initialFont);
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
        this.dialog = new JDialog(frame, title, true);
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(component);
        this.dialog.show();
        if (this.wasCancelled) {
            return this.originalSelection;
        }
        return this.getSelectedFont();
    }

    private void initUI() {
        int i;
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i = 0; i < fonts.length; ++i) {
            this.fontNames.addElement(fonts[i]);
        }
        for (i = 0; i < this.Sizes.length; ++i) {
            this.fontSizes.addElement(this.Sizes[i]);
        }
        this.setLayout(new GridBagLayout());
        Insets ins = new Insets(2, 2, 2, 2);
        this.lstFontNames.addListSelectionListener(this.listSelectionHandler);
        this.lstFontStyle.addListSelectionListener(this.listSelectionHandler);
        this.lstFontSizes.addListSelectionListener(this.listSelectionHandler);
        this.btnOK.addActionListener(this.listSelectionHandler);
        this.btnCancel.addActionListener(this.listSelectionHandler);
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.lstFontNames);
        this.lstFontNames.setPrototypeCellValue("XXXXXXXXXXXXXXXXXXX");
        this.add((Component)new JLabel("Font Name :"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)jsp, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.75, 17, 1, ins, 0, 0));
        jsp = new JScrollPane();
        jsp.setViewportView(this.lstFontStyle);
        this.lstFontStyle.setPrototypeCellValue("XXXXXXXXXXXXXXXXXXXXXXXX");
        this.add((Component)new JLabel("Font Styles :"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)jsp, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.75, 17, 1, ins, 0, 0));
        jsp = new JScrollPane();
        jsp.setViewportView(this.lstFontSizes);
        this.lstFontSizes.setPrototypeCellValue("XX");
        this.add((Component)new JLabel("Font Size :"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)jsp, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.75, 17, 1, ins, 0, 0));
        jsp = new JScrollPane();
        jsp.setViewportView(this.txtExampleArea);
        jsp.setPreferredSize(new Dimension(jsp.getPreferredSize().width, 64));
        BasicUtilities.lockComponentToPerferredSize(jsp);
        this.add((Component)this.lblPreview, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)jsp, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.25, 17, 2, ins, 0, 0));
        JPanel btnPanel = new JPanel();
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(this.btnOK);
        btnPanel.add(this.btnCancel);
        this.add((Component)btnPanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 13, 2, ins, 0, 0));
    }

    private void loadStyles(String fntFamily) {
        this.fontStyles.clear();
        for (int i = 0; i < this.fnts.length; ++i) {
            if (!this.fnts[i].getFamily().equals(fntFamily)) continue;
            if (this.fontStyles.isEmpty()) {
                this.styleFontOffset = i;
            }
            this.fontStyles.addElement(this.fnts[i].getName());
        }
        if (this.fontStyles.isEmpty()) {
            this.fontStyles.addElement("Plain");
            this.styleFontOffset = -1;
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    ActionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == JFontChoser.this.btnOK) {
                JFontChoser.this.wasCancelled = false;
            }
            if (JFontChoser.this.dialog != null) {
                JFontChoser.this.dialog.dispose();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            Object src = evt.getSource();
            Font currentFont = JFontChoser.this.txtExampleArea.getFont();
            String family = (String)JFontChoser.this.lstFontNames.getSelectedValue();
            Integer size = (Integer)JFontChoser.this.lstFontSizes.getSelectedValue();
            if (size == null) {
                size = (Integer)JFontChoser.this.fontSizes.get(0);
            }
            if (src == JFontChoser.this.lstFontNames) {
                JFontChoser.this.loadStyles(family);
            } else if (src == JFontChoser.this.lstFontStyle) {
                if (JFontChoser.this.styleFontOffset != -1) {
                    currentFont = JFontChoser.this.fnts[JFontChoser.this.styleFontOffset + JFontChoser.this.lstFontStyle.getSelectedIndex()];
                    currentFont = currentFont.deriveFont(size.floatValue());
                } else {
                    currentFont = new Font(family, 0, size);
                }
            } else if (src == JFontChoser.this.lstFontSizes) {
                currentFont = currentFont.deriveFont(size.floatValue());
            }
            JFontChoser.this.txtExampleArea.setFont(currentFont);
            JFontChoser.this.lblPreview.setText("Preview : " + currentFont.getFontName());
        }
    }
}

