/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.isqlviewer.util.BasicUtilities;

public final class JListUISupport {
    public static void install(JList jList) {
        JListUISupport.install(jList, true);
    }

    public static void install(JList jList, boolean addKeySupport) {
        if (jList == null || !(jList.getModel() instanceof DefaultListModel)) {
            throw new NullPointerException();
        }
        Im support = new Im(jList, addKeySupport);
        jList.putClientProperty(JListUISupport.class, support);
    }

    public static void uninstall(JList jList) {
        Im support = (Im)jList.getClientProperty(JListUISupport.class);
        if (support == null) {
            return;
        }
        jList.setDropTarget(null);
        support.dndDragSource.removeDragSourceListener(support);
        jList.removeKeyListener(support);
        jList.putClientProperty(JListUISupport.class, null);
    }

    private JListUISupport() {
    }

    private static class Im
    extends DropTargetAdapter
    implements KeyListener,
    DragSourceListener,
    DragGestureListener {
        private Point pt = new Point(2, 2);
        private JList list = null;
        private int dragIndex = -1;
        private DragSource dndDragSource = DragSource.getDefaultDragSource();

        public Im(JList list, boolean addKeySupport) {
            this.list = list;
            DropTarget dt = new DropTarget(list, this);
            list.setDropTarget(dt);
            this.dndDragSource.createDefaultDragGestureRecognizer(list, 3, this);
            if (addKeySupport) {
                list.addKeyListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Transferable transferable = event.getTransferable();
                int index = this.list.locationToIndex(event.getLocation());
                if (this.dragIndex == index) {
                    return;
                }
                DefaultListModel mdl = (DefaultListModel)this.list.getModel();
                switch (event.getSourceActions()) {
                    case 2: 
                    case 3: {
                        Object o = null;
                        if (event.isLocalTransfer()) {
                            o = mdl.remove(this.dragIndex);
                        } else {
                            Object compatible = mdl.get(this.dragIndex);
                            DataFlavor[] flavors = transferable.getTransferDataFlavors();
                            for (int i = 0; i < flavors.length; ++i) {
                                Object data = transferable.getTransferData(flavors[i]);
                                if (!data.getClass().isInstance(compatible)) continue;
                                o = data;
                                break;
                            }
                            if (o == null) {
                                event.rejectDrop();
                                return;
                            }
                        }
                        mdl.add(index, o);
                        this.list.setSelectedIndex(index);
                        return;
                    }
                    case 1: {
                        return;
                    }
                    default: {
                        BasicUtilities.beep();
                        event.rejectDrop();
                        return;
                    }
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                event.rejectDrop();
                return;
            }
            finally {
                event.dropComplete(true);
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            DragGestureRecognizer dndRecognizer = event.getSourceAsDragGestureRecognizer();
            try {
                int index;
                this.dragIndex = index = this.list.locationToIndex(event.getDragOrigin());
                DefaultListModel mdl = (DefaultListModel)this.list.getModel();
                if (mdl.getSize() <= 1 || !this.list.getCellBounds(index, index).contains(event.getDragOrigin())) {
                    dndRecognizer.resetRecognizer();
                    return;
                }
                Transferable data = (Transferable)mdl.get(index);
                if (DragSource.isDragImageSupported()) {
                    GraphicsConfiguration gConfig = this.list.getGraphicsConfiguration();
                    Component comp = this.list.getCellRenderer().getListCellRendererComponent(this.list, data, index, false, true);
                    Dimension dim = comp.getPreferredSize();
                    comp.setSize(dim);
                    BufferedImage bi = gConfig.createCompatibleImage(dim.width, dim.height);
                    Graphics2D g2 = bi.createGraphics();
                    comp.paint(g2);
                    g2.setColor(BasicUtilities.DND_HAZE);
                    g2.fillRect(0, 0, dim.width, dim.height);
                    this.dndDragSource.startDrag(event, null, bi, this.pt, data, this);
                } else {
                    this.dndDragSource.startDrag(event, null, null, this.pt, data, this);
                }
            }
            catch (Throwable t) {
                dndRecognizer.resetRecognizer();
                BasicUtilities.beep();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent event) {
        }

        @Override
        public void dragExit(DragSourceEvent event) {
        }

        @Override
        public void dragOver(DragSourceDragEvent event) {
            int index = this.list.locationToIndex(event.getLocation());
            Rectangle rect = this.list.getCellBounds(Math.max(0, index - 1), Math.min(index + 1, this.list.getModel().getSize() - 1));
            this.list.scrollRectToVisible(rect);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent event) {
        }

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 8: 
                case 127: {
                    DefaultListModel mdl = (DefaultListModel)this.list.getModel();
                    int[] selected = this.list.getSelectedIndices();
                    for (int i = selected.length - 1; i >= 0; --i) {
                        mdl.remove(selected[i]);
                    }
                    if (selected.length < 1) break;
                    if (selected[0] <= mdl.getSize() - 1) {
                        this.list.setSelectedIndex(selected[0]);
                    } else {
                        this.list.clearSelection();
                    }
                    event.consume();
                    break;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

