/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JNumberEditor
extends JTextField
implements ComboBoxEditor,
TableCellEditor {
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.getDefault());

    public JNumberEditor() {
        this(0, 10);
    }

    public JNumberEditor(int value) {
        this(value, 10);
    }

    public JNumberEditor(int value, int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(value);
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = Integer.parseInt(this.getText());
        }
        catch (Exception e) {
            toolkit.beep();
        }
        return retVal;
    }

    public void setValue(int value) {
        try {
            this.setText(this.integerFormatter.format(value));
        }
        catch (Exception e) {
            this.setText("0");
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public void setItem(Object anObject) {
        this.setValue(Integer.parseInt(anObject.toString()));
    }

    @Override
    public Object getItem() {
        return "" + this.getValue();
    }

    @Override
    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public Object getCellEditorValue() {
        return new Integer(this.getValue());
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        return false;
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

