/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class JTextPopup
extends JPopupMenu
implements MouseListener,
ActionListener {
    private JMenuItem pu_cut = new JMenuItem(BasicUtilities.getString("Cut"));
    private JMenuItem pu_copy = new JMenuItem(BasicUtilities.getString("Copy"));
    private JMenuItem pu_paste = new JMenuItem(BasicUtilities.getString("Paste"));
    private JMenuItem pu_clear = new JMenuItem(BasicUtilities.getString("Clear_All"));
    private JMenuItem pu_save = new JMenuItem(BasicUtilities.getString("Save_To_File"));
    private JMenuItem pu_selectAll = new JMenuItem(BasicUtilities.getString("Select_All"));
    private JMenuItem mnuDecodeUnicode = new JMenuItem(BasicUtilities.getString("Decode_UNICODE_Seq"));
    private JMenuItem mnuEncodeUnicode = new JMenuItem(BasicUtilities.getString("Encode_UNICODE_Seq"));
    private JMenuItem mnuBase64Encode = new JMenuItem(BasicUtilities.getString("Encode_Base64"));
    private JMenuItem mnuBase64Decode = new JMenuItem(BasicUtilities.getString("Decode_Base64"));
    private JMenuItem mnuLong2Date = new JMenuItem(BasicUtilities.getString("Convert_Milliseconds_To_Date"));
    private JMenuItem mnuDate2Long = new JMenuItem(BasicUtilities.getString("Convert_Date_To_Milliseconds"));
    private JTextComponent console;
    private SimpleDateFormat sdf = new SimpleDateFormat("");

    public JTextPopup() {
        this.add(this.pu_cut);
        this.add(this.pu_copy);
        this.add(this.pu_paste);
        this.add(this.pu_save);
        this.addSeparator();
        JMenu tools = new JMenu(BasicUtilities.getString("Text_Tools"));
        tools.add(this.mnuBase64Decode);
        tools.add(this.mnuBase64Encode);
        tools.add(this.mnuDecodeUnicode);
        tools.add(this.mnuEncodeUnicode);
        tools.add(this.mnuDate2Long);
        tools.add(this.mnuLong2Date);
        this.add(tools);
        this.add(this.pu_clear);
        this.add(this.pu_selectAll);
        if (!BasicUtilities.isMac()) {
            this.pu_selectAll.setIcon(BasicUtilities.loadIconResource("Spacer16"));
            this.pu_cut.setIcon(BasicUtilities.loadIconResource("Cut16"));
            this.pu_copy.setIcon(BasicUtilities.loadIconResource("Copy16"));
            this.pu_paste.setIcon(BasicUtilities.loadIconResource("Paste16"));
            this.pu_clear.setIcon(BasicUtilities.loadIconResource("Spacer16"));
            this.pu_save.setIcon(BasicUtilities.loadIconResource("Save16"));
            tools.setIcon(BasicUtilities.loadIconResource("Spacer16"));
        }
        this.pu_paste.setAccelerator(BasicUtilities.createKeyStroke(86, BasicUtilities.CMD_MASK));
        this.pu_copy.setAccelerator(BasicUtilities.createKeyStroke(67, BasicUtilities.CMD_MASK));
        this.pu_selectAll.setAccelerator(BasicUtilities.createKeyStroke(65, BasicUtilities.CMD_MASK));
        this.pu_cut.setAccelerator(BasicUtilities.createKeyStroke(88, BasicUtilities.CMD_MASK));
        this.pu_selectAll.addActionListener(this);
        this.pu_cut.addActionListener(this);
        this.pu_copy.addActionListener(this);
        this.pu_paste.addActionListener(this);
        this.pu_clear.addActionListener(this);
        this.pu_save.addActionListener(this);
        this.mnuBase64Decode.addActionListener(this);
        this.mnuBase64Encode.addActionListener(this);
        this.mnuDecodeUnicode.addActionListener(this);
        this.mnuEncodeUnicode.addActionListener(this);
        this.mnuDate2Long.addActionListener(this);
        this.mnuLong2Date.addActionListener(this);
    }

    public final JMenu toJMenu() {
        JMenu r = new JMenu(BasicUtilities.getString("Edit"));
        r.add(this.pu_cut);
        r.add(this.pu_copy);
        r.add(this.pu_paste);
        r.add(this.pu_save);
        r.addSeparator();
        JMenu tools = new JMenu(BasicUtilities.getString("Text_Tools"));
        tools.add(this.mnuBase64Decode);
        tools.add(this.mnuBase64Encode);
        tools.add(this.mnuDecodeUnicode);
        tools.add(this.mnuEncodeUnicode);
        this.add(tools);
        r.add(this.pu_clear);
        r.add(this.pu_selectAll);
        return r;
    }

    public final void removeJTextComponent(JTextComponent jtc) {
        this.console = null;
        jtc.removeMouseListener(this);
    }

    public final void addJTextComponent(JTextComponent jtc) {
        this.addJTextComponent(jtc, true);
    }

    public final void addJTextComponent(JTextComponent jtc, boolean f) {
        this.console = jtc;
        if (f) {
            jtc.addMouseListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JMenuItem src = (JMenuItem)ae.getSource();
        if (this.console == null) {
            return;
        }
        boolean selection = true;
        boolean shiftMod = (ae.getModifiers() & 1) != 1;
        String text = this.console.getSelectedText();
        if (text == null) {
            text = this.console.getText();
            selection = false;
        }
        if (src == this.pu_copy) {
            this.console.copy();
        } else if (src == this.pu_paste) {
            this.console.paste();
        } else if (src == this.pu_selectAll) {
            this.console.selectAll();
        } else if (src == this.pu_cut) {
            this.console.copy();
            if (this.console.isEditable()) {
                this.console.cut();
            }
        } else if (src == this.mnuBase64Encode) {
            try {
                text = new Base64Encoder(text, shiftMod).processString();
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (selection) {
                    this.console.replaceSelection(text);
                } else {
                    this.console.setText(text);
                }
            } else {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection(text);
                cb.setContents(ss, ss);
                System.out.println(BasicUtilities.getString("Encoding_To_Clipboard"));
            }
        } else if (src == this.mnuBase64Decode) {
            try {
                text = new Base64Decoder(text, shiftMod).processString();
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (selection) {
                    this.console.replaceSelection(text);
                } else {
                    this.console.setText(text);
                }
            } else {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection(text);
                cb.setContents(ss, ss);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (src == this.mnuEncodeUnicode) {
            text = StringUtilities.decode(text);
            if (this.console.isEditable()) {
                if (selection) {
                    this.console.replaceSelection(text);
                } else {
                    this.console.setText(text);
                }
            } else {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection(text);
                cb.setContents(ss, ss);
                System.out.println(BasicUtilities.getString("Encoding_To_Clipboard"));
            }
        } else if (src == this.mnuDecodeUnicode) {
            text = StringUtilities.encode(text, false, false);
            if (this.console.isEditable()) {
                if (selection) {
                    this.console.replaceSelection(text);
                } else {
                    this.console.setText(text);
                }
            } else {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection(text);
                cb.setContents(ss, ss);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (src == this.mnuLong2Date) {
            this.sdf.applyPattern(SystemConfig.getInstance().getFormatForSQLType(93));
            try {
                text = this.sdf.format(new Date(Long.parseLong(text)));
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (selection) {
                    this.console.replaceSelection(text);
                } else {
                    this.console.setText(text);
                }
            } else {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection(text);
                cb.setContents(ss, ss);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (src == this.mnuDate2Long) {
            this.sdf.applyPattern(SystemConfig.getInstance().getFormatForSQLType(93));
            try {
                text = Long.toString(this.sdf.parse(text).getTime());
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                return;
            }
            if (this.console.isEditable()) {
                if (selection) {
                    this.console.replaceSelection(text);
                } else {
                    this.console.setText(text);
                }
            } else {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection ss = new StringSelection(text);
                cb.setContents(ss, ss);
                System.out.println(BasicUtilities.getString("Decoding_To_Clipboard"));
            }
        } else if (src == this.pu_clear) {
            if (this.console.isEnabled()) {
                this.console.setText("");
                this.console.setCaretPosition(0);
            }
        } else if (src == this.pu_save) {
            this.Save();
        }
    }

    protected synchronized void Save() {
        try {
            File f = BasicUtilities.saveSystemFile(this);
            if (f == null) {
                return;
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(this.console.getText().getBytes());
            fos.close();
            fos = null;
            Object var1_1 = null;
        }
        catch (Exception exception) {
        }
        finally {
            System.gc();
            System.runFinalization();
        }
    }

    @Override
    public void show(Component com, int x, int y) {
        if (com instanceof JTextComponent && com.isEnabled()) {
            this.console = (JTextComponent)com;
            this.pu_paste.setEnabled(this.console.isEditable());
            SwingUtilities.updateComponentTreeUI(this);
            super.show(com, x, y);
        } else {
            BasicUtilities.beep();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.doPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.doPopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.doPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean doPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.show(e.getComponent(), e.getX(), e.getY());
            e.consume();
            return true;
        }
        return false;
    }
}

