/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.isqlviewer.event.ProgressEvent;

public class ProgressListCellRenderer
extends JComponent
implements TableCellRenderer {
    JProgressBar progress = new JProgressBar(0, 0, 100);

    public ProgressListCellRenderer() {
        this.progress.setStringPainted(true);
        this.setLayout(new BorderLayout(4, 3));
        this.progress.setFont(new Font("Lucinda Sans", 1, 9));
        this.add(Box.createVerticalStrut(2), "South");
        this.add(Box.createVerticalStrut(2), "North");
        this.add(Box.createHorizontalStrut(2), "West");
        this.add(Box.createHorizontalStrut(2), "East");
        this.add((Component)this.progress, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            ProgressEvent e = (ProgressEvent)value;
            this.progress.setMaximum(e.getMaximum());
            this.progress.setValue(e.getProgress());
            if (e.getNote() != null && e.getNote().trim().length() >= 1) {
                this.progress.setString(e.getNote());
            }
            int i = Integer.parseInt(value.toString());
            if (this.progress.getValue() != i) {
                this.progress.setValue(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }
}

