/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.util.BasicUtilities;

public class ProgressPanel
extends JPanel
implements ProgressListener,
ActionListener {
    private JConsole console = new JConsole("");
    protected final Insets insDefault = new Insets(1, 2, 2, 1);
    private NumberFormat pf = NumberFormat.getPercentInstance();
    private JLabel lblProgressNote = new JLabel();
    private JButton btnCancel = new JButton();
    private JProgressBar jpbProgressMeter = new JProgressBar(0);
    private PrintStream filterOut = null;
    private PrintStream filterErr = null;
    private final ActionEvent EVENT = new ActionEvent(this, 0, null);
    private transient ArrayList listeners = null;

    public ProgressPanel() {
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ProgressPanel::initUI()", true);
        }
    }

    public PrintStream getOutStream() {
        return this.filterOut;
    }

    public PrintStream getErrStream() {
        return this.filterErr;
    }

    @Override
    public void progressUpdated(ProgressEvent pe) {
        this.jpbProgressMeter.setMaximum(pe.getMaximum());
        if (pe.getProgress() < 0) {
            this.jpbProgressMeter.setIndeterminate(true);
        } else {
            this.jpbProgressMeter.setIndeterminate(false);
            this.jpbProgressMeter.setValue(pe.getProgress());
        }
        if (pe.getNote() == null || pe.getNote().trim().length() == 0) {
            String ps = this.pf.format((double)pe.getProgress() / (double)pe.getMaximum());
            this.lblProgressNote.setText(BasicUtilities.getString("Percent_Complete", ps));
        } else {
            this.lblProgressNote.setText(pe.getNote());
        }
    }

    public void setCompleted() {
        this.progressUpdated(new ProgressEvent(this, this.jpbProgressMeter.getMaximum(), this.jpbProgressMeter.getMaximum()));
    }

    public void reset() {
        this.jpbProgressMeter.setMaximum(100);
        this.jpbProgressMeter.setValue(0);
        String ps = this.pf.format(0.0);
        this.lblProgressNote.setText(BasicUtilities.getString("Percent_Complete", ps));
        this.console.setText("");
    }

    private void initUI() {
        this.console.configure(SystemConfig.getInstance().getPreferences());
        JScrollPane jsp = new JScrollPane(this.console);
        this.filterOut = new PrintStream(this.console.createFilteredStream("system"), true);
        this.filterErr = new PrintStream(this.console.createFilteredStream("err"), true);
        this.setLayout(new GridBagLayout());
        this.btnCancel.addActionListener(this);
        this.lblProgressNote.setHorizontalAlignment(0);
        this.lblProgressNote.setText(BasicUtilities.getString("Percent_Complete", this.pf.format(0.0)));
        jsp.setBorder(BorderFactory.createTitledBorder(BasicUtilities.getString("Progress_Console_Text")));
        this.console.setToolTipText(BasicUtilities.getString("Progress_Console_Tip"));
        this.btnCancel.setText(BasicUtilities.getString("Cancel"));
        this.btnCancel.setToolTipText(BasicUtilities.getString("Progress_Cancel_Tip"));
        this.add((Component)this.lblProgressNote, this.createGridBag(1, 1, 1, 1, 1.0, 0.0, 10, 2));
        this.add((Component)this.jpbProgressMeter, this.createGridBag(1, 2, 1, 1, 1.0, 0.0, 10, 2));
        this.add((Component)this.btnCancel, this.createGridBag(1, 3, 1, 1, 1.0, 0.0, 13, 0));
        this.add((Component)jsp, this.createGridBag(1, 4, 1, 1, 1.0, 1.0, 10, 1));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireActionPerformed(this.EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(l)) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(l);
            }
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.listeners != null) {
            for (ActionListener al : this.listeners) {
                try {
                    al.actionPerformed(e);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected GridBagConstraints createGridBag(int x, int y, int width, int hieght, double xwieght, double ywieght, int anchor, int fill) {
        return new GridBagConstraints(x, y, width, hieght, xwieght, ywieght, anchor, fill, this.insDefault, 1, 1);
    }
}

