/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.model.SuggestionListModel;
import org.isqlviewer.swing.WindowWillShowListener;
import org.isqlviewer.util.BasicUtilities;

public class SuggestionWindow
extends JWindow {
    private static final String CONTEXT_HELP_INVOCATION = "context-help-invocation";
    private JList lstSuggestions = new JList();
    private JTextComponent txtEditor = null;
    private JScrollPane jsp = new JScrollPane(this.lstSuggestions);
    private SuggestionListModel model = null;
    private Support support = new Support();
    private KeyListenerProxy keyProxy = new KeyListenerProxy(this);
    private int invokeIndex = -1;
    private JLabel titleLabel = new JLabel();
    private ArrayList keyBindings = new ArrayList();
    private InvokeAction invokeAction = new InvokeAction();
    private WindowWillShowListener wwsl = null;

    public SuggestionWindow() {
        this((Window)null);
    }

    public SuggestionWindow(Window owner) {
        super(owner);
        JPanel content = new JPanel(new BorderLayout());
        this.setContentPane(content);
        content.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        content.add((Component)this.jsp, "Center");
        content.add((Component)this.titleLabel, "North");
        this.jsp.setHorizontalScrollBarPolicy(32);
        this.jsp.setVerticalScrollBarPolicy(22);
        this.lstSuggestions.setBackground(UIManager.getColor("ToolTip.background"));
        this.lstSuggestions.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.lstSuggestions.setSelectionBackground(this.lstSuggestions.getForeground());
        this.lstSuggestions.setSelectionForeground(this.lstSuggestions.getBackground());
        this.lstSuggestions.setSelectionMode(0);
        this.lstSuggestions.addKeyListener(this.support);
        this.lstSuggestions.addMouseListener(this.support);
        this.pack();
    }

    public void setModel(SuggestionListModel model) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        SuggestionListModel oldModel = null;
        try {
            oldModel = (SuggestionListModel)this.lstSuggestions.getModel();
        }
        catch (ClassCastException cce) {
            oldModel = null;
        }
        if (oldModel != null) {
            oldModel.removeListDataListener(this.support);
            oldModel = null;
        }
        if (model == null) {
            model = new NullSuggestionModel();
        }
        this.model = model;
        this.model.addListDataListener(this.support);
        this.lstSuggestions.setModel(this.model);
    }

    public void setRenderer(ListCellRenderer renderer) {
        if (renderer != null) {
            this.lstSuggestions.setCellRenderer(renderer);
        } else {
            this.lstSuggestions.setCellRenderer(new DefaultListCellRenderer());
        }
    }

    public void setTextComponent(JTextComponent text) {
        if (!this.isVisible()) {
            ActionMap actMap;
            InputMap inMap;
            if (this.txtEditor != null) {
                this.txtEditor.removeKeyListener(this.invokeAction);
                this.txtEditor.removeKeyListener(this.keyProxy);
                inMap = this.txtEditor.getInputMap(0);
                actMap = this.txtEditor.getActionMap();
                for (KeyStroke next : this.keyBindings) {
                    inMap.remove(next);
                    actMap.remove(CONTEXT_HELP_INVOCATION);
                }
            }
            this.txtEditor = text;
            if (this.txtEditor != null) {
                this.txtEditor.addKeyListener(this.invokeAction);
                this.txtEditor.addKeyListener(this.keyProxy);
                inMap = this.txtEditor.getInputMap(0);
                actMap = this.txtEditor.getActionMap();
                for (KeyStroke next : this.keyBindings) {
                    inMap.put(next, CONTEXT_HELP_INVOCATION);
                    actMap.put(CONTEXT_HELP_INVOCATION, this.invokeAction);
                }
            }
            return;
        }
        throw new IllegalStateException();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setWindowListener(WindowWillShowListener listener) {
        this.wwsl = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKeyBinding(KeyStroke binding) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        if (!this.isInvocationBinding(binding)) {
            boolean added = false;
            ArrayList arrayList = this.keyBindings;
            synchronized (arrayList) {
                added = this.keyBindings.add(binding);
            }
            if (added && this.txtEditor != null) {
                InputMap inMap = this.txtEditor.getInputMap(0);
                ActionMap actMap = this.txtEditor.getActionMap();
                inMap.put(binding, CONTEXT_HELP_INVOCATION);
                actMap.put(CONTEXT_HELP_INVOCATION, this.invokeAction);
            }
            return added;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBinding(KeyStroke binding) {
        if (!this.isVisible()) {
            boolean removed = false;
            ArrayList arrayList = this.keyBindings;
            synchronized (arrayList) {
                removed = this.keyBindings.remove(binding);
            }
            if (removed && this.txtEditor != null) {
                InputMap inMap = this.txtEditor.getInputMap(0);
                ActionMap actMap = this.txtEditor.getActionMap();
                inMap.remove(binding);
                actMap.remove(CONTEXT_HELP_INVOCATION);
            }
            return removed;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean getFocusableWindowState() {
        return false;
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.txtEditor.addKeyListener(this.keyProxy);
            this.txtEditor.addCaretListener(this.support);
            this.model.addListDataListener(this.support);
        } else {
            this.invokeIndex = -1;
            if (this.model != null) {
                this.model.removeListDataListener(this.support);
            }
            if (this.txtEditor != null) {
                this.txtEditor.removeKeyListener(this.keyProxy);
                this.txtEditor.removeCaretListener(this.support);
            }
        }
    }

    protected void show(Component invoker, int x, int y) {
        if (this.model == null || invoker == null || this.txtEditor == null) {
            BasicUtilities.beep();
            return;
        }
        Point p = new Point(x, y);
        Point dp = null;
        try {
            dp = invoker.getLocationOnScreen();
        }
        catch (Throwable t) {
            dp = new Point(0, 0);
        }
        int offset = this.txtEditor.viewToModel(p);
        p.translate(0, this.txtEditor.getFont().getSize() + 3);
        try {
            this.model.updateSuggestion(this.txtEditor.getDocument(), offset);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
            BasicUtilities.beep();
            return;
        }
        if (this.lstSuggestions.getModel().getSize() >= 1 && offset >= 0) {
            this.lstSuggestions.setSelectedIndex(0);
            int rows = Math.min(7, this.lstSuggestions.getModel().getSize());
            Dimension ps = this.lstSuggestions.getPreferredSize();
            Dimension dim = new Dimension(ps.width + 24, this.lstSuggestions.getCellBounds((int)0, (int)rows).height);
            this.jsp.setPreferredSize(dim);
            p.translate(dp.x, dp.y);
            this.setLocation(p);
            if (!this.isVisible()) {
                this.invokeIndex = offset;
            }
            this.setVisible(true);
            this.txtEditor.requestFocus();
            this.txtEditor.setCaretPosition(offset);
        } else {
            BasicUtilities.beep();
        }
    }

    private boolean isInvocationBinding(KeyStroke ks) {
        for (KeyStroke next : this.keyBindings) {
            boolean modMatch;
            boolean codeMatch = ks.getKeyChar() == next.getKeyChar();
            boolean bl = modMatch = ks.getModifiers() == next.getModifiers();
            if (!codeMatch || !modMatch) continue;
            return true;
        }
        return false;
    }

    private static class NullSuggestionModel
    extends SuggestionListModel {
        private NullSuggestionModel() {
        }

        @Override
        public int applySuggestion(Object suggestion, Document doc, int start, int position) {
            return 0;
        }

        @Override
        public void updateSuggestion(Document doc, int offset) {
        }
    }

    private static class KeyListenerProxy
    implements KeyListener {
        private SuggestionWindow window = null;

        public KeyListenerProxy(SuggestionWindow window) {
            this.window = window;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.transferKeyEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.transferKeyEvent(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.transferKeyEvent(e);
        }

        private void transferKeyEvent(KeyEvent e) {
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
            if (this.window.isVisible() && !this.window.isInvocationBinding(ks)) {
                switch (ks.getKeyCode()) {
                    case 27: {
                        this.window.setVisible(false);
                        try {
                            Document doc = this.window.txtEditor.getDocument();
                            int caret = this.window.txtEditor.getCaretPosition();
                            int index = this.window.invokeIndex;
                            this.window.model.applySuggestion(null, doc, index, caret);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        e.consume();
                        break;
                    }
                    case 10: 
                    case 33: 
                    case 34: 
                    case 38: 
                    case 40: {
                        this.window.lstSuggestions.dispatchEvent(e);
                        e.consume();
                        break;
                    }
                }
            }
        }
    }

    private class InvokeAction
    extends AbstractAction
    implements KeyListener {
        private KeyStroke last = null;

        private InvokeAction() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.last = KeyStroke.getKeyStrokeForEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.last = KeyStroke.getKeyStrokeForEvent(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.last = KeyStroke.getKeyStrokeForEvent(e);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block7: {
                try {
                    JTextComponent text = (JTextComponent)e.getSource();
                    if (text == null) {
                        return;
                    }
                    if (text.hasFocus()) {
                        if (SuggestionWindow.this.wwsl != null) {
                            try {
                                KeyEvent ke = new KeyEvent(text, e.getID(), e.getWhen(), this.last.getModifiers(), this.last.getKeyCode(), this.last.getKeyChar());
                                SuggestionWindow.this.wwsl.windowWillShow(SuggestionWindow.this, ke);
                            }
                            catch (Throwable t) {
                                BasicUtilities.beep();
                                return;
                            }
                        }
                        int caret = text.getCaretPosition();
                        Point p = text.modelToView(caret).getLocation();
                        SuggestionWindow.this.show(text, p.x, p.y);
                        break block7;
                    }
                    BasicUtilities.beep();
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "InvokeAction::actionPerformed()");
                }
            }
        }
    }

    private class Support
    extends MouseInputAdapter
    implements ListDataListener,
    KeyListener,
    CaretListener {
        private boolean isSelecting = false;

        private Support() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void select() {
            this.isSelecting = true;
            try {
                Document doc = SuggestionWindow.this.txtEditor.getDocument();
                Object value = SuggestionWindow.this.lstSuggestions.getSelectedValue();
                int newpost = SuggestionWindow.this.model.applySuggestion(value, doc, SuggestionWindow.this.invokeIndex, SuggestionWindow.this.txtEditor.getCaretPosition());
                if (newpost < 0) {
                } else if (newpost > doc.getLength()) {
                    SuggestionWindow.this.txtEditor.setCaretPosition(doc.getLength());
                } else {
                    SuggestionWindow.this.txtEditor.setCaretPosition(newpost);
                }
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                BasicUtilities.HandleException(t);
            }
            finally {
                this.isSelecting = false;
                SuggestionWindow.this.setVisible(false);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (SuggestionWindow.this.isVisible() && !this.isSelecting) {
                try {
                    SuggestionWindow.this.model.updateSuggestion(SuggestionWindow.this.txtEditor.getDocument(), e.getDot());
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.contentsChanged(null);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.checkKeyEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.checkKeyEvent(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.checkKeyEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int cc = event.getClickCount();
            if (cc == 2) {
                this.select();
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (SuggestionWindow.this.model.getSize() >= 1 && SuggestionWindow.this.isVisible()) {
                SuggestionWindow.this.lstSuggestions.setSelectedIndex(0);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }

        private void checkKeyEvent(KeyEvent e) {
            if (SuggestionWindow.this.isVisible()) {
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                switch (ks.getKeyCode()) {
                    case 10: {
                        this.select();
                        break;
                    }
                }
            }
        }
    }
}

