/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WizardPanel
extends JPanel {
    private transient Vector changeListeners;

    public WizardPanel() {
        super(new Layout());
    }

    public Component getCard(String name) {
        int nChildren = this.getComponentCount();
        for (int i = 0; i < nChildren; ++i) {
            Component child = this.getComponent(i);
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public void showCard(Component card) {
        int index;
        if (card.getParent() != this) {
            this.add(card);
        }
        if ((index = this.getVisibleChildIndex()) != -1) {
            this.getComponent(index).setVisible(false);
        }
        card.setVisible(true);
        this.fireStateChanged(new ChangeEvent(this));
        this.revalidate();
        this.repaint();
    }

    public void showCard(String name) {
        int nChildren = this.getComponentCount();
        for (int i = 0; i < nChildren; ++i) {
            Component child = this.getComponent(i);
            if (!child.getName().equals(name)) continue;
            this.showCard(child);
            break;
        }
    }

    public void showNextCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String card = this.getCurrentCard();
            int index = this.getVisibleChildIndex();
            if (index >= this.getComponentCount() - 1) {
                this.showLastCard();
            } else {
                card = this.getComponent(++index).getName();
                this.showCard(card);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showPreviousCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String card = this.getCurrentCard();
            int index = this.getVisibleChildIndex();
            if (index >= 1) {
                card = this.getComponent(--index).getName();
                this.showCard(card);
            } else {
                this.showFirstCard();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCurrentCard() {
        try {
            return this.getComponent(this.getVisibleChildIndex()).getName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Component removeCard(String name) {
        int nChildren = this.getComponentCount();
        for (int i = 0; i < nChildren; ++i) {
            Component child = this.getComponent(i);
            if (!child.getName().equals(name)) continue;
            this.remove(child);
            return child;
        }
        return null;
    }

    public void showFirstCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String card = this.getComponent(0).getName();
            this.showCard(card);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void showLastCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        try {
            String card = this.getComponent(this.getComponentCount() - 1).getName();
            this.showCard(card);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(e);
            }
        }
    }

    protected int getVisibleChildIndex() {
        int nChildren = this.getComponentCount();
        for (int i = 0; i < nChildren; ++i) {
            Component child = this.getComponent(i);
            if (!child.isVisible()) continue;
            return i;
        }
        return -1;
    }

    private static class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component child) {
            if (name != null) {
                child.setName(name);
            }
            child.setVisible(child.getParent().getComponentCount() == 1);
        }

        @Override
        public void removeLayoutComponent(Component child) {
            Container parent;
            if (child.isVisible() && (parent = child.getParent()).getComponentCount() > 0) {
                parent.getComponent(0).setVisible(true);
                this.layoutContainer(parent);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            for (int i = 0; i < nChildren; ++i) {
                Dimension d = parent.getComponent(i).getPreferredSize();
                if (d.width > width) {
                    width = d.width;
                }
                if (d.height <= height) continue;
                height = d.height;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            for (int i = 0; i < nChildren; ++i) {
                Dimension d = parent.getComponent(i).getMinimumSize();
                if (d.width > width) {
                    width = d.width;
                }
                if (d.height <= height) continue;
                height = d.height;
            }
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = new Insets(10, 10, 10, 10);
            for (int i = 0; i < nChildren; ++i) {
                Component child = parent.getComponent(i);
                if (!child.isVisible()) continue;
                Rectangle r = parent.getBounds();
                int width = r.width - (insets.left + insets.right);
                int height = r.height - (insets.top + insets.bottom);
                child.setBounds(insets.left, insets.top, width, height);
                break;
            }
        }
    }
}

