/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.text;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.text.SyntaxStylizer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.SQLTokenizer;
import org.isqlviewer.util.StringUtilities;

public class SQLDocument
extends DefaultStyledDocument {
    private SQLTokenizer st = new SQLTokenizer(" ");
    private SyntaxStylizer styles = null;
    private boolean overwrite = false;
    private HashMap aliasMap = new HashMap();
    private boolean renderLocked = false;

    public SQLDocument() {
        this(false);
    }

    protected SQLDocument(boolean clone) {
        if (!clone) {
            this.styles = new SyntaxStylizer(this);
        }
        this.st.setQuotesEnabled(true);
        this.st.setTokenizeDirection(0);
        this.setAsynchronousLoadPriority(5);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (this.overwrite) {
            try {
                this.doRemove(offset, str.length(), false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (a == null) {
            super.insertString(offset, str, this.styles.getDefaultStyle());
        } else {
            super.insertString(offset, str, a);
        }
        this.validateStyles();
    }

    @Override
    public void remove(int offset, int len) throws BadLocationException {
        this.doRemove(offset, len, true);
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (attrs == null) {
            super.replace(offset, length, text, this.styles.getDefaultStyle());
        } else {
            super.replace(offset, length, text, attrs);
        }
        this.validateStyles();
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        super.getText(offset, Math.max(0, length), txt);
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        return super.getText(offset, Math.max(0, length));
    }

    public Object clone() {
        SQLDocument doc = new SQLDocument(true);
        doc.styles = this.styles;
        return doc;
    }

    public void updateConnection(DatabaseConnection cnx) {
        if (this.styles != null) {
            this.styles.setConnection(cnx);
        }
        this.validateStyles();
    }

    public SyntaxStylizer getStylizer() {
        return this.styles;
    }

    public boolean isAliased(String tableName) {
        if (tableName != null) {
            return this.aliasMap.containsKey(tableName.toUpperCase());
        }
        return false;
    }

    public String getTableForAlias(String alias) {
        return (String)this.aliasMap.get(alias);
    }

    public void setStylesEnabled(boolean b) {
        this.renderLocked = !b;
    }

    public void setOverwriteEnabled(boolean flag) {
        this.overwrite = flag;
    }

    public boolean getOverwriteEnabled() {
        return this.overwrite;
    }

    public void validateStyles() {
        if (this.getCurrentWriter() != null) {
            return;
        }
        this.writeLock();
        try {
            this.aliasMap.clear();
            this.applyStyles();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
        }
        finally {
            this.writeUnlock();
        }
    }

    public String toHTML(String sql, boolean isSwing) throws Exception {
        Color def;
        StringBuffer html = new StringBuffer("");
        AttributeSet attr = this.styles.getDefaultStyle();
        Color cur = def = StyleConstants.getForeground(attr);
        int start = 0;
        int length = sql.length();
        int lastIdx = 0;
        SQLTokenizer tok = new SQLTokenizer(sql);
        String wbuff = null;
        if (isSwing) {
            html.append("<html><font color=\"");
            html.append(StringUtilities.getHTMLColor(def));
            html.append("\">");
        } else {
            html.append("<span style=\"color:");
            html.append(StringUtilities.getHTMLColor(def));
            html.append(";\">");
        }
        while (tok.hasMoreTokens()) {
            attr = this.styles.getDefaultStyle();
            String token = tok.nextToken().trim();
            int tlength = token.length();
            int offset = start + tok.getTokenIndex();
            wbuff = null;
            if (offset + tlength > length || (token = sql.substring(offset, offset + tlength)).trim().length() == 0) continue;
            if (lastIdx != offset) {
                try {
                    wbuff = sql.substring(lastIdx, offset);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            lastIdx = offset + tlength;
            if (token.startsWith("--")) {
                attr = this.styles.getSingleCommentStyle();
            } else if (token.startsWith("/*")) {
                attr = this.styles.getMultiCommentStyle();
            } else if (token.startsWith("\"") || token.startsWith("'")) {
                attr = this.styles.getLiteralStyle();
            }
            if (attr != null) {
                attr = this.styles.getStyle(token);
            }
            cur = StyleConstants.getForeground(attr);
            if (wbuff != null) {
                token = wbuff.concat(token);
            }
            if (!def.equals(cur)) {
                if (isSwing) {
                    html.append("</font>\n");
                    html.append("<font color=\"");
                    html.append(StringUtilities.getHTMLColor(cur));
                    html.append("\">");
                } else {
                    html.append("</span>\n");
                    html.append("<span style=\"color:");
                    html.append(StringUtilities.getHTMLColor(cur));
                    html.append(";\">");
                }
                def = cur;
            }
            html.append(StringUtilities.encode(token, true, false));
        }
        if (isSwing) {
            html.append("</font>\n");
        } else {
            html.append("</span>\n");
        }
        return html.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadFromFile(File f) {
        boolean bl;
        FileInputStream fis = null;
        try {
            this.renderLocked = true;
            fis = new FileInputStream(f);
            byte[] buff = new byte[256];
            int offset = 0;
            while (true) {
                int bytesRead;
                if ((bytesRead = fis.read(buff)) == -1) {
                    bl = true;
                    this.renderLocked = false;
                    this.validateStyles();
                    break;
                }
                String text = new String(buff, 0, bytesRead);
                this.insertString(offset, text, null);
                text = null;
                offset += bytesRead;
            }
        }
        catch (Throwable t) {
            try {
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.renderLocked = false;
                this.validateStyles();
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            if (fis == null) return bl;
            fis.close();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected void doRemove(int offset, int len, boolean fire) throws BadLocationException {
        super.remove(offset, len);
        if (fire) {
            this.validateStyles();
        }
    }

    protected String getString(Element e) throws BadLocationException {
        return this.getText(e.getStartOffset(), e.getEndOffset());
    }

    protected void applyStyles() throws BadLocationException {
        if (this.renderLocked) {
            return;
        }
        AttributeSet attr = this.styles.getDefaultStyle();
        int start = 0;
        int length = this.getLength();
        String s = this.getText(0, length);
        this.setParagraphAttributes(start, length, attr, true);
        this.st.setString(s.toUpperCase().concat("\n"));
        String table = null;
        while (this.st.hasMoreTokens()) {
            String token = this.st.nextToken().trim();
            int tlength = token.length();
            int offset = start + this.st.getTokenIndex();
            if (tlength == 0) continue;
            if (token.startsWith("--")) {
                attr = this.styles.getSingleCommentStyle();
                this.setCharacterAttributes(offset, tlength, attr, true);
                continue;
            }
            if (token.startsWith("/*")) {
                attr = this.styles.getMultiCommentStyle();
                this.setCharacterAttributes(offset, tlength, attr, true);
                continue;
            }
            if (token.startsWith("&") && token.length() >= 2) {
                attr = this.styles.getParameterStyle();
                this.setCharacterAttributes(offset, tlength, attr, true);
                continue;
            }
            if (token.startsWith("\"") || token.startsWith("'")) {
                attr = this.styles.getLiteralStyle();
                this.setCharacterAttributes(offset, tlength, attr, true);
                continue;
            }
            if (this.isAliased(token)) {
                attr = this.styles.getStyle(this.getTableForAlias(token));
                this.setCharacterAttributes(offset, tlength, attr, true);
                continue;
            }
            attr = this.styles.getStyle(token);
            int type = this.styles.getStyleType(token);
            if (type == 5) {
                this.aliasMap.put(token.toUpperCase(), token);
                table = token;
            } else if (table != null && type == 0) {
                this.aliasMap.put(token, table);
            } else {
                table = null;
            }
            this.setCharacterAttributes(offset, tlength, attr, true);
        }
    }
}

