/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.isqlviewer.core.ConfigConstants;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.SuggestionListModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class SyntaxStylizer
implements PreferenceChangeListener {
    public static final int SYNTAX_DEFAULT = 0;
    public static final int SYNTAX_KEYWORD = 1;
    public static final int SYNTAX_FUNCTION = 2;
    public static final int SYNTAX_MLINE_COMMENT = 3;
    public static final int SYNTAX_SLINE_COMMENT = 4;
    public static final int SYNTAX_JDBC_OBJECT = 5;
    public static final int SYNTAX_STRING_LITERAL = 6;
    public static final int SYNTAX_SQL_PARAMETER = 7;
    public static final int SYNTAX_FOREIGN_OBJECT = 8;
    public static final int SYNTAX_PROCEDURES = 9;
    public static final int SYNTAX_TABLESPACES = 10;
    private SimpleAttributeSet[] defaults = new SimpleAttributeSet[11];
    private HashMap syntaxMap = new HashMap();
    private UserPreferences prefs = SystemConfig.getInstance().getPreferences();
    private SQLDocument syntaxView = null;
    private FunctionModel funcModel = new FunctionModel();

    public SyntaxStylizer(SQLDocument document) {
        this.syntaxView = document;
        this.initDefaults();
        this.addKeywords();
    }

    public void addKeyword(String word, int style) {
        this.addKeyword(word, this.defaults[style]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyword(String word, AttributeSet style) {
        HashMap hashMap = this.syntaxMap;
        synchronized (hashMap) {
            this.syntaxMap.put(word.toUpperCase(), style);
        }
    }

    public AttributeSet getStyle(String word) {
        if (word == null) {
            return this.getDefaultStyle();
        }
        AttributeSet style = (AttributeSet)this.syntaxMap.get(word.toUpperCase());
        if (style == null) {
            style = this.getDefaultStyle();
        }
        return style;
    }

    public AttributeSet getLiteralStyle() {
        return this.defaults[6];
    }

    public AttributeSet getParameterStyle() {
        return this.defaults[7];
    }

    public AttributeSet getSingleCommentStyle() {
        return this.defaults[4];
    }

    public AttributeSet getMultiCommentStyle() {
        return this.defaults[3];
    }

    public AttributeSet getDefaultStyle() {
        return this.defaults[0];
    }

    public void updateDefaultFont(Font fnt) {
        SimpleAttributeSet defaultStyle = (SimpleAttributeSet)this.getDefaultStyle();
        if (fnt == null) {
            StyleConstants.setFontFamily(defaultStyle, "Default");
            StyleConstants.setBold(defaultStyle, false);
            StyleConstants.setItalic(defaultStyle, false);
            StyleConstants.setFontSize(defaultStyle, 12);
        } else {
            StyleConstants.setFontFamily(defaultStyle, fnt.getFamily());
            StyleConstants.setBold(defaultStyle, fnt.isBold());
            StyleConstants.setItalic(defaultStyle, fnt.isItalic());
            StyleConstants.setFontSize(defaultStyle, fnt.getSize());
        }
    }

    public void updateDefaultForeground(Color c) {
        SimpleAttributeSet defaultStyle = (SimpleAttributeSet)this.getDefaultStyle();
        if (c == null) {
            StyleConstants.setForeground(defaultStyle, UIManager.getColor("TextArea.foreground"));
        } else {
            StyleConstants.setForeground(defaultStyle, c);
        }
    }

    public void updateDefaultBackground(Color c) {
        SimpleAttributeSet defaultStyle = (SimpleAttributeSet)this.getDefaultStyle();
        if (c == null) {
            StyleConstants.setBackground(defaultStyle, UIManager.getColor("TextArea.background"));
        } else {
            StyleConstants.setBackground(defaultStyle, c);
        }
    }

    public SuggestionListModel getFunctions() {
        return this.funcModel;
    }

    public int getStyleType(String word) {
        AttributeSet style = (AttributeSet)this.syntaxMap.get(word.toUpperCase());
        if (style == null) {
            return 0;
        }
        for (int i = 0; i < this.defaults.length; ++i) {
            if (!style.equals(this.defaults[i])) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String key = event.getKey();
        String val = event.getNewValue();
        SimpleAttributeSet sas = null;
        SimpleAttributeSet defaultStyle = (SimpleAttributeSet)this.getDefaultStyle();
        if (key.equals("editor.font")) {
            Font fnt = StringUtilities.parseFontString(val);
            StyleConstants.setFontFamily(defaultStyle, fnt.getFamily());
            StyleConstants.setFontSize(defaultStyle, fnt.getSize());
            StyleConstants.setBold(defaultStyle, fnt.isBold());
            StyleConstants.setItalic(defaultStyle, fnt.isItalic());
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.background-color")) {
            Color c = Color.decode(val);
            StyleConstants.setBackground(defaultStyle, c);
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.default-color")) {
            Color c = Color.decode(val);
            StyleConstants.setForeground(defaultStyle, c);
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.multicomment-color")) {
            Color c = Color.decode(val);
            sas = this.defaults[3];
            StyleConstants.setForeground(sas, c);
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.sline-comments")) {
            Color c = Color.decode(val);
            sas = this.defaults[4];
            StyleConstants.setForeground(sas, c);
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.functions")) {
            Color c = Color.decode(val);
            sas = this.defaults[2];
            StyleConstants.setForeground(sas, c);
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.literals")) {
            Color c = Color.decode(val);
            sas = this.defaults[6];
            StyleConstants.setForeground(sas, c);
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.local-obj")) {
            Color c = Color.decode(val);
            sas = this.defaults[2];
            StyleConstants.setForeground(sas, c);
            this.syntaxView.validateStyles();
        } else if (key.equals("editor.sql-keywords")) {
            Color c = Color.decode(val);
            sas = this.defaults[1];
            StyleConstants.setForeground(sas, c);
            this.syntaxView.validateStyles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(DatabaseConnection cnx) {
        this.reset();
        if (cnx == null) {
            return;
        }
        DatabaseMetaData metaData = cnx.getDatabaseInformation();
        try {
            this.addObjects(cnx.getAvailableCatalogs(), 10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addObjects(cnx.getAvailableSchemas(), 10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ResultSet set = null;
        try {
            String activeSchema = cnx.getSchema();
            set = metaData.getTables(cnx.getCatalog(), null, "%", cnx.getTableTypes());
            while (set.next()) {
                String table = set.getString("TABLE_NAME");
                String schema = set.getString("TABLE_SCHEM");
                if (schema != null && activeSchema != null && schema.equals(activeSchema)) {
                    this.addKeywords(table, 5);
                    continue;
                }
                this.addKeywords(table, 8);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
            set = null;
        }
        try {
            this.addObjects(cnx.getProcedures(), 9);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(metaData.getStringFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(metaData.getSystemFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(metaData.getTimeDateFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(metaData.getNumericFunctions(), 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeyword(metaData.getProcedureTerm(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeyword(metaData.getCatalogTerm(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeyword(metaData.getSchemaTerm(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.addKeywords(metaData.getSQLKeywords(), 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.syntaxView.validateStyles();
    }

    protected void addKeywords(String kw, int type) {
        StringTokenizer st = new StringTokenizer(kw, ",", false, true);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            this.addKeyword(key, type);
            if (type != 2 || this.funcModel.rootStore.contains(key)) continue;
            this.funcModel.rootStore.add(key);
        }
    }

    protected void addObjects(Object[] items, int type) {
        for (int i = 0; i < items.length; ++i) {
            this.addKeyword(items[i].toString(), type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void reset() {
        HashMap hashMap = this.syntaxMap;
        synchronized (hashMap) {
            this.syntaxMap.clear();
            this.funcModel.clear();
        }
        this.addKeywords();
    }

    private void addKeywords() {
        this.addKeyword("ABSOLUTE", 1);
        this.addKeyword("ACTION", 1);
        this.addKeyword("ADD", 1);
        this.addKeyword("ADMIN", 1);
        this.addKeyword("AFTER", 1);
        this.addKeyword("AGGREGATE", 1);
        this.addKeyword("ALIAS", 1);
        this.addKeyword("ALL", 1);
        this.addKeyword("ALLOCATE", 1);
        this.addKeyword("ALTER", 1);
        this.addKeyword("AND", 1);
        this.addKeyword("ANY", 1);
        this.addKeyword("ARE", 1);
        this.addKeyword("ARRAY", 1);
        this.addKeyword("AS", 1);
        this.addKeyword("ASC", 1);
        this.addKeyword("ASSERTION", 1);
        this.addKeyword("AT", 1);
        this.addKeyword("AUTHORIZATION", 1);
        this.addKeyword("BEFORE", 1);
        this.addKeyword("BEGIN", 1);
        this.addKeyword("BINARY", 1);
        this.addKeyword("BIT", 1);
        this.addKeyword("BLOB", 1);
        this.addKeyword("BOOLEAN", 1);
        this.addKeyword("BOTH", 1);
        this.addKeyword("BREADTH", 1);
        this.addKeyword("BY", 1);
        this.addKeyword("CALL", 1);
        this.addKeyword("CASCADE", 1);
        this.addKeyword("CASCADED", 1);
        this.addKeyword("CASE", 1);
        this.addKeyword("CAST", 1);
        this.addKeyword("CATALOG", 1);
        this.addKeyword("CHAR", 1);
        this.addKeyword("CHARACTER", 1);
        this.addKeyword("CHECK", 1);
        this.addKeyword("CLASS", 1);
        this.addKeyword("CLOB", 1);
        this.addKeyword("CLOSE", 1);
        this.addKeyword("COLLATE", 1);
        this.addKeyword("COLLATION", 1);
        this.addKeyword("COLUMN", 1);
        this.addKeyword("COMMIT", 1);
        this.addKeyword("COMPLETION", 1);
        this.addKeyword("CONDITION", 1);
        this.addKeyword("CONNECT", 1);
        this.addKeyword("CONNECTION", 1);
        this.addKeyword("CONSTRAINT", 1);
        this.addKeyword("CONSTRAINTS", 1);
        this.addKeyword("CONSTRUCTOR", 1);
        this.addKeyword("CONTAINS", 1);
        this.addKeyword("CONTINUE", 1);
        this.addKeyword("CORRESPONDING", 1);
        this.addKeyword("CREATE", 1);
        this.addKeyword("CROSS", 1);
        this.addKeyword("CUBE", 1);
        this.addKeyword("CURRENT", 1);
        this.addKeyword("CURRENT_DATE", 1);
        this.addKeyword("CURRENT_PATH", 1);
        this.addKeyword("CURRENT_ROLE", 1);
        this.addKeyword("CURRENT_TIME", 1);
        this.addKeyword("CURRENT_TIMESTAMP", 1);
        this.addKeyword("CURRENT_USER", 1);
        this.addKeyword("CURSOR", 1);
        this.addKeyword("CYCLE", 1);
        this.addKeyword("DATA", 1);
        this.addKeyword("DATALINK", 1);
        this.addKeyword("DATE", 1);
        this.addKeyword("DAY", 1);
        this.addKeyword("DEALLOCATE", 1);
        this.addKeyword("DEC", 1);
        this.addKeyword("DECIMAL", 1);
        this.addKeyword("DECLARE", 1);
        this.addKeyword("DEFAULT", 1);
        this.addKeyword("DEFERRABLE", 1);
        this.addKeyword("DELETE", 1);
        this.addKeyword("DEPTH", 1);
        this.addKeyword("DEREF", 1);
        this.addKeyword("DESC", 1);
        this.addKeyword("DESCRIPTOR", 1);
        this.addKeyword("DIAGNOSTICS", 1);
        this.addKeyword("DICTIONARY", 1);
        this.addKeyword("DISCONNECT", 1);
        this.addKeyword("DO", 1);
        this.addKeyword("DOMAIN", 1);
        this.addKeyword("DOUBLE", 1);
        this.addKeyword("DROP", 1);
        this.addKeyword("END-EXEC", 1);
        this.addKeyword("EQUALS", 1);
        this.addKeyword("ESCAPE", 1);
        this.addKeyword("EXCEPT", 1);
        this.addKeyword("EXCEPTION", 1);
        this.addKeyword("EXECUTE", 1);
        this.addKeyword("EXIT", 1);
        this.addKeyword("EXPAND", 1);
        this.addKeyword("EXPANDING", 1);
        this.addKeyword("FALSE", 1);
        this.addKeyword("FIRST", 1);
        this.addKeyword("FLOAT", 1);
        this.addKeyword("FOR", 1);
        this.addKeyword("FOREIGN", 1);
        this.addKeyword("FREE", 1);
        this.addKeyword("FROM", 1);
        this.addKeyword("FUNCTION", 1);
        this.addKeyword("GENERAL", 1);
        this.addKeyword("GET", 1);
        this.addKeyword("GLOBAL", 1);
        this.addKeyword("GOTO", 1);
        this.addKeyword("GROUP", 1);
        this.addKeyword("GROUPING", 1);
        this.addKeyword("HANDLER", 1);
        this.addKeyword("HASH", 1);
        this.addKeyword("HOUR", 1);
        this.addKeyword("IDENTITY", 1);
        this.addKeyword("IF", 1);
        this.addKeyword("IGNORE", 1);
        this.addKeyword("IMMEDUATE", 1);
        this.addKeyword("IN", 1);
        this.addKeyword("INDICATOR", 1);
        this.addKeyword("INITIALIZE", 1);
        this.addKeyword("INITALLY", 1);
        this.addKeyword("INNER", 1);
        this.addKeyword("INOUT", 1);
        this.addKeyword("INPUT", 1);
        this.addKeyword("INSERT", 1);
        this.addKeyword("INT", 1);
        this.addKeyword("INTEGER", 1);
        this.addKeyword("INTERSECT", 1);
        this.addKeyword("INTERVAL", 1);
        this.addKeyword("INTO", 1);
        this.addKeyword("IS", 1);
        this.addKeyword("ISOLATION", 1);
        this.addKeyword("ITERATE", 1);
        this.addKeyword("JOIN", 1);
        this.addKeyword("KEY", 1);
        this.addKeyword("LANGUAGE", 1);
        this.addKeyword("LARGE", 1);
        this.addKeyword("LAST", 1);
        this.addKeyword("LATERAL", 1);
        this.addKeyword("LEADING", 1);
        this.addKeyword("LEAVE", 1);
        this.addKeyword("LEFT", 1);
        this.addKeyword("LESS", 1);
        this.addKeyword("LEVEL", 1);
        this.addKeyword("LIKE", 1);
        this.addKeyword("LIMIT", 1);
        this.addKeyword("LOCAL", 1);
        this.addKeyword("LOCALTIME", 1);
        this.addKeyword("LOCALTIME-", 1);
        this.addKeyword("LOCATOR", 1);
        this.addKeyword("LOOP", 1);
        this.addKeyword("MATCH", 1);
        this.addKeyword("MEETS", 1);
        this.addKeyword("MINUTE", 1);
        this.addKeyword("MODIFIES", 1);
        this.addKeyword("MODIFY", 1);
        this.addKeyword("MODULE", 1);
        this.addKeyword("MONTH", 1);
        this.addKeyword("NAMES", 1);
        this.addKeyword("NATIONAL", 1);
        this.addKeyword("NATURAL", 1);
        this.addKeyword("NCHAR", 1);
        this.addKeyword("NCLOB", 1);
        this.addKeyword("NEW", 1);
        this.addKeyword("NEXT", 1);
        this.addKeyword("NO", 1);
        this.addKeyword("NONE", 1);
        this.addKeyword("NORMALIZE", 1);
        this.addKeyword("NOT", 1);
        this.addKeyword("NULL", 1);
        this.addKeyword("NUMERIC", 1);
        this.addKeyword("OBJECT", 1);
        this.addKeyword("OF", 1);
        this.addKeyword("OFF", 1);
        this.addKeyword("OLD", 1);
        this.addKeyword("ON", 1);
        this.addKeyword("ONLY", 1);
        this.addKeyword("OPEN", 1);
        this.addKeyword("OPERATION", 1);
        this.addKeyword("OPTION", 1);
        this.addKeyword("OR", 1);
        this.addKeyword("ORDER", 1);
        this.addKeyword("ORDINALITY", 1);
        this.addKeyword("OUT", 1);
        this.addKeyword("OUTER", 1);
        this.addKeyword("OUTPUT", 1);
        this.addKeyword("PAD", 1);
        this.addKeyword("PARAMETER", 1);
        this.addKeyword("PARAMETERS", 1);
        this.addKeyword("PARTIAL", 1);
        this.addKeyword("PATH", 1);
        this.addKeyword("PERIOD", 1);
        this.addKeyword("POSTFIX", 1);
        this.addKeyword("PRECEDES", 1);
        this.addKeyword("PRECISION", 1);
        this.addKeyword("PREFIX", 1);
        this.addKeyword("PREORDER", 1);
        this.addKeyword("PREPARE", 1);
        this.addKeyword("PRESERVE", 1);
        this.addKeyword("PRIMARY", 1);
        this.addKeyword("PRIOR", 1);
        this.addKeyword("PRIVILEGES", 1);
        this.addKeyword("PROCEDURE", 1);
        this.addKeyword("PUBLIC", 1);
        this.addKeyword("READ", 1);
        this.addKeyword("READS", 1);
        this.addKeyword("REAL", 1);
        this.addKeyword("RECURSIVE", 1);
        this.addKeyword("REDO", 1);
        this.addKeyword("REF", 1);
        this.addKeyword("REFRENCES", 1);
        this.addKeyword("REFRENCING", 1);
        this.addKeyword("RELATIVE", 1);
        this.addKeyword("REPEAT", 1);
        this.addKeyword("RESIGNAL", 1);
        this.addKeyword("RESTRICT", 1);
        this.addKeyword("RESULT", 1);
        this.addKeyword("RETURN", 1);
        this.addKeyword("RETURNS", 1);
        this.addKeyword("REVOKE", 1);
        this.addKeyword("RIGHT", 1);
        this.addKeyword("ROLE", 1);
        this.addKeyword("ROLLBACK", 1);
        this.addKeyword("ROLLUP", 1);
        this.addKeyword("ROUTINE", 1);
        this.addKeyword("ROW", 1);
        this.addKeyword("ROWS", 1);
        this.addKeyword("SAVEPOINT", 1);
        this.addKeyword("SCHEMA", 1);
        this.addKeyword("SCROLL", 1);
        this.addKeyword("SEARCH", 1);
        this.addKeyword("SECOND", 1);
        this.addKeyword("SECTION", 1);
        this.addKeyword("SELECT", 1);
        this.addKeyword("SEQUENCE", 1);
        this.addKeyword("SESSION", 1);
        this.addKeyword("SESSION_USER", 1);
        this.addKeyword("SET", 1);
        this.addKeyword("SETS", 1);
        this.addKeyword("SIGNAL", 1);
        this.addKeyword("SIZE", 1);
        this.addKeyword("SMALLINT", 1);
        this.addKeyword("SPECIFIC", 1);
        this.addKeyword("SPECIFICTYPE", 1);
        this.addKeyword("SQL", 1);
        this.addKeyword("SQLEXCEPTION", 1);
        this.addKeyword("SQLSTATE", 1);
        this.addKeyword("SQLWARNING", 1);
        this.addKeyword("START", 1);
        this.addKeyword("STATE", 1);
        this.addKeyword("STATIC", 1);
        this.addKeyword("STRUCTURE", 1);
        this.addKeyword("SUCCEEDS", 1);
        this.addKeyword("SUM", 1);
        this.addKeyword("SYSTEM_USER", 1);
        this.addKeyword("TABLE", 1);
        this.addKeyword("TEMPORARY", 1);
        this.addKeyword("TERMINATE", 1);
        this.addKeyword("THAN", 1);
        this.addKeyword("THEN", 1);
        this.addKeyword("TIME", 1);
        this.addKeyword("TIMESTAMP", 1);
        this.addKeyword("TIMEZONE_HOUR", 1);
        this.addKeyword("TIMEZONE_MINUTE", 1);
        this.addKeyword("TO", 1);
        this.addKeyword("TRAILING", 1);
        this.addKeyword("TRANSACTION", 1);
        this.addKeyword("TRANSLATION", 1);
        this.addKeyword("TREAT", 1);
        this.addKeyword("TRIGGER", 1);
        this.addKeyword("TRUE", 1);
        this.addKeyword("UNDER", 1);
        this.addKeyword("UNDO", 1);
        this.addKeyword("UNION", 1);
        this.addKeyword("UNIQUE", 1);
        this.addKeyword("UNKNOWN", 1);
        this.addKeyword("UNTIL", 1);
        this.addKeyword("UPDATE", 1);
        this.addKeyword("USAGE", 1);
        this.addKeyword("USER", 1);
        this.addKeyword("USING", 1);
        this.addKeyword("VALUE", 1);
        this.addKeyword("VALUES", 1);
        this.addKeyword("VARIABLE", 1);
        this.addKeyword("VARYING", 1);
        this.addKeyword("VIEW", 1);
        this.addKeyword("WHEN", 1);
        this.addKeyword("WHENEVER", 1);
        this.addKeyword("WHERE", 1);
        this.addKeyword("WHILE", 1);
        this.addKeyword("WITH", 1);
        this.addKeyword("WRITE", 1);
        this.addKeyword("YEAR", 1);
        this.addKeyword("ZONE", 1);
        this.addKeyword("MAX", 2);
        this.addKeyword("MIN", 2);
        this.addKeyword("AVG", 2);
        this.addKeyword("COUNT", 2);
    }

    private void initDefaults() {
        SimpleAttributeSet defaultStyle = new SimpleAttributeSet();
        Font fnt = this.prefs.getFont("editor.font");
        StyleConstants.setFontFamily(defaultStyle, fnt.getFamily());
        StyleConstants.setFontSize(defaultStyle, fnt.getSize());
        StyleConstants.setBold(defaultStyle, fnt.isBold());
        StyleConstants.setItalic(defaultStyle, fnt.isItalic());
        StyleConstants.setForeground(defaultStyle, this.prefs.getColor("editor.default-color"));
        StyleConstants.setBackground(defaultStyle, this.prefs.getColor("editor.background-color"));
        this.defaults[0] = defaultStyle;
        this.defaults[1] = this.createSet(defaultStyle, "editor.sql-keywords");
        this.defaults[2] = this.createSet(defaultStyle, "editor.sline-comments");
        this.defaults[5] = this.createSet(defaultStyle, "editor.local-obj");
        this.defaults[6] = this.createSet(defaultStyle, "editor.literals");
        this.defaults[3] = this.createSet(defaultStyle, "editor.multicomment-color");
        this.defaults[4] = this.createSet(defaultStyle, "editor.sline-comments");
        this.defaults[7] = this.createSet(defaultStyle, "editor.parameters");
        this.defaults[8] = this.createSet(defaultStyle, "editor.foreign-obj");
        this.defaults[9] = this.createSet(defaultStyle, "editor.procedures");
        this.defaults[10] = this.createSet(defaultStyle, "editor.tablespace");
        this.prefs.addPreferenceChangeListener(this);
    }

    private SimpleAttributeSet createSet(AttributeSet parent, String baseKey) {
        SimpleAttributeSet sas = new SimpleAttributeSet();
        String prefKey = null;
        sas.setResolveParent(parent);
        prefKey = ConfigConstants.createStyleKey(baseKey, "color");
        StyleConstants.setForeground(sas, this.prefs.getColor(prefKey));
        prefKey = ConfigConstants.createStyleKey(baseKey, "italics");
        StyleConstants.setItalic(sas, this.prefs.getBoolean(prefKey));
        prefKey = ConfigConstants.createStyleKey(baseKey, "bolded");
        StyleConstants.setBold(sas, this.prefs.getBoolean(prefKey));
        return sas;
    }

    private static class FunctionModel
    extends SuggestionListModel {
        private ArrayList rootStore = new ArrayList();

        private FunctionModel() {
        }

        @Override
        public int applySuggestion(Object suggestion, Document doc, int start, int position) throws BadLocationException {
            this.clear();
            if (suggestion == null) {
                return -1;
            }
            String code = suggestion.toString().trim();
            String word = BasicUtilities.getCurrentWord(doc, position);
            int len = word.length();
            doc.remove(position -= len, len);
            doc.insertString(position, code, null);
            return position + code.length();
        }

        @Override
        public void updateSuggestion(Document doc, int offset) throws BadLocationException {
            String word = BasicUtilities.getCurrentWord(doc, offset);
            Iterator itr = this.rootStore.iterator();
            this.clear();
            while (itr.hasNext()) {
                String next = (String)itr.next();
                if (next.indexOf(word) < 0) continue;
                this.addElement(next);
            }
        }
    }
}

