/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.swing.ColorIcon;
import org.isqlviewer.swing.JFileList;
import org.isqlviewer.swing.JFontChoser;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.PropertyPage;
import org.isqlviewer.util.UserPreferences;

public abstract class AbstractPropertyPage
extends JPanel
implements PropertyPage {
    private static final String FONT_CLIENT_PROPERTY = "PP-GET-FONT";
    private static final String COLOR_CLIENT_PROPERTY = "PP-GET-COLOR";
    private static final Insets INS = new Insets(1, 1, 1, 1);
    protected static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, INS, 0, 0);
    protected static final UserPreferences prefs = SystemConfig.getInstance().getPreferences();
    private Action colorChooserAction = new ColorChangeAction(this);
    private Hashtable propertyMap = new Hashtable(1);
    private Vector childPages = new Vector();
    private PropertyChangeHandler propertyHandler = new PropertyChangeHandler();
    private boolean isModified = false;
    private boolean isLoaded = false;

    protected AbstractPropertyPage() {
    }

    @Override
    public PropertyPage[] getChildren() {
        return this.childPages.toArray(new PropertyPage[0]);
    }

    @Override
    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Preferences16");
    }

    @Override
    public boolean hasChangedProperties() {
        for (PropertyPage kid : this.childPages) {
            if (!kid.hasChangedProperties()) continue;
            return true;
        }
        return this.isModified;
    }

    @Override
    public void revertChangedState() {
        this.setModified(false);
    }

    @Override
    public void loadProperties() {
        Enumeration enum1 = this.propertyMap.keys();
        block0: while (enum1.hasMoreElements()) {
            Object o = enum1.nextElement();
            String p = (String)this.propertyMap.get(o);
            if (o instanceof JComponent) {
                JComponent c = (JComponent)o;
                if (c.getClientProperty(FONT_CLIENT_PROPERTY) != null) {
                    c.setFont(prefs.getFont(p));
                    continue;
                }
                if (c.getClientProperty(COLOR_CLIENT_PROPERTY) != null) {
                    c.setForeground(prefs.getColor(p));
                    continue;
                }
                if (c instanceof JToggleButton) {
                    ((JToggleButton)c).setSelected(prefs.getBoolean(p));
                    continue;
                }
                if (c instanceof JComboBox) {
                    ((JComboBox)c).setSelectedItem(prefs.get(p));
                    continue;
                }
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).setText(prefs.get(p));
                    continue;
                }
                if (!(c instanceof JFileList)) continue;
                ((JFileList)c).setPathString(prefs.get(p));
                continue;
            }
            if (!(o instanceof ButtonGroup)) continue;
            ButtonGroup bg = (ButtonGroup)o;
            Enumeration<AbstractButton> en = bg.getElements();
            String y = prefs.get(p);
            while (en.hasMoreElements()) {
                AbstractButton btn = en.nextElement();
                String x = btn.getModel().getActionCommand();
                if (!y.equalsIgnoreCase(x) && en.hasMoreElements()) continue;
                bg.setSelected(btn.getModel(), true);
                continue block0;
            }
        }
        for (int i = 0; i < this.childPages.size(); ++i) {
            PropertyPage kid = (PropertyPage)this.childPages.get(i);
            kid.loadProperties();
            if (!(kid instanceof AbstractPropertyPage)) continue;
            ((AbstractPropertyPage)kid).updatePage();
        }
        this.updatePage();
        this.setLoaded(true);
    }

    @Override
    public void revertProperties() {
        this.isLoaded = false;
        this.loadProperties();
        this.revertChangedState();
    }

    @Override
    public void saveProperties() {
        for (PropertyPage page : this.childPages) {
            if (!page.hasChangedProperties()) continue;
            page.saveProperties();
        }
        if (this.isModified) {
            for (Object key : this.propertyMap.keySet()) {
                String preference = this.propertyMap.get(key).toString();
                if (key instanceof JComponent) {
                    JComponent cmp = (JComponent)key;
                    if (!cmp.isEnabled()) {
                        prefs.clear(preference);
                        continue;
                    }
                    if (cmp.getClientProperty(FONT_CLIENT_PROPERTY) != null) {
                        prefs.putFont(preference, cmp.getFont());
                        continue;
                    }
                    if (cmp.getClientProperty(COLOR_CLIENT_PROPERTY) != null) {
                        prefs.putColor(preference, cmp.getForeground());
                        continue;
                    }
                    if (cmp instanceof JToggleButton) {
                        JToggleButton jtb = (JToggleButton)cmp;
                        prefs.putBoolean(preference, jtb.isSelected());
                        continue;
                    }
                    if (cmp instanceof JComboBox) {
                        JComboBox jcb = (JComboBox)cmp;
                        Object selected = jcb.getSelectedItem();
                        if (selected != null) {
                            prefs.put(preference, selected.toString());
                            continue;
                        }
                        prefs.clear(preference);
                        continue;
                    }
                    if (cmp instanceof JPasswordField) {
                        JPasswordField jpf = (JPasswordField)cmp;
                        prefs.put(preference, new String(jpf.getPassword()));
                        continue;
                    }
                    if (cmp instanceof JTextComponent) {
                        JTextComponent jtc = (JTextComponent)cmp;
                        prefs.put(preference, jtc.getText());
                        continue;
                    }
                    if (!(cmp instanceof JFileList)) continue;
                    JFileList jfl = (JFileList)cmp;
                    prefs.put(preference, jfl.toPathString());
                    continue;
                }
                if (!(key instanceof ButtonGroup)) continue;
                ButtonGroup group = (ButtonGroup)key;
                ButtonModel selected = group.getSelection();
                if (selected != null) {
                    String cmd = selected.getActionCommand();
                    prefs.put(preference, cmd);
                    continue;
                }
                prefs.clear(preference);
            }
        }
        this.setModified(false);
        this.applyChanges();
    }

    @Override
    public final JComponent getPageComponent() {
        return this;
    }

    protected void applyChanges() {
    }

    protected void updatePage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void setModified(boolean f) {
        AbstractPropertyPage abstractPropertyPage = this;
        synchronized (abstractPropertyPage) {
            this.isModified = f;
            try {
                RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this));
                if (rpc != null) {
                    rpc.getRootPane().putClientProperty("windowModified", f);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void setLoaded(boolean f) {
        AbstractPropertyPage abstractPropertyPage = this;
        synchronized (abstractPropertyPage) {
            this.isLoaded = f;
        }
    }

    protected final void removeChild(PropertyPage page) {
        this.childPages.remove(page);
    }

    protected final void removeChild(int index) {
        this.childPages.remove(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addChild(PropertyPage page) {
        Vector vector = this.childPages;
        synchronized (vector) {
            this.childPages.add(page);
        }
    }

    protected final String getPropertyForComponent(JComponent c) {
        return (String)this.propertyMap.get(c);
    }

    protected final void setFontPropertyForComponent(JComponent c, String property) {
        c.putClientProperty(FONT_CLIENT_PROPERTY, Boolean.TRUE);
        this.setPropertyForComponent(c, property);
    }

    protected final void setColorPropertyForComponent(JComponent c, String property) {
        c.putClientProperty(COLOR_CLIENT_PROPERTY, Boolean.TRUE);
        this.setPropertyForComponent(c, property);
    }

    protected final void addButtonGroupProperty(ButtonGroup bg, String property) {
        this.propertyMap.put(bg, property);
    }

    protected final void setPropertyForComponent(JComponent c, String property) {
        this.propertyMap.put(c, property);
        this.configureComponent(c);
    }

    protected static final void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        AbstractPropertyPage.UI_CONSTRAINT.gridx = x;
        AbstractPropertyPage.UI_CONSTRAINT.gridy = y;
        AbstractPropertyPage.UI_CONSTRAINT.gridwidth = w;
        AbstractPropertyPage.UI_CONSTRAINT.gridheight = h;
        AbstractPropertyPage.UI_CONSTRAINT.weightx = wx;
        AbstractPropertyPage.UI_CONSTRAINT.weighty = wy;
        AbstractPropertyPage.UI_CONSTRAINT.anchor = a;
        AbstractPropertyPage.UI_CONSTRAINT.fill = f;
    }

    protected static final Component createHorizSeperator() {
        return new JSeparator(0);
    }

    private void configureComponent(JComponent c) {
        if (c.getClientProperty(COLOR_CLIENT_PROPERTY) != null && c instanceof JButton) {
            JButton button = (JButton)c;
            button.setAction(this.colorChooserAction);
            button.setVerticalAlignment(0);
            button.setHorizontalAlignment(0);
            return;
        }
        if (c instanceof JTextComponent) {
            JTextComponent jtc = (JTextComponent)c;
            jtc.getDocument().addDocumentListener(this.propertyHandler);
        }
        this.addListener(c, "addActionListener", ActionListener.class);
        this.addListener(c, "addChangeListener", ChangeListener.class);
    }

    private void addListener(Object c, String event, Class type) {
        try {
            c.getClass().getMethod(event, type).invoke(c, this.propertyHandler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static class ColorChangeAction
    extends AbstractAction {
        private final Icon icon = new ColorIcon();
        private AbstractPropertyPage page = null;

        public ColorChangeAction(AbstractPropertyPage page) {
            this.page = page;
            this.putValue("SmallIcon", this.icon);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src instanceof JButton) {
                JButton btn = (JButton)src;
                Color old = btn.getForeground();
                Color c = JColorChooser.showDialog(this.page, "", old);
                if (c == null) {
                    return;
                }
                if (!c.equals(old)) {
                    this.page.setModified(true);
                    btn.setForeground(c);
                }
            }
        }
    }

    protected static class FontChangeAction
    extends AbstractAction {
        private JLabel lbl = null;
        private AbstractPropertyPage page = null;

        public FontChangeAction(AbstractPropertyPage page, Font f, JLabel lbl) {
            if (lbl == null) {
                throw new NullPointerException();
            }
            this.lbl = lbl;
            this.page = page;
            this.putValue("SmallIcon", BasicUtilities.loadIconResource("Font24"));
            this.putValue("ShortDescription", BasicUtilities.getString("Change_Font"));
            String str = lbl.getName();
            String[] p = new String[]{f.getName(), Integer.toString(f.getSize())};
            String fontString = BasicUtilities.getString(str, p);
            lbl.setText(fontString);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src instanceof JButton) {
                JButton btn = (JButton)src;
                JFontChoser chooser = new JFontChoser();
                Font old = btn.getFont();
                Font f = chooser.showDialog(this.page, BasicUtilities.getString("Change_Font"), old);
                if (f == null) {
                    return;
                }
                if (!old.equals(f)) {
                    String str = this.lbl.getName();
                    String[] p = new String[]{f.getName(), Integer.toString(f.getSize())};
                    String fontString = BasicUtilities.getString(str, p);
                    this.lbl.setText(fontString);
                    btn.setFont(f);
                    this.page.setModified(true);
                }
            }
        }
    }

    private class PropertyChangeHandler
    implements ActionListener,
    ChangeListener,
    DocumentListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.toggle();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.toggle();
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            this.toggle();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() instanceof JToggleButton) {
                this.toggle();
            }
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() instanceof JToggleButton) {
                this.toggle();
            }
        }

        protected void toggle() {
            if (AbstractPropertyPage.this.isLoaded) {
                AbstractPropertyPage.this.setModified(true);
            }
        }
    }
}

