/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.model.DriverPropertyTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.util.BasicUtilities;

public final class DriverPropertyEditor
extends JDialog
implements TableModelListener,
ActionListener {
    private DriverPropertyTableModel mdlProperties = null;
    private ITable tabProperties = new ITable((ActionManager)null);
    private JButton btnOK = new JButton();
    private JButton btnCancel = new JButton();
    private ServiceDefinition service;
    private boolean isModified = false;

    public static final boolean showDialog(JDialog Owner, ServiceDefinition service) {
        try {
            DriverPropertyEditor dpe = new DriverPropertyEditor(Owner, service);
            dpe.pack();
            dpe.setSize(512, 380);
            dpe.setLocationRelativeTo(Owner);
            dpe.setVisible(true);
            return dpe.isModified;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "DriverPropertyEditor::showDialog(JDialog, ServiceDefinition)");
            return false;
        }
    }

    private DriverPropertyEditor(JDialog owner, ServiceDefinition service) {
        super(owner, BasicUtilities.getString("XProp_Main_Title", service.getName()), true);
        this.setDefaultCloseOperation(2);
        this.service = service;
        try {
            DatabaseConnection dbc = service.createConnection();
            this.mdlProperties = new DriverPropertyTableModel(dbc.getDriverProperties(new Properties()));
            this.mdlProperties.setProperties(service.getProperties());
            this.tabProperties.setModel(this.mdlProperties);
            this.mdlProperties.addTableModelListener(this);
            this.tabProperties.setDefaultEditor(String[].class, this.mdlProperties.getChoiceEditor());
        }
        catch (SQLException sqle) {
            String msg = BasicUtilities.getString("XProp_SQL_Exception", sqle.getLocalizedMessage());
            BasicUtilities.showExceptionPopup(this, sqle, msg);
            throw new RuntimeException(sqle);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = BasicUtilities.getString("XProp_No_Class");
            BasicUtilities.showExceptionPopup(this, cnfe, msg);
            throw new RuntimeException(cnfe);
        }
        catch (Exception e) {
            String msg = BasicUtilities.getString("XProp_General_Exception");
            BasicUtilities.showExceptionPopup(this, e, msg);
            throw new RuntimeException(e);
        }
        catch (Error err) {
            String msg = BasicUtilities.getString("XProp_Error");
            BasicUtilities.showExceptionPopup(this, err, msg);
            throw new RuntimeException(err);
        }
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "DriverPropertyEditor::initUI()");
        }
    }

    private void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.btnOK.setText(BasicUtilities.getString("Save"));
        this.btnCancel.setText(BasicUtilities.getString("Cancel"));
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
        JPanel content = (JPanel)this.getContentPane();
        JToolBar pnl = new JToolBar(0);
        pnl.setFloatable(false);
        pnl.add(Box.createHorizontalGlue());
        pnl.add(this.btnOK);
        pnl.add(this.btnCancel);
        content.add((Component)new JScrollPane(this.tabProperties), "Center");
        content.add(Box.createVerticalStrut(6), "North");
        content.add(Box.createHorizontalStrut(12), "West");
        content.add(Box.createHorizontalStrut(12), "East");
        content.add((Component)pnl, "South");
        BasicUtilities.optimizeTableView(this.tabProperties);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.isModified = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.btnOK) {
            if (!this.mdlProperties.hasRequiredData()) {
                BasicUtilities.beep();
                return;
            }
            this.service.setProperties(this.mdlProperties.toProperties());
            this.isModified = true;
        } else {
            this.isModified = false;
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

