/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.HistoryTreeModel;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.util.BasicUtilities;

public final class HistoryViewer
extends JDialog {
    protected final Insets insDefault = new Insets(1, 2, 2, 1);
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private final JButton btnExec = new JButton(BasicUtilities.getString("Execute"));
    private final JButton btnClear = new JButton(BasicUtilities.getString("Clear_All"));
    private final JButton btnExit = new JButton(BasicUtilities.getString("Exit"));
    private JButton btnSelect = new JButton(BasicUtilities.getString("Select"));
    private JLabel lblMetaLabel = new JLabel(BasicUtilities.loadIconResource("History16"));
    private HistoryManager manager;
    private JTree treHistoryTree = new JTree();
    private JSplitPane jspRootSplitter = new JSplitPane(1);
    private JTextPane txtSQL = new JTextPane();
    private ListMouseAdapter actionHandler = new ListMouseAdapter();
    private HistoryTreeModel mdlHistoryTree = null;
    private SQLWorkBench workbench = null;

    public static final void showDialog(JFrame owner, HistoryManager mgr, SQLWorkBench bench) {
        HistoryViewer dlg = new HistoryViewer(owner, mgr, bench);
        dlg.setLocationRelativeTo(owner);
        dlg.show();
    }

    private HistoryViewer(JFrame owner, HistoryManager mgr, SQLWorkBench bench) {
        super(owner, BasicUtilities.getString("History_Window_Title"), true);
        this.manager = mgr;
        this.workbench = bench;
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "HistoryViewer()::initUI()", true);
        }
    }

    private void initUI() throws Exception {
        this.actionHandler.owner = this;
        JPanel cp = (JPanel)this.getContentPane();
        this.setContentPane(new WizardPanel());
        this.getContentPane().add((Component)cp, "root");
        SQLEditor editor = this.workbench.getEditor();
        SQLDocument sqlDoc = editor.getDocument();
        this.txtSQL.setDocument((SQLDocument)sqlDoc.clone());
        this.txtSQL.setPreferredSize(new Dimension(320, 100));
        this.txtSQL.setEditable(false);
        this.mdlHistoryTree = new HistoryTreeModel(this.manager);
        this.treHistoryTree.setModel(this.mdlHistoryTree);
        this.treHistoryTree.setCellRenderer(new HistoryTreeRenderer());
        this.treHistoryTree.setRootVisible(false);
        this.treHistoryTree.addTreeSelectionListener(this.actionHandler);
        this.treHistoryTree.addMouseListener(this.actionHandler);
        this.treHistoryTree.expandRow(0);
        this.treHistoryTree.getSelectionModel().setSelectionMode(1);
        this.treHistoryTree.setToolTipText(BasicUtilities.getString("HistoryTree_Tip"));
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel editorPane = new JPanel(new BorderLayout());
        editorPane.add((Component)this.lblMetaLabel, "North");
        editorPane.add((Component)this.txtSQL, "Center");
        this.btnClear.addActionListener(this.actionHandler);
        this.btnExec.addActionListener(this.actionHandler);
        this.btnSelect.addActionListener(this.actionHandler);
        this.btnClear.setToolTipText(BasicUtilities.getString("History_Clear_Tip"));
        this.btnExec.setToolTipText(BasicUtilities.getString("History_Exec_Tip"));
        this.btnSelect.setToolTipText(BasicUtilities.getString("History_Select_Tip"));
        this.btnExit.addActionListener(this.actionHandler);
        this.btnClear.setEnabled(!this.manager.isEmpty());
        this.btnExec.setEnabled(false);
        this.btnSelect.setEnabled(false);
        HistoryViewer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 0);
        panel.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        HistoryViewer.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        panel.add((Component)this.btnClear, UI_CONSTRAINT);
        HistoryViewer.constrain(2, 0, 1, 1, 0.0, 0.0, 13, 0);
        panel.add((Component)this.btnSelect, UI_CONSTRAINT);
        HistoryViewer.constrain(3, 0, 1, 1, 0.0, 0.0, 13, 0);
        panel.add((Component)this.btnExec, UI_CONSTRAINT);
        HistoryViewer.constrain(4, 0, 1, 1, 0.0, 0.0, 13, 0);
        panel.add((Component)this.btnExit, UI_CONSTRAINT);
        this.jspRootSplitter.setLeftComponent(new JScrollPane(this.treHistoryTree));
        this.jspRootSplitter.setRightComponent(new JScrollPane(editorPane));
        cp.add((Component)panel, "South");
        cp.add((Component)this.jspRootSplitter, "Center");
        this.pack();
        this.setSize(630, 330);
        this.jspRootSplitter.setDividerLocation(this.treHistoryTree.getPreferredSize().width + 4);
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        HistoryViewer.UI_CONSTRAINT.gridx = x;
        HistoryViewer.UI_CONSTRAINT.gridy = y;
        HistoryViewer.UI_CONSTRAINT.gridwidth = w;
        HistoryViewer.UI_CONSTRAINT.gridheight = h;
        HistoryViewer.UI_CONSTRAINT.weightx = wx;
        HistoryViewer.UI_CONSTRAINT.weighty = wy;
        HistoryViewer.UI_CONSTRAINT.anchor = a;
        HistoryViewer.UI_CONSTRAINT.fill = f;
    }

    private static class HistoryTreeRenderer
    extends DefaultTreeCellRenderer {
        private SystemConfig sysConfig = SystemConfig.getInstance();
        private SimpleDateFormat leafFormat = new SimpleDateFormat(this.sysConfig.getFormatForSQLType(92));
        private SimpleDateFormat fmtDayNode = new SimpleDateFormat("MMM EEE dd, yyyy");
        private Calendar calendar = Calendar.getInstance();
        private int cdoy = 0;

        public HistoryTreeRenderer() {
            this.calendar.setTime(new Date());
            this.cdoy = this.calendar.get(6);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree t, Object o, boolean s, boolean x, boolean l, int r, boolean f) {
            super.getTreeCellRendererComponent(t, o, s, x, l, r, f);
            this.setFont(t.getFont().deriveFont(10.0f));
            if (l) {
                HistoryItem item = (HistoryItem)o;
                this.setText(this.leafFormat.format(item.getTimeStamp()));
                this.setIcon(BasicUtilities.loadIconResource("Time16"));
            } else {
                try {
                    this.calendar.setTime((Date)o);
                    int doy = this.calendar.get(6);
                    if (doy == this.cdoy) {
                        this.setText(BasicUtilities.getString("History_Today", this.fmtDayNode.format(o)));
                    } else if (doy == this.cdoy - 1) {
                        this.setText(BasicUtilities.getString("History_Yesterday", this.fmtDayNode.format(o)));
                    } else {
                        this.setText(this.fmtDayNode.format(o));
                    }
                    this.setIcon(BasicUtilities.loadIconResource("Date16"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this;
        }
    }

    private static class ListMouseAdapter
    extends MouseAdapter
    implements TreeSelectionListener,
    ActionListener {
        private HistoryViewer owner = null;

        private ListMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getClickCount() == 3 && this.owner.btnSelect.isEnabled()) {
                this.actionPerformed(new ActionEvent(this.owner.btnSelect, 0, ""));
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object o = this.owner.treHistoryTree.getSelectionPath().getLastPathComponent();
            if (o instanceof HistoryItem) {
                HistoryItem item = (HistoryItem)o;
                this.owner.txtSQL.setText(item.getSQLData());
                ((SQLDocument)this.owner.txtSQL.getDocument()).validateStyles();
                this.owner.lblMetaLabel.setText(BasicUtilities.getString("History_Item_Label", item.getServiceReference()));
                this.owner.btnExec.setEnabled(true);
                this.owner.btnSelect.setEnabled(true);
            } else {
                this.owner.btnExec.setEnabled(false);
                this.owner.btnSelect.setEnabled(false);
                this.owner.txtSQL.setText("");
                this.owner.lblMetaLabel.setText("");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IPCService ipc = SystemConfig.getInstance().getIPCService();
            Object src = e.getSource();
            if (src == this.owner.btnClear) {
                this.owner.manager.clear();
            } else if (src == this.owner.btnSelect) {
                ipc.publish(this, "isql-sql-message", this.owner.txtSQL.getText());
            } else if (src == this.owner.btnExec) {
                ipc.publish(this, "isql-sql-execute", this.owner.txtSQL.getText());
            }
            this.owner.dispose();
        }
    }
}

