/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.ActionPopupMenu;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.core.model.MetadataTreeModel;
import org.isqlviewer.core.model.SQLTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.JDBCTreeCellRenderer;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.ui.ExportWizard;
import org.isqlviewer.ui.MainFrame;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.ui.TableSelector;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public final class JDBCExplorer
extends JFrame {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private boolean debug = false;
    private boolean verbose = false;
    private final Properties NULL_TABLE = new Properties();
    private String currentCatalog;
    private String currentSchema;
    private DatabaseMetaData metadata;
    private DatabaseConnection connection;
    private ActionInputHandler actionHandler = new ActionInputHandler();
    private TableSelector tsExplorer;
    private TableSelector tsPrimary;
    private TableSelector tsForiegn;
    private MetadataTreeModel mdlMetadata = new MetadataTreeModel(null);
    private SQLTableModel mdlXref = new SQLTableModel();
    private SQLTableModel mdlMeta = new SQLTableModel();
    private JButton btnPrint = new JButton(BasicUtilities.loadToolbarIconResource("Print"));
    private JButton btnPreview = new JButton(BasicUtilities.loadToolbarIconResource("PrintPreview"));
    private JButton btnDeleteRowColumn = new JButton(BasicUtilities.loadToolbarIconResource("RowDelete"));
    private JButton btnExportTable = new JButton(BasicUtilities.loadToolbarIconResource("Export"));
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnXRef = new JButton(BasicUtilities.loadIconResource("Query24"));
    private ITable tabMeta = new ITable();
    private ITable tabXref = new ITable();
    private JTabbedPane jtpMain = new JTabbedPane(1);
    private JTree treMetadata = new JTree();
    private JSplitPane jspJDBC = new JSplitPane(1);
    private ActionPopupMenu mnuSQLPopup = new ActionPopupMenu("CREATE SQL");
    private static JDBCExplorer instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Class<JDBCExplorer> clazz = JDBCExplorer.class;
        synchronized (JDBCExplorer.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static int showDialog(MainFrame frame) {
        if (instance != null) {
            instance.toFront();
            return 0;
        }
        try {
            instance = new JDBCExplorer(frame, frame.getJDBCConnection());
        }
        catch (Error err) {
            String msg = BasicUtilities.getString("Fatal_Error_Occured");
            BasicUtilities.showExceptionPopup(frame, err, msg);
            return -1;
        }
        catch (Exception ex) {
            String msg = BasicUtilities.getString("General_Exception_Occured");
            BasicUtilities.showExceptionPopup(frame, ex, msg);
            return -1;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, BasicUtilities.getString("JDBCExplorerNotSupported"));
            return -1;
        }
        instance.restoreSession();
        instance.show();
        return 0;
    }

    private JDBCExplorer(Frame owner, DatabaseConnection cnx) {
        super(BasicUtilities.getString("JDBCExplorer_Title"), owner.getGraphicsConfiguration());
        try {
            this.initUI();
            this.setConnection(cnx);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "JDBCExplorer()::initUI()");
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.saveSession();
            if (this.connection != null) {
                this.connection.flushConnectionInfo();
            }
            SystemConfig.getInstance().getIPCService().unSubscribeAll(this.actionHandler);
        }
        super.processWindowEvent(e);
    }

    private void setConnection(DatabaseConnection cnx) {
        this.mdlMetadata.updateConnection(cnx);
        if (cnx != null) {
            this.btnXRef.setEnabled(true);
            this.debug = cnx.getDebugOn();
            this.verbose = cnx.getVerboseOn();
            this.connection = cnx;
            this.metadata = cnx.getDatabaseInformation();
            this.mnuSQLPopup.removeAll();
            this.mnuSQLPopup.add(BasicUtilities.getString("JDBCExplorer_SQL_Create")).setEnabled(false);
            SQLTemplateAction action = new SQLTemplateAction(this.treMetadata, this.metadata, 4);
            action.putValue("Name", "DROP");
            this.mnuSQLPopup.add(action);
            this.mnuSQLPopup.addSeparator();
            action = new SQLTemplateAction(this.treMetadata, this.metadata, 0);
            action.putValue("Name", "SELECT");
            this.mnuSQLPopup.add(action);
            action = new SQLTemplateAction(this.treMetadata, this.metadata, 1);
            action.putValue("Name", "INSERT");
            this.mnuSQLPopup.add(action);
            action = new SQLTemplateAction(this.treMetadata, this.metadata, 3);
            action.putValue("Name", "UPDATE");
            this.mnuSQLPopup.add(action);
            action = new SQLTemplateAction(this.treMetadata, this.metadata, 2);
            action.putValue("Name", "DELETE");
            this.mnuSQLPopup.add(action);
            this.tsExplorer.updateMetaData(cnx);
            this.tsPrimary.updateMetaData(cnx);
            this.tsForiegn.updateMetaData(cnx);
            this.tsExplorer.setSelectedSchema(cnx.getSchema());
            this.tsPrimary.setSelectedSchema(cnx.getSchema());
            this.tsForiegn.setSelectedSchema(cnx.getSchema());
            this.treMetadata.setModel(this.mdlMetadata);
            this.mdlMetadata.setCatalog(this.tsExplorer.getSelectedCatalog(), false);
            this.mdlMetadata.setSchema(this.tsExplorer.getSelectedSchema(), false);
            this.mdlMetadata.reload();
            this.jspJDBC.setDividerLocation(this.treMetadata.getPreferredSize().width + this.jspJDBC.getDividerSize());
        } else {
            this.mnuSQLPopup.removeAll();
            this.tsPrimary.updateMetaData(null);
            this.tsForiegn.updateMetaData(null);
            this.tsExplorer.updateMetaData(null);
            this.connection = null;
            this.metadata = null;
            this.btnXRef.setEnabled(false);
        }
    }

    private void initUI() throws Exception {
        this.setDefaultCloseOperation(2);
        try {
            if (!BasicUtilities.isMac()) {
                Image img = ((ImageIcon)BasicUtilities.loadIconResource("Information24")).getImage();
                this.setIconImage(img);
            }
        }
        catch (Throwable img) {
            // empty catch block
        }
        SystemConfig.getInstance().getIPCService().subscribe(this.actionHandler, "isql-service-change");
        this.NULL_TABLE.setProperty(BasicUtilities.getString("Error"), BasicUtilities.getString("Data_Unavailable"));
        this.tsExplorer = new TableSelector(null, false);
        this.tsPrimary = new TableSelector(null, true);
        this.tsForiegn = new TableSelector(null, true);
        this.tabMeta.setModel(this.mdlMeta);
        this.tabMeta.setDragEnabled(true);
        this.tabXref.setModel(this.mdlXref);
        this.tabXref.setDragEnabled(true);
        this.tsPrimary.setBorder(BorderFactory.createTitledBorder(BasicUtilities.getString("Select_Primary_Table")));
        this.tsForiegn.setBorder(BorderFactory.createTitledBorder(BasicUtilities.getString("Select_Foreign_Table")));
        this.tabMeta.addActionListener(this.actionHandler);
        this.tabXref.addActionListener(this.actionHandler);
        this.tsExplorer.addChangeListener(this.actionHandler);
        this.jspJDBC.setLeftComponent(new JScrollPane(this.treMetadata));
        this.jspJDBC.setRightComponent(new JScrollPane(this.tabMeta));
        this.jspJDBC.setBorder(BorderFactory.createEmptyBorder());
        this.btnPreview.addActionListener(this.actionHandler);
        this.btnPrint.addActionListener(this.actionHandler);
        this.btnDeleteRowColumn.addActionListener(this.actionHandler);
        this.btnExportTable.addActionListener(this.actionHandler);
        this.btnOK.addActionListener(this.actionHandler);
        this.btnXRef.addActionListener(this.actionHandler);
        this.btnXRef.setAlignmentY(0.5f);
        this.btnXRef.setBorderPainted(!BasicUtilities.isMac());
        this.btnXRef.setFocusPainted(false);
        this.btnXRef.setMargin(BasicUtilities.isMac() ? new Insets(2, 3, 2, 3) : new Insets(1, 1, 1, 1));
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.btnXRef.setToolTipText(BasicUtilities.getString("Query_Cross_References"));
        ActionToolBar jtbMain = ActionToolBar.createNullInstance();
        jtbMain.setOrientation(0);
        jtbMain.setFloatable(false);
        ((Container)jtbMain).add(this.btnPreview);
        ((Container)jtbMain).add(this.btnPrint);
        ((Container)jtbMain).add(this.btnDeleteRowColumn);
        ((Container)jtbMain).add(this.btnExportTable);
        ((Container)jtbMain).add(Box.createVerticalGlue());
        this.treMetadata.setModel(this.mdlMetadata);
        this.treMetadata.getSelectionModel().setSelectionMode(4);
        this.treMetadata.addMouseListener(this.actionHandler);
        this.treMetadata.addTreeExpansionListener(this.actionHandler);
        this.treMetadata.addTreeSelectionListener(this.actionHandler);
        this.treMetadata.setCellRenderer(new JDBCTreeCellRenderer());
        JPanel xrefPanel = new JPanel(new GridBagLayout());
        JDBCExplorer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
        xrefPanel.add((Component)this.tsPrimary, UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 1, 1, 1, 1.0, 0.0, 10, 2);
        xrefPanel.add((Component)this.tsForiegn, UI_CONSTRAINT);
        JDBCExplorer.constrain(1, 1, 1, 1, 0.0, 0.0, 15, 0);
        xrefPanel.add((Component)this.btnXRef, UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 2, 2, 1, 0.0, 0.0, 16, 0);
        xrefPanel.add((Component)new JLabel(BasicUtilities.getString("XRefs_Results_Will_Show_Here")), UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 3, 2, 1, 1.0, 1.0, 10, 1);
        xrefPanel.add((Component)new JScrollPane(this.tabXref), UI_CONSTRAINT);
        JPanel expPanel = new JPanel(new GridBagLayout());
        JDBCExplorer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
        expPanel.add((Component)this.tsExplorer, UI_CONSTRAINT);
        JDBCExplorer.constrain(0, 1, 1, 1, 1.0, 1.0, 10, 1);
        expPanel.add((Component)this.jspJDBC, UI_CONSTRAINT);
        JPanel okPanel = new JPanel(new GridBagLayout());
        JDBCExplorer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
        okPanel.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        JDBCExplorer.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
        okPanel.add((Component)this.btnOK, UI_CONSTRAINT);
        this.jtpMain.addTab(BasicUtilities.getString("Database_Objects"), expPanel);
        this.jtpMain.addTab(BasicUtilities.getString("Cross_Refrences"), xrefPanel);
        this.jtpMain.addChangeListener(this.actionHandler);
        this.getContentPane().add((Component)jtbMain, "North");
        this.getContentPane().add((Component)okPanel, "South");
        this.getContentPane().add((Component)this.jtpMain, "Center");
        this.pack();
    }

    private ITable getActiveTable() {
        int index = this.jtpMain.getSelectedIndex();
        if (index == 0) {
            return this.tabMeta;
        }
        if (index == 1) {
            return this.tabXref;
        }
        return null;
    }

    private void enableActions() {
        ITable current = this.getActiveTable();
        boolean f = false;
        if (current != null) {
            TableModel model = current.getModel();
            f = model != null ? model.getRowCount() >= 1 : false;
        }
        this.btnDeleteRowColumn.setEnabled(f);
        this.btnExportTable.setEnabled(f);
        this.btnPreview.setEnabled(f);
        this.btnPrint.setEnabled(f);
    }

    private void processAction(ActionEvent e) {
        boolean xRefTabSelected = this.jtpMain.getSelectedIndex() == 1;
        ITable current = this.getActiveTable();
        if (current == null) {
            return;
        }
        EnhancedTableModel model = (EnhancedTableModel)current.getModel();
        JFrame frm = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        Object obj = e.getSource();
        if (obj == this.btnPreview) {
            String title = xRefTabSelected ? BasicUtilities.getString("Cross_Refrences") : this.treMetadata.getSelectionPath().toString();
            PrinterPreview.showPrintPreviewDialog(frm, (Object)new JTable(model), title);
        } else if (obj == this.tabMeta) {
            if (this.tabMeta.getRowSelectionAllowed()) {
                this.btnDeleteRowColumn.setIcon(BasicUtilities.loadToolbarIconResource("RowDelete"));
            } else {
                this.btnDeleteRowColumn.setIcon(BasicUtilities.loadToolbarIconResource("ColumnDelete"));
            }
        } else if (obj == this.btnExportTable) {
            ExportWizard wiz = new ExportWizard((Frame)frm, model, this.connection);
            wiz.show();
        } else if (obj == this.btnXRef) {
            String pCat = this.tsPrimary.getSelectedCatalog();
            String pScm = this.tsPrimary.getSelectedSchema();
            String pTab = this.tsPrimary.getSelectedTable();
            String fCat = this.tsForiegn.getSelectedCatalog();
            String fScm = this.tsForiegn.getSelectedSchema();
            String fTab = this.tsForiegn.getSelectedTable();
            try {
                if (this.tsPrimary.compareSelection(this.tsForiegn)) {
                    String err = BasicUtilities.getString("Cross_Reference_Check_Error", pTab);
                    JOptionPane.showMessageDialog(this, err);
                    return;
                }
                ResultSet set = this.metadata.getCrossReference(pCat, pScm, pTab, fCat, fScm, fTab);
                this.modelResultSet(set);
            }
            catch (SQLException sqle) {
                this.modelResultSet(null);
                String[] params = new String[]{pTab, sqle.getMessage()};
                String msg = BasicUtilities.getString("Cross_Reference_Error", params);
                BasicUtilities.showExceptionPopup(this, sqle, msg);
            }
        } else if (obj == this.btnOK) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (obj == this.btnPrint) {
            PrinterPreview.print(current, xRefTabSelected ? BasicUtilities.getString("Cross_Refrences") : this.treMetadata.getSelectionPath().toString());
        } else if (obj == this.btnDeleteRowColumn) {
            if (current.getRowSelectionAllowed()) {
                BasicUtilities.removeSelectedRows(current);
            } else if (current.getColumnSelectionAllowed()) {
                BasicUtilities.removeSelectedColumns(current);
            }
        }
    }

    private void restoreSession() {
        UserPreferences preferences = SystemConfig.getInstance().getPreferences();
        BasicUtilities.setPreferredGeometry(this, new Dimension(640, 480), "JDBCExplorer.bounds");
        String key = "session.".concat("JDBCExplorer.tab.index");
        this.tsExplorer.setSelectedSchema(preferences.get("session.".concat("JDBCExplorer.schema")));
        this.tsExplorer.setSelectedCatalog(preferences.get("session.".concat("JDBCExplorer.catalog")));
        int loc = preferences.getInt(key);
        if (loc < 0) {
            loc = 0;
        }
        this.jtpMain.setSelectedIndex(loc);
    }

    private void saveSession() {
        UserPreferences preferences = SystemConfig.getInstance().getPreferences();
        preferences.putRect("session.".concat("JDBCExplorer.bounds"), this.getBounds());
        String value = this.tsExplorer.getSelectedSchema();
        if (value != null) {
            preferences.put("session.".concat("JDBCExplorer.schema"), value);
        } else {
            preferences.clear("session.".concat("JDBCExplorer.schema"));
        }
        value = this.tsExplorer.getSelectedCatalog();
        if (value != null) {
            preferences.put("session.".concat("JDBCExplorer.catalog"), value);
        } else {
            preferences.clear("session.".concat("JDBCExplorer.catalog"));
        }
        int loc = this.jtpMain.getSelectedIndex();
        preferences.putInt("session.".concat("JDBCExplorer.tab.index"), loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modelResultSet(ResultSet set) {
        ITable current = this.getActiveTable();
        if (current == null) {
            throw new IllegalStateException();
        }
        SQLTableModel model = (SQLTableModel)current.getModel();
        try {
            if (set != null) {
                model.setData(set);
            } else {
                model.setData(this.NULL_TABLE);
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "JDBCExplorer::modelResultSet(ResultSet, boolean)");
            model.setData(this.NULL_TABLE);
        }
        finally {
            PrintWriter pw;
            try {
                SQLWarningViewer.addResultsetWarnings(set.getWarnings());
            }
            catch (SQLException sqle) {
                pw = DriverManager.getLogWriter();
                if (pw != null) {
                    BasicUtilities.HandleException((Throwable)sqle, "ResultSet::getWarnings()", true, pw);
                }
            }
            catch (Throwable sqle) {}
            try {
                set.close();
            }
            catch (SQLException sqle) {
                pw = DriverManager.getLogWriter();
                if (pw != null) {
                    BasicUtilities.HandleException((Throwable)sqle, "ResultSet::close()", true, pw);
                }
            }
            catch (Throwable sqle) {}
            BasicUtilities.optimizeTableView(current);
            this.enableActions();
        }
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        JDBCExplorer.UI_CONSTRAINT.gridx = x;
        JDBCExplorer.UI_CONSTRAINT.gridy = y;
        JDBCExplorer.UI_CONSTRAINT.gridwidth = w;
        JDBCExplorer.UI_CONSTRAINT.gridheight = h;
        JDBCExplorer.UI_CONSTRAINT.weightx = wx;
        JDBCExplorer.UI_CONSTRAINT.weighty = wy;
        JDBCExplorer.UI_CONSTRAINT.anchor = a;
        JDBCExplorer.UI_CONSTRAINT.fill = f;
    }

    private static class SQLTemplateAction
    extends AbstractAction {
        public static final int SQL_SELECT = 0;
        public static final int SQL_INSERT = 1;
        public static final int SQL_DELETE = 2;
        public static final int SQL_UPDATE = 3;
        public static final int SQL_DROP = 4;
        private JTree treeReference = null;
        private int templateType = -1;
        private DatabaseMetaData dmd = null;
        private StringBuffer sql = new StringBuffer("");

        public SQLTemplateAction(JTree context, DatabaseMetaData md, int type) {
            this.treeReference = context;
            this.templateType = type;
            this.dmd = md;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sql.setLength(0);
            switch (this.templateType) {
                case 0: {
                    this.generateSelect();
                    break;
                }
                case 1: {
                    this.generateInsert();
                    break;
                }
                case 2: 
                case 3: {
                    this.generateDelete();
                    break;
                }
                case 4: {
                    this.generateDrop();
                }
            }
            IPCService ipc = SystemConfig.getInstance().getIPCService();
            if (this.sql.length() >= 1) {
                ipc.publish(e.getSource(), "isql-sql-message", this.sql.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateSelect() {
            TreePath[] paths = this.treeReference.getSelectionPaths();
            StringBuffer fromClause = new StringBuffer("\nFROM\n ");
            StringBuffer subBuffer = new StringBuffer("");
            MetadataTreeModel mdl = (MetadataTreeModel)this.treeReference.getModel();
            this.sql.append("SELECT\n ");
            String baseTable = null;
            for (int i = 0; i < paths.length; ++i) {
                String table;
                String owner;
                TreePath path = paths[i];
                int depth = path.getPathCount();
                if (depth == 3 && baseTable == null) {
                    owner = mdl.getCurrentSchema();
                    table = path.getLastPathComponent().toString();
                    ResultSet set = null;
                    try {
                        set = this.dmd.getColumns(mdl.getCurrentCatlog(), mdl.getCurrentSchema(), table.trim(), "%");
                        Object[] columns = JDBCUtilities.getSingleColumn(set, "COLUMN_NAME", null);
                        for (int j = 0; j < columns.length - 1; ++j) {
                            subBuffer.append(columns[j]);
                            subBuffer.append(", ");
                        }
                        subBuffer.append(columns[columns.length - 1]);
                        this.sql.append("   ");
                        this.sql.append(StringUtilities.formatBreak(80, subBuffer.toString(), "   ", false));
                        subBuffer.setLength(0);
                        this.sql.append("\nFROM\n   ");
                        table = owner == null || owner.length() == 0 ? "" : owner.concat(".".concat(table));
                        this.sql.append(table);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable) {}
                        set = null;
                    }
                    fromClause.setLength(0);
                    return;
                }
                if (depth != 5) continue;
                owner = mdl.getCurrentSchema();
                table = path.getPath()[2].toString();
                table = owner == null || owner.length() == 0 ? "" : owner.concat(".".concat(table));
                String column = path.getLastPathComponent().toString();
                if (baseTable != null && !table.equalsIgnoreCase(baseTable)) continue;
                this.sql.append(column);
                if (i + 1 < paths.length) {
                    this.sql.append(", ");
                }
                if (i != 0) continue;
                baseTable = table;
                fromClause.append(baseTable);
            }
            this.sql.append(fromClause);
            fromClause.setLength(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateInsert() {
            TreePath[] paths = this.treeReference.getSelectionPaths();
            StringBuffer subBuff = new StringBuffer("");
            MetadataTreeModel mdl = (MetadataTreeModel)this.treeReference.getModel();
            this.sql.append("INSERT INTO\n {0}\n( ");
            String baseTable = null;
            for (int i = 0; i < paths.length; ++i) {
                String table;
                TreePath path = paths[i];
                int depth = path.getPathCount();
                if (depth == 3 && baseTable == null) {
                    table = path.getLastPathComponent().toString();
                    ResultSet set = null;
                    try {
                        int j;
                        set = this.dmd.getColumns(mdl.getCurrentCatlog(), mdl.getCurrentSchema(), table.trim(), "%");
                        subBuff.setLength(0);
                        Object[] columns = JDBCUtilities.getSingleColumn(set, "COLUMN_NAME", null);
                        for (j = 0; j < columns.length - 1; ++j) {
                            subBuff.append(columns[j]);
                            subBuff.append(", ");
                        }
                        subBuff.append(columns[columns.length - 1]);
                        this.sql.append(StringUtilities.formatBreak(80, subBuff.toString(), "  ", false));
                        this.sql.append(")\nVALUES\n( ");
                        subBuff.setLength(0);
                        for (j = 0; j < columns.length - 1; ++j) {
                            subBuff.append("&");
                            subBuff.append(columns[j]);
                            subBuff.append(", ");
                        }
                        subBuff.append("&");
                        subBuff.append(columns[columns.length - 1]);
                        this.sql.append(StringUtilities.formatBreak(80, subBuff.toString(), "  ", false));
                        this.sql.append(")");
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t);
                    }
                    finally {
                        try {
                            set.close();
                        }
                        catch (Throwable columns) {}
                        set = null;
                    }
                    String real = MessageFormat.format(this.sql.toString(), table);
                    this.sql.setLength(0);
                    this.sql.append(real);
                    return;
                }
                if (depth != 5) continue;
                table = path.getPath()[2].toString();
                String column = path.getLastPathComponent().toString();
                if (baseTable != null && !table.equalsIgnoreCase(baseTable)) continue;
                this.sql.append(column);
                subBuff.append("&");
                subBuff.append(column);
                if (i + 1 < paths.length) {
                    this.sql.append(", ");
                    subBuff.append(", ");
                }
                if (i != 0) continue;
                baseTable = table;
            }
            this.sql.append(")\nVALUES\n (");
            this.sql.append(StringUtilities.formatBreak(80, subBuff.toString(), "  ", false));
            this.sql.append(")");
            String real = MessageFormat.format(this.sql.toString(), baseTable);
            this.sql.setLength(0);
            subBuff.setLength(0);
            this.sql.append(real);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateDelete() {
            TreePath[] paths = this.treeReference.getSelectionPaths();
            StringBuffer fromClause = new StringBuffer("");
            MetadataTreeModel mdl = (MetadataTreeModel)this.treeReference.getModel();
            if (this.templateType == 2) {
                this.sql.append("DELETE FROM\n {0}\nWHERE\n ");
            } else {
                this.sql.append("UPDATE\n {0}\nSET\n ");
            }
            String baseTable = null;
            int nicebreak = this.sql.length() + 80;
            for (int i = 0; i < paths.length; ++i) {
                String table;
                TreePath path = paths[i];
                int depth = path.getPathCount();
                if (depth == 3 && baseTable == null) {
                    table = path.getLastPathComponent().toString();
                    ResultSet set = null;
                    try {
                        set = this.dmd.getColumns(mdl.getCurrentCatlog(), mdl.getCurrentSchema(), table.trim(), "%");
                        Object[] columns = JDBCUtilities.getSingleColumn(set, "COLUMN_NAME", null);
                        for (int j = 0; j < columns.length - 1; ++j) {
                            if (nicebreak < this.sql.length() + 2 * columns[j].toString().length() + 4) {
                                this.sql.append("\n ");
                                nicebreak = this.sql.length() + 80;
                            }
                            this.sql.append(columns[j]);
                            this.sql.append("=&");
                            this.sql.append(columns[j]);
                            if (this.templateType == 3) {
                                this.sql.append(", ");
                                continue;
                            }
                            this.sql.append(" AND ");
                        }
                        this.sql.append(columns[columns.length - 1]);
                        this.sql.append("=&");
                        this.sql.append(columns[columns.length - 1]);
                        this.sql.append(" ");
                    }
                    catch (Throwable columns) {
                    }
                    finally {
                        try {
                            set.close();
                        }
                        catch (Throwable columns) {}
                        set = null;
                    }
                    String real = MessageFormat.format(this.sql.toString(), table);
                    this.sql.setLength(0);
                    this.sql.append(real);
                    return;
                }
                if (depth != 5) continue;
                table = path.getPath()[2].toString();
                String column = path.getLastPathComponent().toString();
                if (baseTable != null && !table.equalsIgnoreCase(baseTable)) continue;
                if (nicebreak < this.sql.length() + 2 * column.length() + 4) {
                    this.sql.append("\n ");
                    nicebreak = this.sql.length() + 80;
                }
                this.sql.append(column);
                this.sql.append(" = &");
                this.sql.append(column);
                if (i + 1 < paths.length) {
                    if (this.templateType == 3) {
                        this.sql.append(", ");
                    } else {
                        this.sql.append(" AND ");
                    }
                }
                if (i != 0) continue;
                baseTable = table;
            }
            String real = MessageFormat.format(this.sql.toString(), baseTable);
            this.sql.setLength(0);
            this.sql.append(real);
            fromClause.setLength(0);
        }

        private void generateDrop() {
            MetadataTreeModel mdl = (MetadataTreeModel)this.treeReference.getModel();
            TreePath[] paths = this.treeReference.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                String table;
                TreePath path = paths[i];
                int depth = path.getPathCount();
                String owner = mdl.getCurrentSchema();
                String string = table = path.getPath().length >= 3 ? path.getPath()[2].toString() : "";
                if (depth == 3) {
                    this.sql.append("DROP TABLE\n ");
                    table = owner == null || owner.length() == 0 ? "" : owner.concat(".".concat(table));
                    this.sql.append(table);
                    this.sql.append("\n&RESTRICT_OR_CASCADE;\n");
                    continue;
                }
                String fqtn = owner == null || owner.length() == 0 ? "" : owner.concat(".".concat(table));
                this.sql.append("ALTER TABLE ");
                this.sql.append(fqtn);
                this.sql.append("\n\tDROP COLUMN ");
                this.sql.append(path.getLastPathComponent());
                this.sql.append(" &RESTRICT_OR_CASCADE");
                this.sql.append(path.getLastPathComponent().toString().toUpperCase());
                this.sql.append(";\n");
            }
        }
    }

    private class ActionInputHandler
    extends MouseInputAdapter
    implements ActionListener,
    IPCListener,
    ChangeListener,
    TreeSelectionListener,
    TreeExpansionListener {
        private ActionInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private boolean doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TreePath path = JDBCExplorer.this.treMetadata.getSelectionPath();
                if (path == null) {
                    return false;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                int count = path.getPathCount();
                if (path != null && JDBCExplorer.this.mdlMetadata.isTableTypeNode(node) && (count == 5 || count == 3)) {
                    JDBCExplorer.this.mnuSQLPopup.show(e.getComponent(), e.getX(), e.getY());
                }
                e.consume();
                return true;
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            Object src = ce.getSource();
            if (src == JDBCExplorer.this.tsExplorer) {
                if (JDBCExplorer.this.mdlMeta == null || JDBCExplorer.this.connection == null) {
                    return;
                }
                JDBCExplorer.this.currentCatalog = JDBCExplorer.this.tsExplorer.getSelectedCatalog();
                JDBCExplorer.this.currentSchema = JDBCExplorer.this.tsExplorer.getSelectedSchema();
                JDBCExplorer.this.mdlMetadata.setCatalog(JDBCExplorer.this.currentCatalog, false);
                JDBCExplorer.this.mdlMetadata.setSchema(JDBCExplorer.this.currentSchema, false);
                JDBCExplorer.this.mdlMetadata.reload();
            } else if (src == JDBCExplorer.this.jtpMain) {
                JDBCExplorer.this.enableActions();
            }
        }

        @Override
        public void receiveMessage(Object src, String topic, Object msg) {
            if (topic != null && topic.equals("isql-service-change")) {
                JDBCExplorer.this.setConnection((DatabaseConnection)msg);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JDBCExplorer.this.processAction(e);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
            finally {
                JDBCExplorer.this.enableActions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (JDBCExplorer.this.mdlMeta == null || JDBCExplorer.this.connection == null) {
                return;
            }
            if (!JDBCExplorer.this.btnExportTable.isEnabled()) {
                JDBCExplorer.this.btnExportTable.setEnabled(true);
            }
            JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                String selection = (String)node.getUserObject();
                if (!(JDBCExplorer.this.mdlMetadata.isProcedureNode(node) || JDBCExplorer.this.mdlMetadata.isTableTypeNode(node) || node.getRoot().equals(node))) {
                    switch (node.getParent().getIndex(node) - JDBCExplorer.this.mdlMetadata.getTableTypeCount()) {
                        case 0: {
                            JDBCExplorer.this.mdlMeta.setData(JDBCExplorer.this.connection.getConnectionInformation());
                            return;
                        }
                        case 1: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getSchemas());
                            return;
                        }
                        case 2: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getCatalogs());
                            return;
                        }
                        case 3: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTableTypes());
                            return;
                        }
                        case 4: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTypeInfo());
                            return;
                        }
                        case 5: {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getUDTs(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, null, null));
                            return;
                        }
                        default: {
                            JDBCExplorer.this.modelResultSet(null);
                            return;
                        }
                    }
                }
                String[] param = new String[]{selection.trim()};
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
                switch (node.getLevel()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        if (JDBCExplorer.this.mdlMetadata.isTableTypeNode(node)) {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTables(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, null, param));
                            return;
                        } else {
                            if (!JDBCExplorer.this.mdlMetadata.isProcedureNode(node)) return;
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getProcedures(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, null));
                            return;
                        }
                    }
                    case 2: {
                        String[] types = new String[]{node.getPath()[1].toString().trim()};
                        if (JDBCExplorer.this.mdlMetadata.isTableTypeNode(parentNode)) {
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTables(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, selection, types));
                            return;
                        } else {
                            if (!JDBCExplorer.this.mdlMetadata.isProcedureNode(parentNode)) return;
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getProcedures(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, selection));
                            return;
                        }
                    }
                    case 3: {
                        DefaultMutableTreeNode typeNode = (DefaultMutableTreeNode)node.getPath()[1];
                        if (JDBCExplorer.this.mdlMetadata.isProcedureNode(typeNode)) {
                            String proc = node.getPath()[2].toString();
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getProcedureColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, proc, null));
                            return;
                        }
                        String str = node.getUserObject().toString();
                        String Table = node.getPath()[2].toString();
                        try {
                            if (str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Columns"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table, null));
                                return;
                            }
                            if (str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Indicies"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getIndexInfo(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table, false, false));
                                return;
                            }
                            if (str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Primary_Keys"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getPrimaryKeys(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table));
                                return;
                            }
                            if (str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Exported_Keys"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getExportedKeys(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table));
                                return;
                            }
                            if (str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Imported_Keys"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getImportedKeys(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table));
                                return;
                            }
                            if (str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Version_Columns"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getVersionColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table));
                                return;
                            }
                            if (str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Table_Privileges"))) {
                                JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getTablePrivileges(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table));
                                return;
                            }
                            if (!str.equalsIgnoreCase(BasicUtilities.getString("JDBC_Column_Privileges"))) return;
                            JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getColumnPrivileges(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table, null));
                            return;
                        }
                        catch (Throwable t) {
                            BasicUtilities.HandleException(t, BasicUtilities.getString("JDBC_MetaData_View_Error", node.toString()), JDBCExplorer.this.debug);
                            return;
                        }
                    }
                    case 4: {
                        String Table = node.getPath()[2].toString();
                        JDBCExplorer.this.modelResultSet(JDBCExplorer.this.metadata.getColumns(JDBCExplorer.this.currentCatalog, JDBCExplorer.this.currentSchema, Table, node.getUserObject().toString()));
                        return;
                    }
                    default: {
                        JDBCExplorer.this.modelResultSet(null);
                        return;
                    }
                }
            }
            catch (SQLException sqle) {
                JDBCExplorer.this.modelResultSet(null);
                if (!JDBCExplorer.this.verbose) return;
                BasicUtilities.HandleException(sqle, null, JDBCExplorer.this.debug);
                return;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "JDBCExplorer::valueChanged(TreeSelectionEvent)");
                JDBCExplorer.this.treMetadata.clearSelection();
                JDBCExplorer.this.modelResultSet(null);
                return;
            }
            finally {
                JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                if (!JDBCExplorer.this.mdlMetadata.isUncachedNode(node)) return;
                switch (node.getLevel()) {
                    case 1: {
                        JDBCExplorer.this.mdlMetadata.loadTableTypeNode(node, node.toString());
                        return;
                    }
                    case 2: {
                        JDBCExplorer.this.mdlMetadata.loadTableChildNodes(node);
                        return;
                    }
                    case 3: {
                        JDBCExplorer.this.mdlMetadata.loadColumnChildNodes(node);
                        return;
                    }
                }
                return;
            }
            catch (Throwable t) {
                JDBCExplorer.this.modelResultSet(null);
                if (!JDBCExplorer.this.verbose) return;
                BasicUtilities.HandleException(t, null, JDBCExplorer.this.debug);
                return;
            }
            finally {
                JDBCExplorer.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
        }
    }
}

