/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.CoreAction;
import org.isqlviewer.core.action.DefaultActionManager;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.event.DatabaseEvent;
import org.isqlviewer.event.DatabaseListener;
import org.isqlviewer.sql.BatchRunner;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.BookmarkEditor;
import org.isqlviewer.swing.BookmarkTreeCellRenderer;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.swing.JDrawer;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.AboutBox;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.ui.BatchWizard;
import org.isqlviewer.ui.DataMigrator;
import org.isqlviewer.ui.HistoryViewer;
import org.isqlviewer.ui.ImportWizard;
import org.isqlviewer.ui.JDBCExplorer;
import org.isqlviewer.ui.LoginOptionPane;
import org.isqlviewer.ui.PreferencesEditor;
import org.isqlviewer.ui.QueryWizard;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.ui.ScriptManager;
import org.isqlviewer.ui.ServiceManager;
import org.isqlviewer.ui.TableEditor;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class MainFrame
extends JFrame
implements AppController {
    private static final long serialVersionUID = 1L;
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    protected final ThreadGroup BATCH_THREADS = new ThreadGroup("isql-batch-threads");
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private UserPreferences preferences = this.sysConfig.getPreferences();
    private ServiceDefinition serviceDef;
    private DatabaseConnection databaseConnection;
    private String _clusterName;
    private Thread actionThread;
    private MainToolbar fileBar;
    private SQLWorkBench workbench;
    private ActionManager actionManager = null;
    private ActionManagerHandler actionHandler = new ActionManagerHandler();
    private JConsole sysOut = new JConsole(BasicUtilities.getString("Default_Console_String") + "\n");
    private TreeDropTarget dndHandler = new TreeDropTarget();
    private JDrawer bookDrawer = null;
    private JSplitPane rootPane = new JSplitPane(0);
    private JTree treBookmarks = null;
    private JPanel contentPane = new JPanel(new BorderLayout());
    private JPanel statusBar = null;
    private JLabel lblInfo = new JLabel("", 2);
    private JLabel lblCommit = new JLabel(" " + BasicUtilities.getString("AutoCommit_ON") + " ", 0);
    private DragSource dndDragSource = DragSource.getDefaultDragSource();
    private JTextComponent defaultComponent = null;
    private String currentStatus = "";
    private WizardPanel panel = new WizardPanel();
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    public MainFrame() {
        super("iSQL-Viewer v.2.1.8");
        JFrame.setDefaultLookAndFeelDecorated(false);
        if (BasicUtilities.isMac()) {
            try {
                Class<?> c = Class.forName("org.isqlviewer.mrj.MRJAdapter");
                c.getConstructor(MainFrame.class).newInstance(this);
                System.setProperty("isql.mrj.enabled", "true");
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "mrj:<init>");
            }
        }
        this.enableEvents(24L);
        this.actionManager = new DefaultActionManager();
        HistoryManager historyManager = this.sysConfig.getHistoryManager();
        historyManager.addChangeListener(this.actionHandler);
        boolean f = historyManager.size() >= 1;
        this.actionManager.setActionEnabled(7, f);
        this.actionManager.setActionEnabled(48, false);
        this.actionManager.addActionListener(this.actionHandler);
        this.actionManager.addItemListener(this.actionHandler);
        this.actionManager.addPropertyChangeListener(this.actionHandler);
        this.actionThread = new Thread((Runnable)this.actionManager, "action-manager-thread");
        this.actionThread.setDaemon(true);
        this.actionThread.start();
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "MainFrame::initUI()");
            System.exit(-1);
            return;
        }
    }

    public void setDBConnection(DatabaseConnection dbConnection) {
        this.databaseConnection = dbConnection;
    }

    public SQLWorkBench getWorkBench() {
        return this.workbench;
    }

    @Override
    public void addAccessory(int location, JComponent view) {
        Container root = this.getContentPane();
        switch (location) {
            case 3: 
            case 4: {
                root.add((Component)view, "East");
                break;
            }
            case 2: 
            case 7: {
                root.add((Component)view, "West");
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(location));
            }
        }
    }

    @Override
    public void removeAccessory(int location, JComponent view) {
    }

    public void setClusterName(String clusterName) {
        this._clusterName = clusterName;
    }

    @Override
    public DatabaseConnection getJDBCConnection() {
        if (this._clusterName != null) {
            return SpaceBrowser.getInstance().getClusterDBConnection(this._clusterName);
        }
        return this.databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component zoomComponent(Component view) {
        Component old = this.panel.removeCard("ZOOM");
        if (view != null && view != old) {
            this.panel.add(view, "ZOOM");
            this.panel.showCard("ZOOM");
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
        }
        return old;
    }

    @Override
    public boolean validateConnection() {
        if (!this.isValidDatabaseConnection() && this.promptForService() != 1) {
            this.updateStatus(BasicUtilities.getString("Not_Connected"));
            System.out.println(BasicUtilities.getString("Invalid_Connection"));
            return false;
        }
        return true;
    }

    @Override
    public void disconnect() {
        if (this.databaseConnection == null) {
            System.out.println(BasicUtilities.getString("Not_Connected"));
            return;
        }
        if (this.databaseConnection.isClosed()) {
            this.updateStatus(BasicUtilities.getString("Already_Disconnected"));
        } else {
            if (!this.databaseConnection.getVerboseOn()) {
                System.out.println(BasicUtilities.getString("Disconnect_Message", this.databaseConnection.getConnectionName()));
            }
            this.databaseConnection.removeDatabaseListener(this.actionHandler);
            this.currentStatus = BasicUtilities.getString("Disconnected");
            try {
                String s = this.databaseConnection.getConnectionName();
                this.serviceDef.close();
                System.out.println(BasicUtilities.getString("Disconnect_Success", s));
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, BasicUtilities.getString("Disconnect_Exception"));
            }
            finally {
                this.actionManager.setActionEnabled(12, false);
                this.actionManager.setActionEnabled(14, false);
                this.actionManager.setActionEnabled(13, false);
                this.actionManager.setActionEnabled(48, false);
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
                this.databaseConnection = null;
                this.serviceDef = null;
            }
            this.updateStatus(this.currentStatus);
            IPCService ipc = this.sysConfig.getIPCService();
            ipc.publish(this, "isql-service-change", null);
        }
        try {
            DriverManager.getLogWriter().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public ActionManager getActionManager() {
        return this.actionManager;
    }

    @Override
    public void updateStatus(String status) {
        String[] p = new String[]{BasicUtilities.getString("Status"), status};
        this.lblInfo.setText(BasicUtilities.getString("Status_Label", p));
    }

    @Override
    public void changeService(String service) {
        if (this.serviceDef != null && this.serviceDef.getName().equals(service) && this.isValidDatabaseConnection()) {
            System.out.println(BasicUtilities.getString("Already_Connected_Message", service));
            return;
        }
        this.disconnect();
        this.actionManager.setActionEnabled(14, false);
        this.actionManager.setActionEnabled(13, false);
        this.actionManager.setActionEnabled(48, false);
        this.databaseConnection = null;
        ServiceProvider provider = this.sysConfig.getServiceProvider();
        try {
            this.serviceDef = provider.serviceForName(service);
        }
        catch (IllegalArgumentException iae) {
            BasicUtilities.showExceptionPopup(this, iae, null);
            return;
        }
        this.initTracing(this.serviceDef.getPreferences());
        try {
            this.databaseConnection = this.serviceDef.createConnection();
        }
        catch (ClassNotFoundException cnf) {
            String msg = BasicUtilities.getString("Connect_Failed", cnf.getMessage());
            BasicUtilities.HandleException(cnf, msg);
            System.err.println(BasicUtilities.getString("No_Class_Error", this.serviceDef.getDriverClass()));
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        catch (SQLException sqle) {
            String msg = BasicUtilities.getString("Connect_Failed", sqle.getMessage());
            System.err.println(msg);
            BasicUtilities.showExceptionPopup(this, sqle, msg);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        if (this.serviceDef.isPromptRequired()) {
            String[] newTokens = LoginOptionPane.showDialog(this);
            if (newTokens == null) {
                System.out.println(BasicUtilities.getString("Connect_Cancelled", service));
                this.databaseConnection = null;
                this.serviceDef.close();
                this.serviceDef = null;
                return;
            }
            this.databaseConnection.updateAutheticationTokens(newTokens[0], newTokens[1]);
        }
        try {
            if (!this.databaseConnection.gsConnect()) {
                SQLException error = this.databaseConnection.getLastError();
                String msg = BasicUtilities.getString("Connect_Failed", error.getMessage());
                System.err.println(msg);
                BasicUtilities.showExceptionPopup(this, this.databaseConnection.getLastError(), msg);
                this.databaseConnection = null;
                this.serviceDef.close();
                this.serviceDef = null;
                return;
            }
        }
        catch (SQLException sqle) {
            String msg = BasicUtilities.getString("Connect_Failed", sqle.getMessage());
            System.err.println(msg);
            BasicUtilities.showExceptionPopup(this, sqle, msg);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        catch (Throwable t) {
            String msg = BasicUtilities.getString("Connect_Failed", t.getMessage());
            BasicUtilities.HandleException(t, msg);
            this.databaseConnection = null;
            this.serviceDef.close();
            this.serviceDef = null;
            return;
        }
        System.out.println(BasicUtilities.getString("Connect_Sucess_Message", service));
        this.updateStatus(BasicUtilities.getString("Connect_Status", service));
        boolean f = this.databaseConnection.isTransactionsSupported();
        this.actionManager.setActionEnabled(12, f);
        f = this.databaseConnection.isSavePointsSupported();
        this.actionManager.setActionEnabled(48, f);
        this.databaseConnection.addDatabaseListener(this.actionHandler);
        IPCService ipc = this.sysConfig.getIPCService();
        ipc.publish(this, "isql-service-change", this.databaseConnection);
    }

    @Override
    public boolean isValidDatabaseConnection() {
        if (this.databaseConnection == null) {
            return false;
        }
        return !this.databaseConnection.isClosed();
    }

    @Override
    public int promptForService() {
        return 1;
    }

    @Override
    public void showInvalidConnection() {
        String msg = BasicUtilities.getString("Connection_Nag");
        String title = BasicUtilities.getString("Error");
        JOptionPane.showMessageDialog(this, msg, title, 0);
    }

    @Override
    public void setDefaultTextComponent(JTextComponent textComponent) {
        this.defaultComponent = textComponent;
    }

    @Override
    public Window getRootWindow() {
        return this;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            Boolean f = (Boolean)this.getRootPane().getClientProperty("windowModified");
            if (f.booleanValue()) {
                Object[] options;
                int style;
                int type;
                String title;
                String msg = BasicUtilities.getString("Transaction_Pending_Warning");
                int res = JOptionPane.showOptionDialog(this, msg, title = BasicUtilities.getString("Warning"), type = 1, style = 2, null, options = new String[]{BasicUtilities.getString("Commit"), BasicUtilities.getString("Rollback"), BasicUtilities.getString("Cancel")}, options[0]);
                if (res == 1) {
                    this.databaseConnection.performRollBack();
                    this.databaseConnection.setAutoCommit(true);
                    this.disconnect();
                } else if (res == 0) {
                    this.databaseConnection.performCommit();
                    this.databaseConnection.setAutoCommit(true);
                    this.disconnect();
                } else {
                    return;
                }
            }
            this.finalizeApplication();
            if (Boolean.getBoolean("isql.stand-alone")) {
                System.exit(0);
            }
        } else if (e.getID() == 200) {
            this.updateStatus("");
            System.out.println(BasicUtilities.getString("Init_Success", "2.1.8"));
            System.setOut(new PrintStream(this.sysOut.toOutputStream(), true));
            System.setErr(new PrintStream(this.sysOut.createFilteredStream("err"), true));
            this.checkEmptyServices();
            this.connectStartupService();
            this.bookDrawer = this.configureBookmarkDrawer();
            if (this.preferences.getBoolean("advanced.versioncheck-enabled")) {
                this.performWebCheck(false);
            }
        } else if (e.getID() == 205) {
            if (this.defaultComponent != null) {
                this.defaultComponent.requestFocus();
            }
            if (this.bookDrawer != null && this.bookDrawer.isVisible()) {
                this.bookDrawer.toFront();
            }
        }
        super.processWindowEvent(e);
        System.runFinalization();
    }

    protected void handleActionEvent(ActionEvent evt) {
        int action = evt.getID();
        switch (action) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                TreePath tp = this.treBookmarks.getSelectionPath();
                Object selected = tp == null ? null : tp.getLastPathComponent();
                this.handleBookmarkAction(action, selected);
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 31: {
                this.performWebCheck(true);
                break;
            }
            case 12: {
                this.databaseConnection.setAutoCommit(!this.databaseConnection.getAutoCommit());
                break;
            }
            case 4: {
                PreferencesEditor.showDialog(this);
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 3: {
                ServiceManager.showDialog(this);
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 0: {
                File file = BasicUtilities.saveSystemFile(this);
                if (file == null) break;
                this.sysConfig.getHistoryManager().store(file);
                break;
            }
            case 36: {
                if (!this.validateConnection()) break;
                QueryWizard.showDialog(this, this.databaseConnection, this.workbench);
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 34: {
                ScriptManager.showDialog(this, this.databaseConnection, this.workbench);
                break;
            }
            case 41: {
                this.doQuickBatch();
                break;
            }
            case 9: {
                if (!this.validateConnection()) break;
                ImportWizard wizard = new ImportWizard((Frame)this, this.databaseConnection);
                wizard.show();
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 46: {
                DataMigrator wizard = new DataMigrator(this, this);
                wizard.show();
                this.dispatchEvent(new WindowEvent(this, 205, this));
                break;
            }
            case 2: {
                if (!this.isValidDatabaseConnection() && this.promptForService() != 1) {
                    return;
                }
                JDBCExplorer.showDialog(this);
                break;
            }
            case 42: {
                if (!this.validateConnection()) break;
                TableEditor.showDialog(this);
                break;
            }
            case 25: {
                this.disconnect();
                break;
            }
            case -2: {
                if (!this.validateConnection()) break;
                try {
                    String[] p = new String[]{this.databaseConnection.getCatalog(), evt.getActionCommand()};
                    String message = BasicUtilities.getString("Catalog_Change", p);
                    System.out.println(message);
                    this.databaseConnection.changeCatalog(evt.getActionCommand());
                }
                catch (SQLException sqle) {
                    String msg = BasicUtilities.getString("Catalog_Change_Err", evt.getActionCommand());
                    BasicUtilities.showExceptionPopup(this, sqle, msg);
                }
                catch (Throwable t) {
                    String msg = BasicUtilities.getString("Catalog_Change_Err", evt.getActionCommand());
                    BasicUtilities.HandleException(t, msg);
                }
                break;
            }
            case 7: {
                HistoryViewer.showDialog(this, this.sysConfig.getHistoryManager(), this.workbench);
                break;
            }
            case 6: {
                BatchWizard.showDialog(this);
                break;
            }
            case -1: {
                this.changeService(evt.getActionCommand());
                break;
            }
            case 33: {
                if (this.bookDrawer == null) break;
                this.bookDrawer.toggle();
                break;
            }
            case 24: {
                SQLWarningViewer.showDialog(this);
                break;
            }
            case 14: {
                if (this.databaseConnection == null) break;
                this.databaseConnection.performRollBack();
                break;
            }
            case 48: {
                BasicUtilities.beep();
                break;
            }
            case 13: {
                if (this.databaseConnection == null) break;
                this.databaseConnection.performCommit();
                break;
            }
            case 23: {
                AboutBox.showDialog(this);
                break;
            }
            case 8: {
                this.dispatchEvent(new WindowEvent(this, 201));
            }
        }
    }

    protected void performWebCheck(boolean override) {
        try {
            System.out.println(BasicUtilities.getString("Checking_For_Updated_iSQL"));
            Object[] res = this.sysConfig.performWebCheck();
            int updatetype = this.preferences.getInt("advanced.versioncheck-type");
            if (updatetype == 0 && res[0].toString().equalsIgnoreCase("Beta") && !override || !((Boolean)res[2]).booleanValue()) {
                System.out.println(BasicUtilities.getString("No_Update_Available"));
            } else if (((Boolean)res[2]).booleanValue()) {
                System.out.println(BasicUtilities.getString("New_Version_Available"));
                System.out.println(BasicUtilities.getString("Version_Type_" + res[0]) + " :: " + res[1]);
            }
        }
        catch (Exception e) {
            BasicUtilities.HandleException(e, BasicUtilities.getString("Web_Check_Error"));
        }
    }

    protected void connectStartupService() {
        ServiceProvider provider;
        String startup;
        boolean hasStartup = this.preferences.containsKey("jdbc.auto-service");
        if (hasStartup && (startup = this.preferences.get("jdbc.auto-service")) != null && startup.trim().length() >= 1 && (provider = this.sysConfig.getServiceProvider()).isRegistered(startup)) {
            System.out.println(BasicUtilities.getString("Auto_Connect_Message", startup));
            this.changeService(startup);
        }
    }

    protected void toggleTransactionState() {
        if (!this.isValidDatabaseConnection()) {
            System.out.println(BasicUtilities.getString("Invalid_Connection"));
            return;
        }
        boolean inTransactionMode = false;
        if (!this.databaseConnection.isTransactionsSupported()) {
            System.out.println(BasicUtilities.getString("Transaction_Warning"));
            return;
        }
        try {
            boolean bl = inTransactionMode = !this.databaseConnection.getAutoCommit();
            if (inTransactionMode) {
                this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
            } else {
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
            }
            String txt = inTransactionMode ? BasicUtilities.getString("AutoCommit_OFF") : BasicUtilities.getString("AutoCommit_ON");
            this.lblCommit.setText(" ".concat(txt).concat(" "));
            this.statusBar.revalidate();
            this.actionManager.setActionEnabled(14, inTransactionMode);
            this.actionManager.setActionEnabled(13, inTransactionMode);
        }
        catch (Exception e) {
            BasicUtilities.HandleException(e, BasicUtilities.getString("Transaction_Exception"));
            this.actionManager.setActionEnabled(14, false);
            this.actionManager.setActionEnabled(13, false);
            this.lblCommit.setText(BasicUtilities.getString("AutoCommit_ON"));
            return;
        }
    }

    protected void initTracing(Properties props) {
        String val = props.getProperty("jdbc.trace-enabled", "false");
        if (Boolean.valueOf(val).booleanValue()) {
            PrintWriter pw = new PrintWriter(this.sysOut.createFilteredStream(JConsole.CATEGORY_DRIVER_MANAGER), true);
            DriverManager.setLogWriter(pw);
        } else {
            DriverManager.setLogWriter(null);
        }
    }

    protected void checkEmptyServices() {
        ServiceProvider provider = this.sysConfig.getServiceProvider();
        int count = provider.getRegisteredServices().size();
        if (count == 0) {
            String msg = BasicUtilities.getString("ServiceEmptyPrompt");
            Object[] options = new String[]{BasicUtilities.getString("Yes"), BasicUtilities.getString("No"), BasicUtilities.getString("Detect_Services")};
            int opt = JOptionPane.showOptionDialog(this, msg, "", 1, 1, null, options, options[2]);
            if (opt == 0) {
                this.actionManager.forwardAction(new ActionEvent(this, 3, ""));
            } else if (opt == 2) {
                SystemConfig.getInstance().getServiceProvider().detectServices();
            }
        }
    }

    protected void doQuickBatch() {
        File file;
        if (this.validateConnection() && (file = BasicUtilities.getSystemFile(this, 0)) != null) {
            try {
                BatchRunner br = new BatchRunner(file, null);
                br.setConnection(this.getJDBCConnection());
                br.loadStatements(this.preferences);
                Thread t = new Thread(this.BATCH_THREADS, br, file.getName());
                t.start();
            }
            catch (IOException e) {
                BasicUtilities.beep();
                BasicUtilities.HandleException(e, "SQLWorkbench::doQuickBatch()");
            }
        }
    }

    private void configureFileToolbar() {
        if (!this.preferences.getBoolean("toolbar.file-visible")) {
            return;
        }
        if (this.fileBar == null) {
            this.fileBar = new MainToolbar(this.actionManager);
            String s = this.preferences.get("toolbar.file-dock");
            this.getContentPane().add((Component)this.fileBar, s);
            if (s.equalsIgnoreCase("East") || s.equalsIgnoreCase("West")) {
                this.fileBar.setOrientation(1);
            } else {
                this.fileBar.setOrientation(0);
            }
        }
    }

    private void doPostServiceInit(String service) {
        System.out.println(BasicUtilities.getString("Connect_Sucess_Message", service));
        this.currentStatus = BasicUtilities.getString("Connect_Status", service);
        this.updateStatus(this.currentStatus);
        this.databaseConnection.setConnectionName(service);
        this.sysConfig.getIPCService().publish(this, "isql-service-change", this.databaseConnection);
        boolean f = this.databaseConnection.isTransactionsSupported();
        this.actionManager.setActionEnabled(12, f);
        f = this.databaseConnection.isSavePointsSupported();
        this.actionManager.setActionEnabled(48, f);
        try {
            SQLWarningViewer.addConnectionWarnings(this.databaseConnection.getWarnings());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileToolbar() {
        if (this.fileBar != null) {
            this.getContentPane().remove(this.fileBar);
            Object object = this.getTreeLock();
            synchronized (object) {
                this.validateTree();
            }
            this.fileBar.removeAll();
            this.fileBar = null;
        }
    }

    private void finalizeApplication() {
        this.actionThread.interrupt();
        this.saveSession();
        this.actionManager = null;
        this.workbench = null;
    }

    private void restoreSession() {
        BasicUtilities.setPreferredGeometry(this, new Dimension(800, 600), "MainFrame.bounds");
        String key = "session.".concat("MainFrame.split.loc");
        int loc = this.preferences.getInt(key);
        if (loc < 0) {
            loc = 350;
        }
        this.rootPane.setDividerLocation(loc);
        this.workbench.restoreSession();
    }

    private void saveSession() {
        this.preferences.putRect("session.".concat("MainFrame.bounds"), this.getBounds());
        int loc = this.rootPane.getDividerLocation();
        this.preferences.putInt("session.".concat("MainFrame.split.loc"), loc);
        if (this.workbench != null) {
            this.workbench.saveSession();
        }
    }

    private JPanel configureStatusBar() {
        JPanel bar = new JPanel(new GridBagLayout());
        Border bdr = BorderFactory.createEtchedBorder();
        this.lblInfo.setBorder(bdr);
        this.lblCommit.setBorder(bdr);
        MainFrame.constrain(0, 0, 1, 1, 0.0, 0.0, 10, 0);
        bar.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        MainFrame.constrain(1, 0, 1, 1, 1.0, 0.0, 17, 2);
        bar.add((Component)this.lblInfo, UI_CONSTRAINT);
        MainFrame.constrain(2, 0, 1, 1, 0.0, 0.0, 17, 0);
        bar.add((Component)this.lblCommit, UI_CONSTRAINT);
        MainFrame.constrain(3, 0, 1, 1, 0.0, 0.0, 10, 0);
        bar.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        return bar;
    }

    private JDrawer configureBookmarkDrawer() {
        JDrawer drawer = new JDrawer((Window)this);
        BookmarkTreeCellRenderer rndr = new BookmarkTreeCellRenderer();
        this.treBookmarks = new JTree(this.sysConfig.getBookmarks());
        this.treBookmarks.setEditable(true);
        this.treBookmarks.setCellRenderer(rndr);
        this.treBookmarks.setRootVisible(false);
        this.treBookmarks.setCellEditor(new BookmarkEditor.TreeCell(this.treBookmarks, rndr));
        this.treBookmarks.addMouseListener(this.actionHandler);
        Action a = this.actionManager.getAction(38);
        String key = "delete-selected-bookmarks";
        InputMap im = this.treBookmarks.getInputMap(2);
        ActionMap am = this.treBookmarks.getActionMap();
        im.put(BasicUtilities.createKeyStroke(127, 0), key);
        am.put(key, a);
        DropTarget dt = new DropTarget(this.treBookmarks, this.dndHandler);
        this.treBookmarks.setDropTarget(dt);
        String loc = this.preferences.get("bookmark.location");
        if (loc.equalsIgnoreCase(BasicUtilities.getString("Bookmark_Pref_Loc_Left"))) {
            drawer.setPreferredLocation(7);
        } else {
            drawer.setPreferredLocation(3);
        }
        JScrollPane jsp = new JScrollPane(this.treBookmarks);
        drawer.addChangeListener(this.actionHandler);
        drawer.getContentPane().add((Component)jsp, "Center");
        drawer.getContentPane().add((Component)new BookmarkToolbar(this.actionManager), "North");
        this.dndDragSource.createDefaultDragGestureRecognizer(this.treBookmarks, 3, this.dndHandler);
        return drawer;
    }

    private void handleBookmarkAction(int id, Object selected) {
        SQLBookmark bm = null;
        Window editor = null;
        BookmarkTreeModel mdl = this.sysConfig.getBookmarks();
        switch (id) {
            case 37: {
                bm = new SQLBookmark(BasicUtilities.getString("New_Bookmark_Name"));
                if (selected instanceof String || selected == null) {
                    bm.setPath(selected == null ? "/" : (String)selected);
                } else if (selected instanceof SQLBookmark) {
                    bm.setPath(((SQLBookmark)selected).getPath());
                }
                editor = new BookmarkEditor(this, mdl);
                ((BookmarkEditor)editor).setBookmark(bm);
                ((BookmarkEditor)editor).setIsNew(true);
                ((Dialog)editor).show();
                break;
            }
            case 39: {
                if (selected == null || !(selected instanceof SQLBookmark)) {
                    JOptionPane.showMessageDialog(this, BasicUtilities.getString("Bookmark_Select_Nag"));
                    return;
                }
                bm = (SQLBookmark)selected;
                editor = new BookmarkEditor(this, mdl);
                ((BookmarkEditor)editor).installEditorSupport(this.getJDBCConnection());
                ((BookmarkEditor)editor).setBookmark(bm);
                ((BookmarkEditor)editor).setIsNew(false);
                ((Dialog)editor).show();
                break;
            }
            case 38: {
                String msg;
                int opt;
                if (selected == null) {
                    return;
                }
                if (this.preferences.getBoolean("bookmarks.deletewarning-enabled") && (opt = JOptionPane.showConfirmDialog(this, msg = BasicUtilities.getString("Bookmark_DeleteWarning"), "", 0)) != 0) {
                    return;
                }
                TreePath[] selection = this.treBookmarks.getSelectionPaths();
                for (int i = 0; i < selection.length; ++i) {
                    selected = selection[i].getLastPathComponent();
                    if (selected == null) continue;
                    if (selected instanceof String) {
                        String path = (String)selected;
                        int idx = path.lastIndexOf(47);
                        String parent = path.substring(0, path.lastIndexOf(47, path.length() - 2) + 1);
                        String folder = path.substring(path.lastIndexOf(47, idx - 1) + 1, idx);
                        try {
                            mdl.deleteFolder(parent, folder);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            continue;
                        }
                        catch (Throwable t) {
                            BasicUtilities.HandleException(t, "BookmarkTreeModel::deleteFolder(String, String)");
                            break;
                        }
                    }
                    if (!(selected instanceof SQLBookmark)) continue;
                    try {
                        mdl.deleteBookmark((SQLBookmark)selected);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        continue;
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t, "BookmarkTreeModel::deleteBookmark(SQLBookmark)");
                        break;
                    }
                }
                this.treBookmarks.validate();
                break;
            }
            case 40: {
                String newName = JOptionPane.showInputDialog(this, (Object)"");
                if (newName == null || newName.trim().length() == 0) {
                    return;
                }
                if (selected instanceof String || selected == null) {
                    mdl.createFolder(selected == null ? "/" : (String)selected, newName);
                    break;
                }
                if (!(selected instanceof SQLBookmark)) break;
                bm = (SQLBookmark)selected;
                mdl.createFolder(bm.getPath(), newName);
            }
        }
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() throws Exception {
        this.enableEvents(72L);
        this.setDefaultCloseOperation(2);
        this.preferences.addPreferenceChangeListener(this.actionHandler);
        this.configureFileToolbar();
        try {
            if (!BasicUtilities.isMac()) {
                Image img = ((ImageIcon)BasicUtilities.loadIconResource("Database24")).getImage();
                this.setIconImage(img);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.workbench = new SQLWorkBench(this);
        this.sysOut.configure(this.preferences);
        this.panel.add((Component)this.rootPane, "root");
        this.panel.showCard("root");
        this.statusBar = this.configureStatusBar();
        this.rootPane.setTopComponent(this.workbench);
        this.rootPane.setBorder(BorderFactory.createEmptyBorder());
        this.rootPane.setContinuousLayout(true);
        this.rootPane.setOneTouchExpandable(true);
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
        this.restoreSession();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        MainFrame.UI_CONSTRAINT.gridx = x;
        MainFrame.UI_CONSTRAINT.gridy = y;
        MainFrame.UI_CONSTRAINT.gridwidth = w;
        MainFrame.UI_CONSTRAINT.gridheight = h;
        MainFrame.UI_CONSTRAINT.weightx = wx;
        MainFrame.UI_CONSTRAINT.weighty = wy;
        MainFrame.UI_CONSTRAINT.anchor = a;
        MainFrame.UI_CONSTRAINT.fill = f;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private static class MainToolbar
    extends ActionToolBar {
        private static final long serialVersionUID = 1L;

        @Override
        protected void addButtons() {
            this.addButton(this.manager.getAction(3));
            this.addButton(this.manager.getAction(41));
            this.addSeparator();
            this.addButton(this.manager.getAction(4));
            this.addButton(this.manager.getAction(33));
            this.addSeparator();
            this.addButton(this.manager.getAction(5));
            this.addButton(this.manager.getAction(1));
            this.addSeparator();
            this.addButton(this.manager.getAction(2));
            this.addButton(this.manager.getAction(42));
            this.addButton(this.manager.getAction(7));
            this.addButton(this.manager.getAction(24));
            this.addButton(this.manager.getAction(36));
            this.addButton(this.manager.getAction(46));
            this.addButton(this.manager.getAction(34));
        }

        public MainToolbar(ActionManager manager) {
            super(manager);
            this.setFloatable(false);
        }

        @Override
        protected void processDropProxy(Transferable data, int action) {
        }

        @Override
        protected void configureButton(AbstractButton button, Action action) {
            super.configureButton(button, action);
            if (action instanceof CoreAction) {
                try {
                    String s = (String)action.getValue("ICON_NAME");
                    button.setIcon(BasicUtilities.loadToolbarIconResource(s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class TreeDropTarget
    extends DropTargetAdapter
    implements DragSourceListener,
    DragGestureListener {
        private Point pt = new Point(2, 2);

        private TreeDropTarget() {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Transferable transferable = event.getTransferable();
                int x = event.getLocation().x;
                int y = event.getLocation().y;
                TreePath tp = MainFrame.this.treBookmarks.getPathForLocation(x, y);
                Object d = tp != null ? tp.getLastPathComponent() : "/";
                String dropPath = d instanceof SQLBookmark ? ((SQLBookmark)d).getPath() : d.toString();
                BookmarkTreeModel mdl = MainFrame.this.sysConfig.getBookmarks();
                if (transferable.isDataFlavorSupported(BasicUtilities.bookmarkFlavour)) {
                    event.acceptDrop(event.getDropAction());
                    SQLBookmark s = (SQLBookmark)transferable.getTransferData(BasicUtilities.bookmarkFlavour);
                    switch (event.getSourceActions()) {
                        case 2: 
                        case 3: {
                            mdl.moveBookmark(s, dropPath);
                            break;
                        }
                        case 1: {
                            mdl.copyBookmark(s, dropPath);
                            break;
                        }
                        default: {
                            BasicUtilities.beep();
                            event.rejectDrop();
                            return;
                        }
                    }
                    event.dropComplete(true);
                    MainFrame.this.treBookmarks.expandPath(s.toTreePath());
                    MainFrame.this.treBookmarks.setSelectionPath(s.toTreePath());
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    event.acceptDrop(event.getDropAction());
                    String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (mdl.isPath(s)) {
                        switch (event.getSourceActions()) {
                            case 2: 
                            case 3: {
                                dropPath = s.substring(s.lastIndexOf(47, s.length() - 2) + 1, s.length() - 1) + "/";
                                tp = BookmarkTreeModel.getTreePath(dropPath);
                                mdl.movePath(s, dropPath);
                                break;
                            }
                            case 1: {
                                mdl.copyPath(s, dropPath);
                                tp = BookmarkTreeModel.getTreePath(dropPath);
                                break;
                            }
                            default: {
                                BasicUtilities.beep();
                                event.rejectDrop();
                                return;
                            }
                        }
                        event.dropComplete(true);
                        MainFrame.this.treBookmarks.expandPath(tp);
                        MainFrame.this.treBookmarks.setSelectionPath(tp);
                    } else {
                        int l = Math.min(12, s.length());
                        String name = s.substring(0, l - 1);
                        SQLBookmark bm = new SQLBookmark(name, s);
                        bm.setPath(dropPath);
                        mdl.addBookmark(bm);
                        tp = BookmarkTreeModel.getTreePath(dropPath);
                        MainFrame.this.treBookmarks.expandPath(tp);
                        MainFrame.this.treBookmarks.setSelectionPath(tp);
                        event.dropComplete(true);
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                event.rejectDrop();
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            DragGestureRecognizer dndRecognizer = event.getSourceAsDragGestureRecognizer();
            MainFrame.this.treBookmarks.cancelEditing();
            try {
                int x = event.getDragOrigin().x;
                int y = event.getDragOrigin().y;
                boolean leaf = true;
                int row = MainFrame.this.treBookmarks.getRowForLocation(x, y);
                TreePath tp = MainFrame.this.treBookmarks.getPathForLocation(x, y);
                if (tp == null) {
                    dndRecognizer.resetRecognizer();
                    return;
                }
                Object selected = tp.getLastPathComponent();
                if (selected == null) {
                    dndRecognizer.resetRecognizer();
                    return;
                }
                Transferable data = null;
                if (selected instanceof SQLBookmark) {
                    data = (SQLBookmark)selected;
                    leaf = true;
                } else {
                    data = new StringSelection(selected.toString());
                    leaf = false;
                }
                if (DragSource.isDragImageSupported()) {
                    GraphicsConfiguration gConfig = MainFrame.this.treBookmarks.getGraphicsConfiguration();
                    TreeCellRenderer tcr = MainFrame.this.treBookmarks.getCellRenderer();
                    Component comp = tcr.getTreeCellRendererComponent(MainFrame.this.treBookmarks, selected, true, false, leaf, row, false);
                    Dimension dim = comp.getPreferredSize();
                    comp.setSize(dim);
                    BufferedImage bi = gConfig.createCompatibleImage(dim.width, dim.height);
                    Graphics2D g2 = bi.createGraphics();
                    comp.paint(g2);
                    g2.setColor(new Color(255, 255, 255, 112));
                    g2.fillRect(0, 0, dim.width, dim.height);
                    MainFrame.this.dndDragSource.startDrag(event, null, bi, this.pt, data, this);
                } else {
                    MainFrame.this.dndDragSource.startDrag(event, null, null, this.pt, data, this);
                }
            }
            catch (Throwable t) {
                dndRecognizer.resetRecognizer();
                BasicUtilities.beep();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            MainFrame.this.treBookmarks.cancelEditing();
        }

        @Override
        public void dragEnter(DragSourceDragEvent event) {
        }

        @Override
        public void dragExit(DragSourceEvent event) {
        }

        @Override
        public void dragOver(DragSourceDragEvent event) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent event) {
        }
    }

    private class BookmarkToolbar
    extends ActionToolBar {
        private static final long serialVersionUID = 1L;

        @Override
        protected void addButtons() {
            try {
                this.addButton(this.manager.getAction(37));
                this.addButton(this.manager.getAction(38));
                this.addButton(this.manager.getAction(39));
                this.addButton(this.manager.getAction(40));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public BookmarkToolbar(ActionManager manager) {
            super(manager);
            this.setFloatable(false);
        }

        @Override
        protected void configureButton(AbstractButton button, Action action) {
            super.configureButton(button, action);
            if (action instanceof CoreAction) {
                try {
                    String s = (String)action.getValue("ICON_NAME");
                    button.setIcon(this.manager.getSmallIcon(s, "png"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        protected void processDropProxy(Transferable data, int action) {
        }
    }

    private class ActionManagerHandler
    implements ItemListener,
    MouseListener,
    DatabaseListener,
    ChangeListener,
    ActionListener,
    PropertyChangeListener,
    PreferenceChangeListener {
        private ActionManagerHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBoxAction chkBox = (JCheckBoxAction)e.getItem();
            String actionName = chkBox.getValue("Name").toString();
            boolean f = chkBox.isSelected();
            if (actionName.equalsIgnoreCase(BasicUtilities.getString("File_Toolbar"))) {
                MainFrame.this.preferences.putBoolean("toolbar.file-visible", f);
                if (f) {
                    MainFrame.this.configureFileToolbar();
                } else {
                    MainFrame.this.removeFileToolbar();
                }
            }
        }

        @Override
        public void processDatabaseEvent(DatabaseEvent dbe) {
            switch (dbe.getID()) {
                case 4: {
                    MainFrame.this.toggleTransactionState();
                    break;
                }
                case 0: {
                    MainFrame.this.disconnect();
                    break;
                }
                case 3: {
                    MainFrame.this.doPostServiceInit(dbe.getConnection().getConnectionName());
                }
            }
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent e) {
            String key = e.getKey();
            String val = e.getNewValue();
            if (key.equals("bookmark.location")) {
                if (val.equalsIgnoreCase(BasicUtilities.getString("Bookmark_Pref_Loc_Left"))) {
                    MainFrame.this.bookDrawer.setPreferredLocation(7);
                } else {
                    MainFrame.this.bookDrawer.setPreferredLocation(3);
                }
                return;
            }
            if (key.equals("toolbar.file-dock")) {
                MainFrame.this.removeFileToolbar();
                MainFrame.this.configureFileToolbar();
                return;
            }
            if (key.equals("general.plaf-class")) {
                try {
                    BasicUtilities.setLookAndFeel(e.getNewValue());
                    Window[] wins = MainFrame.this.getOwnedWindows();
                    if (wins != null) {
                        for (int i = 0; i < wins.length; ++i) {
                            SwingUtilities.updateComponentTreeUI(wins[i]);
                        }
                    }
                    SwingUtilities.updateComponentTreeUI(MainFrame.this);
                }
                catch (Throwable t) {
                    BasicUtilities.showExceptionPopup(MainFrame.this, t, t.getMessage());
                }
                return;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String key = e.getPropertyName();
            if (e.getNewValue() == null) {
                return;
            }
            String val = e.getNewValue().toString();
            if (key.equals("begin-command")) {
                MainFrame.this.updateStatus(val);
                return;
            }
            if (key.equals("end-command")) {
                MainFrame.this.updateStatus(MainFrame.this.currentStatus);
                return;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                MainFrame.this.handleActionEvent(e);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "ActionManager::actionPerformed(ActionEvent)");
            }
            finally {
                MainFrame.this.setCursor(Cursor.getDefaultCursor());
                System.runFinalization();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            HistoryManager historyManager;
            Object src = e.getSource();
            if (src == (historyManager = MainFrame.this.sysConfig.getHistoryManager())) {
                boolean f = historyManager.size() >= 1;
                MainFrame.this.actionManager.setActionEnabled(7, f);
            } else if (src == MainFrame.this.bookDrawer && MainFrame.this.bookDrawer.isToggled()) {
                MainFrame.this.treBookmarks.validate();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.doTreeClick(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        protected void doTreeClick(MouseEvent event) {
            if (event.getClickCount() != 2) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            TreePath tp = MainFrame.this.treBookmarks.getPathForLocation(x, y);
            if (tp == null) {
                return;
            }
            Object selected = tp.getLastPathComponent();
            if (selected != null && selected instanceof SQLBookmark) {
                if (!MainFrame.this.preferences.getBoolean("bookmark.activation-style")) {
                    ActionEvent e = new ActionEvent(event.getSource(), 39, "");
                    MainFrame.this.actionManager.forwardAction(e);
                } else {
                    SQLBookmark bookmark = (SQLBookmark)selected;
                    MainFrame.this.workbench.executeBookmark(bookmark, MainFrame.this, false);
                }
            }
        }
    }
}

