/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.isqlviewer.core.EnhancedDataRenderer;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class MutableContentViewer
extends JComponent {
    private ThreadGroup renderProcess = new ThreadGroup("render-processes");
    private UserInputSupport support = new UserInputSupport();
    private JButton unzip = new JButton(BasicUtilities.loadToolbarIconResource("Tgz"));
    private JButton saveAs = new JButton(BasicUtilities.loadToolbarIconResource("SaveAs"));
    private JScrollPane jspView = new JScrollPane();
    private EnhancedDataRenderer currentRenderer = null;

    public MutableContentViewer() {
        this.setLayout(new BorderLayout());
        ActionToolBar tb = ActionToolBar.createNullInstance();
        tb.setOrientation(0);
        tb.setFloatable(false);
        ((Container)tb).add(Box.createHorizontalGlue());
        ((Container)tb).add(this.saveAs);
        ((Container)tb).add(this.unzip);
        this.add((Component)tb, "North");
        this.add((Component)this.jspView, "Center");
        this.unzip.setToolTipText(BasicUtilities.getString("Content_Unzip_Tip"));
        this.unzip.setName("Tgz");
        this.unzip.setEnabled(false);
        this.unzip.addActionListener(this.support);
        this.saveAs.setToolTipText(BasicUtilities.getString("Content_SaveAs_Tip"));
        this.saveAs.setName("SaveAs");
        this.saveAs.setEnabled(false);
        this.saveAs.addActionListener(this.support);
    }

    public void setContent(Object newContent, EnhancedDataRenderer rndr) {
        this.unzip.setEnabled(false);
        this.renderProcess.interrupt();
        this.currentRenderer = rndr;
        try {
            JComponent view = rndr.getDataRenderer();
            view.setPreferredSize(this.jspView.getPreferredSize());
            this.jspView.setViewportView(view);
            Runnable process = rndr.renderContent(newContent, view);
            if (process != null) {
                Thread thread = new Thread(this.renderProcess, process, rndr.getName());
                thread.start();
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
        }
        this.unzip.setEnabled(newContent != null);
        this.saveAs.setEnabled(newContent != null);
    }

    public boolean performPrint() {
        JComponent view;
        if (this.currentRenderer != null && this.currentRenderer.isPrintable(view = (JComponent)this.jspView.getViewport().getView())) {
            PrinterPreview.print(this.currentRenderer.getPrintableData(view), this.currentRenderer.getName());
            return true;
        }
        return false;
    }

    public boolean performPrintPreview() {
        JComponent view;
        if (this.currentRenderer != null && this.currentRenderer.isPrintable(view = (JComponent)this.jspView.getViewport().getView())) {
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            PrinterPreview.showPrintPreviewDialog(frame, this.currentRenderer.getPrintableData(view), this.currentRenderer.getName());
            return true;
        }
        return false;
    }

    private static class Decompressor
    implements Runnable {
        private EnhancedDataRenderer cdr = null;
        private SimpleDateFormat sdf = new SimpleDateFormat("");
        private JComponent jcmp = null;

        public Decompressor(EnhancedDataRenderer renderer, JComponent view) {
            this.cdr = renderer;
            this.jcmp = view;
        }

        @Override
        public void run() {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            try {
                InputStream in = this.cdr.getBinaryStream(this.jcmp);
                if (in == null) {
                    BasicUtilities.beep();
                    return;
                }
                GZIPInputStream gis = new GZIPInputStream(in);
                BasicUtilities.copyStream(gis, out);
                System.out.println(BasicUtilities.getString("Ungzip_Message"));
                Runnable process = this.cdr.renderContent(new ByteArrayBlob(out.toByteArray()), this.jcmp);
                if (process != null) {
                    process.run();
                }
                gis.close();
                return;
            }
            catch (IOException in) {
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
            try {
                InputStream in = this.cdr.getBinaryStream(this.jcmp);
                if (in == null) {
                    BasicUtilities.beep();
                    return;
                }
                ZipInputStream zin = new ZipInputStream(in);
                ZipEntry ze = zin.getNextEntry();
                if (ze != null) {
                    do {
                        String msg = null;
                        msg = BasicUtilities.getString("Zip_Entry_Header", ze.getName());
                        System.out.println(msg);
                        msg = BasicUtilities.getString("Zip_Entry_Cmt", ze.getComment());
                        System.out.println(msg);
                        msg = BasicUtilities.getString("Zip_Entry_CRC", Long.toHexString(ze.getCrc()));
                        System.out.println(msg);
                        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
                        this.sdf.applyPattern(prefs.get("general.timestamp-format"));
                        msg = BasicUtilities.getString("Zip_Entry_Time", this.sdf.format(new Date(ze.getTime())));
                        System.out.println(msg);
                        msg = BasicUtilities.getString("Zip_Entry_Size", StringUtilities.getHumanReadableSize(ze.getSize()));
                        System.out.println(msg);
                        BasicUtilities.copyStream(zin, out);
                        zin.closeEntry();
                    } while ((ze = zin.getNextEntry()) != null);
                    Runnable process = this.cdr.renderContent(new ByteArrayBlob(out.toByteArray()), this.jcmp);
                    if (process != null) {
                        process.run();
                    }
                    zin.close();
                    return;
                }
            }
            catch (Throwable t2) {
                BasicUtilities.HandleException(t2);
            }
            BasicUtilities.beep();
        }
    }

    private class UserInputSupport
    implements ActionListener {
        private UserInputSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            Object src = e.getSource();
            if (MutableContentViewer.this.currentRenderer == null) {
                return;
            }
            if (src == MutableContentViewer.this.unzip) {
                Decompressor target = new Decompressor(MutableContentViewer.this.currentRenderer, (JComponent)MutableContentViewer.this.jspView.getViewport().getView());
                String name = MutableContentViewer.this.currentRenderer.getName();
                Thread decompressor = new Thread(MutableContentViewer.this.renderProcess, target, name);
                decompressor.start();
                return;
            }
            if (src == MutableContentViewer.this.saveAs && (file = BasicUtilities.saveSystemFile(MutableContentViewer.this)) != null) {
                FileOutputStream fos = null;
                InputStream in = null;
                try {
                    fos = new FileOutputStream(file);
                    in = MutableContentViewer.this.currentRenderer.getBinaryStream((JComponent)MutableContentViewer.this.jspView.getViewport().getView());
                    BasicUtilities.copyStream(in, fos);
                    fos.flush();
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

