/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLWarning;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.model.SQLWarningTableModel;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.util.BasicUtilities;

public class SQLWarningViewer
extends JDialog
implements ListSelectionListener,
ActionListener {
    static SQLWarningTableModel mdlConnection = new SQLWarningTableModel();
    static SQLWarningTableModel mdlStatements = new SQLWarningTableModel();
    static SQLWarningTableModel mdlResultSet = new SQLWarningTableModel();
    private JTable tabConnection = new JTable(mdlConnection);
    private JTable tabStatements = new JTable(mdlStatements);
    private JTable tabResultSet = new JTable(mdlResultSet);
    private JTabbedPane jtpWarnings = new JTabbedPane(1);
    private JSplitPane jspRootContainer = new JSplitPane(0);
    private JTextArea txtMessageArea = new JTextArea();
    private JToolBar jtbMain = ActionToolBar.createNullInstance();
    private JButton btnClearWarnings = new JButton();
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));

    public static int showDialog(Frame Owner) {
        try {
            SQLWarningViewer dlg = new SQLWarningViewer(Owner);
            dlg.show();
            return 0;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "SQLWarningViewer::showDialog(Frame)");
            return -1;
        }
    }

    private SQLWarningViewer(Frame Owner) {
        super(Owner, BasicUtilities.getString("Warning_Viewer_Title"), false);
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "SQLWarningViewer::initUI()");
        }
    }

    private void initUI() {
        this.tabConnection.getSelectionModel().addListSelectionListener(this);
        this.tabResultSet.getSelectionModel().addListSelectionListener(this);
        this.tabStatements.getSelectionModel().addListSelectionListener(this);
        this.jtbMain.setFloatable(false);
        this.jtbMain.add(this.btnClearWarnings);
        this.btnClearWarnings.setIcon(BasicUtilities.loadToolbarIconResource("Delete"));
        this.btnClearWarnings.setToolTipText(BasicUtilities.getString("Clear_Warning_Tab_Tip"));
        this.btnClearWarnings.addActionListener(this);
        String txt = BasicUtilities.getString("Connection_Warning_Tab");
        Icon ico = BasicUtilities.loadIconResource("WebComponent16");
        JScrollPane cmp = new JScrollPane(this.tabConnection);
        this.jtpWarnings.addTab(txt, ico, cmp);
        txt = BasicUtilities.getString("Statement_Warning_Tab");
        ico = BasicUtilities.loadIconResource("Query16");
        cmp = new JScrollPane(this.tabStatements);
        this.jtpWarnings.addTab(txt, ico, cmp);
        txt = BasicUtilities.getString("Resultset_Warning_Tab");
        ico = BasicUtilities.loadIconResource("Table16");
        cmp = new JScrollPane(this.tabResultSet);
        this.jtpWarnings.addTab(txt, ico, cmp);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)new JLabel(BasicUtilities.getString("SQL_Warning_Message")), "North");
        pnl.add((Component)new JScrollPane(this.txtMessageArea), "Center");
        this.btnOK.addActionListener(this);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.jtbMain.setOrientation(0);
        JToolBar tb = new JToolBar(0);
        tb.add(Box.createHorizontalGlue());
        tb.add(this.btnOK);
        tb.setFloatable(false);
        this.jspRootContainer.setTopComponent(this.jtpWarnings);
        this.jspRootContainer.setBottomComponent(pnl);
        Container cntr = this.getContentPane();
        cntr.add((Component)this.jtbMain, "North");
        cntr.add((Component)this.jspRootContainer, "Center");
        cntr.add((Component)tb, "South");
        this.pack();
        this.setSize(512, 420);
        this.jspRootContainer.setDividerLocation(0.5);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void addConnectionWarnings(SQLWarning warnings) {
        mdlConnection.setData(warnings, true);
    }

    public static void setConnectionWarnings(SQLWarning warnings) {
        mdlConnection.setData(warnings, false);
    }

    public static void addStatementWarnings(SQLWarning warnings) {
        mdlStatements.setData(warnings, true);
    }

    public static void setStatementWarnings(SQLWarning warnings) {
        mdlStatements.setData(warnings, false);
    }

    public static void addResultsetWarnings(SQLWarning warnings) {
        mdlResultSet.setData(warnings, true);
    }

    public static void setResultsetWarnings(SQLWarning warnings) {
        mdlResultSet.setData(warnings, false);
    }

    public static void clearAll() {
        mdlResultSet.clear();
        mdlStatements.clear();
        mdlConnection.clear();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String tab = this.jtpWarnings.getTitleAt(this.jtpWarnings.getSelectedIndex());
        if (tab.equalsIgnoreCase(BasicUtilities.getString("Connection_Warning_Tab"))) {
            this.txtMessageArea.setText(mdlConnection.getWarningMessageForRow(e.getFirstIndex()));
        } else if (tab.equalsIgnoreCase(BasicUtilities.getString("Statement_Warning_Tab"))) {
            this.txtMessageArea.setText(mdlStatements.getWarningMessageForRow(e.getFirstIndex()));
        } else if (tab.equalsIgnoreCase(BasicUtilities.getString("Resultset_Warning_Tab"))) {
            this.txtMessageArea.setText(mdlResultSet.getWarningMessageForRow(e.getFirstIndex()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String tab;
        Object src = e.getSource();
        if (src == this.btnOK) {
            this.dispose();
        }
        if ((tab = this.jtpWarnings.getTitleAt(this.jtpWarnings.getSelectedIndex())).equalsIgnoreCase(BasicUtilities.getString("Connection_Warning_Tab"))) {
            mdlConnection.clear();
            this.tabConnection.repaint();
        } else if (tab.equalsIgnoreCase(BasicUtilities.getString("Statement_Warning_Tab"))) {
            mdlStatements.clear();
            this.tabStatements.repaint();
        } else if (tab.equalsIgnoreCase(BasicUtilities.getString("Resultset_Warning_Tab"))) {
            mdlResultSet.clear();
            this.tabResultSet.repaint();
        }
    }

    static {
        WarningListener Listener2 = new WarningListener();
        mdlConnection.addTableModelListener(Listener2);
        mdlStatements.addTableModelListener(Listener2);
        mdlResultSet.addTableModelListener(Listener2);
    }

    private static class WarningListener
    implements TableModelListener {
        private WarningListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() != 1) {
                return;
            }
            String Source2 = "";
            if (e.getSource() == mdlConnection) {
                Source2 = BasicUtilities.getString("Connection_Warning_Tab");
            } else if (e.getSource() == mdlStatements) {
                Source2 = BasicUtilities.getString("Statement_Warning_Tab");
            } else if (e.getSource() == mdlResultSet) {
                Source2 = BasicUtilities.getString("Resultset_Warning_Tab");
            }
            String[] p = new String[]{Integer.toString(e.getLastRow() - e.getFirstRow() + 1), Source2};
            System.out.println(BasicUtilities.getString("Warnings_Added", p));
        }
    }
}

