/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import com.j_spaces.core.IJSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.MetadataTreeModel;
import org.isqlviewer.core.model.ResultSetTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.BookmarkTreeCellRenderer;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.JDBCTreeCellRenderer;
import org.isqlviewer.swing.SortableHeaderRenderer;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.ui.MainFrame;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class TableEditor
extends JDialog
implements ResultSetViewer {
    private static final int ACTION_OK = 0;
    private static final int ACTION_ROW_ADD = 1;
    private static final int ACTION_ROW_REFRESH = 2;
    private static final int ACTION_ROW_DELETE = 3;
    private static final int ACTION_PRINT = 4;
    private static final int ACTION_SCHEMA_CHANGE = 5;
    private static TableEditor instance = null;
    private DatabaseConnection connection = null;
    private NumberFormat nf = NumberFormat.getIntegerInstance();
    private String currentStatement = null;
    private ActionInputHandler actionHandler = new ActionInputHandler();
    private MetadataTreeModel mdlBrowser = new MetadataTreeModel(null);
    private ResultSetTableModel mdlEditor = new ResultSetTableModel(null, null, false);
    private DefaultComboBoxModel mdlSchemas = new DefaultComboBoxModel<Object>(new Object[0]);
    private boolean supportsUpdatableResults = false;
    private int preferredType = 0;
    private JSplitPane jspSplitter = new JSplitPane(1);
    private JTree jtrBrowser = new JTree(this.mdlBrowser);
    private JTree jtrBookmark = new JTree(SystemConfig.getInstance().getBookmarks());
    private JButton btnOK = new JButton();
    private ITable tabEditor = new ITable(this.mdlEditor);
    private JToolBar toolbar = ActionToolBar.createNullInstance();
    private JComboBox jcbSchemas = new JComboBox(this.mdlSchemas);
    private JButton btnAddRow = new JButton(BasicUtilities.loadToolbarIconResource("AddRow"));
    private JButton btnRemRow = new JButton(BasicUtilities.loadToolbarIconResource("RowDelete"));
    private JButton btnRefRow = new JButton(BasicUtilities.loadToolbarIconResource("Refresh"));
    private JButton btnPrint = new JButton(BasicUtilities.loadToolbarIconResource("PrintPreview"));
    private JLabel lblScroll = new JLabel(" ");
    private JLabel lblLocatr = new JLabel(" 000/000 ");
    private JLabel lblCursor = new JLabel(" ");

    @Override
    public void processGeneratedKeys(String stmtID, ResultSet keys, String nativeSQL) {
    }

    @Override
    public void processRowUpdates(String stmtID, int updateCount, String nativeSQL) {
        String msg = BasicUtilities.getString("TabEditor_Bad_ResultSet_Recieved");
        JOptionPane.showMessageDialog(this, msg);
    }

    @Override
    public boolean supportsGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsUpdateableResultSets() {
        return true;
    }

    @Override
    public void handleSQLException(ResultSet set, SQLException e) {
        String msg = BasicUtilities.getString("Query_Failed");
        BasicUtilities.showExceptionPopup(this, e, msg);
    }

    @Override
    public void handleException(ResultSet set, Throwable e) {
        String msg = e.toString();
        BasicUtilities.showExceptionPopup(this, e, msg);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        switch (event.getID()) {
            case 200: {
                if (this.supportsUpdatableResults) break;
                String msg = BasicUtilities.getString("TabEditor_Support_Warning");
                String title = BasicUtilities.getString("Warning");
                JOptionPane.showMessageDialog(this, msg, title, 2);
                break;
            }
            case 201: {
                this.cleanupCurrentStatement();
            }
        }
        super.processWindowEvent(event);
    }

    @Override
    public void processResultSet(String stmtID, ResultSet set, String nativeSQL, int count, IJSpace spaceProxy, int executionTime) {
        if (JDBCUtilities.isUpdatable(set)) {
            try {
                this.mdlEditor.setData(set, null);
                String cursor = null;
                try {
                    cursor = set.getCursorName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (cursor == null) {
                    this.lblCursor.setText(BasicUtilities.getString("TabEditor_Cursor_Txt", ""));
                } else {
                    this.lblCursor.setText(cursor);
                }
                BasicUtilities.optimizeTableView(this.tabEditor);
                String str = null;
                switch (set.getType()) {
                    case 1004: {
                        str = BasicUtilities.getString("TabEditor_Scroll_Insensitive");
                        break;
                    }
                    case 1005: {
                        str = BasicUtilities.getString("TabEditor_Scroll_Sensitive");
                        break;
                    }
                    default: {
                        str = BasicUtilities.getString("TabEditor_Scroll_Unknown");
                    }
                }
                this.lblScroll.setText(" " + str + " ");
                this.currentStatement = stmtID;
                this.toolbar.setEnabled(true);
                if (this.mdlEditor.getTrueRowCount() >= 1) {
                    this.tabEditor.addRowSelectionInterval(0, 0);
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, BasicUtilities.getString("Query_Exception"));
            }
            SQLWarningViewer.addConnectionWarnings(this.connection.getWarnings());
        } else {
            String msg = BasicUtilities.getString("TabEditor_Bad_ResultSet_Recieved");
            JOptionPane.showMessageDialog(this, msg);
            this.connection.disposeStatement(stmtID);
        }
    }

    @Override
    public void recieveResultsetWarnings(ResultSet set, SQLWarning warnings) {
        SQLWarningViewer.addResultsetWarnings(warnings);
    }

    @Override
    public void recieveStatementWarnings(Statement stmt, SQLWarning warnings) {
        SQLWarningViewer.addStatementWarnings(warnings);
    }

    @Override
    public void statementInitialized(String stmtID) {
        this.mdlEditor.clearAll();
        this.toolbar.setEnabled(false);
    }

    @Override
    public void handleStatementInterrupted(String stmtID) {
    }

    public static int showDialog(MainFrame frame) {
        try {
            instance = new TableEditor((Frame)frame, frame.getJDBCConnection());
            instance.pack();
            instance.setSize(640, 480);
            instance.setLocationRelativeTo(frame);
            instance.show();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
            return -1;
        }
        return 0;
    }

    private TableEditor(Frame owner, DatabaseConnection cnx) {
        super(owner, BasicUtilities.getString("TabEditor_Window_Title"), true);
        try {
            this.initUI();
            this.setConnection(cnx);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "TableEditor()::initUI()");
        }
        this.nf.setMinimumIntegerDigits(3);
    }

    protected void setConnection(DatabaseConnection cnx) {
        this.connection = cnx;
        try {
            DatabaseMetaData md = this.connection.getDatabaseInformation();
            if (md.supportsResultSetType(1005)) {
                this.preferredType = 1005;
            } else if (md.supportsResultSetType(1004)) {
                this.preferredType = 1004;
            }
            this.supportsUpdatableResults = md.supportsResultSetConcurrency(this.preferredType, 1008);
        }
        catch (Throwable t) {
            this.supportsUpdatableResults = false;
        }
        this.mdlBrowser.updateConnection(cnx);
        this.mdlSchemas.removeAllElements();
        if (cnx != null) {
            this.mdlBrowser.setCatalog(cnx.getCatalog(), true);
            Object[] scms = cnx.getAvailableSchemas();
            if (scms != null) {
                for (int i = 0; i < scms.length; ++i) {
                    this.mdlSchemas.addElement(scms[i]);
                }
            }
            if (this.mdlSchemas.getSize() >= 1) {
                this.jcbSchemas.setSelectedItem(cnx.getSchema());
            }
        } else {
            this.mdlBrowser.setSchema(null, false);
            this.mdlBrowser.setCatalog(null, true);
        }
        this.jcbSchemas.setEnabled(this.mdlSchemas.getSize() >= 1);
    }

    protected void handleActionPreformed(int command) {
        int index = this.tabEditor.getSelectedRow();
        switch (command) {
            case 0: {
                this.dispatchEvent(new WindowEvent(this, 201));
                break;
            }
            case 5: {
                String schema = (String)this.mdlSchemas.getSelectedItem();
                this.mdlBrowser.setSchema(schema, true);
                break;
            }
            case 4: {
                PrinterPreview.showPrintPreviewDialog(this, (Object)this.tabEditor.getModel(), "");
                break;
            }
            case 1: {
                try {
                    this.mdlEditor.createInsertRow();
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "ResultSetTableModel::createInsertRow()");
                }
                break;
            }
            case 3: {
                if (index < 0) break;
                this.mdlEditor.removeRow(index);
                break;
            }
            case 2: {
                if (index < 0) break;
                try {
                    this.mdlEditor.refreshRow(index);
                    break;
                }
                catch (Throwable t) {
                    BasicUtilities.showExceptionPopup(this, t, "");
                }
            }
        }
    }

    private void cleanupCurrentStatement() {
        if (this.currentStatement != null) {
            this.connection.disposeStatement(this.currentStatement);
            this.mdlEditor.disableEditing();
        }
    }

    private void initUI() {
        this.mdlBrowser.setMetadataEnabled(false);
        this.mdlBrowser.setProceduresEnabled(false);
        this.tabEditor.setSelectionMode(0);
        this.tabEditor.setSelectionToggleEnabled(false);
        this.tabEditor.addActionListener(new TableActionHandler());
        this.jtrBrowser.setCellRenderer(new JDBCTreeCellRenderer());
        this.jtrBrowser.addMouseListener(this.actionHandler);
        this.jtrBrowser.setRootVisible(false);
        this.jtrBookmark.setCellRenderer(new BookmarkTreeCellRenderer());
        this.jtrBookmark.addMouseListener(this.actionHandler);
        this.jtrBookmark.setRootVisible(false);
        this.lblScroll.setToolTipText(BasicUtilities.getString("TabEditor_Scroll_Tip"));
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.btnOK.addActionListener(this.actionHandler);
        this.btnOK.setActionCommand(Integer.toString(0));
        this.btnOK.setText(BasicUtilities.getString("Ok"));
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnAddRow.addActionListener(this.actionHandler);
        this.btnAddRow.setActionCommand(Integer.toString(1));
        this.btnAddRow.setToolTipText(BasicUtilities.getString("TabEditor_InsertRow_Tip"));
        this.btnPrint.addActionListener(this.actionHandler);
        this.btnPrint.setActionCommand(Integer.toString(4));
        this.btnPrint.setToolTipText(BasicUtilities.getString("Print"));
        this.btnRemRow.addActionListener(this.actionHandler);
        this.btnRemRow.setActionCommand(Integer.toString(3));
        this.btnRemRow.setToolTipText(BasicUtilities.getString("TabEditor_RemoveRow_Tip"));
        this.btnRefRow.addActionListener(this.actionHandler);
        this.btnRefRow.setActionCommand(Integer.toString(2));
        this.btnRefRow.setToolTipText(BasicUtilities.getString("TabEditor_UpdateRow_Tip"));
        this.toolbar.setOrientation(0);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.btnPrint);
        this.toolbar.addSeparator();
        this.toolbar.add(this.btnAddRow);
        this.toolbar.add(this.btnRemRow);
        this.toolbar.add(this.btnRefRow);
        this.toolbar.add(Box.createHorizontalGlue());
        JPanel editor = new JPanel(new BorderLayout());
        editor.add((Component)this.toolbar, "North");
        editor.add((Component)new JScrollPane(this.tabEditor), "Center");
        editor.add((Component)this.configureTableStatusbar(), "South");
        JPanel browser = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.addTab("Bookmarks", BasicUtilities.loadIconResource("Bookmarks16"), new JScrollPane(this.jtrBookmark));
        tabbedPane.addTab("JDBC", BasicUtilities.loadIconResource("Database16"), browser);
        browser.add((Component)this.jcbSchemas, "North");
        browser.add(Box.createVerticalStrut(this.toolbar.getPreferredSize().height));
        browser.add((Component)new JScrollPane(this.jtrBrowser), "Center");
        JToolBar jtbOK = new JToolBar(0);
        jtbOK.add(Box.createHorizontalGlue());
        jtbOK.add(this.btnOK);
        jtbOK.setFloatable(false);
        this.jcbSchemas.setActionCommand(Integer.toString(5));
        this.jcbSchemas.addActionListener(this.actionHandler);
        this.jcbSchemas.setMaximumRowCount(6);
        this.jtrBrowser.addTreeExpansionListener(this.actionHandler);
        this.tabEditor.getSelectionModel().addListSelectionListener(this.actionHandler);
        this.tabEditor.getTableHeader().setDefaultRenderer(new EditorHeaderRenderer(this.tabEditor));
        this.jspSplitter.setLeftComponent(tabbedPane);
        this.jspSplitter.setRightComponent(editor);
        this.jspSplitter.setOneTouchExpandable(true);
        this.jspSplitter.setContinuousLayout(true);
        this.jspSplitter.setResizeWeight(0.75);
        JPanel cntnt = (JPanel)this.getContentPane();
        WizardPanel panel = new WizardPanel();
        panel.add(this.jspSplitter);
        panel.showCard(this.jspSplitter);
        cntnt.add((Component)panel, "Center");
        cntnt.add((Component)jtbOK, "South");
    }

    private void executeBookmark(SQLBookmark bmark) {
        if (bmark != null && !this.connection.isClosed()) {
            SQLBookmark copy = (SQLBookmark)bmark.clone();
            String sql = this.processSQLParameters(copy.getSQL());
            if (sql == null) {
                return;
            }
            copy.setSQL(sql);
            int rsType = this.preferredType;
            int rsConc = 1008;
            if (bmark.hasParameters()) {
                try {
                    PreparedStatement ps = copy.toPreparedStatement(this.connection, rsType, rsConc);
                    bmark.updateLastAcessTime();
                    bmark.updateUseCount();
                    this.connection.executeStatement(ps, copy.getSQL(), this);
                }
                catch (Throwable t) {
                    String msg = BasicUtilities.getString("Bookmark_PrepStatement_Failed");
                    BasicUtilities.showExceptionPopup(this, t, msg);
                }
            } else {
                bmark.updateLastAcessTime();
                bmark.updateUseCount();
                this.connection.executeStaticRequest(copy.getSQL(), this, rsType, rsConc);
            }
            Object var2_2 = null;
        } else {
            BasicUtilities.beep();
        }
    }

    private String processSQLParameters(String sql) {
        String[] p = StringUtilities.getSQLParameters(sql);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < p.length; ++i) {
            String key = p[i];
            String val = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("SQL_Param_Prompt", key));
            if (val == null) {
                System.out.println(BasicUtilities.getString("Query_Cancelled"));
                map.clear();
                map = null;
                p = null;
                return null;
            }
            map.put(key, val);
        }
        String command = StringUtilities.applySQLParameters(map, sql);
        map.clear();
        map = null;
        p = null;
        return command;
    }

    private JComponent configureTableStatusbar() {
        JPanel bar = new JPanel(new GridBagLayout());
        Border bdr = BorderFactory.createEtchedBorder();
        this.lblLocatr.setBorder(bdr);
        this.lblScroll.setBorder(bdr);
        this.lblCursor.setBorder(bdr);
        this.lblLocatr.setVerticalAlignment(0);
        this.lblScroll.setVerticalAlignment(0);
        this.lblCursor.setVerticalAlignment(0);
        this.lblScroll.setHorizontalAlignment(0);
        this.lblLocatr.setHorizontalAlignment(0);
        this.lblCursor.setHorizontalAlignment(0);
        Insets i = new Insets(0, 0, 0, 0);
        bar.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, i, 0, 0));
        bar.add((Component)this.lblCursor, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, i, 0, 0));
        bar.add((Component)this.lblScroll, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, i, 0, 0));
        bar.add(Box.createHorizontalStrut(2), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, i, 0, 0));
        bar.add((Component)this.lblLocatr, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, i, 0, 0));
        return bar;
    }

    private class ActionInputHandler
    extends MouseInputAdapter
    implements ActionListener,
    IPCListener,
    ChangeListener,
    ListSelectionListener,
    TreeExpansionListener {
        private ActionInputHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
        }

        @Override
        public void receiveMessage(Object src, String topic, Object msg) {
            if (topic != null && topic.equals("isql-service-change")) {
                TableEditor.this.setConnection((DatabaseConnection)msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                int action = -1;
                try {
                    action = Integer.parseInt(evt.getActionCommand());
                }
                catch (Throwable t) {
                    TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                TableEditor.this.handleActionPreformed(action);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "ActionInputHandler::actionPerformed(ActionEvent)");
            }
            finally {
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void valueChanged(TreeSelectionEvent e) {
            if (TableEditor.this.mdlBrowser == null) return;
            if (TableEditor.this.connection == null) {
                return;
            }
            TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                String selection = (String)node.getUserObject();
                switch (node.getLevel()) {
                    case 2: {
                        String type = node.getParent().toString();
                        this.getTableData(type, selection);
                        return;
                    }
                }
                return;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "TableEditor::valueChanged(TreeSelectionEvent)");
                return;
            }
            finally {
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getTableData(String type, String tab) {
            String cat = TableEditor.this.connection.getCatalog();
            String scm = (String)TableEditor.this.mdlSchemas.getSelectedItem();
            ResultSet set = null;
            String tablename = scm == null || scm.trim().length() == 0 ? "" : scm.concat(".");
            tablename = tablename.concat(tab);
            String command = "SELECT * FROM ".concat(tablename);
            int rsType = TableEditor.this.preferredType;
            int rsConc = 1008;
            DatabaseMetaData md = TableEditor.this.connection.getDatabaseInformation();
            try {
                TableEditor.this.connection.executeStaticRequest(command, TableEditor.this, rsType, rsConc);
                set = md.getPrimaryKeys(cat, scm, tab);
                List<Object> lst = Arrays.asList(JDBCUtilities.getSingleColumn(set, "COLUMN_NAME", null));
                TableEditor.this.mdlEditor.applyPrimaryKeys(lst);
            }
            catch (Throwable t) {
                if (TableEditor.this.connection.getVerboseOn()) {
                    String msg = "getTableData(" + type + ", " + tab + ")";
                    BasicUtilities.HandleException(t, msg, TableEditor.this.connection.getDebugOn());
                }
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable lst) {}
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                if (!TableEditor.this.mdlBrowser.isUncachedNode(node)) return;
                switch (node.getLevel()) {
                    case 1: {
                        TableEditor.this.mdlBrowser.loadTableTypeNode(node, node.toString());
                        return;
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                return;
            }
            finally {
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String str = TableEditor.this.nf.format(TableEditor.this.tabEditor.getSelectedRow() + 1);
            str = str.concat("/");
            str = str.concat(TableEditor.this.nf.format(TableEditor.this.mdlEditor.getTrueRowCount()));
            TableEditor.this.lblLocatr.setText(" ".concat(str).concat(" "));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            int cc = e.getClickCount();
            if (cc == 2) {
                if (TableEditor.this.mdlBrowser == null || TableEditor.this.connection == null) {
                    return;
                }
                TableEditor.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Point p = e.getPoint();
                    JTree source = (JTree)e.getSource();
                    TreePath tp = source.getPathForLocation(p.x, p.y);
                    if (tp == null) {
                        BasicUtilities.beep();
                        return;
                    }
                    Object o = tp.getLastPathComponent();
                    if (o instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                        String selection = (String)node.getUserObject();
                        switch (node.getLevel()) {
                            case 2: {
                                String type = node.getParent().toString();
                                TableEditor.this.cleanupCurrentStatement();
                                this.getTableData(type, selection);
                                break;
                            }
                        }
                    } else if (o instanceof SQLBookmark) {
                        TableEditor.this.cleanupCurrentStatement();
                        TableEditor.this.executeBookmark((SQLBookmark)o);
                    }
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "TableEditor::valueChanged(TreeSelectionEvent)");
                }
                finally {
                    TableEditor.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class TableActionHandler
    implements ActionListener {
        private TableActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            switch (evt.getID()) {
                case 767: {
                    int col = Integer.parseInt(evt.getActionCommand());
                    int row = evt.getModifiers();
                    TableEditor.this.tabEditor.setValueAt(null, row, col);
                }
            }
        }
    }

    private class EditorHeaderRenderer
    extends SortableHeaderRenderer {
        public EditorHeaderRenderer(JTable table) {
            super(table);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (TableEditor.this.mdlEditor.isPrimaryKey((String)value)) {
                this.setIcon(BasicUtilities.loadIconResource("Key16"));
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

