/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class TableSelector
extends JComponent
implements ActionListener {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private DefaultComboBoxModel mdlCatalogs = new DefaultComboBoxModel();
    private DefaultComboBoxModel mdlSchemas = new DefaultComboBoxModel();
    private DefaultComboBoxModel mdlTables;
    private JComboBox jcbCatalogs = new JComboBox(this.mdlCatalogs);
    private JComboBox jcbSchemas = new JComboBox(this.mdlSchemas);
    private JComboBox jcbTables;
    private DatabaseMetaData dmd;
    private boolean isLoadingTables = false;
    private String lastTable = null;
    private String lastCatalog = null;
    private String lastSchema = null;
    private transient Vector changeListeners;

    public TableSelector(DatabaseMetaData dmd, boolean allowTableSelection) {
        this.dmd = dmd;
        if (allowTableSelection) {
            this.mdlTables = new DefaultComboBoxModel();
            this.jcbTables = new JComboBox(this.mdlTables);
            this.configureCombobox(this.jcbTables);
        }
        this.initCatlogs();
        this.initSchemas();
        try {
            this.initUI(allowTableSelection);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
        }
        if (this.mdlSchemas == null && this.mdlCatalogs == null && !allowTableSelection) {
            this.dmd = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        String selection = (String)((JComboBox)src).getSelectedItem();
        String previous = null;
        if (this.isLoadingTables) {
            return;
        }
        if (src == this.jcbCatalogs) {
            String string = previous = this.lastCatalog == null ? "" : this.lastCatalog;
            if (previous.equals(selection)) return;
            this.lastCatalog = selection;
            this.loadTableNames();
        } else if (src == this.jcbSchemas) {
            String string = previous = this.lastSchema == null ? "" : this.lastSchema;
            if (previous.equals(selection)) return;
            this.lastSchema = selection;
            this.loadTableNames();
        } else if (src == this.jcbTables) {
            String string = previous = this.lastTable == null ? "" : this.lastTable;
            if (previous.equals(selection)) return;
            this.lastTable = selection;
        }
        this.fireStateChanged(new ChangeEvent(this));
    }

    @Override
    public void setEnabled(boolean f) {
        if (this.jcbTables != null) {
            this.jcbTables.setEnabled(f);
        }
        if (this.jcbCatalogs != null) {
            this.jcbCatalogs.setEnabled(f);
        }
        if (this.jcbSchemas != null) {
            this.jcbSchemas.setEnabled(f);
        }
    }

    public boolean compareSelection(TableSelector other) {
        return !(this.jcbCatalogs.isEnabled() && other.jcbCatalogs.isEnabled() && !other.getSelectedCatalog().equalsIgnoreCase(this.getSelectedCatalog()) || this.jcbSchemas.isEnabled() && other.jcbSchemas.isEnabled() && !other.getSelectedSchema().equalsIgnoreCase(this.getSelectedSchema()) || this.jcbTables != null && other.jcbTables != null && !other.getSelectedTable().equalsIgnoreCase(this.getSelectedTable()));
    }

    public void updateMetaData(DatabaseConnection cnx) {
        if (cnx == null) {
            this.mdlTables.removeAllElements();
            this.mdlSchemas.removeAllElements();
            this.mdlCatalogs.removeAllElements();
            this.setEnabled(false);
        } else {
            this.dmd = cnx.getDatabaseInformation();
            this.setEnabled(true);
            this.initCatlogs();
            this.initSchemas();
            this.setSelectedCatalog(cnx.getCatalog());
            this.setSelectedSchema(cnx.getSchema());
        }
    }

    public void setSelectedCatalog(String name) {
        if (name == null) {
            if (this.mdlCatalogs.getSize() >= 1) {
                this.jcbCatalogs.setSelectedIndex(0);
            }
        } else if (this.jcbCatalogs.isEnabled() && this.mdlCatalogs.getIndexOf(name) >= 0) {
            this.mdlCatalogs.setSelectedItem(name);
        }
    }

    public void setSelectedSchema(String name) {
        if (name == null) {
            if (this.mdlSchemas.getSize() >= 1) {
                this.jcbSchemas.setSelectedIndex(0);
            }
        } else if (this.jcbSchemas.isEnabled() && this.mdlSchemas.getIndexOf(name) >= 0) {
            this.mdlSchemas.setSelectedItem(name);
        }
    }

    public void setSelectedTable(String name) {
        if (this.mdlTables == null) {
            return;
        }
        if (name == null) {
            if (this.mdlTables.getSize() >= 1) {
                this.jcbTables.setSelectedIndex(0);
            }
        } else if (this.jcbTables.isEnabled() && this.mdlTables.getIndexOf(name) >= 0) {
            this.mdlTables.setSelectedItem(name);
        }
    }

    public void setTablesEditable(boolean f) {
        if (this.jcbTables != null) {
            this.jcbTables.setEditable(f);
        }
    }

    public String getSelectedTable() {
        if (this.mdlTables == null) {
            return null;
        }
        return (String)this.mdlTables.getSelectedItem();
    }

    public String getQualifiedTable() {
        String scm = this.getSelectedSchema();
        if (scm != null) {
            return scm + "." + this.getSelectedTable();
        }
        return this.getSelectedTable();
    }

    public String getSelectedCatalog() {
        if (this.mdlCatalogs == null || this.mdlCatalogs.getSize() == 0) {
            return null;
        }
        return (String)this.mdlCatalogs.getSelectedItem();
    }

    public String getSelectedSchema() {
        if (this.mdlSchemas == null || this.mdlSchemas.getSize() == 0) {
            return null;
        }
        return (String)this.mdlSchemas.getSelectedItem();
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                try {
                    ((ChangeListener)listeners.elementAt(i)).stateChanged(e);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void initUI(boolean tableSelectionAllowed) {
        this.setLayout(new GridBagLayout());
        TableSelector.constrain(0, 0, 1, 1, 0.0, 0.0, 10, 0);
        this.add((Component)new JLabel(BasicUtilities.getString("Select_Catalog")), UI_CONSTRAINT);
        TableSelector.constrain(1, 0, 1, 1, 1.0, 0.0, 10, 2);
        this.add((Component)this.jcbCatalogs, UI_CONSTRAINT);
        TableSelector.constrain(2, 0, 1, 1, 0.0, 0.0, 10, 0);
        this.add((Component)new JLabel(BasicUtilities.getString("Select_Schema")), UI_CONSTRAINT);
        TableSelector.constrain(3, 0, 1, 1, 1.0, 0.0, 10, 2);
        this.add((Component)this.jcbSchemas, UI_CONSTRAINT);
        if (tableSelectionAllowed) {
            TableSelector.constrain(0, 1, 1, 1, 0.0, 0.0, 10, 0);
            this.add((Component)new JLabel(BasicUtilities.getString("Select_Table")), UI_CONSTRAINT);
            TableSelector.constrain(1, 1, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.jcbTables, UI_CONSTRAINT);
            if (this.mdlTables.getSize() >= 1) {
                this.jcbTables.setSelectedIndex(0);
            }
        }
        if (this.mdlCatalogs.getSize() >= 1) {
            this.jcbCatalogs.setSelectedIndex(0);
        }
        if (this.mdlSchemas.getSize() >= 1) {
            this.jcbSchemas.setSelectedIndex(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCatlogs() {
        ResultSet set = null;
        try {
            set = this.dmd.getCatalogs();
            Object[] schems = JDBCUtilities.getSingleColumn(set, 1, null).toArray();
            this.mdlCatalogs.removeAllElements();
            for (int i = 0; i < schems.length; ++i) {
                String s;
                if (schems[i] == null || (s = schems[i].toString()).trim().length() < 1) continue;
                this.mdlCatalogs.addElement(s.trim());
            }
            this.configureCombobox(this.jcbCatalogs);
            this.jcbCatalogs.setEnabled(this.mdlCatalogs.getSize() >= 1);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
            set = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableNames() {
        if (this.mdlTables == null || this.jcbTables == null || this.dmd == null || this.isLoadingTables) {
            return;
        }
        ResultSet set = null;
        String cat = this.getSelectedCatalog();
        String scm = this.getSelectedSchema();
        this.isLoadingTables = true;
        try {
            set = this.dmd.getTables(cat, scm, "%", null);
            Object[] tables = JDBCUtilities.getSingleColumn(set, "TABLE_NAME", null);
            this.mdlTables.removeAllElements();
            if (tables != null) {
                for (int i = 0; i < tables.length; ++i) {
                    this.mdlTables.addElement(tables[i]);
                }
            }
            this.mdlTables.setSelectedItem(tables[0]);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable throwable) {}
            set = null;
            this.isLoadingTables = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSchemas() {
        ResultSet set = null;
        try {
            set = this.dmd.getSchemas();
            Object[] schems = JDBCUtilities.getSingleColumn(set, "TABLE_SCHEM", null);
            this.mdlSchemas.removeAllElements();
            for (int i = 0; i < schems.length; ++i) {
                String s;
                String string = s = schems[i] == null ? "" : schems[i].toString();
                if (s.trim().length() < 1) continue;
                this.mdlSchemas.addElement(s.trim());
            }
            this.configureCombobox(this.jcbSchemas);
            this.jcbSchemas.setSelectedItem(this.dmd.getUserName());
            this.jcbSchemas.setEnabled(this.mdlSchemas.getSize() >= 1);
        }
        catch (Throwable t) {
            this.jcbSchemas.setEnabled(false);
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable schems) {}
            set = null;
        }
    }

    private void configureCombobox(JComboBox box) {
        box.addActionListener(this);
        box.setMaximumRowCount(5);
        box.setEditable(false);
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        TableSelector.UI_CONSTRAINT.gridx = x;
        TableSelector.UI_CONSTRAINT.gridy = y;
        TableSelector.UI_CONSTRAINT.gridwidth = w;
        TableSelector.UI_CONSTRAINT.gridheight = h;
        TableSelector.UI_CONSTRAINT.weightx = wx;
        TableSelector.UI_CONSTRAINT.weighty = wy;
        TableSelector.UI_CONSTRAINT.anchor = a;
        TableSelector.UI_CONSTRAINT.fill = f;
    }
}

