/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.isqlviewer.swing.JNumberEditor;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class HistoryPropertyPage
extends AbstractPropertyPage
implements ActionListener {
    private JCheckBox chkCycleHistory = new JCheckBox(BasicUtilities.getString("History_CycleList_Txt"));
    private JCheckBox chkHistoryClear = new JCheckBox(BasicUtilities.getString("History_SessionClr_Txt"));
    private JCheckBox chkSessionStyle = new JCheckBox(BasicUtilities.getString("History_SesStyle_Txt"));
    private JCheckBox chkDuplicates = new JCheckBox(BasicUtilities.getString("History_Duplicates_Txt"));
    private JCheckBox chkCRC32Enable = new JCheckBox(BasicUtilities.getString("History_UseCRC32_Txt"));
    private JNumberEditor txtMaxDays = new JNumberEditor(0, 5);
    private JNumberEditor txtMaxCount = new JNumberEditor(0, 5);
    private ButtonGroup grpHistoryStyle = new ButtonGroup();
    private JRadioButton rdoServiceStyle = new JRadioButton(BasicUtilities.getString("History_SvcStyle_Txt"));
    private JRadioButton rdoDriverStyle = new JRadioButton(BasicUtilities.getString("History_DrvStyle_Txt"));
    private JRadioButton rdoGlobalStyle = new JRadioButton(BasicUtilities.getString("History_GblStyle_Txt"));

    public HistoryPropertyPage() {
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "PropertiesHistory::initUI()");
        }
    }

    @Override
    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("History16");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.chkCRC32Enable.setEnabled(this.chkDuplicates.isSelected());
    }

    @Override
    public String getPropertyPageName() {
        return BasicUtilities.getString("History_Property_Page");
    }

    @Override
    protected void updatePage() {
        this.actionPerformed(null);
    }

    protected void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkCycleHistory.setToolTipText(BasicUtilities.getString("History_CycleList_Tip"));
        this.chkHistoryClear.setToolTipText(BasicUtilities.getString("History_SessionClr_Tip"));
        this.chkSessionStyle.setToolTipText(BasicUtilities.getString("History_SesStyle_Tip"));
        this.chkDuplicates.setToolTipText(BasicUtilities.getString("History_Duplicates_Tip"));
        this.chkCRC32Enable.setToolTipText(BasicUtilities.getString("History_UseCRC32_Tip"));
        this.txtMaxDays.setToolTipText(BasicUtilities.getString("History_MaxDays_Tip"));
        this.txtMaxCount.setToolTipText(BasicUtilities.getString("History_MaxCount_Tip"));
        this.rdoServiceStyle.setToolTipText(BasicUtilities.getString("History_SvcStyle_Tip"));
        this.rdoDriverStyle.setToolTipText(BasicUtilities.getString("History_DrvStyle_Tip"));
        this.rdoGlobalStyle.setToolTipText(BasicUtilities.getString("History_GblStyle_Tip"));
        this.grpHistoryStyle.add(this.rdoDriverStyle);
        this.grpHistoryStyle.add(this.rdoGlobalStyle);
        this.grpHistoryStyle.add(this.rdoServiceStyle);
        this.addButtonGroupProperty(this.grpHistoryStyle, "history.style");
        this.setPropertyForComponent(this.txtMaxCount, "history.max-count");
        this.setPropertyForComponent(this.txtMaxDays, "history.max-days");
        this.setPropertyForComponent(this.chkSessionStyle, "history.persistent-enabled");
        this.setPropertyForComponent(this.chkHistoryClear, "history.sessionclear-enabled");
        this.setPropertyForComponent(this.chkCycleHistory, "history.circular-enabled");
        this.setPropertyForComponent(this.chkDuplicates, "history.duplicates-enabled");
        this.setPropertyForComponent(this.chkCRC32Enable, "history.crc32-enabled");
        this.rdoServiceStyle.setActionCommand(Integer.toString(2));
        this.rdoDriverStyle.setActionCommand(Integer.toString(1));
        this.rdoGlobalStyle.setActionCommand(Integer.toString(0));
        this.chkDuplicates.addActionListener(this);
        this.chkCRC32Enable.setSelected(prefs.containsKey("history.crc32-enabled"));
        HistoryPropertyPage.constrain(1, 0, 3, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        HistoryPropertyPage.constrain(0, 0, 1, 13, 0.0, 0.0, 10, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("History_MaxDays_Txt", null), UI_CONSTRAINT);
        HistoryPropertyPage.constrain(2, 1, 2, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.txtMaxDays, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 2, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("History_MaxCount_Txt", null), UI_CONSTRAINT);
        HistoryPropertyPage.constrain(2, 2, 2, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.txtMaxCount, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 3, 3, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.chkCycleHistory, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 4, 3, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.chkHistoryClear, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 5, 3, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.chkSessionStyle, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 6, 2, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.chkDuplicates, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(3, 6, 1, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.chkCRC32Enable, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 7, 3, 1, 1.0, 0.0, 10, 2);
        this.add(HistoryPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 8, 1, 1, 0.0, 0.0, 10, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("History_StyleSelect_Txt", null), UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 9, 3, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.rdoGlobalStyle, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 10, 3, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.rdoServiceStyle, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 11, 3, 1, 1.0, 0.0, 17, 0);
        this.add((Component)this.rdoDriverStyle, UI_CONSTRAINT);
        HistoryPropertyPage.constrain(1, 12, 3, 1, 0.0, 1.0, 17, 0);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        HistoryPropertyPage.constrain(4, 0, 1, 13, 1.0, 0.0, 10, 0);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
    }
}

