/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.swing.JNumberEditor;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class JDBCPropertyPage
extends AbstractPropertyPage {
    private DefaultComboBoxModel mdlServcList = new DefaultComboBoxModel();
    private JCheckBox chkKeepAlive = new JCheckBox();
    private JCheckBox chkBeVerbose = new JCheckBox();
    private JCheckBox chkEchoDebug = new JCheckBox();
    private JCheckBox chkQueryEcho = new JCheckBox();
    private JCheckBox chkCountEcho = new JCheckBox();
    private JCheckBox chkEscpeProc = new JCheckBox();
    private JCheckBox chkRevrsFtch = new JCheckBox();
    private JCheckBox chkJDBCTrace = new JCheckBox();
    private JCheckBox chkAutoComit = new JCheckBox();
    private JCheckBox chkIsSecure = new JCheckBox();
    private JCheckBox chkGenKeys = new JCheckBox();
    private JComboBox cmbServcList = new JComboBox(this.mdlServcList);
    private JNumberEditor txtSvTimeout = new JNumberEditor(0, 6);
    private JNumberEditor txtSvMaxRows = new JNumberEditor(0, 6);
    private JNumberEditor txtMaxFldSiz = new JNumberEditor(0, 6);
    private JNumberEditor txtLoginTime = new JNumberEditor(0, 6);
    private JNumberEditor txtMaxChains = new JNumberEditor(0, 6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCPropertyPage() {
        SystemConfig system = SystemConfig.getInstance();
        ServiceProvider provider = system.getServiceProvider();
        Iterator itr = provider.getRegisteredServices().iterator();
        try {
            this.initUI();
            while (itr.hasNext()) {
                this.mdlServcList.addElement(itr.next());
            }
            itr = null;
            provider = null;
        }
        catch (Throwable throwable) {
        }
        finally {
            system = null;
            provider = null;
            itr = null;
        }
    }

    @Override
    public String getPropertyPageName() {
        return BasicUtilities.getString("JDBC_Property_Page");
    }

    @Override
    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Database16");
    }

    protected void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkKeepAlive.setText(BasicUtilities.getString("Enable_Auto_Connect_Text"));
        this.chkBeVerbose.setText(BasicUtilities.getString("Enable_Verbose_Text"));
        this.chkEchoDebug.setText(BasicUtilities.getString("Enable_Debug_Text"));
        this.chkQueryEcho.setText(BasicUtilities.getString("Log_Queries_Text"));
        this.chkCountEcho.setText(BasicUtilities.getString("Echo_Result_Text"));
        this.chkEscpeProc.setText(BasicUtilities.getString("Allow_Escape_Text"));
        this.chkRevrsFtch.setText(BasicUtilities.getString("Enable_Reverse_Fetch_Text"));
        this.chkAutoComit.setText(BasicUtilities.getString("Auto_Commit_On_Close"));
        this.chkIsSecure.setText(BasicUtilities.getString("Is_Service_Secure"));
        this.chkJDBCTrace.setText(BasicUtilities.getString("Enable_JDBC_Trace_Text"));
        this.chkGenKeys.setText(BasicUtilities.getString("Enabled_Generated_Keys"));
        this.chkKeepAlive.setToolTipText(BasicUtilities.getString("Enable_Auto_Connect_Tip"));
        this.chkBeVerbose.setToolTipText(BasicUtilities.getString("Enable_Verbose_Tip"));
        this.chkQueryEcho.setToolTipText(BasicUtilities.getString("Log_Queries_Tip"));
        this.chkEchoDebug.setToolTipText(BasicUtilities.getString("Enable_Debug_Tip"));
        this.chkJDBCTrace.setToolTipText(BasicUtilities.getString("Enable_JDBC_Trace_Tip"));
        this.chkCountEcho.setToolTipText(BasicUtilities.getString("Echo_Result_Tip"));
        this.chkEscpeProc.setToolTipText(BasicUtilities.getString("Allow_Escape_Tip"));
        this.chkRevrsFtch.setToolTipText(BasicUtilities.getString("Enable_Reverse_Fetch_Tip"));
        this.txtSvMaxRows.setToolTipText(BasicUtilities.getString("MaxRows_Tip"));
        this.txtMaxFldSiz.setToolTipText(BasicUtilities.getString("MaxFldSz_Tip"));
        this.txtSvTimeout.setToolTipText(BasicUtilities.getString("QueryTimeout_Tip"));
        this.txtLoginTime.setToolTipText(BasicUtilities.getString("LoginTimeout_Tip"));
        this.txtMaxChains.setToolTipText(BasicUtilities.getString("MaxChains_Tip"));
        this.chkAutoComit.setToolTipText(BasicUtilities.getString("Auto_Commit_On_Close_Tip"));
        this.chkIsSecure.setToolTipText(BasicUtilities.getString("Is_Service_Secure_Tip"));
        this.chkGenKeys.setToolTipText(BasicUtilities.getString("Enabled_Generated_Keys_Tip"));
        this.setPropertyForComponent(this.cmbServcList, "jdbc.auto-service");
        this.setPropertyForComponent(this.chkBeVerbose, "jdbc.verbose-enabled");
        this.setPropertyForComponent(this.chkQueryEcho, "jdbc.echo-query");
        this.setPropertyForComponent(this.chkKeepAlive, "jdbc.keepalive-enabled");
        this.setPropertyForComponent(this.chkEchoDebug, "jdbc.debug-enabled");
        this.setPropertyForComponent(this.chkJDBCTrace, "jdbc.trace-enabled");
        this.setPropertyForComponent(this.chkCountEcho, "jdbc.echo-rowcount");
        this.setPropertyForComponent(this.chkRevrsFtch, "jdbc.reverseFetch-enabled");
        this.setPropertyForComponent(this.chkEscpeProc, "jdbc.escapeProc-enabled");
        this.setPropertyForComponent(this.txtLoginTime, "jdbc.timeout-login");
        this.setPropertyForComponent(this.txtSvTimeout, "jdbc.timeout-query");
        this.setPropertyForComponent(this.txtMaxFldSiz, "jdbc.max-fieldsize");
        this.setPropertyForComponent(this.txtSvMaxRows, "jdbc.max-rows");
        this.setPropertyForComponent(this.txtMaxChains, "jdbc.max-warnings");
        this.setPropertyForComponent(this.chkAutoComit, "jdbc.autocommit-enabled");
        this.setPropertyForComponent(this.chkIsSecure, "general.security-enabled");
        this.setPropertyForComponent(this.chkGenKeys, "jdbc.resultsetkeys-enabled");
        JDBCPropertyPage.constrain(0, 0, 1, 12, 0.0, 0.0, 17, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 0, 4, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        JLabel lblInfo = new JLabel(BasicUtilities.getString("JDBC_Preference_Info"), 0);
        lblInfo.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TextArea.foreground"), 1));
        lblInfo.setFont(lblInfo.getFont().deriveFont(1, 13.0f));
        JDBCPropertyPage.constrain(1, 1, 4, 1, 0.0, 0.0, 10, 2);
        this.add((Component)lblInfo, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 2, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkKeepAlive, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(3, 2, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkJDBCTrace, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 3, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkBeVerbose, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(3, 3, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkEchoDebug, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 4, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkQueryEcho, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(3, 4, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkCountEcho, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 5, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkEscpeProc, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(3, 5, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkRevrsFtch, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 6, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkAutoComit, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(3, 6, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkIsSecure, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 7, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkGenKeys, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 8, 4, 1, 0.0, 0.0, 10, 2);
        this.add(JDBCPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 8, 4, 1, 0.0, 0.0, 10, 2);
        this.add(Box.createVerticalStrut(12), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 9, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("MaxRows", null), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(2, 9, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtSvMaxRows, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(3, 9, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("MaxFldSz", null), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(4, 9, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtMaxFldSiz, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 10, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("QueryTimeout", null), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(2, 10, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtSvTimeout, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(3, 10, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("LoginTimeout", null), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(4, 10, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtLoginTime, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 11, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("MaxChains", null), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(2, 11, 3, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.txtMaxChains, UI_CONSTRAINT);
        JDBCPropertyPage.constrain(1, 12, 6, 1, 0.0, 1.0, 17, 0);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        JDBCPropertyPage.constrain(5, 0, 1, 12, 1.0, 0.0, 17, 0);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
    }
}

