/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    public static final int DIRECTION_FORWARD = 0;
    public static final int DIRECTION_BACKWARD = 1;
    private final String QUOTES = "'\"";
    protected int currentPosition;
    protected int maxPosition;
    protected String str;
    protected String delimiters;
    protected boolean retTokens;
    protected int lastQuoteIdx = -1;
    protected char lastQuote = '\u0000';
    protected boolean ignoreQuotes = true;
    protected boolean ignoreDoubleTokens;
    protected int minimumIndex = 0;
    protected int tokenIndex = -1;
    protected int parseDirection = 0;

    public StringTokenizer(String str, String delim, boolean returnTokens, boolean ignoreConsecutiveTokens) {
        this.str = str == null ? "" : str;
        this.delimiters = delim;
        this.retTokens = returnTokens;
        this.ignoreDoubleTokens = ignoreConsecutiveTokens;
        this.setTokenizeDirection(0);
    }

    public StringTokenizer(String str, String delim, boolean returnTokens) {
        this(str, delim, returnTokens, true);
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false, true);
    }

    public StringTokenizer(String str) {
        this(str, " \t\n\r", false, true);
    }

    public synchronized void setReturnTokens(boolean val) {
        this.retTokens = val;
    }

    public String toString() {
        return this.str;
    }

    public synchronized void setTokenizeDirection(int Direction2) {
        this.parseDirection = Direction2;
        this.reset();
    }

    public int getTokenizeDirection() {
        return this.parseDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setString(String str) {
        if (str == null) {
            str = "";
        }
        StringTokenizer stringTokenizer = this;
        synchronized (stringTokenizer) {
            this.str = str;
            this.reset();
        }
    }

    public void setQuotesEnabled(boolean b) {
        this.ignoreQuotes = !b;
    }

    public boolean getQuotesEnabled() {
        return this.ignoreQuotes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendString(String newString) {
        if (newString == null) {
            return;
        }
        switch (this.parseDirection) {
            case 1: {
                StringTokenizer stringTokenizer = this;
                synchronized (stringTokenizer) {
                    this.str = this.str.concat(newString);
                    break;
                }
            }
            default: {
                StringTokenizer stringTokenizer = this;
                synchronized (stringTokenizer) {
                    this.str = this.str.concat(newString);
                    this.maxPosition = this.str.length();
                    break;
                }
            }
        }
    }

    public String nextToken() {
        String token = null;
        this.tokenIndex = this.currentPosition;
        switch (this.parseDirection) {
            case 1: {
                token = this.nextBackwardToken();
                break;
            }
            default: {
                token = this.nextForwardToken();
            }
        }
        return token;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public boolean hasMoreTokens() {
        switch (this.parseDirection) {
            case 1: {
                return this.hasBackwardMoreTokens();
            }
        }
        return this.hasMoreForwardTokens();
    }

    public int countTokens() {
        switch (this.parseDirection) {
            case 1: {
                return this.countBackwardTokens();
            }
        }
        return this.countForwardTokens();
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        StringTokenizer stringTokenizer = this;
        synchronized (stringTokenizer) {
            switch (this.parseDirection) {
                case 1: {
                    this.minimumIndex = this.str.length() - 1;
                    this.maxPosition = 0;
                    break;
                }
                default: {
                    this.minimumIndex = 0;
                    this.maxPosition = this.str.length();
                }
            }
            this.lastQuote = '\u0000';
            this.lastQuoteIdx = -1;
            this.tokenIndex = this.currentPosition = this.minimumIndex;
        }
    }

    public String[] toArray() {
        this.reset();
        String[] tokens = new String[this.countTokens()];
        int i = 0;
        while (this.hasMoreTokens()) {
            tokens[i++] = this.nextToken();
        }
        return tokens;
    }

    protected char getLastDelimiter() {
        try {
            return this.str.charAt(this.getTokenIndex() - 1);
        }
        catch (Throwable t) {
            return '\u0000';
        }
    }

    protected int countForwardTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition) {
            while (!this.retTokens && currpos < this.maxPosition && this.isDelimiterAtIndex(currpos)) {
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(currpos - 1)) < 0) {
                    ++currpos;
                    continue;
                }
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(currpos - 1)) >= 0) {
                    ++count;
                    ++currpos;
                    continue;
                }
                if (!this.ignoreDoubleTokens) continue;
                ++currpos;
            }
            if (currpos >= this.maxPosition) break;
            int start = currpos;
            while (currpos < this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) < 0) {
                ++currpos;
            }
            if (this.retTokens && start == currpos && this.isDelimiterAtIndex(currpos)) {
                ++currpos;
            }
            if (!this.isDelimiterAtIndex(currpos)) continue;
            ++count;
        }
        return count;
    }

    protected int countBackwardTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos > this.maxPosition) {
            while (!this.retTokens && currpos > this.maxPosition && this.isDelimiterAtIndex(currpos)) {
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(currpos + 1)) < 0) {
                    --currpos;
                    continue;
                }
                if (!this.ignoreDoubleTokens && this.delimiters.indexOf(this.str.charAt(currpos + 1)) >= 0) {
                    ++count;
                    --currpos;
                    continue;
                }
                if (!this.ignoreDoubleTokens) continue;
                --currpos;
            }
            if (currpos <= this.maxPosition) break;
            int start = currpos;
            while (currpos > this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) < 0) {
                --currpos;
            }
            if (this.retTokens && start == currpos && this.isDelimiterAtIndex(currpos)) {
                --currpos;
            }
            ++count;
        }
        return count;
    }

    protected String nextForwardToken() {
        this.skipForwardDelimiters();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.lastQuoteIdx = -1;
        while (this.currentPosition < this.maxPosition && !this.isDelimiterAtIndex(this.currentPosition)) {
            ++this.currentPosition;
        }
        if (this.retTokens && start == this.currentPosition) {
            ++this.currentPosition;
            return Character.toString(this.str.charAt(start));
        }
        this.currentPosition = this.currentPosition < this.maxPosition ? ++this.currentPosition : this.maxPosition + 1;
        return this.str.substring(start, this.currentPosition - 1);
    }

    protected String nextBackwardToken() {
        this.skipBackwardDelimiters();
        if (this.currentPosition <= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        while (this.currentPosition > this.maxPosition && !this.isDelimiterAtIndex(this.currentPosition)) {
            --this.currentPosition;
        }
        if (!this.retTokens && start == this.currentPosition) {
            --this.currentPosition;
            return new String("");
        }
        --this.currentPosition;
        if (this.currentPosition > this.maxPosition) {
            return this.str.substring(this.currentPosition + 2, start + 1);
        }
        return this.str.substring(this.currentPosition + 1, start + 1);
    }

    protected void skipForwardDelimiters() {
        while (!this.retTokens && this.currentPosition < this.maxPosition && this.isDelimiterAtIndex(this.currentPosition) && this.ignoreDoubleTokens) {
            ++this.currentPosition;
        }
    }

    protected void skipBackwardDelimiters() {
        while (!this.retTokens && this.currentPosition < this.maxPosition && this.isDelimiterAtIndex(this.currentPosition) && this.ignoreDoubleTokens) {
            ++this.currentPosition;
        }
    }

    protected boolean hasMoreForwardTokens() {
        this.skipForwardDelimiters();
        return this.currentPosition < this.maxPosition;
    }

    protected boolean hasBackwardMoreTokens() {
        this.skipBackwardDelimiters();
        return this.currentPosition > this.maxPosition;
    }

    protected boolean isDelimiterAtIndex(int index) {
        if (index >= 0 && index < this.str.length()) {
            boolean isDelim;
            boolean isQuote = this.isQuoteIdentiferAtIndex(index);
            boolean bl = isDelim = this.delimiters.indexOf(this.str.charAt(index)) >= 0;
            if (isQuote) {
                return false;
            }
            return isDelim;
        }
        return false;
    }

    protected boolean isQuoteIdentiferAtIndex(int index) {
        if (this.ignoreQuotes || index < 0 || index >= this.str.length()) {
            return false;
        }
        try {
            boolean isQuote;
            boolean bl = isQuote = "'\"".indexOf(this.str.charAt(index)) >= 0;
            if (index >= 1 && this.str.charAt(index - 1) == '\\') {
                isQuote = false;
            }
            if (isQuote) {
                if (this.lastQuote == this.str.charAt(index)) {
                    this.lastQuote = '\u0000';
                    this.lastQuoteIdx = -1;
                } else {
                    this.lastQuote = this.str.charAt(index);
                    this.lastQuoteIdx = index;
                }
            } else {
                switch (this.parseDirection) {
                    case 1: {
                        isQuote = index < this.lastQuoteIdx;
                        break;
                    }
                    default: {
                        isQuote = index > this.lastQuoteIdx && this.lastQuoteIdx >= 0;
                    }
                }
            }
            return isQuote;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

