/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public abstract class StringUtilities {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeXMLEntities(String str) {
        if (str == null) {
            return "null";
        }
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block7: for (int x = 0; x < len; ++x) {
            char aChar = str.charAt(x);
            switch (aChar) {
                case '\"': {
                    outBuffer.append("&quot;");
                    continue block7;
                }
                case '>': {
                    outBuffer.append("&gt;");
                    continue block7;
                }
                case '<': {
                    outBuffer.append("&lt;");
                    continue block7;
                }
                case '\'': {
                    outBuffer.append("&apos;");
                    continue block7;
                }
                case '&': {
                    outBuffer.append("&amp;");
                    continue block7;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static String encode(String theString, boolean asHTML, boolean escapeSpaces) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block11: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (asHTML) {
                        outBuffer.append("&nbsp;");
                        continue block11;
                    }
                    if (escapeSpaces) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block11;
                }
                case '\\': {
                    outBuffer.append('\\');
                    continue block11;
                }
                case '\t': {
                    if (asHTML) {
                        outBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        continue block11;
                    }
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block11;
                }
                case '\"': {
                    if (asHTML) {
                        outBuffer.append("&quot;");
                        continue block11;
                    }
                    outBuffer.append('\"');
                    continue block11;
                }
                case '>': {
                    if (asHTML) {
                        outBuffer.append("&gt;");
                        continue block11;
                    }
                    outBuffer.append('>');
                    continue block11;
                }
                case '<': {
                    if (asHTML) {
                        outBuffer.append("&lt;");
                        continue block11;
                    }
                    outBuffer.append('<');
                    continue block11;
                }
                case '\n': {
                    if (asHTML) {
                        outBuffer.append("<BR>");
                        continue block11;
                    }
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block11;
                }
                case '\r': {
                    if (asHTML) {
                        outBuffer.append("<BR>");
                        continue block11;
                    }
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block11;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block11;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        if (asHTML) {
                            outBuffer.append('&');
                            outBuffer.append('#');
                        } else {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                        }
                        outBuffer.append(StringUtilities.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar & 0xF));
                        continue block11;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static String decode(String str) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = str.charAt(x++)) == 92) {
                if ((aChar = str.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = str.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static int charCount(String str, char c, boolean countEscaped) {
        if (str == null) {
            return -1;
        }
        int cnt = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c || i < 1) continue;
            if (str.charAt(i - 1) == '\\') {
                if (!countEscaped) continue;
                ++cnt;
                continue;
            }
            ++cnt;
        }
        return cnt;
    }

    public static String getTypeStringForObject(Object o) {
        if (o instanceof String) {
            return "VARCHAR";
        }
        if (o instanceof Byte) {
            return "TINYINT";
        }
        if (o instanceof Boolean) {
            return "BOOLEAN";
        }
        if (o instanceof Short) {
            return "SMALLINT";
        }
        if (o instanceof Integer) {
            return "INTEGER";
        }
        if (o instanceof Long || o instanceof BigInteger) {
            return "BIGINT";
        }
        if (o instanceof Double || o instanceof Float) {
            return "DOUBLE";
        }
        if (o instanceof BigDecimal) {
            return "DECIMAL";
        }
        if (o instanceof Timestamp) {
            return "TIMESTAMP";
        }
        if (o instanceof Time) {
            return "TIME";
        }
        if (o instanceof Ref) {
            return "REF";
        }
        if (o instanceof Date) {
            return "DATE";
        }
        if (o instanceof Clob) {
            return "CLOB";
        }
        if (o instanceof Blob) {
            return "BLOB";
        }
        if (o instanceof byte[] || o instanceof InputStream) {
            return "LONGVARBINARY";
        }
        if (o instanceof Reader) {
            return "LONGVARCHAR";
        }
        return "JAVA_OBJECT";
    }

    public static String getTypeforValue(int type) {
        try {
            Class<Types> c = Types.class;
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                int value = fields[i].getInt(null);
                if (value != type) continue;
                return name;
            }
            return "OTHER";
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHTMLColor(Color c) {
        String red = Integer.toHexString(c.getRed());
        String blu = Integer.toHexString(c.getBlue());
        String gre = Integer.toHexString(c.getGreen());
        red = red.length() == 1 ? "0" + red : red;
        blu = blu.length() == 1 ? "0" + blu : blu;
        gre = gre.length() == 1 ? "0" + gre : gre;
        return "#" + red + gre + blu;
    }

    public static Font parseFontString(String s) {
        try {
            String name = s.substring(0, s.indexOf(","));
            int size = Integer.parseInt(s.substring(s.indexOf(",") + 1));
            return new Font(name, 0, size);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getFontString(Font fnt) {
        return fnt.getName().concat(",".concat(Integer.toString(fnt.getSize())));
    }

    public static String getHumanReadableSize(long bytes) {
        long mb = (long)Math.pow(2.0, 20.0);
        long kb = (long)Math.pow(2.0, 10.0);
        long gb = (long)Math.pow(2.0, 30.0);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        double relSize = 0.0;
        long abytes = Math.abs(bytes);
        String id = "";
        if (abytes / gb >= 1L) {
            relSize = (double)abytes / (double)gb;
            id = "GB";
        } else if (abytes / mb >= 1L) {
            relSize = (double)abytes / (double)mb;
            id = "MB";
        } else if (abytes / kb >= 1L) {
            relSize = (double)abytes / (double)kb;
            id = "KB";
        } else {
            relSize = abytes;
            id = "b";
        }
        return nf.format((double)(bytes < 0L ? -1 : 1) * relSize) + id;
    }

    public static String removeSubString(String source, String sub) {
        StringBuffer buff = new StringBuffer(source);
        String upcase = source.toUpperCase();
        int idx = upcase.indexOf(sub.toUpperCase());
        int end = idx + sub.length();
        if (idx >= 0 && end <= source.length() - 1) {
            buff.delete(idx, end);
        }
        return buff.toString();
    }

    public static String[] getSQLParameters(String sql) {
        StringTokenizer st = new StringTokenizer(sql, "&", true, true);
        ArrayList<String> p = new ArrayList<String>();
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens()) {
            char first;
            String token = st.nextToken(" \r\n\t,");
            char c = first = token.length() >= 2 ? token.charAt(1) : token.charAt(0);
            if (first == '&' || first == '<' || first == '>') {
                try {
                    st.nextToken("&");
                    continue;
                }
                catch (NoSuchElementException nse) {
                    break;
                }
            }
            p.add(token);
            try {
                st.nextToken("&");
            }
            catch (NoSuchElementException nse) {
                break;
            }
        }
        return p.toArray(new String[0]);
    }

    public static String applySQLParameters(Map map, String sql) {
        StringBuffer buff = new StringBuffer(sql);
        for (String key : map.keySet()) {
            String val = (String)map.get(key);
            int idx = buff.toString().indexOf("&" + key);
            buff.replace(idx, idx + key.length() + 1, val);
        }
        return buff.toString();
    }

    public static Rectangle parseRectangle(String str) {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        StringTokenizer tok = new StringTokenizer(str, ",", false, false);
        int c = 0;
        while (tok.hasMoreTokens()) {
            int val = Integer.parseInt(tok.nextToken());
            switch (c) {
                case 0: {
                    rect.setLocation(val, 0);
                    break;
                }
                case 1: {
                    rect.setLocation(rect.x, val);
                    break;
                }
                case 2: {
                    rect.setSize(val, 0);
                    break;
                }
                case 3: {
                    rect.setSize(rect.width, val);
                }
            }
            ++c;
        }
        return rect;
    }

    public static String formatBreak(int length, String text, String newLine, boolean htmlBreak) {
        StringBuffer buff = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(text, "\t\r\n ", false, true);
        int nicebreak = length;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (nicebreak < buff.length() + token.length() + 2) {
                buff.append(htmlBreak ? "<br>" : "\n");
                if (newLine != null) {
                    buff.append(newLine);
                }
                nicebreak = buff.length() + length;
            }
            buff.append(token);
            buff.append(" ");
        }
        return buff.toString();
    }

    public static String formatRectangle(Rectangle rect) {
        return rect.x + "," + rect.y + "," + rect.width + "," + rect.height;
    }

    public static String oneLine(String s) {
        if (s == null) {
            return "null";
        }
        s = s.replace('\r', ' ');
        s = s.replace('\n', ' ');
        s = s.replace('\t', ' ');
        return s;
    }

    public static String stripCharacters(String s, String set) {
        if (s == null) {
            return "null";
        }
        StringBuffer outBuffer = new StringBuffer("");
        for (int x = 0; x < s.length(); ++x) {
            char aChar = s.charAt(x);
            if (set.indexOf(aChar) >= 0) continue;
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    public static Object processString(String value, int sqlType, String options) throws ParseException {
        String cmds = options.trim().concat(";");
        StringTokenizer tok = new StringTokenizer(cmds, ";", false, true);
        StringTokenizer paramTok = new StringTokenizer("", ",", false, true);
        SimpleDateFormat sdf = new SimpleDateFormat("");
        String fmt = SystemConfig.getInstance().getFormatForSQLType(sqlType);
        if (fmt != null) {
            sdf.applyPattern(fmt);
        }
        tok.setQuotesEnabled(true);
        paramTok.setQuotesEnabled(false);
        String workString = value;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            String cmd = token.toUpperCase();
            String parameters = null;
            if (token.indexOf(40) >= 1 && token.endsWith(")")) {
                int start = token.indexOf(40) + 1;
                int end = token.lastIndexOf(41);
                parameters = token.substring(start, end);
                paramTok.setString(parameters.concat(","));
                cmd = cmd.substring(0, start - 1);
            }
            if (parameters == null) {
                if (cmd.equals("NATIVETOASCII")) {
                    workString = StringUtilities.encode(workString, false, false);
                    continue;
                }
                if (cmd.equals("ASCIITONATIVE")) {
                    workString = StringUtilities.decode(workString);
                    continue;
                }
                if (cmd.equals("TRIM")) {
                    workString = workString.trim();
                    continue;
                }
                if (cmd.equals("TOUPPER")) {
                    workString = workString.toUpperCase();
                    continue;
                }
                if (!cmd.equals("TOLOWER")) continue;
                workString = workString.toLowerCase();
                continue;
            }
            String[] params = paramTok.toArray();
            if (cmd.equals("REPLACEALL")) {
                workString = workString.replaceAll(params[0], params[1]);
                continue;
            }
            if (cmd.equals("REPLACEFIRST")) {
                workString = workString.replaceFirst(params[0], params[1]);
                continue;
            }
            if (cmd.equals("REPLACE")) {
                workString = workString.replace(params[0].charAt(0), params[1].charAt(0));
                continue;
            }
            if (cmd.equals("SUBSTRING")) {
                int start = Integer.parseInt(params[0]);
                int end = -1;
                end = params.length >= 2 ? Integer.parseInt(params[1]) : workString.length();
                workString = workString.substring(start, end);
                continue;
            }
            if (cmd.equals("FORMAT")) {
                String text = StringUtilities.decode(params[0]);
                workString = MessageFormat.format(text, workString);
                continue;
            }
            if (cmd.equals("PATTERN")) {
                sdf.applyLocalizedPattern(params[0]);
                continue;
            }
            if (cmd.equals("TIMEZONE")) {
                sdf.setTimeZone(TimeZone.getTimeZone(params[0]));
                continue;
            }
            if (cmd.equals("STRIP")) {
                String text = StringUtilities.decode(params[0]);
                workString = StringUtilities.stripCharacters(workString, text);
                continue;
            }
            if (!cmd.equals("DELETE")) continue;
            String text = StringUtilities.decode(params[0]);
            workString = StringUtilities.removeSubString(workString, text);
        }
        if (!workString.equalsIgnoreCase(value)) {
            return JDBCUtilities.convertValue(workString, sqlType, sdf);
        }
        return null;
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static void validateParameters(String[] params, int minCount, boolean allowBlanks, String command) {
        String[] p = new String[]{command, Integer.toString(minCount)};
        if (params.length < minCount) {
            String e = BasicUtilities.getString("Not_Enough_Parameters", p);
            throw new IllegalArgumentException(e);
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                String e = BasicUtilities.getString("Not_Enough_Parameters", p);
                throw new IllegalArgumentException(e);
            }
            if (params[i].trim().length() != 0 || allowBlanks) continue;
            String e = BasicUtilities.getString("Blank_Parameter_Invaid", p);
            throw new IllegalArgumentException(e);
        }
    }
}

