/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.isqlviewer.util.StringUtilities;

public final class UserPreferences {
    private static final String BACKING_STORE_AVAIL = "BackingStoreAvail";
    private Preferences prefStore = null;
    private Preferences defaults = null;

    public UserPreferences() {
        this(Preferences.userRoot(), "");
    }

    public UserPreferences(Preferences defaults) {
        this(defaults, "");
    }

    public UserPreferences(UserPreferences defaults) {
        this(defaults.toPreferences());
    }

    public UserPreferences(UserPreferences defaults, String node) {
        this(defaults.toPreferences(), node);
    }

    public UserPreferences(Preferences defaults, String node) {
        if (defaults == null) {
            defaults = Preferences.userRoot();
        }
        this.defaults = defaults;
        if (node == null) {
            node = "";
        }
        this.prefStore = defaults.node(node);
    }

    public boolean getBoolean(String key) {
        return this.prefStore.getBoolean(key, this.defaults.getBoolean(key, false));
    }

    public void putBoolean(String key, boolean value) {
        if (this.getBoolean(key) != value) {
            this.prefStore.putBoolean(key, value);
        }
    }

    public double getDouble(String key) {
        return this.prefStore.getDouble(key, this.defaults.getDouble(key, Double.NaN));
    }

    public void putDouble(String key, double value) {
        this.prefStore.putDouble(key, value);
    }

    public float getFloat(String key) {
        return this.prefStore.getFloat(key, this.defaults.getFloat(key, Float.NaN));
    }

    public void putFloat(String key, float value) {
        if (this.getFloat(key) != value) {
            this.prefStore.putFloat(key, value);
        }
    }

    public long getLong(String key) {
        return this.prefStore.getLong(key, this.defaults.getLong(key, Long.MIN_VALUE));
    }

    public void putLong(String key, long value) {
        if (this.getLong(key) != value) {
            this.prefStore.putLong(key, value);
        }
    }

    public int getInt(String key) {
        return this.prefStore.getInt(key, this.defaults.getInt(key, Integer.MIN_VALUE));
    }

    public void putInt(String key, int value) {
        if (this.getInt(key) != value) {
            this.prefStore.putInt(key, value);
        }
    }

    public String get(String key) {
        return this.prefStore.get(key, this.defaults.get(key, ""));
    }

    public void put(String key, String value) {
        try {
            if (!this.get(key).equals(value)) {
                this.prefStore.put(key, value);
            }
        }
        catch (NullPointerException npe) {
            this.prefStore.put(key, value);
        }
    }

    public void putColor(String key, Color value) {
        this.put(key, StringUtilities.getHTMLColor(value));
    }

    public Color getColor(String key) {
        return Color.decode(this.prefStore.get(key, this.defaults.get(key, "#000000")));
    }

    public void putRect(String key, Rectangle value) {
        this.put(key, StringUtilities.formatRectangle(value));
    }

    public Rectangle getRect(String key) {
        return StringUtilities.parseRectangle(this.prefStore.get(key, this.defaults.get(key, "0,0,0,0")));
    }

    public void putFont(String key, Font value) {
        this.put(key, StringUtilities.getFontString(value));
    }

    public Font getFont(String key) {
        Font fnt = StringUtilities.parseFontString(this.prefStore.get(key, this.defaults.get(key, "Default,11")));
        if (fnt == null) {
            fnt = StringUtilities.parseFontString("Default,11");
        }
        return fnt;
    }

    public boolean clearAll() {
        try {
            this.prefStore.clear();
            return true;
        }
        catch (BackingStoreException bse) {
            return false;
        }
    }

    public void clear(String key) {
        this.prefStore.remove(key);
    }

    public boolean hasBackingStore() {
        try {
            boolean oldValue = this.prefStore.getBoolean(BACKING_STORE_AVAIL, false);
            this.prefStore.putBoolean(BACKING_STORE_AVAIL, !oldValue);
            this.prefStore.flush();
        }
        catch (BackingStoreException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.prefStore.remove(BACKING_STORE_AVAIL);
        }
        return true;
    }

    public boolean containsKey(String key) {
        try {
            return Arrays.asList(this.prefStore.keys()).contains(key);
        }
        catch (BackingStoreException bse) {
            return false;
        }
    }

    public boolean isEmpty() {
        try {
            return this.prefStore.keys().length == 0;
        }
        catch (BackingStoreException bse) {
            return false;
        }
    }

    public boolean flush() {
        try {
            this.prefStore.flush();
            return true;
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    public Properties toPropertiesWithKeys(Collection keys) {
        Properties properties = new Properties(null);
        for (String key : keys) {
            String value = this.get(key);
            if (value == null) continue;
            properties.setProperty(key, value);
        }
        return properties;
    }

    public boolean sync() {
        try {
            this.prefStore.sync();
            return true;
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    public Preferences toPreferences() {
        return this.prefStore;
    }

    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        this.prefStore.addPreferenceChangeListener(pcl);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        this.prefStore.removePreferenceChangeListener(pcl);
    }
}

