/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pf.joi.ArraySpy;
import org.pf.joi.ElementFilter;
import org.pf.joi.ElementSpy;
import org.pf.joi.Preferences;
import org.pf.joi.Spy;

public abstract class AbstractObjectSpy
extends Spy {
    private String name = "this";
    protected String[] _elementNames;
    protected String[] _elementTypes;
    private Object object = null;
    private List elementHolders = null;
    private ElementFilter elementFilter = null;
    private boolean _isRootObject;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public Object getObject() {
        return this.object;
    }

    protected void setObject(Object newValue) {
        this.object = newValue;
    }

    protected List getElementHolders() {
        return this.elementHolders;
    }

    protected void setElementHolders(List newValue) {
        this.elementHolders = newValue;
    }

    public ElementFilter getElementFilter() {
        return this.elementFilter;
    }

    public void setElementFilter(ElementFilter aValue) {
        this.elementFilter = aValue;
    }

    public boolean isRootObject() {
        return this._isRootObject;
    }

    public AbstractObjectSpy(Object obj) throws SecurityException {
        this(obj, null, null, false);
    }

    public AbstractObjectSpy(Object obj, String[] elementNames, String[] elementTypes, boolean isRootObject) throws SecurityException {
        this._elementNames = elementNames;
        this._elementTypes = elementTypes;
        this.setElementFilter(Preferences.instance().getInitialElementFilter());
        this.setObject(obj);
        this.initializeElements();
        this._isRootObject = isRootObject;
    }

    @Override
    public Class getType() {
        Class<Void> type = null;
        type = this.getObject() == null ? Void.TYPE : this.getObject().getClass();
        return type;
    }

    @Override
    public Object getValue() throws Exception {
        return this._isRootObject && this instanceof ArraySpy ? "" : this.getObject();
    }

    @Override
    public int getModifiers() {
        return this.getType().getModifiers();
    }

    public List getElements() {
        Vector<Spy> result = null;
        Iterator iterator = null;
        Spy element2 = null;
        result = new Vector<Spy>();
        for (Spy element2 : this.getElementHolders()) {
            if (this.getElementFilter().matchesAny(element2.getModifiers())) continue;
            result.add(element2);
        }
        return result;
    }

    public int getFullElementCount() {
        return this.getElementHolders().size();
    }

    public ElementSpy getElementNamed(String elementName) {
        ElementSpy element2 = null;
        Iterator iterator = null;
        for (ElementSpy element2 : this.getElements()) {
            if (!element2.getName().equals(elementName)) continue;
            return element2;
        }
        return null;
    }

    protected abstract void addAllElements();

    protected void initializeElements() throws SecurityException {
        this.setElementHolders(this.createNewElementList());
        if (this.getObject() != null) {
            this.addAllElements();
        }
    }

    protected List createNewElementList() {
        return new Vector();
    }

    protected boolean canBeSorted() {
        return true;
    }

    public boolean sortElements() {
        Object[] array = null;
        if (this.canBeSorted()) {
            array = this.getElementHolders().toArray();
            Arrays.sort(array);
            this.setElementHolders(Arrays.asList(array));
            return true;
        }
        return false;
    }

    protected boolean allowsElementModification() {
        return false;
    }

    protected void setElementValue(ElementSpy element, Object value) throws Exception {
        throw new Exception("Modification of element '" + (element == null ? "" : element.getName()) + "' not supported!");
    }
}

