/*
 * Decompiled with CFR 0.152.
 */
package org.pf.joi;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.pf.joi.AbstractObjectSpy;
import org.pf.joi.ArraySpy;
import org.pf.joi.ElementFilter;
import org.pf.joi.ElementSpy;
import org.pf.joi.ElementSpyTreeNode;
import org.pf.joi.InspectionRenderer;
import org.pf.joi.InspectionView;
import org.pf.joi.InspectionWindowController;
import org.pf.joi.Inspector;
import org.pf.joi.ObjectSpyTreeNode;
import org.pf.joi.ObjectValuePanel;
import org.pf.joi.Preferences;
import org.pf.joi.Spy;
import org.pf.joi.SpyTreeNode;
import org.pf.text.StringUtil;

public class BasicInspector
extends Inspector
implements ActionListener,
TreeSelectionListener {
    protected static final int MIN_TREE_WIDTH = 100;
    protected static final int MIN_TREE_HEIGHT = 2000;
    protected static final int MIN_INFO_WIDTH = 250;
    protected static final PrintStream errorDevice = System.out;
    private InspectionWindowController controller = null;
    private InspectionView associatedView = null;
    private ObjectValuePanel contentArea = null;
    private JTextField declaredTypeField = null;
    private JTextField actualTypeField = null;
    private Spy currentElement = null;
    private JTree elementTree = null;
    private CardLayout cardLayout;
    private JPanel valueCardPanel;
    private Vector columnNames = new Vector();
    private static final String TEXT_VALUE_VIEW = "textArea";
    private static final String TABLE_VALUES_VIEW = "valuesTable";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin.ui.spacebrowser");

    protected InspectionWindowController getController() {
        return this.controller;
    }

    protected void setController(InspectionWindowController newValue) {
        this.controller = newValue;
    }

    protected InspectionView getAssociatedView() {
        return this.associatedView;
    }

    protected void setAssociatedView(InspectionView newValue) {
        this.associatedView = newValue;
    }

    protected ObjectValuePanel getContentArea() {
        return this.contentArea;
    }

    protected void setContentArea(ObjectValuePanel newValue) {
        this.contentArea = newValue;
    }

    protected JTextField getDeclaredTypeField() {
        return this.declaredTypeField;
    }

    protected void setDeclaredTypeField(JTextField aValue) {
        this.declaredTypeField = aValue;
    }

    protected JTextField getActualTypeField() {
        return this.actualTypeField;
    }

    protected void setActualTypeField(JTextField aValue) {
        this.actualTypeField = aValue;
    }

    protected Spy getCurrentElement() {
        return this.currentElement;
    }

    protected void setCurrentElement(Spy aValue) {
        this.currentElement = aValue;
    }

    protected JTree getElementTree() {
        return this.elementTree;
    }

    protected void setElementTree(JTree aValue) {
        this.elementTree = aValue;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath treePath = null;
        SpyTreeNode treeNode = null;
        Spy spy = null;
        treePath = event.getPath();
        treeNode = (SpyTreeNode)treePath.getLastPathComponent();
        spy = treeNode.getModel();
        this.setCurrentElement(spy);
        boolean isRoot = false;
        TreeNode parentTreeNode = treeNode.getParent();
        if (parentTreeNode == null && spy instanceof AbstractObjectSpy && ((AbstractObjectSpy)spy).isRootObject()) {
            isRoot = true;
        }
        this.updateInformation(spy, isRoot);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("actionInspectInTab")) {
            this.inspectCurrentElement(2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTree tree = null;
        TreePath treePath = null;
        tree = (JTree)e.getSource();
        treePath = tree.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        tree.setSelectionPath(treePath);
        SpyTreeNode treeNode = (SpyTreeNode)treePath.getLastPathComponent();
        Spy spy = treeNode.getModel();
        boolean isPrimitiveType = spy.isPrimitive();
        if ((e.getModifiers() & 0x10) > 0 && e.getClickCount() == 2 && treePath.getParentPath() != null && !isPrimitiveType) {
            this.inspectCurrentElement(2);
        }
    }

    protected void inspectCurrentElement(int where) {
        if (this.getCurrentElement() != null) {
            try {
                if (where == 3) {
                    Inspector.inspect(this.getCurrentElement().getValue());
                } else {
                    Inspector.inspectIn(this.getController(), where, this.getCurrentElement().getName(), this.getCurrentElement().getValue());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(errorDevice);
            }
        }
    }

    protected void inspectObject(String name, Object obj) {
        this.inspectObject(name, obj, null, null, false);
    }

    @Override
    protected void inspectObject(String name, Object obj, String[] elementNames, String[] elementTypes, boolean isRootNode) {
        super.inspectObject(name, obj, elementNames, elementTypes, isRootNode);
        if (this.prefs().isAutoSortOn()) {
            this.getInspectedObject().sortElements();
        }
    }

    protected String getObjectDisplayName() {
        return this.getInspectedObject().getName();
    }

    protected InspectionView getInspectionView() {
        if (this.getAssociatedView() == null) {
            this.setAssociatedView(this.buildInspectionView());
        }
        return this.getAssociatedView();
    }

    protected InspectionView buildInspectionView() {
        JSplitPane splitPane = null;
        JTextField dclField = null;
        JTextField actField = null;
        JPanel columnPanel = null;
        JPanel typePanel = null;
        JPanel infoPanel = null;
        this.setContentArea(new ObjectValuePanel(this));
        dclField = new JTextField();
        dclField.setEditable(false);
        this.setDeclaredTypeField(dclField);
        actField = new JTextField();
        actField.setEditable(false);
        this.setActualTypeField(actField);
        typePanel = new JPanel(new BorderLayout());
        columnPanel = new JPanel(new GridLayout(2, 0));
        columnPanel.add(new JLabel(" Declared: "));
        columnPanel.add(new JLabel(" Actual: "));
        typePanel.add((Component)columnPanel, "West");
        columnPanel = new JPanel(new GridLayout(2, 0));
        columnPanel.add(dclField);
        columnPanel.add(actField);
        typePanel.add((Component)columnPanel, "Center");
        this.cardLayout = new CardLayout();
        this.valueCardPanel = new JPanel(this.cardLayout);
        AbstractObjectSpy inspectedObject = this.getInspectedObject();
        List elementsList = inspectedObject.getElements();
        int elementsListSize = elementsList.size();
        Vector tableData = new Vector(elementsListSize);
        for (int i = 0; i < elementsListSize; ++i) {
            Spy spyElement = (Spy)elementsList.get(i);
            Vector<String> rowVector = new Vector<String>(3);
            try {
                String name = spyElement.getName();
                rowVector.add(name);
                String valueType = this.getValueTypeStringOf(spyElement);
                rowVector.add(valueType);
                String value = this.getValueStringOf(spyElement);
                rowVector.add(value);
                tableData.add(rowVector);
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.columnNames.add("Field Name");
        this.columnNames.add("Field Type");
        this.columnNames.add("Field Value");
        ValuesTableModel tableModel = new ValuesTableModel(tableData, this.columnNames);
        JTable valuesTable = new JTable(tableModel);
        valuesTable.setAutoCreateColumnsFromModel(false);
        valuesTable.setSelectionMode(0);
        valuesTable.setAutoResizeMode(1);
        valuesTable.setAutoscrolls(true);
        JTableHeader tableHeader = valuesTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.valueCardPanel.add((Component)((Object)this.getContentArea()), TEXT_VALUE_VIEW);
        this.valueCardPanel.add((Component)new JScrollPane(valuesTable), TABLE_VALUES_VIEW);
        infoPanel = new JPanel(new BorderLayout());
        infoPanel.setMinimumSize(new Dimension(250, 200));
        infoPanel.add((Component)typePanel, "North");
        infoPanel.add((Component)this.valueCardPanel, "Center");
        this.cardLayout.show(this.valueCardPanel, TABLE_VALUES_VIEW);
        splitPane = new JSplitPane(1, true);
        splitPane.setDividerLocation(this.prefs().getTreeWidth() + 38);
        splitPane.setDividerSize(3);
        splitPane.setLeftComponent(this.createTreePanel());
        splitPane.setRightComponent(infoPanel);
        InspectionView panel = new InspectionView(this);
        panel.add(splitPane);
        return panel;
    }

    protected JMenuItem createMenuItem(String text, String command) {
        JMenuItem menuItem = null;
        menuItem = new JMenuItem(text);
        menuItem.setActionCommand(command);
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected JMenu createMenu(String text) {
        return new JMenu(text);
    }

    protected JComponent createTreePanel() {
        JScrollPane scrollPane = null;
        JTree tree = null;
        ObjectSpyTreeNode rootNode = null;
        InspectionRenderer renderer = null;
        int rowHeight = 0;
        int treeHeight = 2000;
        rootNode = this.createTreeNodes();
        tree = new JTree(rootNode);
        this.setElementTree(tree);
        renderer = new InspectionRenderer();
        tree.setCellRenderer(renderer);
        rowHeight = renderer.getLeafIcon().getIconHeight() + 1;
        tree.setRowHeight(rowHeight);
        treeHeight = rowHeight * (this.getInspectedObject().getFullElementCount() + 1) + 10;
        tree.setPreferredSize(new Dimension(this.prefs().getTreeWidth(), treeHeight));
        tree.addTreeSelectionListener(this);
        tree.addMouseListener(this);
        tree.setSelectionRow(0);
        scrollPane = new JScrollPane(tree);
        scrollPane.setMinimumSize(new Dimension(100, treeHeight));
        return scrollPane;
    }

    protected String getTypeStringOf(Spy spy) {
        if (spy instanceof ArraySpy && ((ArraySpy)spy).isRootObject()) {
            return "";
        }
        String typeString = "";
        typeString = spy.getTypeString();
        typeString = Modifier.toString(spy.getModifiers()) + " " + typeString;
        return typeString.trim();
    }

    protected String getValueTypeStringOf(Spy spy) {
        if (spy instanceof ArraySpy && ((ArraySpy)spy).isRootObject()) {
            return "";
        }
        String typeString = null;
        try {
            typeString = spy.getValueTypeString();
        }
        catch (Exception ex) {
            ex.printStackTrace(errorDevice);
        }
        return typeString;
    }

    protected String getValueStringOf(Spy spy) {
        String valueString = "";
        try {
            valueString = spy.getValueString();
        }
        catch (Exception ex) {
            ex.printStackTrace(errorDevice);
            valueString = ex.toString();
        }
        return valueString;
    }

    protected Component getValueComponentOf(Spy spy) {
        try {
            return spy.getValueComponent();
        }
        catch (Exception ex) {
            ex.printStackTrace(errorDevice);
            return null;
        }
    }

    protected Object getValueOf(Spy spy) {
        Object value;
        try {
            value = spy.getValue();
        }
        catch (Exception ex) {
            ex.printStackTrace(errorDevice);
            value = ex.toString();
        }
        return value;
    }

    protected void updateInformation(Spy spy, boolean isRootNode) {
        this.getDeclaredTypeField().setText(this.getTypeStringOf(spy));
        this.getActualTypeField().setText(this.getValueTypeStringOf(spy));
        if (isRootNode) {
            this.cardLayout.show(this.valueCardPanel, TABLE_VALUES_VIEW);
        } else {
            this.cardLayout.show(this.valueCardPanel, TEXT_VALUE_VIEW);
            Component value = this.getValueComponentOf(spy);
            if (this.isVisualComponent(value)) {
                this.getContentArea().activateComponent(value);
            } else {
                this.getContentArea().activateText(this.getValueStringOf(spy));
            }
        }
    }

    protected boolean isVisualComponent(Object obj) {
        return obj instanceof Component && !(obj instanceof Window);
    }

    protected void setFilter(ElementFilter filter) {
        this.getInspectedObject().setElementFilter(filter);
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.getElementTree().clearSelection();
        this.getElementTree().setModel(new DefaultTreeModel(this.createTreeNodes()));
    }

    protected void displayValueModificationError(Exception ex) {
        JOptionPane.showMessageDialog(this.getDialogOwner(), ex.toString(), "Value Modification Error", 0);
    }

    protected Integer parseToInteger(String text) throws Exception {
        return new Integer(Integer.parseInt(text.trim()));
    }

    protected Boolean parseToBoolean(String str) throws Exception {
        String text = str.trim();
        if ("true".equals(text)) {
            return Boolean.TRUE;
        }
        if ("false".equals(text)) {
            return Boolean.FALSE;
        }
        throw new Exception("Invalid value '" + text + "' for boolean type.");
    }

    protected Character parseToCharacter(String str) throws Exception {
        String text = str.trim();
        if (text.length() == 1) {
            return new Character(text.charAt(0));
        }
        throw new Exception("Invalid value '" + text + "' for char type.");
    }

    protected Long parseToLong(String text) throws Exception {
        return new Long(Long.parseLong(text.trim()));
    }

    protected Short parseToShort(String text) throws Exception {
        return new Short(Short.parseShort(text.trim()));
    }

    protected Byte parseToByte(String text) throws Exception {
        return new Byte(Byte.parseByte(text.trim()));
    }

    protected Double parseToDouble(String text) throws Exception {
        return new Double(Double.parseDouble(text.trim()));
    }

    protected Float parseToFloat(String text) throws Exception {
        return new Float(Float.parseFloat(text.trim()));
    }

    protected ObjectSpyTreeNode createTreeNodes() {
        ObjectSpyTreeNode rootNode = null;
        ElementSpyTreeNode treeNode = null;
        Iterator iter = null;
        rootNode = new ObjectSpyTreeNode(this.getInspectedObject());
        iter = this.getInspectedObject().getElements().iterator();
        while (iter.hasNext()) {
            treeNode = new ElementSpyTreeNode((ElementSpy)iter.next());
            rootNode.add(treeNode);
        }
        return rootNode;
    }

    protected void sortElements() {
        if (this.getInspectedObject().sortElements()) {
            this.updateDisplay();
        }
    }

    protected ElementFilter elementFilter() {
        return this.getInspectedObject().getElementFilter();
    }

    protected Container getDialogOwner() {
        return this.getController().getMainFrame().getContentPane();
    }

    protected String getInspectorId() {
        return "BasicInspector";
    }

    protected Preferences prefs() {
        return Preferences.instance();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    public class ValuesTableModel
    extends DefaultTableModel {
        public ValuesTableModel(Vector data, Vector columnNames) {
            super(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

